
Global $_STAGE
Global $SET_DPSROOT
Global $SET_PLATFORM
Global $SPLASH_ACTION
Const $_FINISHERDIR = StringReplace(@ScriptFullPath, @ScriptName, "")
Const $_NF = "not found"
Const $_SETTINGSFILE = $_FINISHERDIR & "\fSetup.ini"
Const $_DEBUG = true
Const $_LOGFILE = __STRINGTOBOOL(__REPLACEENVVARS(IniRead($_SETTINGSFILE, "Settings", "logLocation", "%systemroot%")) & "\DPsFnshr.log")
Const $_SPLASHSCREEN = true
Global $CSET_CLEANUP[12]
$CSET_CLEANUP[0] = "%dpsroot%\hwids.dat"
$CSET_CLEANUP[1] = "%systemdrive%\fSetup.ini"
$CSET_CLEANUP[2] = "%systemdrive%\devcon.exe"
$CSET_CLEANUP[3] = "%systemdrive%\makePNF.exe"
$CSET_CLEANUP[4] = "%systemdrive%\pmtimer.exe"
$CSET_CLEANUP[5] = "%systemdrive%\*.ins"
$CSET_CLEANUP[6] = "%systemdrive%\DSPdsblr.exe"
$CSET_CLEANUP[7] = "%systemdrive%\mute.exe"
$CSET_CLEANUP[8] = "%systemdrive%\DriverPack_*.ini"
$CSET_CLEANUP[9] = "%systemdrive%\DP_Install_Tool.cmd"
$CSET_CLEANUP[10] = "%systemdrive%\DPINST.exe"
$CSET_CLEANUP[11] = "%systemdrive%\DPInst.xml"

Func _ARRAYADD(ByRef $AVARRAY, $VVALUE)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, -1)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(2, 0, -1)
	Local $IUBOUND = UBound($AVARRAY)
	ReDim $AVARRAY[$IUBOUND + 1]
	$AVARRAY[$IUBOUND] = $VVALUE
	Return $IUBOUND
EndFunc


Func _ARRAYBINARYSEARCH(Const ByRef $AVARRAY, $VVALUE, $ISTART = 0, $IEND = 0)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, -1)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(5, 0, -1)
	Local $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(4, 0, -1)
	Local $IMID = Int(($IEND + $ISTART) / 2)
	If $AVARRAY[$ISTART] > $VVALUE Or $AVARRAY[$IEND] < $VVALUE Then Return SetError(2, 0, -1)
	While $ISTART <= $IMID And $VVALUE <> $AVARRAY[$IMID]
		If $VVALUE < $AVARRAY[$IMID] Then
			$IEND = $IMID - 1
		Else
			$ISTART = $IMID + 1
		EndIf
		$IMID = Int(($IEND + $ISTART) / 2)
	WEnd
	If $ISTART > $IEND Then Return SetError(3, 0, -1)
	Return $IMID
EndFunc


Func _ARRAYCOMBINATIONS(ByRef $AVARRAY, $ISET, $SDELIM = "")
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(2, 0, 0)
	Local $IN = UBound($AVARRAY)
	Local $IR = $ISET
	Local $AIDX[$IR]
	For $I = 0 To $IR - 1
		$AIDX[$I] = $I
	Next
	Local $ITOTAL = __ARRAY_COMBINATIONS($IN, $IR)
	Local $ILEFT = $ITOTAL
	Local $ARESULT[$ITOTAL + 1]
	$ARESULT[0] = $ITOTAL
	Local $ICOUNT = 1
	While $ILEFT > 0
		__ARRAY_GETNEXT($IN, $IR, $ILEFT, $ITOTAL, $AIDX)
		For $I = 0 To $ISET - 1
			$ARESULT[$ICOUNT] &= $AVARRAY[$AIDX[$I]] & $SDELIM
		Next
		If $SDELIM <> "" Then $ARESULT[$ICOUNT] = StringTrimRight($ARESULT[$ICOUNT], 1)
		$ICOUNT += 1
	WEnd
	Return $ARESULT
EndFunc


Func _ARRAYCONCATENATE(ByRef $AVARRAYTARGET, Const ByRef $AVARRAYSOURCE, $ISTART = 0)
	If Not IsArray($AVARRAYTARGET) Then Return SetError(1, 0, 0)
	If Not IsArray($AVARRAYSOURCE) Then Return SetError(2, 0, 0)
	If UBound($AVARRAYTARGET, 0) <> 1 Then
		If UBound($AVARRAYSOURCE, 0) <> 1 Then Return SetError(5, 0, 0)
		Return SetError(3, 0, 0)
	EndIf
	If UBound($AVARRAYSOURCE, 0) <> 1 Then Return SetError(4, 0, 0)
	Local $IUBOUNDTARGET = UBound($AVARRAYTARGET) - $ISTART, $IUBOUNDSOURCE = UBound($AVARRAYSOURCE)
	ReDim $AVARRAYTARGET[$IUBOUNDTARGET + $IUBOUNDSOURCE]
	For $I = $ISTART To $IUBOUNDSOURCE - 1
		$AVARRAYTARGET[$IUBOUNDTARGET + $I] = $AVARRAYSOURCE[$I]
	Next
	Return $IUBOUNDTARGET + $IUBOUNDSOURCE
EndFunc


Func _ARRAYCREATE($V_0, $V_1 = 0, $V_2 = 0, $V_3 = 0, $V_4 = 0, $V_5 = 0, $V_6 = 0, $V_7 = 0, $V_8 = 0, $V_9 = 0, $V_10 = 0, $V_11 = 0, $V_12 = 0, $V_13 = 0, $V_14 = 0, $V_15 = 0, $V_16 = 0, $V_17 = 0, $V_18 = 0, $V_19 = 0, $V_20 = 0)
	Local $AV_ARRAY[21] = [$V_0, $V_1, $V_2, $V_3, $V_4, $V_5, $V_6, $V_7, $V_8, $V_9, $V_10, $V_11, $V_12, $V_13, $V_14, $V_15, $V_16, $V_17, $V_18, $V_19, $V_20]
	ReDim $AV_ARRAY[@NumParams]
	Return $AV_ARRAY
EndFunc


Func _ARRAYDELETE(ByRef $AVARRAY, $IELEMENT)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	Local $IUBOUND = UBound($AVARRAY, 1) - 1
	If Not $IUBOUND Then
		$AVARRAY = ""
		Return 0
	EndIf
	If $IELEMENT < 0 Then $IELEMENT = 0
	If $IELEMENT > $IUBOUND Then $IELEMENT = $IUBOUND
	Switch UBound($AVARRAY, 0)
		Case 1
			For $I = $IELEMENT To $IUBOUND - 1
				$AVARRAY[$I] = $AVARRAY[$I + 1]
			Next
			ReDim $AVARRAY[$IUBOUND]
		Case 2
			Local $ISUBMAX = UBound($AVARRAY, 2) - 1
			For $I = $IELEMENT To $IUBOUND - 1
				For $J = 0 To $ISUBMAX
					$AVARRAY[$I][$J] = $AVARRAY[$I + 1][$J]
				Next
			Next
			ReDim $AVARRAY[$IUBOUND][$ISUBMAX + 1]
		Case Else
			Return SetError(3, 0, 0)
	EndSwitch
	Return $IUBOUND
EndFunc


Func _ARRAYDISPLAY(Const ByRef $AVARRAY, $STITLE = "Array: ListView Display", $IITEMLIMIT = -1, $ITRANSPOSE = 0, $SSEPARATOR = "", $SREPLACE = "|", $SHEADER = "")
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	Local $IDIMENSION = UBound($AVARRAY, 0), $IUBOUND = UBound($AVARRAY, 1) - 1, $ISUBMAX = UBound($AVARRAY, 2) - 1
	If $IDIMENSION > 2 Then Return SetError(2, 0, 0)
	If $SSEPARATOR = "" Then $SSEPARATOR = Chr(124)
	If _ARRAYSEARCH($AVARRAY, $SSEPARATOR, 0, 0, 0, 1) <> -1 Then
		For $X = 1 To 255
			If $X >= 32 And $X <= 127 Then ContinueLoop
			Local $SFIND = _ARRAYSEARCH($AVARRAY, Chr($X), 0, 0, 0, 1)
			If $SFIND = -1 Then
				$SSEPARATOR = Chr($X)
				ExitLoop
			EndIf
		Next
	EndIf
	Local $VTMP, $IBUFFER = 64
	Local $ICOLLIMIT = 250
	Local $IONEVENTMODE = Opt("GUIOnEventMode", 0), $SDATASEPARATORCHAR = Opt("GUIDataSeparatorChar", $SSEPARATOR)
	If $ISUBMAX < 0 Then $ISUBMAX = 0
	If $ITRANSPOSE Then
		$VTMP = $IUBOUND
		$IUBOUND = $ISUBMAX
		$ISUBMAX = $VTMP
	EndIf
	If $ISUBMAX > $ICOLLIMIT Then $ISUBMAX = $ICOLLIMIT
	If $IITEMLIMIT < 1 Then $IITEMLIMIT = $IUBOUND
	If $IUBOUND > $IITEMLIMIT Then $IUBOUND = $IITEMLIMIT
	If $SHEADER = "" Then
		$SHEADER = "Row  "
		For $I = 0 To $ISUBMAX
			$SHEADER &= $SSEPARATOR & "Col " & $I
		Next
	EndIf
	Local $AVARRAYTEXT[$IUBOUND + 1]
	For $I = 0 To $IUBOUND
		$AVARRAYTEXT[$I] = "[" & $I & "]"
		For $J = 0 To $ISUBMAX
			If $IDIMENSION = 1 Then
				If $ITRANSPOSE Then
					$VTMP = $AVARRAY[$J]
				Else
					$VTMP = $AVARRAY[$I]
				EndIf
			Else
				If $ITRANSPOSE Then
					$VTMP = $AVARRAY[$J][$I]
				Else
					$VTMP = $AVARRAY[$I][$J]
				EndIf
			EndIf
			$VTMP = StringReplace($VTMP, $SSEPARATOR, $SREPLACE, 0, 1)
			$AVARRAYTEXT[$I] &= $SSEPARATOR & $VTMP
			$VTMP = StringLen($VTMP)
			If $VTMP > $IBUFFER Then $IBUFFER = $VTMP
		Next
	Next
	$IBUFFER += 1
	Local Const $_ARRAYCONSTANT_GUI_DOCKBORDERS = 102
	Local Const $_ARRAYCONSTANT_GUI_DOCKBOTTOM = 64
	Local Const $_ARRAYCONSTANT_GUI_DOCKHEIGHT = 512
	Local Const $_ARRAYCONSTANT_GUI_DOCKLEFT = 2
	Local Const $_ARRAYCONSTANT_GUI_DOCKRIGHT = 4
	Local Const $_ARRAYCONSTANT_GUI_EVENT_CLOSE = -3
	Local Const $_ARRAYCONSTANT_LVIF_PARAM = 4
	Local Const $_ARRAYCONSTANT_LVIF_TEXT = 1
	Local Const $_ARRAYCONSTANT_LVM_GETCOLUMNWIDTH = (4096 + 29)
	Local Const $_ARRAYCONSTANT_LVM_GETITEMCOUNT = (4096 + 4)
	Local Const $_ARRAYCONSTANT_LVM_GETITEMSTATE = (4096 + 44)
	Local Const $_ARRAYCONSTANT_LVM_INSERTITEMW = (4096 + 77)
	Local Const $_ARRAYCONSTANT_LVM_SETEXTENDEDLISTVIEWSTYLE = (4096 + 54)
	Local Const $_ARRAYCONSTANT_LVM_SETITEMW = (4096 + 76)
	Local Const $_ARRAYCONSTANT_LVS_EX_FULLROWSELECT = 32
	Local Const $_ARRAYCONSTANT_LVS_EX_GRIDLINES = 1
	Local Const $_ARRAYCONSTANT_LVS_SHOWSELALWAYS = 8
	Local Const $_ARRAYCONSTANT_WS_EX_CLIENTEDGE = 512
	Local Const $_ARRAYCONSTANT_WS_MAXIMIZEBOX = 65536
	Local Const $_ARRAYCONSTANT_WS_MINIMIZEBOX = 131072
	Local Const $_ARRAYCONSTANT_WS_SIZEBOX = 262144
	Local Const $_ARRAYCONSTANT_TAGLVITEM = "int Mask;int Item;int SubItem;int State;int StateMask;ptr Text;int TextMax;int Image;int Param;int Indent;int GroupID;int Columns;ptr pColumns"
	Local $IADDMASK = BitOR($_ARRAYCONSTANT_LVIF_TEXT, $_ARRAYCONSTANT_LVIF_PARAM)
	Local $TBUFFER = DllStructCreate("wchar Text[" & $IBUFFER & "]"), $PBUFFER = DllStructGetPtr($TBUFFER)
	Local $TITEM = DllStructCreate($_ARRAYCONSTANT_TAGLVITEM), $PITEM = DllStructGetPtr($TITEM)
	DllStructSetData($TITEM, "Param", 0)
	DllStructSetData($TITEM, "Text", $PBUFFER)
	DllStructSetData($TITEM, "TextMax", $IBUFFER)
	Local $IWIDTH = 640, $IHEIGHT = 480
	Local $HGUI = GUICreate($STITLE, $IWIDTH, $IHEIGHT, Default, Default, BitOR($_ARRAYCONSTANT_WS_SIZEBOX, $_ARRAYCONSTANT_WS_MINIMIZEBOX, $_ARRAYCONSTANT_WS_MAXIMIZEBOX))
	Local $AIGUISIZE = WinGetClientSize($HGUI)
	Local $HLISTVIEW = GUICtrlCreateListView($SHEADER, 0, 0, $AIGUISIZE[0], $AIGUISIZE[1] - 26, $_ARRAYCONSTANT_LVS_SHOWSELALWAYS)
	Local $HCOPY = GUICtrlCreateButton("Copy Selected", 3, $AIGUISIZE[1] - 23, $AIGUISIZE[0] - 6, 20)
	GUICtrlSetResizing($HLISTVIEW, $_ARRAYCONSTANT_GUI_DOCKBORDERS)
	GUICtrlSetResizing($HCOPY, $_ARRAYCONSTANT_GUI_DOCKLEFT + $_ARRAYCONSTANT_GUI_DOCKRIGHT + $_ARRAYCONSTANT_GUI_DOCKBOTTOM + $_ARRAYCONSTANT_GUI_DOCKHEIGHT)
	GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_SETEXTENDEDLISTVIEWSTYLE, $_ARRAYCONSTANT_LVS_EX_GRIDLINES, $_ARRAYCONSTANT_LVS_EX_GRIDLINES)
	GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_SETEXTENDEDLISTVIEWSTYLE, $_ARRAYCONSTANT_LVS_EX_FULLROWSELECT, $_ARRAYCONSTANT_LVS_EX_FULLROWSELECT)
	GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_SETEXTENDEDLISTVIEWSTYLE, $_ARRAYCONSTANT_WS_EX_CLIENTEDGE, $_ARRAYCONSTANT_WS_EX_CLIENTEDGE)
	Local $AITEM
	For $I = 0 To $IUBOUND
		If GUICtrlCreateListViewItem($AVARRAYTEXT[$I], $HLISTVIEW) = 0 Then
			$AITEM = StringSplit($AVARRAYTEXT[$I], $SSEPARATOR)
			DllStructSetData($TBUFFER, "Text", $AITEM[1])
			DllStructSetData($TITEM, "Item", $I)
			DllStructSetData($TITEM, "SubItem", 0)
			DllStructSetData($TITEM, "Mask", $IADDMASK)
			GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_INSERTITEMW, 0, $PITEM)
			DllStructSetData($TITEM, "Mask", $_ARRAYCONSTANT_LVIF_TEXT)
			For $J = 2 To $AITEM[0]
				DllStructSetData($TBUFFER, "Text", $AITEM[$J])
				DllStructSetData($TITEM, "SubItem", $J - 1)
				GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_SETITEMW, 0, $PITEM)
			Next
		EndIf
	Next
	$IWIDTH = 0
	For $I = 0 To $ISUBMAX + 1
		$IWIDTH += GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_GETCOLUMNWIDTH, $I, 0)
	Next
	If $IWIDTH < 250 Then $IWIDTH = 230
	$IWIDTH += 20
	If $IWIDTH > @DesktopWidth Then $IWIDTH = @DesktopWidth - 100
	WinMove($HGUI, "", (@DesktopWidth - $IWIDTH) / 2, Default, $IWIDTH)
	GUISetState(@SW_SHOW, $HGUI)
	While 1
		Switch GUIGetMsg()
			Case $_ARRAYCONSTANT_GUI_EVENT_CLOSE
				ExitLoop
			Case $HCOPY
				Local $SCLIP = ""
				Local $AICURITEMS[1] = [0]
				For $I = 0 To GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_GETITEMCOUNT, 0, 0)
					If GUICtrlSendMsg($HLISTVIEW, $_ARRAYCONSTANT_LVM_GETITEMSTATE, $I, 2) Then
						$AICURITEMS[0] += 1
						ReDim $AICURITEMS[$AICURITEMS[0] + 1]
						$AICURITEMS[$AICURITEMS[0]] = $I
					EndIf
				Next
				If Not $AICURITEMS[0] Then
					For $SITEM In $AVARRAYTEXT
						$SCLIP &= $SITEM & @CRLF
					Next
				Else
					For $I = 1 To UBound($AICURITEMS) - 1
						$SCLIP &= $AVARRAYTEXT[$AICURITEMS[$I]] & @CRLF
					Next
				EndIf
				ClipPut($SCLIP)
		EndSwitch
	WEnd
	GUIDelete($HGUI)
	Opt("GUIOnEventMode", $IONEVENTMODE)
	Opt("GUIDataSeparatorChar", $SDATASEPARATORCHAR)
	Return 1
EndFunc


Func _ARRAYFINDALL(Const ByRef $AVARRAY, $VVALUE, $ISTART = 0, $IEND = 0, $ICASE = 0, $IPARTIAL = 0, $ISUBITEM = 0)
	$ISTART = _ARRAYSEARCH($AVARRAY, $VVALUE, $ISTART, $IEND, $ICASE, $IPARTIAL, 1, $ISUBITEM)
	If @error Then Return SetError(@error, 0, -1)
	Local $IINDEX = 0, $AVRESULT[UBound($AVARRAY)]
	Do
		$AVRESULT[$IINDEX] = $ISTART
		$IINDEX += 1
		$ISTART = _ARRAYSEARCH($AVARRAY, $VVALUE, $ISTART + 1, $IEND, $ICASE, $IPARTIAL, 1, $ISUBITEM)
	Until @error
	ReDim $AVRESULT[$IINDEX]
	Return $AVRESULT
EndFunc


Func _ARRAYINSERT(ByRef $AVARRAY, $IELEMENT, $VVALUE = "")
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(2, 0, 0)
	Local $IUBOUND = UBound($AVARRAY) + 1
	ReDim $AVARRAY[$IUBOUND]
	For $I = $IUBOUND - 1 To $IELEMENT + 1 Step -1
		$AVARRAY[$I] = $AVARRAY[$I - 1]
	Next
	$AVARRAY[$IELEMENT] = $VVALUE
	Return $IUBOUND
EndFunc


Func _ARRAYMAX(Const ByRef $AVARRAY, $ICOMPNUMERIC = 0, $ISTART = 0, $IEND = 0)
	Local $IRESULT = _ARRAYMAXINDEX($AVARRAY, $ICOMPNUMERIC, $ISTART, $IEND)
	If @error Then Return SetError(@error, 0, "")
	Return $AVARRAY[$IRESULT]
EndFunc


Func _ARRAYMAXINDEX(Const ByRef $AVARRAY, $ICOMPNUMERIC = 0, $ISTART = 0, $IEND = 0)
	If Not IsArray($AVARRAY) Or UBound($AVARRAY, 0) <> 1 Then Return SetError(1, 0, -1)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(3, 0, -1)
	Local $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(2, 0, -1)
	Local $IMAXINDEX = $ISTART
	If $ICOMPNUMERIC Then
		For $I = $ISTART To $IEND
			If Number($AVARRAY[$IMAXINDEX]) < Number($AVARRAY[$I]) Then $IMAXINDEX = $I
		Next
	Else
		For $I = $ISTART To $IEND
			If $AVARRAY[$IMAXINDEX] < $AVARRAY[$I] Then $IMAXINDEX = $I
		Next
	EndIf
	Return $IMAXINDEX
EndFunc


Func _ARRAYMIN(Const ByRef $AVARRAY, $ICOMPNUMERIC = 0, $ISTART = 0, $IEND = 0)
	Local $IRESULT = _ARRAYMININDEX($AVARRAY, $ICOMPNUMERIC, $ISTART, $IEND)
	If @error Then Return SetError(@error, 0, "")
	Return $AVARRAY[$IRESULT]
EndFunc


Func _ARRAYMININDEX(Const ByRef $AVARRAY, $ICOMPNUMERIC = 0, $ISTART = 0, $IEND = 0)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, -1)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(3, 0, -1)
	Local $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(2, 0, -1)
	Local $IMININDEX = $ISTART
	If $ICOMPNUMERIC Then
		For $I = $ISTART To $IEND
			If Number($AVARRAY[$IMININDEX]) > Number($AVARRAY[$I]) Then $IMININDEX = $I
		Next
	Else
		For $I = $ISTART To $IEND
			If $AVARRAY[$IMININDEX] > $AVARRAY[$I] Then $IMININDEX = $I
		Next
	EndIf
	Return $IMININDEX
EndFunc


Func _ARRAYPERMUTE(ByRef $AVARRAY, $SDELIM = "")
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(2, 0, 0)
	Local $ISIZE = UBound($AVARRAY), $IFACTORIAL = 1, $AIDX[$ISIZE], $ARESULT[1], $ICOUNT = 1
	For $I = 0 To $ISIZE - 1
		$AIDX[$I] = $I
	Next
	For $I = $ISIZE To 1 Step -1
		$IFACTORIAL *= $I
	Next
	ReDim $ARESULT[$IFACTORIAL + 1]
	$ARESULT[0] = $IFACTORIAL
	__ARRAY_EXETERINTERNAL($AVARRAY, 0, $ISIZE, $SDELIM, $AIDX, $ARESULT, $ICOUNT)
	Return $ARESULT
EndFunc


Func _ARRAYPOP(ByRef $AVARRAY)
	If (Not IsArray($AVARRAY)) Then Return SetError(1, 0, "")
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(2, 0, "")
	Local $IUBOUND = UBound($AVARRAY) - 1, $SLASTVAL = $AVARRAY[$IUBOUND]
	If Not $IUBOUND Then
		$AVARRAY = ""
	Else
		ReDim $AVARRAY[$IUBOUND]
	EndIf
	Return $SLASTVAL
EndFunc


Func _ARRAYPUSH(ByRef $AVARRAY, $VVALUE, $IDIRECTION = 0)
	If (Not IsArray($AVARRAY)) Then Return SetError(1, 0, 0)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(3, 0, 0)
	Local $IUBOUND = UBound($AVARRAY) - 1
	If IsArray($VVALUE) Then
		Local $IUBOUNDS = UBound($VVALUE)
		If ($IUBOUNDS - 1) > $IUBOUND Then Return SetError(2, 0, 0)
		If $IDIRECTION Then
			For $I = $IUBOUND To $IUBOUNDS Step -1
				$AVARRAY[$I] = $AVARRAY[$I - $IUBOUNDS]
			Next
			For $I = 0 To $IUBOUNDS - 1
				$AVARRAY[$I] = $VVALUE[$I]
			Next
		Else
			For $I = 0 To $IUBOUND - $IUBOUNDS
				$AVARRAY[$I] = $AVARRAY[$I + $IUBOUNDS]
			Next
			For $I = 0 To $IUBOUNDS - 1
				$AVARRAY[$I + $IUBOUND - $IUBOUNDS + 1] = $VVALUE[$I]
			Next
		EndIf
	Else
		If $IDIRECTION Then
			For $I = $IUBOUND To 1 Step -1
				$AVARRAY[$I] = $AVARRAY[$I - 1]
			Next
			$AVARRAY[0] = $VVALUE
		Else
			For $I = 0 To $IUBOUND - 1
				$AVARRAY[$I] = $AVARRAY[$I + 1]
			Next
			$AVARRAY[$IUBOUND] = $VVALUE
		EndIf
	EndIf
	Return 1
EndFunc


Func _ARRAYREVERSE(ByRef $AVARRAY, $ISTART = 0, $IEND = 0)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(3, 0, 0)
	Local $VTMP, $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(2, 0, 0)
	For $I = $ISTART To Int(($ISTART + $IEND - 1) / 2)
		$VTMP = $AVARRAY[$I]
		$AVARRAY[$I] = $AVARRAY[$IEND]
		$AVARRAY[$IEND] = $VTMP
		$IEND -= 1
	Next
	Return 1
EndFunc


Func _ARRAYSEARCH(Const ByRef $AVARRAY, $VVALUE, $ISTART = 0, $IEND = 0, $ICASE = 0, $IPARTIAL = 0, $IFORWARD = 1, $ISUBITEM = -1)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, -1)
	If UBound($AVARRAY, 0) > 2 Or UBound($AVARRAY, 0) < 1 Then Return SetError(2, 0, -1)
	Local $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(4, 0, -1)
	Local $ISTEP = 1
	If Not $IFORWARD Then
		Local $ITMP = $ISTART
		$ISTART = $IEND
		$IEND = $ITMP
		$ISTEP = -1
	EndIf
	Switch UBound($AVARRAY, 0)
		Case 1
			If Not $IPARTIAL Then
				If Not $ICASE Then
					For $I = $ISTART To $IEND Step $ISTEP
						If $AVARRAY[$I] = $VVALUE Then Return $I
					Next
				Else
					For $I = $ISTART To $IEND Step $ISTEP
						If $AVARRAY[$I] == $VVALUE Then Return $I
					Next
				EndIf
			Else
				For $I = $ISTART To $IEND Step $ISTEP
					If StringInStr($AVARRAY[$I], $VVALUE, $ICASE) > 0 Then Return $I
				Next
			EndIf
		Case 2
			Local $IUBOUNDSUB = UBound($AVARRAY, 2) - 1
			If $ISUBITEM > $IUBOUNDSUB Then $ISUBITEM = $IUBOUNDSUB
			If $ISUBITEM < 0 Then
				$ISUBITEM = 0
			Else
				$IUBOUNDSUB = $ISUBITEM
			EndIf
			For $J = $ISUBITEM To $IUBOUNDSUB
				If Not $IPARTIAL Then
					If Not $ICASE Then
						For $I = $ISTART To $IEND Step $ISTEP
							If $AVARRAY[$I][$J] = $VVALUE Then Return $I
						Next
					Else
						For $I = $ISTART To $IEND Step $ISTEP
							If $AVARRAY[$I][$J] == $VVALUE Then Return $I
						Next
					EndIf
				Else
					For $I = $ISTART To $IEND Step $ISTEP
						If StringInStr($AVARRAY[$I][$J], $VVALUE, $ICASE) > 0 Then Return $I
					Next
				EndIf
			Next
		Case Else
			Return SetError(7, 0, -1)
	EndSwitch
	Return SetError(6, 0, -1)
EndFunc


Func _ARRAYSORT(ByRef $AVARRAY, $IDESCENDING = 0, $ISTART = 0, $IEND = 0, $ISUBITEM = 0)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	Local $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(2, 0, 0)
	Switch UBound($AVARRAY, 0)
		Case 1
			__ARRAYQUICKSORT1D($AVARRAY, $ISTART, $IEND)
			If $IDESCENDING Then _ARRAYREVERSE($AVARRAY, $ISTART, $IEND)
		Case 2
			Local $ISUBMAX = UBound($AVARRAY, 2) - 1
			If $ISUBITEM > $ISUBMAX Then Return SetError(3, 0, 0)
			If $IDESCENDING Then
				$IDESCENDING = -1
			Else
				$IDESCENDING = 1
			EndIf
			__ARRAYQUICKSORT2D($AVARRAY, $IDESCENDING, $ISTART, $IEND, $ISUBITEM, $ISUBMAX)
		Case Else
			Return SetError(4, 0, 0)
	EndSwitch
	Return 1
EndFunc


Func __ARRAYQUICKSORT1D(ByRef $AVARRAY, ByRef $ISTART, ByRef $IEND)
	If $IEND <= $ISTART Then Return
	Local $VTMP
	If ($IEND - $ISTART) < 15 Then
		Local $VCUR
		For $I = $ISTART + 1 To $IEND
			$VTMP = $AVARRAY[$I]
			If IsNumber($VTMP) Then
				For $J = $I - 1 To $ISTART Step -1
					$VCUR = $AVARRAY[$J]
					If ($VTMP >= $VCUR And IsNumber($VCUR)) Or (Not IsNumber($VCUR) And StringCompare($VTMP, $VCUR) >= 0) Then ExitLoop
					$AVARRAY[$J + 1] = $VCUR
				Next
			Else
				For $J = $I - 1 To $ISTART Step -1
					If (StringCompare($VTMP, $AVARRAY[$J]) >= 0) Then ExitLoop
					$AVARRAY[$J + 1] = $AVARRAY[$J]
				Next
			EndIf
			$AVARRAY[$J + 1] = $VTMP
		Next
		Return
	EndIf
	Local $L = $ISTART, $R = $IEND, $VPIVOT = $AVARRAY[Int(($ISTART + $IEND) / 2)], $FNUM = IsNumber($VPIVOT)
	Do
		If $FNUM Then
			While ($AVARRAY[$L] < $VPIVOT And IsNumber($AVARRAY[$L])) Or (Not IsNumber($AVARRAY[$L]) And StringCompare($AVARRAY[$L], $VPIVOT) < 0)
				$L += 1
			WEnd
			While ($AVARRAY[$R] > $VPIVOT And IsNumber($AVARRAY[$R])) Or (Not IsNumber($AVARRAY[$R]) And StringCompare($AVARRAY[$R], $VPIVOT) > 0)
				$R -= 1
			WEnd
		Else
			While (StringCompare($AVARRAY[$L], $VPIVOT) < 0)
				$L += 1
			WEnd
			While (StringCompare($AVARRAY[$R], $VPIVOT) > 0)
				$R -= 1
			WEnd
		EndIf
		If $L <= $R Then
			$VTMP = $AVARRAY[$L]
			$AVARRAY[$L] = $AVARRAY[$R]
			$AVARRAY[$R] = $VTMP
			$L += 1
			$R -= 1
		EndIf
	Until $L > $R
	__ARRAYQUICKSORT1D($AVARRAY, $ISTART, $R)
	__ARRAYQUICKSORT1D($AVARRAY, $L, $IEND)
EndFunc


Func __ARRAYQUICKSORT2D(ByRef $AVARRAY, ByRef $ISTEP, ByRef $ISTART, ByRef $IEND, ByRef $ISUBITEM, ByRef $ISUBMAX)
	If $IEND <= $ISTART Then Return
	Local $VTMP, $L = $ISTART, $R = $IEND, $VPIVOT = $AVARRAY[Int(($ISTART + $IEND) / 2)][$ISUBITEM], $FNUM = IsNumber($VPIVOT)
	Do
		If $FNUM Then
			While ($ISTEP * ($AVARRAY[$L][$ISUBITEM] - $VPIVOT) < 0 And IsNumber($AVARRAY[$L][$ISUBITEM])) Or (Not IsNumber($AVARRAY[$L][$ISUBITEM]) And $ISTEP * StringCompare($AVARRAY[$L][$ISUBITEM], $VPIVOT) < 0)
				$L += 1
			WEnd
			While ($ISTEP * ($AVARRAY[$R][$ISUBITEM] - $VPIVOT) > 0 And IsNumber($AVARRAY[$R][$ISUBITEM])) Or (Not IsNumber($AVARRAY[$R][$ISUBITEM]) And $ISTEP * StringCompare($AVARRAY[$R][$ISUBITEM], $VPIVOT) > 0)
				$R -= 1
			WEnd
		Else
			While ($ISTEP * StringCompare($AVARRAY[$L][$ISUBITEM], $VPIVOT) < 0)
				$L += 1
			WEnd
			While ($ISTEP * StringCompare($AVARRAY[$R][$ISUBITEM], $VPIVOT) > 0)
				$R -= 1
			WEnd
		EndIf
		If $L <= $R Then
			For $I = 0 To $ISUBMAX
				$VTMP = $AVARRAY[$L][$I]
				$AVARRAY[$L][$I] = $AVARRAY[$R][$I]
				$AVARRAY[$R][$I] = $VTMP
			Next
			$L += 1
			$R -= 1
		EndIf
	Until $L > $R
	__ARRAYQUICKSORT2D($AVARRAY, $ISTEP, $ISTART, $R, $ISUBITEM, $ISUBMAX)
	__ARRAYQUICKSORT2D($AVARRAY, $ISTEP, $L, $IEND, $ISUBITEM, $ISUBMAX)
EndFunc


Func _ARRAYSWAP(ByRef $VITEM1, ByRef $VITEM2)
	Local $VTMP = $VITEM1
	$VITEM1 = $VITEM2
	$VITEM2 = $VTMP
EndFunc


Func _ARRAYTOCLIP(Const ByRef $AVARRAY, $ISTART = 0, $IEND = 0)
	Local $SRESULT = _ARRAYTOSTRING($AVARRAY, @CR, $ISTART, $IEND)
	If @error Then Return SetError(@error, 0, 0)
	Return ClipPut($SRESULT)
EndFunc


Func _ARRAYTOSTRING(Const ByRef $AVARRAY, $SDELIM = "|", $ISTART = 0, $IEND = 0)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, "")
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(3, 0, "")
	Local $SRESULT, $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(2, 0, "")
	For $I = $ISTART To $IEND
		$SRESULT &= $AVARRAY[$I] & $SDELIM
	Next
	Return StringTrimRight($SRESULT, StringLen($SDELIM))
EndFunc


Func _ARRAYTRIM(ByRef $AVARRAY, $ITRIMNUM, $IDIRECTION = 0, $ISTART = 0, $IEND = 0)
	If Not IsArray($AVARRAY) Then Return SetError(1, 0, 0)
	If UBound($AVARRAY, 0) <> 1 Then Return SetError(2, 0, 0)
	Local $IUBOUND = UBound($AVARRAY) - 1
	If $IEND < 1 Or $IEND > $IUBOUND Then $IEND = $IUBOUND
	If $ISTART < 0 Then $ISTART = 0
	If $ISTART > $IEND Then Return SetError(5, 0, 0)
	If $IDIRECTION Then
		For $I = $ISTART To $IEND
			$AVARRAY[$I] = StringTrimRight($AVARRAY[$I], $ITRIMNUM)
		Next
	Else
		For $I = $ISTART To $IEND
			$AVARRAY[$I] = StringTrimLeft($AVARRAY[$I], $ITRIMNUM)
		Next
	EndIf
	Return 1
EndFunc


Func _ARRAYUNIQUE($AARRAY, $IDIMENSION = 1, $IBASE = 0, $ICASE = 0, $VDELIM = "|")
	Local $IUBOUNDDIM
	If $VDELIM = "|" Then $VDELIM = Chr(1)
	If Not IsArray($AARRAY) Then Return SetError(1, 0, 0)
	If Not $IDIMENSION > 0 Then
		Return SetError(3, 0, 0)
	Else
		$IUBOUNDDIM = UBound($AARRAY, 1)
		If @error Then Return SetError(3, 0, 0)
		If $IDIMENSION > 1 Then
			Local $AARRAYTMP[1]
			For $I = 0 To $IUBOUNDDIM - 1
				_ARRAYADD($AARRAYTMP, $AARRAY[$I][$IDIMENSION - 1])
			Next
			_ARRAYDELETE($AARRAYTMP, 0)
		Else
			If UBound($AARRAY, 0) = 1 Then
				Dim $AARRAYTMP[1]
				For $I = 0 To $IUBOUNDDIM - 1
					_ARRAYADD($AARRAYTMP, $AARRAY[$I])
				Next
				_ARRAYDELETE($AARRAYTMP, 0)
			Else
				Dim $AARRAYTMP[1]
				For $I = 0 To $IUBOUNDDIM - 1
					_ARRAYADD($AARRAYTMP, $AARRAY[$I][$IDIMENSION - 1])
				Next
				_ARRAYDELETE($AARRAYTMP, 0)
			EndIf
		EndIf
	EndIf
	Local $SHOLD
	For $ICC = $IBASE To UBound($AARRAYTMP) - 1
		If Not StringInStr($VDELIM & $SHOLD, $VDELIM & $AARRAYTMP[$ICC] & $VDELIM, $ICASE) Then $SHOLD &= $AARRAYTMP[$ICC] & $VDELIM
	Next
	If $SHOLD Then
		$AARRAYTMP = StringSplit(StringTrimRight($SHOLD, StringLen($VDELIM)), $VDELIM, 1)
		Return $AARRAYTMP
	EndIf
	Return SetError(2, 0, 0)
EndFunc


Func __ARRAY_EXETERINTERNAL(ByRef $AVARRAY, $ISTART, $ISIZE, $SDELIM, ByRef $AIDX, ByRef $ARESULT, ByRef $ICOUNT)
	If $ISTART == $ISIZE - 1 Then
		For $I = 0 To $ISIZE - 1
			$ARESULT[$ICOUNT] &= $AVARRAY[$AIDX[$I]] & $SDELIM
		Next
		If $SDELIM <> "" Then $ARESULT[$ICOUNT] = StringTrimRight($ARESULT[$ICOUNT], 1)
		$ICOUNT += 1
	Else
		Local $ITEMP
		For $I = $ISTART To $ISIZE - 1
			$ITEMP = $AIDX[$I]
			$AIDX[$I] = $AIDX[$ISTART]
			$AIDX[$ISTART] = $ITEMP
			__ARRAY_EXETERINTERNAL($AVARRAY, $ISTART + 1, $ISIZE, $SDELIM, $AIDX, $ARESULT, $ICOUNT)
			$AIDX[$ISTART] = $AIDX[$I]
			$AIDX[$I] = $ITEMP
		Next
	EndIf
EndFunc


Func __ARRAY_COMBINATIONS($IN, $IR)
	Local $I_TOTAL = 1
	For $I = $IR To 1 Step -1
		$I_TOTAL *= ($IN / $I)
		$IN -= 1
	Next
	Return $I_TOTAL
EndFunc


Func __ARRAY_GETNEXT($IN, $IR, ByRef $ILEFT, $ITOTAL, ByRef $AIDX)
	If $ILEFT == $ITOTAL Then
		$ILEFT -= 1
		Return
	EndIf
	Local $I = $IR - 1
	While $AIDX[$I] == $IN - $IR + $I
		$I -= 1
	WEnd
	$AIDX[$I] += 1
	For $J = $I + 1 To $IR - 1
		$AIDX[$J] = $AIDX[$I] + $J - $I
	Next
	$ILEFT -= 1
EndFunc

Global Const $PROCESS_TERMINATE = 1
Global Const $PROCESS_CREATE_THREAD = 2
Global Const $PROCESS_SET_SESSIONID = 4
Global Const $PROCESS_VM_OPERATION = 8
Global Const $PROCESS_VM_READ = 16
Global Const $PROCESS_VM_WRITE = 32
Global Const $PROCESS_DUP_HANDLE = 64
Global Const $PROCESS_CREATE_PROCESS = 128
Global Const $PROCESS_SET_QUOTA = 256
Global Const $PROCESS_SET_INFORMATION = 512
Global Const $PROCESS_QUERY_INFORMATION = 1024
Global Const $PROCESS_SUSPEND_RESUME = 2048
Global Const $PROCESS_ALL_ACCESS = 2035711
Global Const $FC_NOOVERWRITE = 0
Global Const $FC_OVERWRITE = 1
Global Const $FT_MODIFIED = 0
Global Const $FT_CREATED = 1
Global Const $FT_ACCESSED = 2
Global Const $FO_READ = 0
Global Const $FO_APPEND = 1
Global Const $FO_OVERWRITE = 2
Global Const $FO_BINARY = 16
Global Const $FO_UNICODE = 32
Global Const $FO_UTF16_LE = 32
Global Const $FO_UTF16_BE = 64
Global Const $FO_UTF8 = 128
Global Const $FO_UTF8_NOBOM = 256
Global Const $EOF = -1
Global Const $FD_FILEMUSTEXIST = 1
Global Const $FD_PATHMUSTEXIST = 2
Global Const $FD_MULTISELECT = 4
Global Const $FD_PROMPTCREATENEW = 8
Global Const $FD_PROMPTOVERWRITE = 16
Global Const $CREATE_NEW = 1
Global Const $CREATE_ALWAYS = 2
Global Const $OPEN_EXISTING = 3
Global Const $OPEN_ALWAYS = 4
Global Const $TRUNCATE_EXISTING = 5
Global Const $INVALID_SET_FILE_POINTER = -1
Global Const $FILE_BEGIN = 0
Global Const $FILE_CURRENT = 1
Global Const $FILE_END = 2
Global Const $FILE_ATTRIBUTE_READONLY = 1
Global Const $FILE_ATTRIBUTE_HIDDEN = 2
Global Const $FILE_ATTRIBUTE_SYSTEM = 4
Global Const $FILE_ATTRIBUTE_DIRECTORY = 16
Global Const $FILE_ATTRIBUTE_ARCHIVE = 32
Global Const $FILE_ATTRIBUTE_DEVICE = 64
Global Const $FILE_ATTRIBUTE_NORMAL = 128
Global Const $FILE_ATTRIBUTE_TEMPORARY = 256
Global Const $FILE_ATTRIBUTE_SPARSE_FILE = 512
Global Const $FILE_ATTRIBUTE_REPARSE_POINT = 1024
Global Const $FILE_ATTRIBUTE_COMPRESSED = 2048
Global Const $FILE_ATTRIBUTE_OFFLINE = 4096
Global Const $FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 8192
Global Const $FILE_ATTRIBUTE_ENCRYPTED = 16384
Global Const $FILE_SHARE_READ = 1
Global Const $FILE_SHARE_WRITE = 2
Global Const $FILE_SHARE_DELETE = 4
Global Const $GENERIC_ALL = 268435456
Global Const $GENERIC_EXECUTE = 536870912
Global Const $GENERIC_WRITE = 1073741824
Global Const $GENERIC_READ = -2147483648
Global Const $DDL_ARCHIVE = 32
Global Const $DDL_DIRECTORY = 16
Global Const $DDL_DRIVES = 16384
Global Const $DDL_EXCLUSIVE = 32768
Global Const $DDL_HIDDEN = 2
Global Const $DDL_READONLY = 1
Global Const $DDL_READWRITE = 0
Global Const $DDL_SYSTEM = 4
Global Const $COLOR_AQUA = 65535
Global Const $COLOR_BLACK = 0
Global Const $COLOR_BLUE = 255
Global Const $COLOR_CREAM = 16776176
Global Const $COLOR_FUCHSIA = 16711935
Global Const $COLOR_GRAY = 8421504
Global Const $COLOR_GREEN = 32768
Global Const $COLOR_LIME = 65280
Global Const $COLOR_MAROON = 9116770
Global Const $COLOR_MEDBLUE = 708
Global Const $COLOR_MEDGRAY = 10526884
Global Const $COLOR_MONEYGREEN = 12639424
Global Const $COLOR_NAVY = 128
Global Const $COLOR_OLIVE = 8421376
Global Const $COLOR_PURPLE = 8388736
Global Const $COLOR_RED = 16711680
Global Const $COLOR_SILVER = 12632256
Global Const $COLOR_SKYBLUE = 10930928
Global Const $COLOR_TEAL = 32896
Global Const $COLOR_WHITE = 16777215
Global Const $COLOR_YELLOW = 16776960
Global Const $CLR_NONE = -1
Global Const $CLR_DEFAULT = -16777216
Global Const $CLR_AQUA = 16776960
Global Const $CLR_BLACK = 0
Global Const $CLR_BLUE = 16711680
Global Const $CLR_CREAM = 15793151
Global Const $CLR_FUCHSIA = 16711935
Global Const $CLR_GRAY = 8421504
Global Const $CLR_GREEN = 32768
Global Const $CLR_LIME = 65280
Global Const $CLR_MAROON = 6429835
Global Const $CLR_MEDBLUE = 12845568
Global Const $CLR_MEDGRAY = 10789024
Global Const $CLR_MONEYGREEN = 12639424
Global Const $CLR_NAVY = 8388608
Global Const $CLR_OLIVE = 32896
Global Const $CLR_PURPLE = 8388736
Global Const $CLR_RED = 255
Global Const $CLR_SILVER = 12632256
Global Const $CLR_SKYBLUE = 15780518
Global Const $CLR_TEAL = 8421376
Global Const $CLR_WHITE = 16777215
Global Const $CLR_YELLOW = 65535
Global Const $CC_ANYCOLOR = 256
Global Const $CC_FULLOPEN = 2
Global Const $CC_RGBINIT = 1
Global Const $OPT_COORDSRELATIVE = 0
Global Const $OPT_COORDSABSOLUTE = 1
Global Const $OPT_COORDSCLIENT = 2
Global Const $OPT_ERRORSILENT = 0
Global Const $OPT_ERRORFATAL = 1
Global Const $OPT_CAPSNOSTORE = 0
Global Const $OPT_CAPSSTORE = 1
Global Const $OPT_MATCHSTART = 1
Global Const $OPT_MATCHANY = 2
Global Const $OPT_MATCHEXACT = 3
Global Const $OPT_MATCHADVANCED = 4
Global Const $CCS_TOP = 1
Global Const $CCS_NOMOVEY = 2
Global Const $CCS_BOTTOM = 3
Global Const $CCS_NORESIZE = 4
Global Const $CCS_NOPARENTALIGN = 8
Global Const $CCS_NOHILITE = 16
Global Const $CCS_ADJUSTABLE = 32
Global Const $CCS_NODIVIDER = 64
Global Const $CCS_VERT = 128
Global Const $CCS_LEFT = 129
Global Const $CCS_NOMOVEX = 130
Global Const $CCS_RIGHT = 131
Global Const $DI_MASK = 1
Global Const $DI_IMAGE = 2
Global Const $DI_NORMAL = 3
Global Const $DI_COMPAT = 4
Global Const $DI_DEFAULTSIZE = 8
Global Const $DI_NOMIRROR = 16
Global Const $DISPLAY_DEVICE_ATTACHED_TO_DESKTOP = 1
Global Const $DISPLAY_DEVICE_MULTI_DRIVER = 2
Global Const $DISPLAY_DEVICE_PRIMARY_DEVICE = 4
Global Const $DISPLAY_DEVICE_MIRRORING_DRIVER = 8
Global Const $DISPLAY_DEVICE_VGA_COMPATIBLE = 16
Global Const $DISPLAY_DEVICE_REMOVABLE = 32
Global Const $DISPLAY_DEVICE_DISCONNECT = 33554432
Global Const $DISPLAY_DEVICE_REMOTE = 67108864
Global Const $DISPLAY_DEVICE_MODESPRUNED = 134217728
Global Const $FLASHW_CAPTION = 1
Global Const $FLASHW_TRAY = 2
Global Const $FLASHW_TIMER = 4
Global Const $FLASHW_TIMERNOFG = 12
Global Const $FORMAT_MESSAGE_ALLOCATE_BUFFER = 256
Global Const $FORMAT_MESSAGE_IGNORE_INSERTS = 512
Global Const $FORMAT_MESSAGE_FROM_STRING = 1024
Global Const $FORMAT_MESSAGE_FROM_HMODULE = 2048
Global Const $FORMAT_MESSAGE_FROM_SYSTEM = 4096
Global Const $FORMAT_MESSAGE_ARGUMENT_ARRAY = 8192
Global Const $GW_HWNDFIRST = 0
Global Const $GW_HWNDLAST = 1
Global Const $GW_HWNDNEXT = 2
Global Const $GW_HWNDPREV = 3
Global Const $GW_OWNER = 4
Global Const $GW_CHILD = 5
Global Const $GWL_WNDPROC = -4
Global Const $GWL_HINSTANCE = -6
Global Const $GWL_HWNDPARENT = -8
Global Const $GWL_ID = -12
Global Const $GWL_STYLE = -16
Global Const $GWL_EXSTYLE = -20
Global Const $GWL_USERDATA = -21
Global Const $STD_CUT = 0
Global Const $STD_COPY = 1
Global Const $STD_PASTE = 2
Global Const $STD_UNDO = 3
Global Const $STD_REDOW = 4
Global Const $STD_DELETE = 5
Global Const $STD_FILENEW = 6
Global Const $STD_FILEOPEN = 7
Global Const $STD_FILESAVE = 8
Global Const $STD_PRINTPRE = 9
Global Const $STD_PROPERTIES = 10
Global Const $STD_HELP = 11
Global Const $STD_FIND = 12
Global Const $STD_REPLACE = 13
Global Const $STD_PRINT = 14
Global Const $LR_DEFAULTCOLOR = 0
Global Const $LR_MONOCHROME = 1
Global Const $LR_COLOR = 2
Global Const $LR_COPYRETURNORG = 4
Global Const $LR_COPYDELETEORG = 8
Global Const $LR_LOADFROMFILE = 16
Global Const $LR_LOADTRANSPARENT = 32
Global Const $LR_DEFAULTSIZE = 64
Global Const $LR_VGACOLOR = 128
Global Const $LR_LOADMAP3DCOLORS = 4096
Global Const $LR_CREATEDIBSECTION = 8192
Global Const $LR_COPYFROMRESOURCE = 16384
Global Const $LR_SHARED = 32768
Global Const $IMAGE_BITMAP = 0
Global Const $IMAGE_ICON = 1
Global Const $IMAGE_CURSOR = 2
Global Const $KB_SENDSPECIAL = 0
Global Const $KB_SENDRAW = 1
Global Const $KB_CAPSOFF = 0
Global Const $KB_CAPSON = 1
Global Const $DONT_RESOLVE_DLL_REFERENCES = 1
Global Const $LOAD_LIBRARY_AS_DATAFILE = 2
Global Const $LOAD_WITH_ALTERED_SEARCH_PATH = 8
Global Const $OBJID_WINDOW = 0
Global Const $OBJID_TITLEBAR = -2
Global Const $OBJID_SIZEGRIP = -7
Global Const $OBJID_CARET = -8
Global Const $OBJID_CURSOR = -9
Global Const $OBJID_ALERT = -10
Global Const $OBJID_SOUND = -11
Global Const $VK_DOWN = 40
Global Const $VK_END = 35
Global Const $VK_HOME = 36
Global Const $VK_LEFT = 37
Global Const $VK_NEXT = 34
Global Const $VK_PRIOR = 33
Global Const $VK_RIGHT = 39
Global Const $VK_UP = 38
Global Const $MB_OK = 0
Global Const $MB_OKCANCEL = 1
Global Const $MB_ABORTRETRYIGNORE = 2
Global Const $MB_YESNOCANCEL = 3
Global Const $MB_YESNO = 4
Global Const $MB_RETRYCANCEL = 5
Global Const $MB_ICONHAND = 16
Global Const $MB_ICONQUESTION = 32
Global Const $MB_ICONEXCLAMATION = 48
Global Const $MB_ICONASTERISK = 64
Global Const $MB_DEFBUTTON1 = 0
Global Const $MB_DEFBUTTON2 = 256
Global Const $MB_DEFBUTTON3 = 512
Global Const $MB_APPLMODAL = 0
Global Const $MB_SYSTEMMODAL = 4096
Global Const $MB_TASKMODAL = 8192
Global Const $MB_TOPMOST = 262144
Global Const $MB_RIGHTJUSTIFIED = 524288
Global Const $IDTIMEOUT = -1
Global Const $IDOK = 1
Global Const $IDCANCEL = 2
Global Const $IDABORT = 3
Global Const $IDRETRY = 4
Global Const $IDIGNORE = 5
Global Const $IDYES = 6
Global Const $IDNO = 7
Global Const $IDTRYAGAIN = 10
Global Const $IDCONTINUE = 11
Global Const $DLG_NOTITLE = 1
Global Const $DLG_NOTONTOP = 2
Global Const $DLG_TEXTLEFT = 4
Global Const $DLG_TEXTRIGHT = 8
Global Const $DLG_MOVEABLE = 16
Global Const $DLG_TEXTVCENTER = 32
Global Const $TIP_ICONNONE = 0
Global Const $TIP_ICONASTERISK = 1
Global Const $TIP_ICONEXCLAMATION = 2
Global Const $TIP_ICONHAND = 3
Global Const $TIP_NOSOUND = 16
Global Const $IDC_UNKNOWN = 0
Global Const $IDC_APPSTARTING = 1
Global Const $IDC_ARROW = 2
Global Const $IDC_CROSS = 3
Global Const $IDC_HAND = 32649
Global Const $IDC_HELP = 4
Global Const $IDC_IBEAM = 5
Global Const $IDC_ICON = 6
Global Const $IDC_NO = 7
Global Const $IDC_SIZE = 8
Global Const $IDC_SIZEALL = 9
Global Const $IDC_SIZENESW = 10
Global Const $IDC_SIZENS = 11
Global Const $IDC_SIZENWSE = 12
Global Const $IDC_SIZEWE = 13
Global Const $IDC_UPARROW = 14
Global Const $IDC_WAIT = 15
Global Const $IDI_APPLICATION = 32512
Global Const $IDI_ASTERISK = 32516
Global Const $IDI_EXCLAMATION = 32515
Global Const $IDI_HAND = 32513
Global Const $IDI_QUESTION = 32514
Global Const $IDI_WINLOGO = 32517
Global Const $SD_LOGOFF = 0
Global Const $SD_SHUTDOWN = 1
Global Const $SD_REBOOT = 2
Global Const $SD_FORCE = 4
Global Const $SD_POWERDOWN = 8
Global Const $STR_NOCASESENSE = 0
Global Const $STR_CASESENSE = 1
Global Const $STR_STRIPLEADING = 1
Global Const $STR_STRIPTRAILING = 2
Global Const $STR_STRIPSPACES = 4
Global Const $STR_STRIPALL = 8
Global Const $TRAY_ITEM_EXIT = 3
Global Const $TRAY_ITEM_PAUSE = 4
Global Const $TRAY_ITEM_FIRST = 7
Global Const $TRAY_CHECKED = 1
Global Const $TRAY_UNCHECKED = 4
Global Const $TRAY_ENABLE = 64
Global Const $TRAY_DISABLE = 128
Global Const $TRAY_FOCUS = 256
Global Const $TRAY_DEFAULT = 512
Global Const $TRAY_EVENT_SHOWICON = -3
Global Const $TRAY_EVENT_HIDEICON = -4
Global Const $TRAY_EVENT_FLASHICON = -5
Global Const $TRAY_EVENT_NOFLASHICON = -6
Global Const $TRAY_EVENT_PRIMARYDOWN = -7
Global Const $TRAY_EVENT_PRIMARYUP = -8
Global Const $TRAY_EVENT_SECONDARYDOWN = -9
Global Const $TRAY_EVENT_SECONDARYUP = -10
Global Const $TRAY_EVENT_MOUSEOVER = -11
Global Const $TRAY_EVENT_MOUSEOUT = -12
Global Const $TRAY_EVENT_PRIMARYDOUBLE = -13
Global Const $TRAY_EVENT_SECONDARYDOUBLE = -14
Global Const $STDIN_CHILD = 1
Global Const $STDOUT_CHILD = 2
Global Const $STDERR_CHILD = 4
Global Const $STDERR_MERGED = 8
Global Const $STDIO_INHERIT_PARENT = 16
Global Const $RUN_CREATE_NEW_CONSOLE = 65536
Global Const $MOUSEEVENTF_ABSOLUTE = 32768
Global Const $MOUSEEVENTF_MOVE = 1
Global Const $MOUSEEVENTF_LEFTDOWN = 2
Global Const $MOUSEEVENTF_LEFTUP = 4
Global Const $MOUSEEVENTF_RIGHTDOWN = 8
Global Const $MOUSEEVENTF_RIGHTUP = 16
Global Const $MOUSEEVENTF_MIDDLEDOWN = 32
Global Const $MOUSEEVENTF_MIDDLEUP = 64
Global Const $MOUSEEVENTF_WHEEL = 2048
Global Const $MOUSEEVENTF_XDOWN = 128
Global Const $MOUSEEVENTF_XUP = 256
Global Const $REG_NONE = 0
Global Const $REG_SZ = 1
Global Const $REG_EXPAND_SZ = 2
Global Const $REG_BINARY = 3
Global Const $REG_DWORD = 4
Global Const $REG_DWORD_BIG_ENDIAN = 5
Global Const $REG_LINK = 6
Global Const $REG_MULTI_SZ = 7
Global Const $REG_RESOURCE_LIST = 8
Global Const $REG_FULL_RESOURCE_DESCRIPTOR = 9
Global Const $REG_RESOURCE_REQUIREMENTS_LIST = 10
Global Const $HWND_BOTTOM = 1
Global Const $HWND_NOTOPMOST = -2
Global Const $HWND_TOP = 0
Global Const $HWND_TOPMOST = -1
Global Const $SWP_NOSIZE = 1
Global Const $SWP_NOMOVE = 2
Global Const $SWP_NOZORDER = 4
Global Const $SWP_NOREDRAW = 8
Global Const $SWP_NOACTIVATE = 16
Global Const $SWP_FRAMECHANGED = 32
Global Const $SWP_DRAWFRAME = 32
Global Const $SWP_SHOWWINDOW = 64
Global Const $SWP_HIDEWINDOW = 128
Global Const $SWP_NOCOPYBITS = 256
Global Const $SWP_NOOWNERZORDER = 512
Global Const $SWP_NOREPOSITION = 512
Global Const $SWP_NOSENDCHANGING = 1024
Global Const $SWP_DEFERERASE = 8192
Global Const $SWP_ASYNCWINDOWPOS = 16384
Global Const $LANG_AFRIKAANS = 54
Global Const $LANG_ALBANIAN = 28
Global Const $LANG_ARABIC = 1
Global Const $LANG_ARMENIAN = 43
Global Const $LANG_ASSAMESE = 77
Global Const $LANG_AZERI = 44
Global Const $LANG_BASQUE = 45
Global Const $LANG_BELARUSIAN = 35
Global Const $LANG_BENGALI = 69
Global Const $LANG_BULGARIAN = 2
Global Const $LANG_CATALAN = 3
Global Const $LANG_CHINESE = 4
Global Const $LANG_CROATIAN = 26
Global Const $LANG_CZECH = 5
Global Const $LANG_DANISH = 6
Global Const $LANG_DUTCH = 19
Global Const $LANG_ENGLISH = 9
Global Const $LANG_ESTONIAN = 37
Global Const $LANG_FAEROESE = 56
Global Const $LANG_FARSI = 41
Global Const $LANG_FINNISH = 11
Global Const $LANG_FRENCH = 156
Global Const $LANG_GEORGIAN = 55
Global Const $LANG_GERMAN = 7
Global Const $LANG_GREEK = 8
Global Const $LANG_GUJARATI = 71
Global Const $LANG_HEBREW = 13
Global Const $LANG_HINDI = 57
Global Const $LANG_HUNGARIAN = 14
Global Const $LANG_ICELANDIC = 15
Global Const $LANG_INDONESIAN = 33
Global Const $LANG_ITALIAN = 16
Global Const $LANG_JAPANESE = 17
Global Const $LANG_KANNADA = 75
Global Const $LANG_KASHMIRI = 96
Global Const $LANG_KAZAK = 63
Global Const $LANG_KONKANI = 87
Global Const $LANG_KOREAN = 18
Global Const $LANG_LATVIAN = 38
Global Const $LANG_LITHUANIAN = 39
Global Const $LANG_MACEDONIAN = 47
Global Const $LANG_MALAY = 62
Global Const $LANG_MALAYALAM = 76
Global Const $LANG_MANIPURI = 88
Global Const $LANG_MARATHI = 78
Global Const $LANG_NEPALI = 97
Global Const $LANG_NEUTRAL = 0
Global Const $LANG_NORWEGIAN = 20
Global Const $LANG_ORIYA = 72
Global Const $LANG_POLISH = 21
Global Const $LANG_PORTUGUESE = 22
Global Const $LANG_PUNJABI = 70
Global Const $LANG_ROMANIAN = 24
Global Const $LANG_RUSSIAN = 25
Global Const $LANG_SANSKRIT = 79
Global Const $LANG_SERBIAN = 26
Global Const $LANG_SINDHI = 89
Global Const $LANG_SLOVAK = 27
Global Const $LANG_SLOVENIAN = 36
Global Const $LANG_SPANISH = 10
Global Const $LANG_SWAHILI = 65
Global Const $LANG_SWEDISH = 29
Global Const $LANG_TAMIL = 73
Global Const $LANG_TATAR = 68
Global Const $LANG_TELUGU = 74
Global Const $LANG_THAI = 30
Global Const $LANG_TURKISH = 31
Global Const $LANG_UKRAINIAN = 34
Global Const $LANG_URDU = 32
Global Const $LANG_UZBEK = 67
Global Const $LANG_VIETNAMESE = 42
Global Const $SUBLANG_ARABIC_ALGERIA = 5
Global Const $SUBLANG_ARABIC_BAHRAIN = 15
Global Const $SUBLANG_ARABIC_EGYPT = 3
Global Const $SUBLANG_ARABIC_IRAQ = 2
Global Const $SUBLANG_ARABIC_JORDAN = 11
Global Const $SUBLANG_ARABIC_KUWAIT = 13
Global Const $SUBLANG_ARABIC_LEBANON = 12
Global Const $SUBLANG_ARABIC_LIBYA = 4
Global Const $SUBLANG_ARABIC_MOROCCO = 6
Global Const $SUBLANG_ARABIC_OMAN = 8
Global Const $SUBLANG_ARABIC_QATAR = 16
Global Const $SUBLANG_ARABIC_SAUDI_ARABIA = 1
Global Const $SUBLANG_ARABIC_SYRIA = 10
Global Const $SUBLANG_ARABIC_TUNISIA = 7
Global Const $SUBLANG_ARABIC_UAE = 14
Global Const $SUBLANG_ARABIC_YEMEN = 9
Global Const $SUBLANG_AZERI_CYRILLIC = 2
Global Const $SUBLANG_AZERI_LATIN = 1
Global Const $SUBLANG_CHINESE_HONGKONG = 3
Global Const $SUBLANG_CHINESE_MACAU = 5
Global Const $SUBLANG_CHINESE_SIMPLIFIED = 2
Global Const $SUBLANG_CHINESE_SINGAPORE = 4
Global Const $SUBLANG_CHINESE_TRADITIONAL = 1
Global Const $SUBLANG_DEFAULT = 1
Global Const $SUBLANG_DUTCH = 1
Global Const $SUBLANG_DUTCH_BELGIAN = 2
Global Const $SUBLANG_ENGLISH_AUS = 3
Global Const $SUBLANG_ENGLISH_BELIZE = 10
Global Const $SUBLANG_ENGLISH_CAN = 4
Global Const $SUBLANG_ENGLISH_CARIBBEAN = 9
Global Const $SUBLANG_ENGLISH_EIRE = 6
Global Const $SUBLANG_ENGLISH_JAMAICA = 8
Global Const $SUBLANG_ENGLISH_NZ = 5
Global Const $SUBLANG_ENGLISH_PHILIPPINES = 13
Global Const $SUBLANG_ENGLISH_SOUTH_AFRICA = 7
Global Const $SUBLANG_ENGLISH_TRINIDAD = 11
Global Const $SUBLANG_ENGLISH_UK = 2
Global Const $SUBLANG_ENGLISH_US = 1
Global Const $SUBLANG_ENGLISH_ZIMBABWE = 12
Global Const $SUBLANG_FRENCH = 1
Global Const $SUBLANG_FRENCH_BELGIAN = 2
Global Const $SUBLANG_FRENCH_CANADIAN = 3
Global Const $SUBLANG_FRENCH_LUXEMBOURG = 5
Global Const $SUBLANG_FRENCH_MONACO = 6
Global Const $SUBLANG_FRENCH_SWISS = 4
Global Const $SUBLANG_GERMAN = 1
Global Const $SUBLANG_GERMAN_AUSTRIAN = 3
Global Const $SUBLANG_GERMAN_LIECHTENSTEIN = 5
Global Const $SUBLANG_GERMAN_LUXEMBOURG = 4
Global Const $SUBLANG_GERMAN_SWISS = 2
Global Const $SUBLANG_ITALIAN = 1
Global Const $SUBLANG_ITALIAN_SWISS = 2
Global Const $SUBLANG_KASHMIRI_INDIA = 2
Global Const $SUBLANG_KOREAN = 1
Global Const $SUBLANG_LITHUANIAN = 1
Global Const $SUBLANG_MALAY_BRUNEI_DARUSSALAM = 2
Global Const $SUBLANG_MALAY_MALAYSIA = 1
Global Const $SUBLANG_NEPALI_INDIA = 2
Global Const $SUBLANG_NEUTRAL = 0
Global Const $SUBLANG_NORWEGIAN_BOKMAL = 1
Global Const $SUBLANG_NORWEGIAN_NYNORSK = 2
Global Const $SUBLANG_PORTUGUESE = 2
Global Const $SUBLANG_PORTUGUESE_BRAZILIAN = 1
Global Const $SUBLANG_SERBIAN_CYRILLIC = 3
Global Const $SUBLANG_SERBIAN_LATIN = 2
Global Const $SUBLANG_SPANISH = 1
Global Const $SUBLANG_SPANISH_ARGENTINA = 11
Global Const $SUBLANG_SPANISH_BOLIVIA = 16
Global Const $SUBLANG_SPANISH_CHILE = 13
Global Const $SUBLANG_SPANISH_COLOMBIA = 9
Global Const $SUBLANG_SPANISH_COSTA_RICA = 5
Global Const $SUBLANG_SPANISH_DOMINICAN_REPUBLIC = 7
Global Const $SUBLANG_SPANISH_ECUADOR = 12
Global Const $SUBLANG_SPANISH_EL_SALVADOR = 17
Global Const $SUBLANG_SPANISH_GUATEMALA = 4
Global Const $SUBLANG_SPANISH_HONDURAS = 18
Global Const $SUBLANG_SPANISH_MEXICAN = 2
Global Const $SUBLANG_SPANISH_MODERN = 3
Global Const $SUBLANG_SPANISH_NICARAGUA = 19
Global Const $SUBLANG_SPANISH_PANAMA = 6
Global Const $SUBLANG_SPANISH_PARAGUAY = 15
Global Const $SUBLANG_SPANISH_PERU = 10
Global Const $SUBLANG_SPANISH_PUERTO_RICO = 20
Global Const $SUBLANG_SPANISH_URUGUAY = 14
Global Const $SUBLANG_SPANISH_VENEZUELA = 8
Global Const $SUBLANG_SWEDISH = 1
Global Const $SUBLANG_SWEDISH_FINLAND = 2
Global Const $SUBLANG_SYS_DEFAULT = 2
Global Const $SUBLANG_URDU_INDIA = 2
Global Const $SUBLANG_URDU_PAKISTAN = 1
Global Const $SUBLANG_UZBEK_CYRILLIC = 2
Global Const $SORT_DEFAULT = 0
Global Const $SORT_JAPANESE_XJIS = 0
Global Const $SORT_JAPANESE_UNICODE = 1
Global Const $SORT_CHINESE_BIG5 = 0
Global Const $SORT_CHINESE_PRCP = 0
Global Const $SORT_CHINESE_UNICODE = 1
Global Const $SORT_CHINESE_PRC = 2
Global Const $SORT_KOREAN_KSC = 0
Global Const $SORT_KOREAN_UNICODE = 1
Global Const $SORT_GERMAN_PHONE_BOOK = 1
Global Const $SORT_HUNGARIAN_DEFAULT = 0
Global Const $SORT_HUNGARIAN_TECHNICAL = 1
Global Const $SORT_GEORGIAN_TRADITIONAL = 0
Global Const $SORT_GEORGIAN_MODERN = 1
Global Const $ES_LEFT = 0
Global Const $ES_CENTER = 1
Global Const $ES_RIGHT = 2
Global Const $ES_MULTILINE = 4
Global Const $ES_UPPERCASE = 8
Global Const $ES_LOWERCASE = 16
Global Const $ES_PASSWORD = 32
Global Const $ES_AUTOVSCROLL = 64
Global Const $ES_AUTOHSCROLL = 128
Global Const $ES_NOHIDESEL = 256
Global Const $ES_OEMCONVERT = 1024
Global Const $ES_READONLY = 2048
Global Const $ES_WANTRETURN = 4096
Global Const $ES_NUMBER = 8192
Global Const $EC_ERR = -1
Global Const $ECM_FIRST = 5376
Global Const $EM_CANUNDO = 198
Global Const $EM_CHARFROMPOS = 215
Global Const $EM_EMPTYUNDOBUFFER = 205
Global Const $EM_FMTLINES = 200
Global Const $EM_GETCUEBANNER = ($ECM_FIRST + 2)
Global Const $EM_GETFIRSTVISIBLELINE = 206
Global Const $EM_GETHANDLE = 189
Global Const $EM_GETIMESTATUS = 217
Global Const $EM_GETLIMITTEXT = 213
Global Const $EM_GETLINE = 196
Global Const $EM_GETLINECOUNT = 186
Global Const $EM_GETMARGINS = 212
Global Const $EM_GETMODIFY = 184
Global Const $EM_GETPASSWORDCHAR = 210
Global Const $EM_GETRECT = 178
Global Const $EM_GETSEL = 176
Global Const $EM_GETTHUMB = 190
Global Const $EM_GETWORDBREAKPROC = 209
Global Const $EM_HIDEBALLOONTIP = ($ECM_FIRST + 4)
Global Const $EM_LIMITTEXT = 197
Global Const $EM_LINEFROMCHAR = 201
Global Const $EM_LINEINDEX = 187
Global Const $EM_LINELENGTH = 193
Global Const $EM_LINESCROLL = 182
Global Const $EM_POSFROMCHAR = 214
Global Const $EM_REPLACESEL = 194
Global Const $EM_SCROLL = 181
Global Const $EM_SCROLLCARET = 183
Global Const $EM_SETCUEBANNER = ($ECM_FIRST + 1)
Global Const $EM_SETHANDLE = 188
Global Const $EM_SETIMESTATUS = 216
Global Const $EM_SETLIMITTEXT = $EM_LIMITTEXT
Global Const $EM_SETMARGINS = 211
Global Const $EM_SETMODIFY = 185
Global Const $EM_SETPASSWORDCHAR = 204
Global Const $EM_SETREADONLY = 207
Global Const $EM_SETRECT = 179
Global Const $EM_SETRECTNP = 180
Global Const $EM_SETSEL = 177
Global Const $EM_SETTABSTOPS = 203
Global Const $EM_SETWORDBREAKPROC = 208
Global Const $EM_SHOWBALLOONTIP = ($ECM_FIRST + 3)
Global Const $EM_UNDO = 199
Global Const $EC_LEFTMARGIN = 1
Global Const $EC_RIGHTMARGIN = 2
Global Const $EC_USEFONTINFO = 65535
Global Const $EMSIS_COMPOSITIONSTRING = 1
Global Const $EIMES_GETCOMPSTRATONCE = 1
Global Const $EIMES_CANCELCOMPSTRINFOCUS = 2
Global Const $EIMES_COMPLETECOMPSTRKILLFOCUS = 4
Global Const $EN_ALIGN_LTR_EC = 1792
Global Const $EN_ALIGN_RTL_EC = 1793
Global Const $EN_CHANGE = 768
Global Const $EN_ERRSPACE = 1280
Global Const $EN_HSCROLL = 1537
Global Const $EN_KILLFOCUS = 512
Global Const $EN_MAXTEXT = 1281
Global Const $EN_SETFOCUS = 256
Global Const $EN_UPDATE = 1024
Global Const $EN_VSCROLL = 1538
Global Const $TTI_NONE = 0
Global Const $TTI_INFO = 1
Global Const $TTI_WARNING = 2
Global Const $TTI_ERROR = 3
Global Const $TTI_INFO_LARGE = 4
Global Const $TTI_WARNING_LARGE = 5
Global Const $TTI_ERROR_LARGE = 6
Global Const $__EDITCONSTANT_WS_VSCROLL = 2097152
Global Const $__EDITCONSTANT_WS_HSCROLL = 1048576
Global Const $GUI_SS_DEFAULT_EDIT = BitOR($ES_WANTRETURN, $__EDITCONSTANT_WS_VSCROLL, $__EDITCONSTANT_WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL)
Global Const $GUI_SS_DEFAULT_INPUT = BitOR($ES_LEFT, $ES_AUTOHSCROLL)

Func _FILECOUNTLINES($SFILEPATH)
	Local $HFILE = FileOpen($SFILEPATH, $FO_READ)
	If $HFILE = -1 Then Return SetError(1, 0, 0)
	Local $SFILECONTENT = StringStripWS(FileRead($HFILE), 2)
	FileClose($HFILE)
	Local $ATMP
	If StringInStr($SFILECONTENT, @LF) Then
		$ATMP = StringSplit(StringStripCR($SFILECONTENT), @LF)
	ElseIf StringInStr($SFILECONTENT, @CR) Then
		$ATMP = StringSplit($SFILECONTENT, @CR)
	Else
		If StringLen($SFILECONTENT) Then
			Return 1
		Else
			Return SetError(2, 0, 0)
		EndIf
	EndIf
	Return $ATMP[0]
EndFunc


Func _FILECREATE($SFILEPATH)
	Local $HOPENFILE = FileOpen($SFILEPATH, $FO_OVERWRITE)
	If $HOPENFILE = -1 Then Return SetError(1, 0, 0)
	Local $HWRITEFILE = FileWrite($HOPENFILE, "")
	FileClose($HOPENFILE)
	If $HWRITEFILE = -1 Then Return SetError(2, 0, 0)
	Return 1
EndFunc


Func _FILELISTTOARRAY($SPATH, $SFILTER = "*", $IFLAG = 0)
	Local $HSEARCH, $SFILE, $SFILELIST, $SDELIM = "|"
	$SPATH = StringRegExpReplace($SPATH, "[\\/]+\z", "") & "\"
	If Not FileExists($SPATH) Then Return SetError(1, 1, "")
	If StringRegExp($SFILTER, "[\\/:><\|]|(?s)\A\s*\z") Then Return SetError(2, 2, "")
	If Not ($IFLAG = 0 Or $IFLAG = 1 Or $IFLAG = 2) Then Return SetError(3, 3, "")
	$HSEARCH = FileFindFirstFile($SPATH & $SFILTER)
	If @error Then Return SetError(4, 4, "")
	While 1
		$SFILE = FileFindNextFile($HSEARCH)
		If @error Then ExitLoop
		If ($IFLAG + @extended = 2) Then ContinueLoop
		$SFILELIST &= $SDELIM & $SFILE
	WEnd
	FileClose($HSEARCH)
	If Not $SFILELIST Then Return SetError(4, 4, "")
	Return StringSplit(StringTrimLeft($SFILELIST, 1), "|")
EndFunc


Func _FILEPRINT($S_FILE, $I_SHOW = @SW_HIDE)
	Local $A_RET = DllCall("shell32.dll", "int", "ShellExecuteW", "hwnd", 0, "wstr", "print", "wstr", $S_FILE, "wstr", "", "wstr", "", "int", $I_SHOW)
	If @error Then Return SetError(@error, @extended, 0)
	If $A_RET[0] <= 32 Then Return SetError(10, $A_RET[0], 0)
	Return 1
EndFunc


Func _FILEREADTOARRAY($SFILEPATH, ByRef $AARRAY)
	Local $HFILE = FileOpen($SFILEPATH, $FO_READ)
	If $HFILE = -1 Then Return SetError(1, 0, 0)
	Local $AFILE = FileRead($HFILE, FileGetSize($SFILEPATH))
	If StringRight($AFILE, 1) = @LF Then $AFILE = StringTrimRight($AFILE, 1)
	If StringRight($AFILE, 1) = @CR Then $AFILE = StringTrimRight($AFILE, 1)
	FileClose($HFILE)
	If StringInStr($AFILE, @LF) Then
		$AARRAY = StringSplit(StringStripCR($AFILE), @LF)
	ElseIf StringInStr($AFILE, @CR) Then
		$AARRAY = StringSplit($AFILE, @CR)
	Else
		If StringLen($AFILE) Then
			Dim $AARRAY[2] = [1, $AFILE]
		Else
			Return SetError(2, 0, 0)
		EndIf
	EndIf
	Return 1
EndFunc


Func _FILEWRITEFROMARRAY($FILE, $A_ARRAY, $I_BASE = 0, $I_UBOUND = 0)
	If Not IsArray($A_ARRAY) Then Return SetError(2, 0, 0)
	Local $LAST = UBound($A_ARRAY) - 1
	If $I_UBOUND < 1 Or $I_UBOUND > $LAST Then $I_UBOUND = $LAST
	If $I_BASE < 0 Or $I_BASE > $LAST Then $I_BASE = 0
	Local $HFILE
	If IsString($FILE) Then
		$HFILE = FileOpen($FILE, $FO_OVERWRITE)
	Else
		$HFILE = $FILE
	EndIf
	If $HFILE = -1 Then Return SetError(1, 0, 0)
	Local $ERRORSAV = 0
	For $X = $I_BASE To $I_UBOUND
		If FileWrite($HFILE, $A_ARRAY[$X] & @CRLF) = 0 Then
			$ERRORSAV = 3
			ExitLoop
		EndIf
	Next
	If IsString($FILE) Then FileClose($HFILE)
	If $ERRORSAV Then Return SetError($ERRORSAV, 0, 0)
	Return 1
EndFunc


Func _FILEWRITELOG($SLOGPATH, $SLOGMSG, $IFLAG = -1)
	Local $IOPENMODE = $FO_APPEND
	Local $SDATENOW = @YEAR & "-" & @MON & "-" & @MDAY
	Local $STIMENOW = @HOUR & ":" & @MIN & ":" & @SEC
	Local $SMSG = $SDATENOW & " " & $STIMENOW & " : " & $SLOGMSG
	If $IFLAG <> -1 Then
		$SMSG &= @CRLF & FileRead($SLOGPATH)
		$IOPENMODE = $FO_OVERWRITE
	EndIf
	Local $HOPENFILE = FileOpen($SLOGPATH, $IOPENMODE)
	If $HOPENFILE = -1 Then Return SetError(1, 0, 0)
	Local $IWRITEFILE = FileWriteLine($HOPENFILE, $SMSG)
	Local $IRET = FileClose($HOPENFILE)
	If $IWRITEFILE = -1 Then Return SetError(2, $IRET, 0)
	Return $IRET
EndFunc


Func _FILEWRITETOLINE($SFILE, $ILINE, $STEXT, $FOVERWRITE = 0)
	If $ILINE <= 0 Then Return SetError(4, 0, 0)
	If Not IsString($STEXT) Then
		$STEXT = String($STEXT)
		If $STEXT = "" Then Return SetError(6, 0, 0)
	EndIf
	If $FOVERWRITE <> 0 And $FOVERWRITE <> 1 Then Return SetError(5, 0, 0)
	If Not FileExists($SFILE) Then Return SetError(2, 0, 0)
	Local $SREAD_FILE = FileRead($SFILE)
	Local $ASPLIT_FILE = StringSplit(StringStripCR($SREAD_FILE), @LF)
	If UBound($ASPLIT_FILE) < $ILINE Then Return SetError(1, 0, 0)
	Local $HFILE = FileOpen($SFILE, $FO_OVERWRITE)
	If $HFILE = -1 Then Return SetError(3, 0, 0)
	$SREAD_FILE = ""
	For $I = 1 To $ASPLIT_FILE[0]
		If $I = $ILINE Then
			If $FOVERWRITE = 1 Then
				If $STEXT <> "" Then $SREAD_FILE &= $STEXT & @CRLF
			Else
				$SREAD_FILE &= $STEXT & @CRLF & $ASPLIT_FILE[$I] & @CRLF
			EndIf
		ElseIf $I < $ASPLIT_FILE[0] Then
			$SREAD_FILE &= $ASPLIT_FILE[$I] & @CRLF
		ElseIf $I = $ASPLIT_FILE[0] Then
			$SREAD_FILE &= $ASPLIT_FILE[$I]
		EndIf
	Next
	FileWrite($HFILE, $SREAD_FILE)
	FileClose($HFILE)
	Return 1
EndFunc


Func _PATHFULL($SRELATIVEPATH, $SBASEPATH = @WorkingDir)
	If Not $SRELATIVEPATH Or $SRELATIVEPATH = "." Then Return $SBASEPATH
	Local $SFULLPATH = StringReplace($SRELATIVEPATH, "/", "\")
	Local Const $SFULLPATHCONST = $SFULLPATH
	Local $SPATH
	Local $BROOTONLY = StringLeft($SFULLPATH, 1) = "\" And StringMid($SFULLPATH, 2, 1) <> "\"
	For $I = 1 To 2
		$SPATH = StringLeft($SFULLPATH, 2)
		If $SPATH = "\\" Then
			$SFULLPATH = StringTrimLeft($SFULLPATH, 2)
			Local $NSERVERLEN = StringInStr($SFULLPATH, "\") - 1
			$SPATH = "\\" & StringLeft($SFULLPATH, $NSERVERLEN)
			$SFULLPATH = StringTrimLeft($SFULLPATH, $NSERVERLEN)
			ExitLoop
		ElseIf StringRight($SPATH, 1) = ":" Then
			$SFULLPATH = StringTrimLeft($SFULLPATH, 2)
			ExitLoop
		Else
			$SFULLPATH = $SBASEPATH & "\" & $SFULLPATH
		EndIf
	Next
	If $I = 3 Then Return ""
	If StringLeft($SFULLPATH, 1) <> "\" Then
		If StringLeft($SFULLPATHCONST, 2) = StringLeft($SBASEPATH, 2) Then
			$SFULLPATH = $SBASEPATH & "\" & $SFULLPATH
		Else
			$SFULLPATH = "\" & $SFULLPATH
		EndIf
	EndIf
	Local $ATEMP = StringSplit($SFULLPATH, "\")
	Local $APATHPARTS[$ATEMP[0]], $J = 0
	For $I = 2 To $ATEMP[0]
		If $ATEMP[$I] = ".." Then
			If $J Then $J -= 1
		ElseIf Not ($ATEMP[$I] = "" And $I <> $ATEMP[0]) And $ATEMP[$I] <> "." Then
			$APATHPARTS[$J] = $ATEMP[$I]
			$J += 1
		EndIf
	Next
	$SFULLPATH = $SPATH
	If Not $BROOTONLY Then
		For $I = 0 To $J - 1
			$SFULLPATH &= "\" & $APATHPARTS[$I]
		Next
	Else
		$SFULLPATH &= $SFULLPATHCONST
		If StringInStr($SFULLPATH, "..") Then $SFULLPATH = _PATHFULL($SFULLPATH)
	EndIf
	While StringInStr($SFULLPATH, ".\")
		$SFULLPATH = StringReplace($SFULLPATH, ".\", "\")
	WEnd
	Return $SFULLPATH
EndFunc


Func _PATHGETRELATIVE($SFROM, $STO)
	If StringRight($SFROM, 1) <> "\" Then $SFROM &= "\"
	If StringRight($STO, 1) <> "\" Then $STO &= "\"
	If $SFROM = $STO Then Return SetError(1, 0, StringTrimRight($STO, 1))
	Local $ASFROM = StringSplit($SFROM, "\")
	Local $ASTO = StringSplit($STO, "\")
	If $ASFROM[1] <> $ASTO[1] Then Return SetError(2, 0, StringTrimRight($STO, 1))
	Local $I = 2
	Local $IDIFF = 1
	While 1
		If $ASFROM[$I] <> $ASTO[$I] Then
			$IDIFF = $I
			ExitLoop
		EndIf
		$I += 1
	WEnd
	$I = 1
	Local $SRELPATH = ""
	For $J = 1 To $ASTO[0]
		If $I >= $IDIFF Then
			$SRELPATH &= "\" & $ASTO[$I]
		EndIf
		$I += 1
	Next
	$SRELPATH = StringTrimLeft($SRELPATH, 1)
	$I = 1
	For $J = 1 To $ASFROM[0]
		If $I > $IDIFF Then
			$SRELPATH = "..\" & $SRELPATH
		EndIf
		$I += 1
	Next
	If StringRight($SRELPATH, 1) == "\" Then $SRELPATH = StringTrimRight($SRELPATH, 1)
	Return $SRELPATH
EndFunc


Func _PATHMAKE($SZDRIVE, $SZDIR, $SZFNAME, $SZEXT)
	If StringLen($SZDRIVE) Then
		If Not (StringLeft($SZDRIVE, 2) = "\\") Then $SZDRIVE = StringLeft($SZDRIVE, 1) & ":"
	EndIf
	If StringLen($SZDIR) Then
		If Not (StringRight($SZDIR, 1) = "\") And Not (StringRight($SZDIR, 1) = "/") Then $SZDIR = $SZDIR & "\"
	EndIf
	If StringLen($SZEXT) Then
		If Not (StringLeft($SZEXT, 1) = ".") Then $SZEXT = "." & $SZEXT
	EndIf
	Return $SZDRIVE & $SZDIR & $SZFNAME & $SZEXT
EndFunc


Func _PATHSPLIT($SZPATH, ByRef $SZDRIVE, ByRef $SZDIR, ByRef $SZFNAME, ByRef $SZEXT)
	Local $DRIVE = ""
	Local $DIR = ""
	Local $FNAME = ""
	Local $EXT = ""
	Local $POS
	Local $ARRAY[5]
	$ARRAY[0] = $SZPATH
	If StringMid($SZPATH, 2, 1) = ":" Then
		$DRIVE = StringLeft($SZPATH, 2)
		$SZPATH = StringTrimLeft($SZPATH, 2)
	ElseIf StringLeft($SZPATH, 2) = "\\" Then
		$SZPATH = StringTrimLeft($SZPATH, 2)
		$POS = StringInStr($SZPATH, "\")
		If $POS = 0 Then $POS = StringInStr($SZPATH, "/")
		If $POS = 0 Then
			$DRIVE = "\\" & $SZPATH
			$SZPATH = ""
		Else
			$DRIVE = "\\" & StringLeft($SZPATH, $POS - 1)
			$SZPATH = StringTrimLeft($SZPATH, $POS - 1)
		EndIf
	EndIf
	Local $NPOSFORWARD = StringInStr($SZPATH, "/", 0, -1)
	Local $NPOSBACKWARD = StringInStr($SZPATH, "\", 0, -1)
	If $NPOSFORWARD >= $NPOSBACKWARD Then
		$POS = $NPOSFORWARD
	Else
		$POS = $NPOSBACKWARD
	EndIf
	$DIR = StringLeft($SZPATH, $POS)
	$FNAME = StringRight($SZPATH, StringLen($SZPATH) - $POS)
	If StringLen($DIR) = 0 Then $FNAME = $SZPATH
	$POS = StringInStr($FNAME, ".", 0, -1)
	If $POS Then
		$EXT = StringRight($FNAME, StringLen($FNAME) - ($POS - 1))
		$FNAME = StringLeft($FNAME, $POS - 1)
	EndIf
	$SZDRIVE = $DRIVE
	$SZDIR = $DIR
	$SZFNAME = $FNAME
	$SZEXT = $EXT
	$ARRAY[1] = $DRIVE
	$ARRAY[2] = $DIR
	$ARRAY[3] = $FNAME
	$ARRAY[4] = $EXT
	Return $ARRAY
EndFunc


Func _REPLACESTRINGINFILE($SZFILENAME, $SZSEARCHSTRING, $SZREPLACESTRING, $FCASENESS = 0, $FOCCURANCE = 1)
	Local $IRETVAL = 0
	Local $NCOUNT, $SENDSWITH
	If StringInStr(FileGetAttrib($SZFILENAME), "R") Then Return SetError(6, 0, -1)
	Local $HFILE = FileOpen($SZFILENAME, $FO_READ)
	If $HFILE = -1 Then Return SetError(1, 0, -1)
	Local $S_TOTFILE = FileRead($HFILE, FileGetSize($SZFILENAME))
	If StringRight($S_TOTFILE, 2) = @CRLF Then
		$SENDSWITH = @CRLF
	ElseIf StringRight($S_TOTFILE, 1) = @CR Then
		$SENDSWITH = @CR
	ElseIf StringRight($S_TOTFILE, 1) = @LF Then
		$SENDSWITH = @LF
	Else
		$SENDSWITH = ""
	EndIf
	Local $AFILELINES = StringSplit(StringStripCR($S_TOTFILE), @LF)
	FileClose($HFILE)
	Local $HWRITEHANDLE = FileOpen($SZFILENAME, $FO_OVERWRITE)
	If $HWRITEHANDLE = -1 Then Return SetError(2, 0, -1)
	For $NCOUNT = 1 To $AFILELINES[0]
		If StringInStr($AFILELINES[$NCOUNT], $SZSEARCHSTRING, $FCASENESS) Then
			$AFILELINES[$NCOUNT] = StringReplace($AFILELINES[$NCOUNT], $SZSEARCHSTRING, $SZREPLACESTRING, 1 - $FOCCURANCE, $FCASENESS)
			$IRETVAL = $IRETVAL + 1
			If $FOCCURANCE = 0 Then
				$IRETVAL = 1
				ExitLoop
			EndIf
		EndIf
	Next
	For $NCOUNT = 1 To $AFILELINES[0] - 1
		If FileWriteLine($HWRITEHANDLE, $AFILELINES[$NCOUNT]) = 0 Then
			FileClose($HWRITEHANDLE)
			Return SetError(3, 0, -1)
		EndIf
	Next
	If $AFILELINES[$NCOUNT] <> "" Then FileWrite($HWRITEHANDLE, $AFILELINES[$NCOUNT] & $SENDSWITH)
	FileClose($HWRITEHANDLE)
	Return $IRETVAL
EndFunc


Func _TEMPFILE($S_DIRECTORYNAME = @TempDir, $S_FILEPREFIX = "~", $S_FILEEXTENSION = ".tmp", $I_RANDOMLENGTH = 7)
	If Not FileExists($S_DIRECTORYNAME) Then $S_DIRECTORYNAME = @TempDir
	If Not FileExists($S_DIRECTORYNAME) Then $S_DIRECTORYNAME = @ScriptDir
	If StringRight($S_DIRECTORYNAME, 1) <> "\" Then $S_DIRECTORYNAME = $S_DIRECTORYNAME & "\"
	Local $S_TEMPNAME
	Do
		$S_TEMPNAME = ""
		While StringLen($S_TEMPNAME) < $I_RANDOMLENGTH
			$S_TEMPNAME = $S_TEMPNAME & Chr(Random(97, 122, 1))
		WEnd
		$S_TEMPNAME = $S_DIRECTORYNAME & $S_FILEPREFIX & $S_TEMPNAME & $S_FILEEXTENSION
	Until Not FileExists($S_TEMPNAME)
	Return $S_TEMPNAME
EndFunc

Global Const $GUI_EVENT_CLOSE = -3
Global Const $GUI_EVENT_MINIMIZE = -4
Global Const $GUI_EVENT_RESTORE = -5
Global Const $GUI_EVENT_MAXIMIZE = -6
Global Const $GUI_EVENT_PRIMARYDOWN = -7
Global Const $GUI_EVENT_PRIMARYUP = -8
Global Const $GUI_EVENT_SECONDARYDOWN = -9
Global Const $GUI_EVENT_SECONDARYUP = -10
Global Const $GUI_EVENT_MOUSEMOVE = -11
Global Const $GUI_EVENT_RESIZED = -12
Global Const $GUI_EVENT_DROPPED = -13
Global Const $GUI_RUNDEFMSG = "GUI_RUNDEFMSG"
Global Const $GUI_AVISTOP = 0
Global Const $GUI_AVISTART = 1
Global Const $GUI_AVICLOSE = 2
Global Const $GUI_CHECKED = 1
Global Const $GUI_INDETERMINATE = 2
Global Const $GUI_UNCHECKED = 4
Global Const $GUI_DROPACCEPTED = 8
Global Const $GUI_NODROPACCEPTED = 4096
Global Const $GUI_ACCEPTFILES = $GUI_DROPACCEPTED
Global Const $GUI_SHOW = 16
Global Const $GUI_HIDE = 32
Global Const $GUI_ENABLE = 64
Global Const $GUI_DISABLE = 128
Global Const $GUI_FOCUS = 256
Global Const $GUI_NOFOCUS = 8192
Global Const $GUI_DEFBUTTON = 512
Global Const $GUI_EXPAND = 1024
Global Const $GUI_ONTOP = 2048
Global Const $GUI_FONTITALIC = 2
Global Const $GUI_FONTUNDER = 4
Global Const $GUI_FONTSTRIKE = 8
Global Const $GUI_DOCKAUTO = 1
Global Const $GUI_DOCKLEFT = 2
Global Const $GUI_DOCKRIGHT = 4
Global Const $GUI_DOCKHCENTER = 8
Global Const $GUI_DOCKTOP = 32
Global Const $GUI_DOCKBOTTOM = 64
Global Const $GUI_DOCKVCENTER = 128
Global Const $GUI_DOCKWIDTH = 256
Global Const $GUI_DOCKHEIGHT = 512
Global Const $GUI_DOCKSIZE = 768
Global Const $GUI_DOCKMENUBAR = 544
Global Const $GUI_DOCKSTATEBAR = 576
Global Const $GUI_DOCKALL = 802
Global Const $GUI_DOCKBORDERS = 102
Global Const $GUI_GR_CLOSE = 1
Global Const $GUI_GR_LINE = 2
Global Const $GUI_GR_BEZIER = 4
Global Const $GUI_GR_MOVE = 6
Global Const $GUI_GR_COLOR = 8
Global Const $GUI_GR_RECT = 10
Global Const $GUI_GR_ELLIPSE = 12
Global Const $GUI_GR_PIE = 14
Global Const $GUI_GR_DOT = 16
Global Const $GUI_GR_PIXEL = 18
Global Const $GUI_GR_HINT = 20
Global Const $GUI_GR_REFRESH = 22
Global Const $GUI_GR_PENSIZE = 24
Global Const $GUI_GR_NOBKCOLOR = -2
Global Const $GUI_BKCOLOR_DEFAULT = -1
Global Const $GUI_BKCOLOR_TRANSPARENT = -2
Global Const $GUI_BKCOLOR_LV_ALTERNATE = -33554432
Global Const $GUI_WS_EX_PARENTDRAG = 1048576

Func _PROCESSGETNAME($I_PID)
	If Not ProcessExists($I_PID) Then Return SetError(1, 0, "")
	If Not @error Then
		Local $A_PROCESSES = ProcessList()
		For $I = 1 To $A_PROCESSES[0][0]
			If $A_PROCESSES[$I][1] = $I_PID Then Return $A_PROCESSES[$I][0]
		Next
	EndIf
	Return SetError(1, 0, "")
EndFunc


Func _PROCESSGETPRIORITY($VPROCESS)
	Local $IERROR, $IEXTENDED, $IRETURN = -1
	Local $I_PID = ProcessExists($VPROCESS)
	If Not $I_PID Then Return SetError(1, 0, -1)
	Local $HDLL = DllOpen("kernel32.dll")
	Do
		Local $APROCESSHANDLE = DllCall($HDLL, "handle", "OpenProcess", "dword", $PROCESS_QUERY_INFORMATION, "bool", False, "dword", $I_PID)
		If @error Then
			$IERROR = @error
			$IEXTENDED = @extended
			ExitLoop
		EndIf
		If Not $APROCESSHANDLE[0] Then ExitLoop
		Local $APRIORITY = DllCall($HDLL, "dword", "GetPriorityClass", "handle", $APROCESSHANDLE[0])
		If @error Then
			$IERROR = @error
			$IEXTENDED = @extended
		EndIf
		DllCall($HDLL, "bool", "CloseHandle", "handle", $APROCESSHANDLE[0])
		If $IERROR Then ExitLoop
		Switch $APRIORITY[0]
			Case 64
				$IRETURN = 0
			Case 16384
				$IRETURN = 1
			Case 32
				$IRETURN = 2
			Case 32768
				$IRETURN = 3
			Case 128
				$IRETURN = 4
			Case 256
				$IRETURN = 5
			Case Else
				$IERROR = 1
				$IEXTENDED = $APRIORITY[0]
				$IRETURN = -1
		EndSwitch
	Until True
	DllClose($HDLL)
	Return SetError($IERROR, $IEXTENDED, $IRETURN)
EndFunc


Func _RUNDOS($SCOMMAND)
	Local $NRESULT = RunWait(@ComSpec & " /C " & $SCOMMAND, "", @SW_HIDE)
	Return SetError(@error, @extended, $NRESULT)
EndFunc

Global Const $SS_LEFT = 0
Global Const $SS_CENTER = 1
Global Const $SS_RIGHT = 2
Global Const $SS_ICON = 3
Global Const $SS_BLACKRECT = 4
Global Const $SS_GRAYRECT = 5
Global Const $SS_WHITERECT = 6
Global Const $SS_BLACKFRAME = 7
Global Const $SS_GRAYFRAME = 8
Global Const $SS_WHITEFRAME = 9
Global Const $SS_SIMPLE = 11
Global Const $SS_LEFTNOWORDWRAP = 12
Global Const $SS_BITMAP = 14
Global Const $SS_ETCHEDHORZ = 16
Global Const $SS_ETCHEDVERT = 17
Global Const $SS_ETCHEDFRAME = 18
Global Const $SS_NOPREFIX = 128
Global Const $SS_NOTIFY = 256
Global Const $SS_CENTERIMAGE = 512
Global Const $SS_RIGHTJUST = 1024
Global Const $SS_SUNKEN = 4096
Global Const $GUI_SS_DEFAULT_LABEL = 0
Global Const $GUI_SS_DEFAULT_GRAPHIC = 0
Global Const $GUI_SS_DEFAULT_ICON = $SS_NOTIFY
Global Const $GUI_SS_DEFAULT_PIC = $SS_NOTIFY
Global Const $WS_TILED = 0
Global Const $WS_OVERLAPPED = 0
Global Const $WS_MAXIMIZEBOX = 65536
Global Const $WS_MINIMIZEBOX = 131072
Global Const $WS_TABSTOP = 65536
Global Const $WS_GROUP = 131072
Global Const $WS_SIZEBOX = 262144
Global Const $WS_THICKFRAME = 262144
Global Const $WS_SYSMENU = 524288
Global Const $WS_HSCROLL = 1048576
Global Const $WS_VSCROLL = 2097152
Global Const $WS_DLGFRAME = 4194304
Global Const $WS_BORDER = 8388608
Global Const $WS_CAPTION = 12582912
Global Const $WS_OVERLAPPEDWINDOW = 13565952
Global Const $WS_TILEDWINDOW = 13565952
Global Const $WS_MAXIMIZE = 16777216
Global Const $WS_CLIPCHILDREN = 33554432
Global Const $WS_CLIPSIBLINGS = 67108864
Global Const $WS_DISABLED = 134217728
Global Const $WS_VISIBLE = 268435456
Global Const $WS_MINIMIZE = 536870912
Global Const $WS_CHILD = 1073741824
Global Const $WS_POPUP = -2147483648
Global Const $WS_POPUPWINDOW = -2138570752
Global Const $DS_MODALFRAME = 128
Global Const $DS_SETFOREGROUND = 512
Global Const $DS_CONTEXTHELP = 8192
Global Const $WS_EX_ACCEPTFILES = 16
Global Const $WS_EX_MDICHILD = 64
Global Const $WS_EX_APPWINDOW = 262144
Global Const $WS_EX_COMPOSITED = 33554432
Global Const $WS_EX_CLIENTEDGE = 512
Global Const $WS_EX_CONTEXTHELP = 1024
Global Const $WS_EX_DLGMODALFRAME = 1
Global Const $WS_EX_LEFTSCROLLBAR = 16384
Global Const $WS_EX_OVERLAPPEDWINDOW = 768
Global Const $WS_EX_RIGHT = 4096
Global Const $WS_EX_STATICEDGE = 131072
Global Const $WS_EX_TOOLWINDOW = 128
Global Const $WS_EX_TOPMOST = 8
Global Const $WS_EX_TRANSPARENT = 32
Global Const $WS_EX_WINDOWEDGE = 256
Global Const $WS_EX_LAYERED = 524288
Global Const $WS_EX_CONTROLPARENT = 65536
Global Const $WS_EX_LAYOUTRTL = 4194304
Global Const $WS_EX_RTLREADING = 8192
Global Const $WM_GETTEXTLENGTH = 14
Global Const $WM_GETTEXT = 13
Global Const $WM_SIZE = 5
Global Const $WM_SIZING = 532
Global Const $WM_USER = 1024
Global Const $WM_CREATE = 1
Global Const $WM_DESTROY = 2
Global Const $WM_MOVE = 3
Global Const $WM_ACTIVATE = 6
Global Const $WM_SETFOCUS = 7
Global Const $WM_KILLFOCUS = 8
Global Const $WM_ENABLE = 10
Global Const $WM_SETREDRAW = 11
Global Const $WM_SETTEXT = 12
Global Const $WM_PAINT = 15
Global Const $WM_CLOSE = 16
Global Const $WM_QUIT = 18
Global Const $WM_ERASEBKGND = 20
Global Const $WM_SYSCOLORCHANGE = 21
Global Const $WM_SHOWWINDOW = 24
Global Const $WM_WININICHANGE = 26
Global Const $WM_DEVMODECHANGE = 27
Global Const $WM_ACTIVATEAPP = 28
Global Const $WM_FONTCHANGE = 29
Global Const $WM_TIMECHANGE = 30
Global Const $WM_CANCELMODE = 31
Global Const $WM_SETCURSOR = 32
Global Const $WM_MOUSEACTIVATE = 33
Global Const $WM_CHILDACTIVATE = 34
Global Const $WM_QUEUESYNC = 35
Global Const $WM_GETMINMAXINFO = 36
Global Const $WM_PAINTICON = 38
Global Const $WM_ICONERASEBKGND = 39
Global Const $WM_NEXTDLGCTL = 40
Global Const $WM_SPOOLERSTATUS = 42
Global Const $WM_DRAWITEM = 43
Global Const $WM_MEASUREITEM = 44
Global Const $WM_DELETEITEM = 45
Global Const $WM_VKEYTOITEM = 46
Global Const $WM_CHARTOITEM = 47
Global Const $WM_SETFONT = 48
Global Const $WM_GETFONT = 49
Global Const $WM_SETHOTKEY = 50
Global Const $WM_GETHOTKEY = 51
Global Const $WM_QUERYDRAGICON = 55
Global Const $WM_COMPAREITEM = 57
Global Const $WM_GETOBJECT = 61
Global Const $WM_COMPACTING = 65
Global Const $WM_COMMNOTIFY = 68
Global Const $WM_WINDOWPOSCHANGING = 70
Global Const $WM_WINDOWPOSCHANGED = 71
Global Const $WM_POWER = 72
Global Const $WM_NOTIFY = 78
Global Const $WM_COPYDATA = 74
Global Const $WM_CANCELJOURNAL = 75
Global Const $WM_INPUTLANGCHANGEREQUEST = 80
Global Const $WM_INPUTLANGCHANGE = 81
Global Const $WM_TCARD = 82
Global Const $WM_HELP = 83
Global Const $WM_USERCHANGED = 84
Global Const $WM_NOTIFYFORMAT = 85
Global Const $WM_CUT = 768
Global Const $WM_COPY = 769
Global Const $WM_PASTE = 770
Global Const $WM_CLEAR = 771
Global Const $WM_UNDO = 772
Global Const $WM_CONTEXTMENU = 123
Global Const $WM_STYLECHANGING = 124
Global Const $WM_STYLECHANGED = 125
Global Const $WM_DISPLAYCHANGE = 126
Global Const $WM_GETICON = 127
Global Const $WM_SETICON = 128
Global Const $WM_NCCREATE = 129
Global Const $WM_NCDESTROY = 130
Global Const $WM_NCCALCSIZE = 131
Global Const $WM_NCHITTEST = 132
Global Const $WM_NCPAINT = 133
Global Const $WM_NCACTIVATE = 134
Global Const $WM_GETDLGCODE = 135
Global Const $WM_SYNCPAINT = 136
Global Const $WM_NCMOUSEMOVE = 160
Global Const $WM_NCLBUTTONDOWN = 161
Global Const $WM_NCLBUTTONUP = 162
Global Const $WM_NCLBUTTONDBLCLK = 163
Global Const $WM_NCRBUTTONDOWN = 164
Global Const $WM_NCRBUTTONUP = 165
Global Const $WM_NCRBUTTONDBLCLK = 166
Global Const $WM_NCMBUTTONDOWN = 167
Global Const $WM_NCMBUTTONUP = 168
Global Const $WM_NCMBUTTONDBLCLK = 169
Global Const $WM_KEYDOWN = 256
Global Const $WM_KEYUP = 257
Global Const $WM_CHAR = 258
Global Const $WM_DEADCHAR = 259
Global Const $WM_SYSKEYDOWN = 260
Global Const $WM_SYSKEYUP = 261
Global Const $WM_SYSCHAR = 262
Global Const $WM_SYSDEADCHAR = 263
Global Const $WM_INITDIALOG = 272
Global Const $WM_COMMAND = 273
Global Const $WM_SYSCOMMAND = 274
Global Const $WM_TIMER = 275
Global Const $WM_HSCROLL = 276
Global Const $WM_VSCROLL = 277
Global Const $WM_INITMENU = 278
Global Const $WM_INITMENUPOPUP = 279
Global Const $WM_MENUSELECT = 287
Global Const $WM_MENUCHAR = 288
Global Const $WM_ENTERIDLE = 289
Global Const $WM_MENURBUTTONUP = 290
Global Const $WM_MENUDRAG = 291
Global Const $WM_MENUGETOBJECT = 292
Global Const $WM_UNINITMENUPOPUP = 293
Global Const $WM_MENUCOMMAND = 294
Global Const $WM_CHANGEUISTATE = 295
Global Const $WM_UPDATEUISTATE = 296
Global Const $WM_QUERYUISTATE = 297
Global Const $WM_CTLCOLORMSGBOX = 306
Global Const $WM_CTLCOLOREDIT = 307
Global Const $WM_CTLCOLORLISTBOX = 308
Global Const $WM_CTLCOLORBTN = 309
Global Const $WM_CTLCOLORDLG = 310
Global Const $WM_CTLCOLORSCROLLBAR = 311
Global Const $WM_CTLCOLORSTATIC = 312
Global Const $WM_CTLCOLOR = 25
Global Const $MN_GETHMENU = 481
Global Const $NM_FIRST = 0
Global Const $NM_OUTOFMEMORY = $NM_FIRST - 1
Global Const $NM_CLICK = $NM_FIRST - 2
Global Const $NM_DBLCLK = $NM_FIRST - 3
Global Const $NM_RETURN = $NM_FIRST - 4
Global Const $NM_RCLICK = $NM_FIRST - 5
Global Const $NM_RDBLCLK = $NM_FIRST - 6
Global Const $NM_SETFOCUS = $NM_FIRST - 7
Global Const $NM_KILLFOCUS = $NM_FIRST - 8
Global Const $NM_CUSTOMDRAW = $NM_FIRST - 12
Global Const $NM_HOVER = $NM_FIRST - 13
Global Const $NM_NCHITTEST = $NM_FIRST - 14
Global Const $NM_KEYDOWN = $NM_FIRST - 15
Global Const $NM_RELEASEDCAPTURE = $NM_FIRST - 16
Global Const $NM_SETCURSOR = $NM_FIRST - 17
Global Const $NM_CHAR = $NM_FIRST - 18
Global Const $NM_TOOLTIPSCREATED = $NM_FIRST - 19
Global Const $NM_LDOWN = $NM_FIRST - 20
Global Const $NM_RDOWN = $NM_FIRST - 21
Global Const $NM_THEMECHANGED = $NM_FIRST - 22
Global Const $WM_MOUSEMOVE = 512
Global Const $WM_LBUTTONDOWN = 513
Global Const $WM_LBUTTONUP = 514
Global Const $WM_LBUTTONDBLCLK = 515
Global Const $WM_RBUTTONDOWN = 516
Global Const $WM_RBUTTONUP = 517
Global Const $WM_RBUTTONDBLCK = 518
Global Const $WM_MBUTTONDOWN = 519
Global Const $WM_MBUTTONUP = 520
Global Const $WM_MBUTTONDBLCK = 521
Global Const $WM_MOUSEWHEEL = 522
Global Const $WM_XBUTTONDOWN = 523
Global Const $WM_XBUTTONUP = 524
Global Const $WM_XBUTTONDBLCLK = 525
Global Const $WM_MOUSEHWHEEL = 526
Global Const $PS_SOLID = 0
Global Const $PS_DASH = 1
Global Const $PS_DOT = 2
Global Const $PS_DASHDOT = 3
Global Const $PS_DASHDOTDOT = 4
Global Const $PS_NULL = 5
Global Const $PS_INSIDEFRAME = 6
Global Const $LWA_ALPHA = 2
Global Const $LWA_COLORKEY = 1
Global Const $RGN_AND = 1
Global Const $RGN_OR = 2
Global Const $RGN_XOR = 3
Global Const $RGN_DIFF = 4
Global Const $RGN_COPY = 5
Global Const $ERRORREGION = 0
Global Const $NULLREGION = 1
Global Const $SIMPLEREGION = 2
Global Const $COMPLEXREGION = 3
Global Const $TRANSPARENT = 1
Global Const $OPAQUE = 2
Global Const $CCM_FIRST = 8192
Global Const $CCM_GETUNICODEFORMAT = ($CCM_FIRST + 6)
Global Const $CCM_SETUNICODEFORMAT = ($CCM_FIRST + 5)
Global Const $CCM_SETBKCOLOR = $CCM_FIRST + 1
Global Const $CCM_SETCOLORSCHEME = $CCM_FIRST + 2
Global Const $CCM_GETCOLORSCHEME = $CCM_FIRST + 3
Global Const $CCM_GETDROPTARGET = $CCM_FIRST + 4
Global Const $CCM_SETWINDOWTHEME = $CCM_FIRST + 11
Global Const $GA_PARENT = 1
Global Const $GA_ROOT = 2
Global Const $GA_ROOTOWNER = 3
Global Const $SM_CXSCREEN = 0
Global Const $SM_CYSCREEN = 1
Global Const $SM_CXVSCROLL = 2
Global Const $SM_CYHSCROLL = 3
Global Const $SM_CYCAPTION = 4
Global Const $SM_CXBORDER = 5
Global Const $SM_CYBORDER = 6
Global Const $SM_CXDLGFRAME = 7
Global Const $SM_CYDLGFRAME = 8
Global Const $SM_CYVTHUMB = 9
Global Const $SM_CXHTHUMB = 10
Global Const $SM_CXICON = 11
Global Const $SM_CYICON = 12
Global Const $SM_CXCURSOR = 13
Global Const $SM_CYCURSOR = 14
Global Const $SM_CYMENU = 15
Global Const $SM_CXFULLSCREEN = 16
Global Const $SM_CYFULLSCREEN = 17
Global Const $SM_CYKANJIWINDOW = 18
Global Const $SM_MOUSEPRESENT = 19
Global Const $SM_CYVSCROLL = 20
Global Const $SM_CXHSCROLL = 21
Global Const $SM_DEBUG = 22
Global Const $SM_SWAPBUTTON = 23
Global Const $SM_RESERVED1 = 24
Global Const $SM_RESERVED2 = 25
Global Const $SM_RESERVED3 = 26
Global Const $SM_RESERVED4 = 27
Global Const $SM_CXMIN = 28
Global Const $SM_CYMIN = 29
Global Const $SM_CXSIZE = 30
Global Const $SM_CYSIZE = 31
Global Const $SM_CXFRAME = 32
Global Const $SM_CYFRAME = 33
Global Const $SM_CXMINTRACK = 34
Global Const $SM_CYMINTRACK = 35
Global Const $SM_CXDOUBLECLK = 36
Global Const $SM_CYDOUBLECLK = 37
Global Const $SM_CXICONSPACING = 38
Global Const $SM_CYICONSPACING = 39
Global Const $SM_MENUDROPALIGNMENT = 40
Global Const $SM_PENWINDOWS = 41
Global Const $SM_DBCSENABLED = 42
Global Const $SM_CMOUSEBUTTONS = 43
Global Const $SM_SECURE = 44
Global Const $SM_CXEDGE = 45
Global Const $SM_CYEDGE = 46
Global Const $SM_CXMINSPACING = 47
Global Const $SM_CYMINSPACING = 48
Global Const $SM_CXSMICON = 49
Global Const $SM_CYSMICON = 50
Global Const $SM_CYSMCAPTION = 51
Global Const $SM_CXSMSIZE = 52
Global Const $SM_CYSMSIZE = 53
Global Const $SM_CXMENUSIZE = 54
Global Const $SM_CYMENUSIZE = 55
Global Const $SM_ARRANGE = 56
Global Const $SM_CXMINIMIZED = 57
Global Const $SM_CYMINIMIZED = 58
Global Const $SM_CXMAXTRACK = 59
Global Const $SM_CYMAXTRACK = 60
Global Const $SM_CXMAXIMIZED = 61
Global Const $SM_CYMAXIMIZED = 62
Global Const $SM_NETWORK = 63
Global Const $SM_CLEANBOOT = 67
Global Const $SM_CXDRAG = 68
Global Const $SM_CYDRAG = 69
Global Const $SM_SHOWSOUNDS = 70
Global Const $SM_CXMENUCHECK = 71
Global Const $SM_CYMENUCHECK = 72
Global Const $SM_SLOWMACHINE = 73
Global Const $SM_MIDEASTENABLED = 74
Global Const $SM_MOUSEWHEELPRESENT = 75
Global Const $SM_XVIRTUALSCREEN = 76
Global Const $SM_YVIRTUALSCREEN = 77
Global Const $SM_CXVIRTUALSCREEN = 78
Global Const $SM_CYVIRTUALSCREEN = 79
Global Const $SM_CMONITORS = 80
Global Const $SM_SAMEDISPLAYFORMAT = 81
Global Const $SM_IMMENABLED = 82
Global Const $SM_CXFOCUSBORDER = 83
Global Const $SM_CYFOCUSBORDER = 84
Global Const $SM_TABLETPC = 86
Global Const $SM_MEDIACENTER = 87
Global Const $SM_STARTER = 88
Global Const $SM_SERVERR2 = 89
Global Const $SM_CMETRICS = 90
Global Const $SM_REMOTESESSION = 4096
Global Const $SM_SHUTTINGDOWN = 8192
Global Const $SM_REMOTECONTROL = 8193
Global Const $SM_CARETBLINKINGENABLED = 8194
Global Const $BLACKNESS = 66
Global Const $CAPTUREBLT = 1073741824
Global Const $DSTINVERT = 5570569
Global Const $MERGECOPY = 12583114
Global Const $MERGEPAINT = 12255782
Global Const $NOMIRRORBITMAP = -2147483648
Global Const $NOTSRCCOPY = 3342344
Global Const $NOTSRCERASE = 1114278
Global Const $PATCOPY = 15728673
Global Const $PATINVERT = 5898313
Global Const $PATPAINT = 16452105
Global Const $SRCAND = 8913094
Global Const $SRCCOPY = 13369376
Global Const $SRCERASE = 4457256
Global Const $SRCINVERT = 6684742
Global Const $SRCPAINT = 15597702
Global Const $WHITENESS = 16711778
Global Const $DT_BOTTOM = 8
Global Const $DT_CALCRECT = 1024
Global Const $DT_CENTER = 1
Global Const $DT_EDITCONTROL = 8192
Global Const $DT_END_ELLIPSIS = 32768
Global Const $DT_EXPANDTABS = 64
Global Const $DT_EXTERNALLEADING = 512
Global Const $DT_HIDEPREFIX = 1048576
Global Const $DT_INTERNAL = 4096
Global Const $DT_LEFT = 0
Global Const $DT_MODIFYSTRING = 65536
Global Const $DT_NOCLIP = 256
Global Const $DT_NOFULLWIDTHCHARBREAK = 524288
Global Const $DT_NOPREFIX = 2048
Global Const $DT_PATH_ELLIPSIS = 16384
Global Const $DT_PREFIXONLY = 2097152
Global Const $DT_RIGHT = 2
Global Const $DT_RTLREADING = 131072
Global Const $DT_SINGLELINE = 32
Global Const $DT_TABSTOP = 128
Global Const $DT_TOP = 0
Global Const $DT_VCENTER = 4
Global Const $DT_WORDBREAK = 16
Global Const $DT_WORD_ELLIPSIS = 262144
Global Const $RDW_ERASE = 4
Global Const $RDW_FRAME = 1024
Global Const $RDW_INTERNALPAINT = 2
Global Const $RDW_INVALIDATE = 1
Global Const $RDW_NOERASE = 32
Global Const $RDW_NOFRAME = 2048
Global Const $RDW_NOINTERNALPAINT = 16
Global Const $RDW_VALIDATE = 8
Global Const $RDW_ERASENOW = 512
Global Const $RDW_UPDATENOW = 256
Global Const $RDW_ALLCHILDREN = 128
Global Const $RDW_NOCHILDREN = 64
Global Const $WM_RENDERFORMAT = 773
Global Const $WM_RENDERALLFORMATS = 774
Global Const $WM_DESTROYCLIPBOARD = 775
Global Const $WM_DRAWCLIPBOARD = 776
Global Const $WM_PAINTCLIPBOARD = 777
Global Const $WM_VSCROLLCLIPBOARD = 778
Global Const $WM_SIZECLIPBOARD = 779
Global Const $WM_ASKCBFORMATNAME = 780
Global Const $WM_CHANGECBCHAIN = 781
Global Const $WM_HSCROLLCLIPBOARD = 782
Global Const $HTERROR = -2
Global Const $HTTRANSPARENT = -1
Global Const $HTNOWHERE = 0
Global Const $HTCLIENT = 1
Global Const $HTCAPTION = 2
Global Const $HTSYSMENU = 3
Global Const $HTGROWBOX = 4
Global Const $HTSIZE = $HTGROWBOX
Global Const $HTMENU = 5
Global Const $HTHSCROLL = 6
Global Const $HTVSCROLL = 7
Global Const $HTMINBUTTON = 8
Global Const $HTMAXBUTTON = 9
Global Const $HTLEFT = 10
Global Const $HTRIGHT = 11
Global Const $HTTOP = 12
Global Const $HTTOPLEFT = 13
Global Const $HTTOPRIGHT = 14
Global Const $HTBOTTOM = 15
Global Const $HTBOTTOMLEFT = 16
Global Const $HTBOTTOMRIGHT = 17
Global Const $HTBORDER = 18
Global Const $HTREDUCE = $HTMINBUTTON
Global Const $HTZOOM = $HTMAXBUTTON
Global Const $HTSIZEFIRST = $HTLEFT
Global Const $HTSIZELAST = $HTBOTTOMRIGHT
Global Const $HTOBJECT = 19
Global Const $HTCLOSE = 20
Global Const $HTHELP = 21
Global Const $COLOR_SCROLLBAR = 0
Global Const $COLOR_BACKGROUND = 1
Global Const $COLOR_ACTIVECAPTION = 2
Global Const $COLOR_INACTIVECAPTION = 3
Global Const $COLOR_MENU = 4
Global Const $COLOR_WINDOW = 5
Global Const $COLOR_WINDOWFRAME = 6
Global Const $COLOR_MENUTEXT = 7
Global Const $COLOR_WINDOWTEXT = 8
Global Const $COLOR_CAPTIONTEXT = 9
Global Const $COLOR_ACTIVEBORDER = 10
Global Const $COLOR_INACTIVEBORDER = 11
Global Const $COLOR_APPWORKSPACE = 12
Global Const $COLOR_HIGHLIGHT = 13
Global Const $COLOR_HIGHLIGHTTEXT = 14
Global Const $COLOR_BTNFACE = 15
Global Const $COLOR_BTNSHADOW = 16
Global Const $COLOR_GRAYTEXT = 17
Global Const $COLOR_BTNTEXT = 18
Global Const $COLOR_INACTIVECAPTIONTEXT = 19
Global Const $COLOR_BTNHIGHLIGHT = 20
Global Const $COLOR_3DDKSHADOW = 21
Global Const $COLOR_3DLIGHT = 22
Global Const $COLOR_INFOTEXT = 23
Global Const $COLOR_INFOBK = 24
Global Const $COLOR_HOTLIGHT = 26
Global Const $COLOR_GRADIENTACTIVECAPTION = 27
Global Const $COLOR_GRADIENTINACTIVECAPTION = 28
Global Const $COLOR_MENUHILIGHT = 29
Global Const $COLOR_MENUBAR = 30
Global Const $COLOR_DESKTOP = 1
Global Const $COLOR_3DFACE = 15
Global Const $COLOR_3DSHADOW = 16
Global Const $COLOR_3DHIGHLIGHT = 20
Global Const $COLOR_3DHILIGHT = 20
Global Const $COLOR_BTNHILIGHT = 20
Global Const $HINST_COMMCTRL = -1
Global Const $IDB_STD_SMALL_COLOR = 0
Global Const $IDB_STD_LARGE_COLOR = 1
Global Const $IDB_VIEW_SMALL_COLOR = 4
Global Const $IDB_VIEW_LARGE_COLOR = 5
Global Const $IDB_HIST_SMALL_COLOR = 8
Global Const $IDB_HIST_LARGE_COLOR = 9
Global Const $STARTF_FORCEOFFFEEDBACK = 128
Global Const $STARTF_FORCEONFEEDBACK = 64
Global Const $STARTF_RUNFULLSCREEN = 32
Global Const $STARTF_USECOUNTCHARS = 8
Global Const $STARTF_USEFILLATTRIBUTE = 16
Global Const $STARTF_USEHOTKEY = 512
Global Const $STARTF_USEPOSITION = 4
Global Const $STARTF_USESHOWWINDOW = 1
Global Const $STARTF_USESIZE = 2
Global Const $STARTF_USESTDHANDLES = 256
Global Const $CDDS_PREPAINT = 1
Global Const $CDDS_POSTPAINT = 2
Global Const $CDDS_PREERASE = 3
Global Const $CDDS_POSTERASE = 4
Global Const $CDDS_ITEM = 65536
Global Const $CDDS_ITEMPREPAINT = 65537
Global Const $CDDS_ITEMPOSTPAINT = 65538
Global Const $CDDS_ITEMPREERASE = 65539
Global Const $CDDS_ITEMPOSTERASE = 65540
Global Const $CDDS_SUBITEM = 131072
Global Const $CDIS_SELECTED = 1
Global Const $CDIS_GRAYED = 2
Global Const $CDIS_DISABLED = 4
Global Const $CDIS_CHECKED = 8
Global Const $CDIS_FOCUS = 16
Global Const $CDIS_DEFAULT = 32
Global Const $CDIS_HOT = 64
Global Const $CDIS_MARKED = 128
Global Const $CDIS_INDETERMINATE = 256
Global Const $CDIS_SHOWKEYBOARDCUES = 512
Global Const $CDIS_NEARHOT = 1024
Global Const $CDIS_OTHERSIDEHOT = 2048
Global Const $CDIS_DROPHILITED = 4096
Global Const $CDRF_DODEFAULT = 0
Global Const $CDRF_NEWFONT = 2
Global Const $CDRF_SKIPDEFAULT = 4
Global Const $CDRF_NOTIFYPOSTPAINT = 16
Global Const $CDRF_NOTIFYITEMDRAW = 32
Global Const $CDRF_NOTIFYSUBITEMDRAW = 32
Global Const $CDRF_NOTIFYPOSTERASE = 64
Global Const $CDRF_DOERASE = 8
Global Const $CDRF_SKIPPOSTPAINT = 256
Global Const $GUI_SS_DEFAULT_GUI = BitOR($WS_MINIMIZEBOX, $WS_CAPTION, $WS_POPUP, $WS_SYSMENU)

Func __CLNP()
	Global $_STAGE
	$_STAGE = "CLNP"
	__SPLASH("Cleaning up...")

	For $I = 0 To UBound($CSET_CLEANUP, 1) - 1
		If FileExists(__REPLACEENVVARS($CSET_CLEANUP[$I])) Then
			If FileDelete(__REPLACEENVVARS($CSET_CLEANUP[$I])) Then
				__LOG('Deleted "' & __REPLACEENVVARS($CSET_CLEANUP[$I]) & '"!')
			Else
				__ERR('Could not delete "' & __REPLACEENVVARS($CSET_CLEANUP[$I]) & '"!')
			EndIf
		EndIf
	Next
	
	If FileExists(@SystemDir & "SETUP.org") Then
		If FileExists(@SystemDir & "SETUP.EX_") Then
			If Not FileDelete(@SystemDir & "SETUP.EX_") Then
				__CRIT("Could not delete existing SETUP.EX_ to allow restoring SETUP.org.")
			EndIf
		EndIf
		If FileMove(@SystemDir & "SETUP.org", @SystemDir & "SETUP.EX_", 1) Then
			__LOG("Renamed SETUP.org to SETUP.EX_.  Original file restored.")
		Else
			__CRIT("Could not rename SETUP.org to SETUP.EX_ - Unable to restore the original file.")
		EndIf
	EndIf
	Return 1
EndFunc


Func __QUIT()
	_FILEWRITELOG($_LOGFILE, "Program terminated.")
	Exit
EndFunc


Func __LOG($FA_MESSAGE)
	Global $_STAGE
	Local $F_INDENTATION = ""
	If StringLen($_STAGE) == 3 Then
		$F_INDENTATION = " "
	EndIf
	_FILEWRITELOG($_LOGFILE, "<" & $_STAGE & "> " & $F_INDENTATION & $FA_MESSAGE)
	Return 1
EndFunc


Func __DBG($FA_MESSAGE)
	Local $F_INDENTATION = ""
	If $_DEBUG == False Then
		Return 0
	Else
		_FILEWRITELOG($_LOGFILE, "<DBG>  " & $F_INDENTATION & $FA_MESSAGE)
		Return 1
	EndIf
EndFunc


Func __SPLASH($FA_MESSAGE)
	Global $SPLASH_ACTION
	If $_SPLASHSCREEN == True Then
		GUICtrlSetData($SPLASH_ACTION, $FA_MESSAGE)
	EndIf
	Return 1
EndFunc


Func __ERR($FA_MESSAGE)
	_FILEWRITELOG($_LOGFILE, "<ERR>  " & $FA_MESSAGE)
	SplashOff()
	MsgBox(16, "Error", $FA_MESSAGE, 5)
	Return 1
EndFunc


Func __CRIT($FA_MESSAGE)
	_FILEWRITELOG($_LOGFILE, "<CRIT> " & $FA_MESSAGE)
	SplashOff()
	MsgBox(16, " ", $FA_MESSAGE, 5)
	__CLNP()
	__QUIT()
EndFunc


Func __GETSYSTEMHWIDS()
	Local $F_HWID
	Local $F_HWIDS[1]
	Local $F_POS
	Local $F_TMP
	$F_HWIDS[0] = 0
	If Not FileExists(__REPLACEENVVARS("%finisherdir%\devcon.exe")) Then
		__CRIT("Could not find devcon.exe. devcon.exe has to be present in the %systemdrive% (" & __REPLACEENVVARS("%systemdrive%") & ") directory!")
	EndIf
	_RUNDOS('""' & __REPLACEENVVARS('%finisherdir%\devcon.exe" find * >> "%dpsroot%\hwids.dat') & '""')
	$I = 1
	While 1
		$I = $I + 1
		$F_TMP = FileReadLine(__REPLACEENVVARS("%dpsroot%\hwids.dat"), $I)
		If @error <> 0 Then
			ExitLoop
		EndIf
		If Not StringInStr($F_TMP, "\") Then
			ContinueLoop
		EndIf
		$F_TMP = StringStripWS($F_TMP, 8)
		$F_TMP = StringSplit($F_TMP, ":")
		$F_POS = StringInStr($F_TMP[1], "\", 0, -1)
		$F_HWID = StringTrimRight($F_TMP[1], StringLen($F_TMP[1]) - $F_POS + 1)
		ReDim $F_HWIDS[$F_HWIDS[0] + 1 + 1]
		$F_HWIDS[0] = $F_HWIDS[0] + 1
		$F_HWIDS[$F_HWIDS[0]] = $F_HWID
	WEnd
	Return $F_HWIDS
EndFunc


Func __FINDMATCHINGHWIDS($FA_INFFILE, $FA_PATTERN, $FA_RETURNSOURCEDISKSFILES = "no")
	Global $_LAST_MATCHED_PATTERN
	Local $F_CNT
	Local $F_COMPLETE
	Local $F_HWIDS
	Local $F_MANUFACTURERS[1]
	Local $F_MATCH = 0
	Local $F_RSDF
	Local $F_SPLITTED
	$F_RSDF = $FA_RETURNSOURCEDISKSFILES
	$FA_RETURNSOURCEDISKSFILES = ""
	If StringRight($FA_INFFILE, 4) <> ".inf" Then
		Return 0
	EndIf
	$F_COMPLETE = IniReadSection($FA_INFFILE, "Manufacturer")
	$F_CNT = 0
	For $I = 1 To UBound($F_COMPLETE) - 1
		If StringInStr($F_COMPLETE[$I][1], ",") > 0 Then
			$F_SPLITTED = StringSplit($F_COMPLETE[$I][1], ",")
			$F_CNT = $F_CNT + 1
			ReDim $F_MANUFACTURERS[$F_CNT + 1]
			$F_MANUFACTURERS[$F_CNT] = StringStripWS($F_SPLITTED[1], 3)
			For $I = 2 To $F_SPLITTED[0]
				$F_CNT = $F_CNT + 1
				ReDim $F_MANUFACTURERS[$F_CNT + 1]
				$F_MANUFACTURERS[$F_CNT] = StringStripWS($F_SPLITTED[1], 3) & "." & StringStripWS($F_SPLITTED[$I], 3)
			Next
		Else
			$F_CNT = $F_CNT + 1
			ReDim $F_MANUFACTURERS[$F_CNT + 1]
			$F_MANUFACTURERS[$F_CNT] = $F_COMPLETE[$I][1]
		EndIf
	Next
	For $I = 1 To UBound($F_MANUFACTURERS) - 1
		If $F_MANUFACTURERS[$I] == "" Then
			ContinueLoop
		EndIf
		$F_HWIDS = IniReadSection($FA_INFFILE, $F_MANUFACTURERS[$I])
		For $K = 1 To UBound($F_HWIDS) - 1
			If IsArray($FA_PATTERN) Then
				For $N = 1 To $FA_PATTERN[0]
					If StringInStr($F_HWIDS[$K][1], $FA_PATTERN[$N], 0, 1) > 0 Then
						$F_MATCH = True
						If $F_RSDF == "no" Then
							$_LAST_MATCHED_PATTERN = $FA_PATTERN[$N]
							Return 1
						EndIf
					EndIf
				Next
			ElseIf IsString($FA_PATTERN) Then
				If StringInStr($F_HWIDS[$K][1], $FA_PATTERN) Then
					$F_MATCH = True
					If $F_RSDF == "no" Then
						Return 1
					EndIf
				EndIf
			EndIf
		Next
	Next
	Return 0
EndFunc


Func __DECREASEHWIDUNIQUENESS($F_HWID, $F_UNIQUENESS)
	Local $F_DECRHWID
	Local $F_SUFFIX
	Local $F_TMP
	Local $F_TYPE
	If Not StringInStr($F_HWID, "\") Then
		__CRIT('"' & $F_HWID & '" is not a valid HWID!')
	EndIf
	$F_TMP = StringSplit($F_HWID, "\")
	$F_TYPE = $F_TMP[1]
	Select
		Case StringLower($F_TYPE) == "acpi"
			Return $F_HWID
		Case StringLower($F_TYPE) == "hdaudio"
			Return $F_HWID
		Case StringLower($F_TYPE) == "pci"
			Select
				Case $F_UNIQUENESS == 1
					$F_DECRHWID = $F_HWID
					$F_SUFFIX = "&SUBSYS_12345678"
					$F_TMP = StringInStr($F_DECRHWID, "&SUBSYS_", 0)
					If $F_TMP > 0 Then
						$F_DECRHWID = StringLeft($F_DECRHWID, $F_TMP - 1) & StringRight($F_DECRHWID, StringLen($F_DECRHWID) - ($F_TMP - 1) - StringLen($F_SUFFIX))
					EndIf
					$F_SUFFIX = "&REV_12"
					$F_TMP = StringInStr($F_DECRHWID, "&REV_", 0)
					If $F_TMP > 0 Then
						$F_DECRHWID = StringLeft($F_DECRHWID, $F_TMP - 1) & StringRight($F_DECRHWID, StringLen($F_DECRHWID) - ($F_TMP - 1) - StringLen($F_SUFFIX))
					EndIf
					Return $F_DECRHWID
				Case $F_UNIQUENESS == 2
					$F_DECRHWID = $F_HWID
					$F_SUFFIX = "&SUBSYS_12345678"
					$F_TMP = StringInStr($F_DECRHWID, "&SUBSYS_", 0)
					If $F_TMP > 0 Then
						$F_DECRHWID = StringLeft($F_DECRHWID, $F_TMP - 1) & StringRight($F_DECRHWID, StringLen($F_DECRHWID) - ($F_TMP - 1) - StringLen($F_SUFFIX))
					EndIf
					Return $F_DECRHWID
				Case $F_UNIQUENESS == 3
					$F_DECRHWID = $F_HWID
					$F_SUFFIX = "&REV_12"
					$F_TMP = StringInStr($F_DECRHWID, "&REV_", 0)
					If $F_TMP > 0 Then
						$F_DECRHWID = StringLeft($F_DECRHWID, $F_TMP - 1) & StringRight($F_DECRHWID, StringLen($F_DECRHWID) - ($F_TMP - 1) - StringLen($F_SUFFIX))
					EndIf
					Return $F_DECRHWID
				Case $F_UNIQUENESS == 4
					$F_DECRHWID = $F_HWID
					Return $F_DECRHWID
			EndSelect
		Case StringLower($F_TYPE) == "usb"
			Return $F_HWID
		Case Else
			Return $F_HWID
	EndSelect
EndFunc


Func __CREATEENVVAR_WNT5($FA_VALNAME, $FA_VAL, $FA_OVERWRITE = 0)
	If $FA_OVERWRITE == 0 Or RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment", $FA_VALNAME) == "" Then
		If Not RegWrite("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment", $FA_VALNAME, "REG_EXPAND_SZ", $FA_VAL) Then
			Return 0
		EndIf
	EndIf
	EnvUpdate()
	Return 1
EndFunc


Func __REPLACEENVVARS($FA_STRING)
	Global $SET_DPSROOT
	If StringInStr($FA_STRING, "%finisherdir%") Then
		$FA_STRING = StringReplace($FA_STRING, "%finisherdir%", $_FINISHERDIR, 0, 0)
	EndIf
	If StringInStr($FA_STRING, "%systemdrive%") Then
		$FA_STRING = StringReplace($FA_STRING, "%systemdrive%", EnvGet("systemdrive"), 0, 0)
	EndIf
	If StringInStr($FA_STRING, "%systemroot%") Then
		$FA_STRING = StringReplace($FA_STRING, "%systemroot%", @WindowsDir, 0, 0)
	EndIf
	If StringInStr($FA_STRING, "%windir%") Then
		$FA_STRING = StringReplace($FA_STRING, "%windir%", @WindowsDir, 0, 0)
	EndIf
	If StringInStr($FA_STRING, "%programfiles%") Then
		$FA_STRING = StringReplace($FA_STRING, "%programfiles%", @ProgramFilesDir, 0, 0)
	EndIf
	If StringInStr($FA_STRING, "%dpsroot%") Then
		$FA_STRING = StringReplace($FA_STRING, "%dpsroot%", $SET_DPSROOT, 0, 0)
	EndIf
	Return $FA_STRING
EndFunc


Func __STRINGTOBOOL($FA_VARIABLE)
	Select
		Case $FA_VARIABLE == "false"
			Return False
		Case $FA_VARIABLE == "true"
			Return True
		Case Else
			Return $FA_VARIABLE
	EndSelect
EndFunc


Func __DBG_ARRAY($FA_ARRAY, $FA_ARRAYNAME, $FA_ISCHILDPROCESS = False, $FA_PREFIX = "", $FA_DIM = 1, $FA_DIMPATH = "")
	Local $F_DIM
	Local $F_TMP
	If $_DEBUG == True Then
		If $FA_ISCHILDPROCESS == False Then
			__DBG("    $" & $FA_ARRAYNAME & " = array(")
		EndIf
		For $R = 0 To UBound($FA_ARRAY, $FA_DIM) - 1
			If UBound($FA_ARRAY, $FA_DIM + 1) > 0 Then
				__DBG($FA_PREFIX & "        [" & $R & "] =>")
				If $FA_ISCHILDPROCESS == False Then
					__DBG_ARRAY($FA_ARRAY, "", True, "    ", $FA_DIM + 1, $R)
				Else
					__DBG_ARRAY($FA_ARRAY, "", True, "    ", $FA_DIM + 1, $FA_DIMPATH & "," & $R)
				EndIf
			Else
				If $FA_ISCHILDPROCESS == False Then
					__DBG($FA_PREFIX & "        [" & $R & "] => " & $FA_ARRAY[$R])
				Else
					$F_TMP = StringSplit($FA_DIMPATH, ",")
					Select
						Case $F_TMP[0] == 1
							__DBG($FA_PREFIX & "        [" & $R & "] => " & $FA_ARRAY[$F_TMP[1]][$R])
						Case $F_TMP[0] == 2
							__DBG($FA_PREFIX & "        [" & $R & "] => " & $FA_ARRAY[$F_TMP[1]][$F_TMP[2]][$R])
						Case $F_TMP[0] == 3
							__DBG($FA_PREFIX & "        [" & $R & "] => " & $FA_ARRAY[$F_TMP[1]][$F_TMP[2]][$F_TMP[3]][$R])
						Case $F_TMP[0] == 4
							__DBG($FA_PREFIX & "        [" & $R & "] => " & $FA_ARRAY[$F_TMP[1]][$F_TMP[2]][$F_TMP[3]][$F_TMP[4]][$R])
						Case $F_TMP[0] == 5
							__DBG($FA_PREFIX & "        [" & $R & "] => " & $FA_ARRAY[$F_TMP[1]][$F_TMP[2]][$F_TMP[3]][$F_TMP[4]][$F_TMP[5]][$R])
					EndSelect
				EndIf
			EndIf
		Next
		__DBG($FA_PREFIX & "    )")
	EndIf
	Return 1
EndFunc


Func __EXCPARSE_GETREQUIREMENTSBYTYPE($FA_FILE, $FA_SECTION, $FA_EXC_NUM, $FA_REQ_TYPE)
	Local $F_ENTRY_INSTANCE
	Local $F_REQ_ARRAY[1]
	Local $F_REQ_COUNT
	Local $I
	Local $TMP
	$F_ENTRY_INSTANCE = StringTrimRight($FA_REQ_TYPE, 1)
	$F_REQ_COUNT = IniRead($FA_FILE, $FA_SECTION, "exc_" & $FA_EXC_NUM & "_" & $FA_REQ_TYPE, $_NF)
	If $F_REQ_COUNT == $_NF Then
		Return -1
	EndIf
	If $F_REQ_COUNT > 0 Then
		ReDim $F_REQ_ARRAY[$F_REQ_COUNT]
	EndIf
	For $I = 1 To $F_REQ_COUNT
		$TMP = IniRead($FA_FILE, $FA_SECTION, "exc_" & $FA_EXC_NUM & "_" & $F_ENTRY_INSTANCE & $I, $_NF)
		If $TMP == $_NF Then
			Return -1
		Else
			_ARRAYPUSH($F_REQ_ARRAY, $TMP)
		EndIf
	Next
	If $F_REQ_COUNT == 0 Then
		Return 0
	ElseIf $F_REQ_COUNT == 1 Then
		Return $F_REQ_ARRAY[0]
	Else
		Return _ARRAYTOSTRING($F_REQ_ARRAY, "|||")
	EndIf
EndFunc


Func __EXCPARSE_DBGOUTPUTBYTYPE($FA_EXCEPTIONS, $FA_EXC_ID, $FA_REQ_TYPE, $FA_REQ_TYPE_ID)
	Local $I
	Local $TMP
	$TMP = StringSplit($FA_EXCEPTIONS[$FA_EXC_ID][$FA_REQ_TYPE_ID], "|||", 1)
	If $TMP[0] > 1 Or $TMP[1] <> 0 Then
		__DBG("           [" & $FA_REQ_TYPE & "] = array(")
		$I = 1
		While $I <= $TMP[0]
			__DBG("                [" & $I & "] => " & $TMP[$I])
			$I += 1
		WEnd
		__DBG("           )")
	EndIf
	Return 1
EndFunc

Opt("MustDeclareVars", 1)
Local $DP_NAME
Local $DP_ROOT
Local $DP_EXCEPTIONS
Local $EXC_ID
Local $EXC_COUNT
Local $EXCEPTIONS[1][8]
$EXCEPTIONS[0][0] = 0
$EXCEPTIONS[0][1] = 0
Local $FILE
Local $FULLFILE
Local $I
Local $K
Local $R
Local $SEARCH
Local $SIZEBEFORE
Local $TMP
Local $TMP2
$_STAGE = "INIT"
If FileExists($_LOGFILE) Then
	If Not FileDelete($_LOGFILE) Then
		__CRIT("   -!")
	EndIf
EndIf
__LOG("    . ( DriverPacks Finisher 10.6, koros aka ya158, koros@ya.ru")
GUISetFont(-1, -1, -1, "Tahoma")
GUICreate("  ", 430, 115, -1, -1, $WS_POPUPWINDOW)
GUICtrlCreateLabel("  ", 20, 20, 400, 40)
GUICtrlSetFont(-1, 20, 700, -1, "Arial")
$SPLASH_ACTION = GUICtrlCreateLabel("...", 20, 55, 300, 30, $SS_CENTER)
GUICtrlSetFont(-1, 8, 550, -1, "Arial")
GUICtrlCreateLabel("© Wim Leers 2004-" & @YEAR & " http://driverpacks.net/," & " modify koros aka ya158, koros@ya.ru", 20, 80, 400, 30, $SS_LEFT)
GUICtrlSetFont(-1, 8, 300, -1, "Arial")
GUISetState()
__LOG(" .")
__SPLASH(" ...")
Select
	Case @ProcessorArch == "X86"
		If @OSVersion == "WIN_2000" Or @OSVersion == "WIN_XP" Or @OSVersion == "WIN_2003" Then
			$SET_PLATFORM = "wnt5_x86-32"
		EndIf
	Case Else
		__CRIT("   ! : " & @OSVersion & "   " & @ProcessorArch & " CPU.")
EndSelect
__LOG(" " & $SET_PLATFORM & ".")
__DBG(":")
__DBG("	$_LOGFILE: " & $_LOGFILE)
__DBG("	$_NF: " & $_NF)
__DBG("	$_SETTINGSFILE: " & $_SETTINGSFILE)
__DBG("	$_SPLASHSCREEN: " & $_SPLASHSCREEN)
__LOG(":")
__LOG("	%finisherdir% = " & __REPLACEENVVARS("%finisherdir%"))
__LOG("	%systemdrive% = " & __REPLACEENVVARS("%systemdrive%"))
__LOG("	%systemroot% = " & __REPLACEENVVARS("%systemroot%"))
__LOG("	%windir% = " & __REPLACEENVVARS("%windir%"))
__LOG("	%programfiles% = " & __REPLACEENVVARS("%programfiles%"))
__LOG("	%dpsroot% = " & __REPLACEENVVARS("%dpsroot%"))
__LOG(" HWID   .")
If FileExists(@ScriptDir & "\devcon.exe") Then
	__LOG("1. ACPI ")
	FileWriteLine($_LOGFILE, "")
	_RUNDOS('""' & @ScriptDir & '\devcon.exe" find ACPI* >> "' & $_LOGFILE & '""')
	FileWriteLine($_LOGFILE, "")
	__LOG("2. PCI ")
	FileWriteLine($_LOGFILE, "")
	_RUNDOS('""' & @ScriptDir & '\devcon.exe" find PCI* >> "' & $_LOGFILE & '""')
	FileWriteLine($_LOGFILE, "")
	__LOG("3. HDAUDIO ")
	FileWriteLine($_LOGFILE, "")
	_RUNDOS('""' & @ScriptDir & '\devcon.exe" find HDAUDIO* >> "' & $_LOGFILE & '""')
	FileWriteLine($_LOGFILE, "")
	__LOG("4. USB ")
	FileWriteLine($_LOGFILE, "")
	_RUNDOS('""' & @ScriptDir & '\devcon.exe" find USB* >> "' & $_LOGFILE & '""')
	FileWriteLine($_LOGFILE, "")
	__LOG(" HWID .")
Else
	__LOG("devcon.exe :   HWID.")
EndIf
__SPLASH(" ...")
If Not FileExists($_SETTINGSFILE) Then
	__CRIT("    fSetup.ini  %SystemRoot%\system32\")
EndIf
$SET_DPSROOT = __REPLACEENVVARS(IniRead($_SETTINGSFILE, "Options", "DrvFolder", $_NF))
If Not FileExists($SET_DPSROOT & "\D") Then
	__CRIT(" ,    ,      !")
EndIf
$SEARCH = FileFindFirstFile(__REPLACEENVVARS("%DPSROOT%\DriverPack_*_" & $SET_PLATFORM & ".ini"))
If $SEARCH == -1 Then
	__LOG(' .ini   "' & __REPLACEENVVARS("%DPSROOT%") & '"  ' & $SET_PLATFORM & " !")
	FileClose($SEARCH)
Else
	$EXC_ID = 1
	While 1
		$FILE = FileFindNextFile($SEARCH)
		If @error Then
			FileClose($SEARCH)
			ExitLoop
		EndIf
		If $FILE == "" Or $FILE == "." Or $FILE == ".." Then
			ContinueLoop
		EndIf
		$FULLFILE = __REPLACEENVVARS("%DPSROOT%\" & $FILE)
		$DP_NAME = IniRead($FULLFILE, "DriverPack", "name", $_NF)
		If $DP_NAME == $_NF Then
			__CRIT(".ini   " & $DP_NAME & "  :    name   [DriverPack]")
		EndIf
		$DP_ROOT = IniRead($FULLFILE, "DriverPack", "rootDir", $_NF)
		If $DP_ROOT == $_NF Then
			__CRIT(".ini   " & $DP_NAME & "  :    root   [DriverPack]")
		EndIf
		$DP_EXCEPTIONS = IniReadSectionNames($FULLFILE)
		_ARRAYDELETE($DP_EXCEPTIONS, 0)
		__LOG(" .ini    " & $DP_NAME & '! ("' & $FULLFILE & '")')
		If UBound($DP_EXCEPTIONS) == 0 Then
			__CRIT(".ini    " & $DP_NAME & " :    !")
		ElseIf $DP_EXCEPTIONS[0] <> "DriverPack" Then
			__CRIT(".ini    " & $DP_NAME & " :    [DriverPack].")
		EndIf
		If $DP_ROOT == $_NF Then
			__CRIT("   " & $DP_NAME & "     .ini !")
		EndIf
		_ARRAYDELETE($DP_EXCEPTIONS, 0)
		__DBG_ARRAY($DP_EXCEPTIONS, "dp_exceptions")
		$SIZEBEFORE = UBound($DP_EXCEPTIONS)
		$I = 0
		While 1
			If $I < 0 Or UBound($DP_EXCEPTIONS) == 0 Then
				ExitLoop
			ElseIf $I == UBound($DP_EXCEPTIONS) Then
				ExitLoop
			EndIf
			__LOG("    Processing driver exceptions section [" & $DP_EXCEPTIONS[$I] & "].")
			If Not FileExists($SET_DPSROOT & "\" & $DP_ROOT & "\" & StringReplace($DP_EXCEPTIONS[$I], "-", "\")) Then
				__LOG('        Disabled this section because the directory "' & $SET_DPSROOT & "\" & $DP_ROOT & "\" & StringReplace($DP_EXCEPTIONS[$I], "-", "\") & '" did not exist.')
				If UBound($DP_EXCEPTIONS) == 1 Then
					$I = -1
				Else
					_ARRAYDELETE($DP_EXCEPTIONS, $I)
				EndIf
			Else
				$EXC_COUNT = IniRead($FULLFILE, $DP_EXCEPTIONS[$I], "exc_count", 0)
				$K = 1
				__LOG('        Importing exceptions for this driver because the directory "' & $SET_DPSROOT & "\" & $DP_ROOT & "\" & StringReplace($DP_EXCEPTIONS[$I], "-", "\") & '" did exist.')
				While $K <= $EXC_COUNT
					__LOG("        Importing the full requirements for exception " & $K & " of " & $EXC_COUNT & " for this driver.")
					If $EXC_ID == UBound($EXCEPTIONS) Then
						ReDim $EXCEPTIONS[$EXC_ID + 1][8]
					EndIf
					$EXCEPTIONS[$EXC_ID][0] = $DP_EXCEPTIONS[$I]
					$EXCEPTIONS[$EXC_ID][1] = __EXCPARSE_GETREQUIREMENTSBYTYPE($FULLFILE, $DP_EXCEPTIONS[$I], $K, "tagFiles")
					$EXCEPTIONS[$EXC_ID][2] = __EXCPARSE_GETREQUIREMENTSBYTYPE($FULLFILE, $DP_EXCEPTIONS[$I], $K, "+hwids")
					$EXCEPTIONS[$EXC_ID][3] = __EXCPARSE_GETREQUIREMENTSBYTYPE($FULLFILE, $DP_EXCEPTIONS[$I], $K, "-hwids")
					$EXCEPTIONS[$EXC_ID][4] = __EXCPARSE_GETREQUIREMENTSBYTYPE($FULLFILE, $DP_EXCEPTIONS[$I], $K, "+infFiles")
					$EXCEPTIONS[$EXC_ID][5] = __EXCPARSE_GETREQUIREMENTSBYTYPE($FULLFILE, $DP_EXCEPTIONS[$I], $K, "-infFiles")
					$EXCEPTIONS[$EXC_ID][6] = __EXCPARSE_GETREQUIREMENTSBYTYPE($FULLFILE, $DP_EXCEPTIONS[$I], $K, "commands")
					For $R = 1 To 6
						If $EXCEPTIONS[$EXC_ID][$R] == -1 Then
							__LOG("            Could not find one or more of the requirement types for this exception! This exception will therefore not be processed!")
							$K += 1
							ContinueLoop 2
						EndIf
					Next
					$EXCEPTIONS[$EXC_ID][7] = True
					$EXCEPTIONS[0][0] += 1
					$EXCEPTIONS[0][1] += 1
					$EXC_ID += 1
					$K += 1
				WEnd
				$I += 1
			EndIf
		WEnd
		If $SIZEBEFORE == UBound($DP_EXCEPTIONS) Then
			__LOG("    No exceptions disabled for this DriverPack.")
		EndIf
		If $EXCEPTIONS[0][1] <> $EXCEPTIONS[0][0] Then
			__CRIT("Something went wrong while importing the requirements for this DriverPack. Please file a bug report at driverpacks.net's bugtracker!")
		EndIf
		If $I == -1 Then
			__LOG("Number of exceptions imported for this DriverPack: 0.")
		Else
			__LOG("Number of exceptions imported for this DriverPack: " & UBound($DP_EXCEPTIONS) & ".")
		EndIf
		__LOG("Total number of exceptions: " & $EXCEPTIONS[0][0] & ".")
		__DBG("exceptions[0][0]: " & $EXCEPTIONS[0][0])
		__DBG("exceptions[0][1]: " & $EXCEPTIONS[0][1])
	WEnd
EndIf
__LOG("Processed settings.")
__DBG("Content of $exceptions array: (custom array output)")
__DBG("    $exceptions = array(")
$I = 1
While 1
	If $I == $EXCEPTIONS[0][0] + 1 Then
		ExitLoop
	EndIf
	__DBG("        [" & $EXCEPTIONS[$I][0] & "] = array(")
	__EXCPARSE_DBGOUTPUTBYTYPE($EXCEPTIONS, $I, "tagFiles", 1)
	__EXCPARSE_DBGOUTPUTBYTYPE($EXCEPTIONS, $I, "+hwids", 2)
	__EXCPARSE_DBGOUTPUTBYTYPE($EXCEPTIONS, $I, "-hwids", 3)
	__EXCPARSE_DBGOUTPUTBYTYPE($EXCEPTIONS, $I, "+infFiles", 4)
	__EXCPARSE_DBGOUTPUTBYTYPE($EXCEPTIONS, $I, "-infFiles", 5)
	__EXCPARSE_DBGOUTPUTBYTYPE($EXCEPTIONS, $I, "commands", 6)
	__DBG("        )")
	$I += 1
WEnd
__DBG("    )")
__DBG("Content of $exceptions array: (raw array contents)")
__DBG_ARRAY($EXCEPTIONS, "exceptions")
If FileExists(@SystemDir & "\presetup.cmd") Then
	If Not RegWrite("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion", "DevicePath", "REG_EXPAND_SZ", "%SystemRoot%\Inf") Then
		__ERR("Could not reset the DevicePath value in the registry to its original value.")
	Else
		__LOG("Detected a method 2 driver installation, the DevicePath value in the registry has been reset.")
	EndIf
EndIf
Global $_STAGE
Global $SET_DPSROOT
Global $SET_PLATFORM
Global $SPLASH_ACTION
Local $CHECK
Local $FILE
Local $HWIDS
Local $INFFILE
Local $INFSEARCHING
Local $INFSEARCHINGLOOPRESETTED
Local $SEARCH
Local $TMP
$_STAGE = "FLTR"
If $EXCEPTIONS[0][0] == 0 Then
	__LOG("No exceptions left, skip immediately to CLNP.")
Else
	__SPLASH(" HWID...")
	$HWIDS = __GETSYSTEMHWIDS()
	__LOG(" HWID   .")
	For $I = 1 To $EXCEPTIONS[0][0]
		__SPLASH("Filtering exceptions... " & "(" & $I & "/" & $EXCEPTIONS[0][0] & ")")
		__LOG("Verifying requirements for exception [" & $EXCEPTIONS[$I][0] & "] (" & $I & " of " & $EXCEPTIONS[0][0] & " exceptions).")
		If $EXCEPTIONS[$I][1] <> "" Then
			__LOG("	1. tagFiles (ALL tagFiles must be found)")
			$TMP = StringSplit($EXCEPTIONS[$I][1], "|||", 1)
			For $K = 1 To $TMP[0]
				$TMP[$K] = __REPLACEENVVARS($TMP[$K])
				If FileExists($TMP[$K]) Then
					__LOG('		Found tagfile "' & $TMP[$K] & '" (' & $K & "/" & $TMP[0] & ").")
				Else
					__LOG('		! Could not find tagfile "' & $TMP[$K] & '" (' & $K & " of " & $TMP[0] & " tagfiles).")
					__LOG("	=> This exception will not be applied.")
					$EXCEPTIONS[$I][7] = False
					$EXCEPTIONS[0][1] -= 1
					ExitLoop
				EndIf
			Next
			If $EXCEPTIONS[$I][7] == False Then
				ContinueLoop
			EndIf
		EndIf
		If $EXCEPTIONS[$I][2] <> "" Then
			__LOG("	2. +hwids (ANY +hwids must be matched)")
			$CHECK = False
			$TMP = StringSplit($EXCEPTIONS[$I][2], "|||", 1)
			For $K = 1 To $TMP[0]
				For $M = 1 To $HWIDS[0]
					If StringInStr($HWIDS[$M], $TMP[$K], 0) Then
						__LOG('		Matched +hwid "' & $TMP[$K] & '" (' & $K & " of " & $TMP[0] & " +hwids).")
						$CHECK = True
						ExitLoop 2
					EndIf
				Next
			Next
			If $CHECK == False Then
				$EXCEPTIONS[$I][7] = False
				$EXCEPTIONS[0][1] -= 1
				__LOG("		! Could not match any of the +hwids.")
				__LOG("	=> This exception will not be applied.")
				ContinueLoop
			EndIf
		EndIf
		If $EXCEPTIONS[$I][3] <> "" Then
			__LOG("	3. -hwids (ANY -hwids must be matched)")
			$CHECK = False
			$TMP = StringSplit($EXCEPTIONS[$I][3], "|||", 1)
			For $K = 1 To $TMP[0]
				For $M = 1 To $HWIDS[0]
					If StringInStr($HWIDS[$M], $TMP[$K], 0) Then
						__LOG('		Matched -hwid "' & $TMP[$K] & '" (' & $K & " / " & $TMP[0] & " -hwids).")
						$CHECK = True
						ExitLoop 2
					EndIf
				Next
			Next
			If $CHECK == True Then
				$EXCEPTIONS[$I][7] = False
				$EXCEPTIONS[0][1] -= 1
				__LOG("		! matched a -hwids.")
				__LOG("	=> This exception will not be applied.")
				ContinueLoop
			EndIf
		EndIf
		If $EXCEPTIONS[$I][4] <> "" Then
			__LOG("	4. +infFiles (ANY +infFiles must be matched)")
			$CHECK = False
			$TMP = StringSplit($EXCEPTIONS[$I][4], "|||", 1)
			$INFSEARCHINGLOOPRESETTED = False
			For $K = 1 To $TMP[0]
				If $INFSEARCHINGLOOPRESETTED == False Then
					$INFSEARCHING = False
				EndIf
				$TMP[$K] = __REPLACEENVVARS($TMP[$K])
				If StringLower(StringRight($TMP[$K], 5)) == "*.inf" Then
					If $INFSEARCHING == False Then
						__LOG("		Wildcard specified for +infFiles requirement: scan for .inf files (" & $K & " of " & $TMP[0] & " +infFiles).")
						$SEARCH = FileFindFirstFile(__REPLACEENVVARS($TMP[$K]))
						If $SEARCH == -1 Then
							__LOG("			No .inf files found!")
							FileClose($SEARCH)
							ContinueLoop 1
						EndIf
						$INFSEARCHING = True
					ElseIf $INFSEARCHING == True Then
						$FILE = FileFindNextFile($SEARCH)
						If @error Then
							FileClose($SEARCH)
							ContinueLoop 1
						EndIf
						$INFFILE = StringLeft($TMP[$K], StringInStr($TMP[$K], "\", 0, -1)) & $FILE
						__LOG('		Checking .inf file "' & $INFFILE & '".')
						$INFSEARCHING = True
					EndIf
				Else
					$INFFILE = $TMP[$K]
					__LOG('		Checking .inf file "' & $INFFILE & '".')
					$INFSEARCHING = False
				EndIf
				If $INFFILE <> "." And $INFFILE <> ".." And $INFFILE <> "" Then
					For $M = 1 To $HWIDS[0]
						If __FINDMATCHINGHWIDS($INFFILE, $HWIDS[$M], "no") Then
							$CHECK = True
							__LOG('		Matched +infFile"' & $INFFILE & '" through the HWID "' & $HWIDS[$M] & '" (original HWID: "' & $HWIDS[$M] & '") (' & $K & " of " & $TMP[0] & " +infFiles).")
						Else
							For $O = 3 To 1 Step -1
								If __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) <> $HWIDS[$M] Then
									If __FINDMATCHINGHWIDS($INFFILE, __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O), "no") Then
										$CHECK = True
										If $INFSEARCHING == False Then
											__LOG('		Matched +infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '") (' & $K & " of " & $TMP[0] & " +infFiles).")
										Else
											__LOG('		Matched +infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '").')
										EndIf
										ExitLoop 3
									ElseIf $_DEBUG == True Then
										If $INFSEARCHING == False Then
											__LOG('		! Could not match +infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '") (' & $K & " of " & $TMP[0] & " +infFiles).")
										Else
											__LOG('		! Could not match +infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '").')
										EndIf
									EndIf
								EndIf
							Next
						EndIf
					Next
				EndIf
				If $INFSEARCHING == True Then
					$INFSEARCHINGLOOPRESETTED = True
					$K -= 1
				Else
					$INFSEARCHINGLOOPRESETTED = False
				EndIf
			Next
			FileClose($SEARCH)
			If $CHECK == False Then
				$EXCEPTIONS[$I][7] = False
				$EXCEPTIONS[0][1] -= 1
				__LOG("		! Could not match any of the +infFiles.")
				__LOG("	=> This exception will not be applied.")
				ContinueLoop
			EndIf
		EndIf
		If $EXCEPTIONS[$I][5] <> "" Then
			__LOG("	5. -infFiles (ANY -infFiles must be matched)")
			$CHECK = False
			$TMP = StringSplit($EXCEPTIONS[$I][5], "|||", 1)
			$INFSEARCHINGLOOPRESETTED = False
			For $K = 1 To $TMP[0]
				If $INFSEARCHINGLOOPRESETTED == False Then
					$INFSEARCHING = False
				EndIf
				$TMP[$K] = __REPLACEENVVARS($TMP[$K])
				If StringLower(StringRight($TMP[$K], 5)) == "*.inf" Then
					If $INFSEARCHING == False Then
						__LOG("		Wildcard specified for -infFiles requirement: scan for .inf files (" & $K & " of " & $TMP[0] & " +infFiles).")
						$SEARCH = FileFindFirstFile(__REPLACEENVVARS($TMP[$K]))
						If $SEARCH == -1 Then
							__LOG("			No .inf files found!")
							FileClose($SEARCH)
							ContinueLoop 1
						EndIf
						$INFSEARCHING = True
					ElseIf $INFSEARCHING == True Then
						$FILE = FileFindNextFile($SEARCH)
						If @error Then
							FileClose($SEARCH)
							ContinueLoop 1
						EndIf
						$INFFILE = StringLeft($TMP[$K], StringInStr($TMP[$K], "\", 0, -1)) & $FILE
						__LOG('		Checking .inf file "' & $INFFILE & '".')
						$INFSEARCHING = True
					EndIf
				Else
					$INFFILE = $TMP[$K]
					$INFSEARCHING = False
				EndIf
				If $INFFILE <> "." And $INFFILE <> ".." And $INFFILE <> "" Then
					For $M = 1 To $HWIDS[0]
						If __FINDMATCHINGHWIDS($INFFILE, $HWIDS[$M], "no") Then
							$CHECK = True
							__LOG('		Matched +infFile"' & $INFFILE & '" through the HWID "' & $HWIDS[$M] & '" (original HWID: "' & $HWIDS[$M] & '") (' & $K & " of " & $TMP[0] & " +infFiles).")
						Else
							For $O = 3 To 1 Step -1
								If __FINDMATCHINGHWIDS($INFFILE, __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O), "no") Then
									$CHECK = True
									If $INFSEARCHING == False Then
										__LOG('		Matched -infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '") (' & $K & " of " & $TMP[0] & " -infFiles).")
									Else
										__LOG('		Matched -infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '").')
									EndIf
									ExitLoop 3
								ElseIf $_DEBUG == True Then
									If $INFSEARCHING == False Then
										__LOG('		! Could not match -infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '") (' & $K & " of " & $TMP[0] & " -infFiles).")
									Else
										__LOG('		! Could not match -infFile"' & $INFFILE & '" through the HWID "' & __DECREASEHWIDUNIQUENESS($HWIDS[$M], $O) & '" (original HWID: "' & $HWIDS[$M] & '").')
									EndIf
								EndIf
							Next
						EndIf
					Next
				EndIf
				If $INFSEARCHING == True Then
					$INFSEARCHINGLOOPRESETTED = True
					$K -= 1
				Else
					$INFSEARCHINGLOOPRESETTED = False
				EndIf
			Next
			FileClose($SEARCH)
			If $CHECK == False Then
				$EXCEPTIONS[$I][7] = False
				$EXCEPTIONS[0][1] -= 1
				__LOG("		! Could not match any of the -infFiles.")
				__LOG("	=> This exception will not be applied.")
				ContinueLoop
			EndIf
		EndIf
		__LOG("	=> All requirements for exception [" & $EXCEPTIONS[$I][0] & "] have been met!")
	Next
	__LOG("Finished filtering exceptions.")
	__DBG($EXCEPTIONS[0][1] & " exceptions have fulfilled the requirements to be executed!")
EndIf
Global $_STAGE
Global $EXCEPTIONS
Local $CMD
Local $LINE
Local $TMP
Local $TMPTIMER
$_STAGE = "EXEC"
If $EXCEPTIONS[0][0] <> 0 Then
	__SPLASH("Executing exceptions...")
	For $I = 1 To $EXCEPTIONS[0][0]
		If $EXCEPTIONS[$I][7] == False Then
			ContinueLoop
		EndIf
		$TMP = StringSplit($EXCEPTIONS[$I][6], "|||", 1)
		__LOG("Executing all commands (" & $TMP[0] & ") for exception [" & $EXCEPTIONS[$I][0] & "].")
		For $K = 1 To $TMP[0]
			__LOG("	Executing command " & $K & " of " & $TMP[0] & ': "' & $TMP[$K] & '"')
			$CMD = RunWait(__REPLACEENVVARS($TMP[$K]), @SystemDir, $STDERR_CHILD + $STDOUT_CHILD)
			$CHECK = False
			While 1
				$LINE = StdoutRead($CMD)
				If @error = -1 Then
					ExitLoop
				EndIf
				$CHECK = True
				If $LINE == "" Then
					ContinueLoop 2
				EndIf
				__LOG("		STDOUT: " & $LINE)
			WEnd
			While 1
				$LINE = StderrRead($CMD)
				If @error = -1 Then
					ExitLoop
				EndIf
				$CHECK = True
				__ERR("		! STDERR: " & $LINE)
			WEnd
			If $CHECK == False Then
				__LOG("		No STDOUT/STDERR output occurred.")
			EndIf
		Next
	Next
EndIf

Func __SETUPCOPYOEMINF($FA_DIR)
	Return 0
EndFunc

__CLNP()
If $_SPLASHSCREEN == True Then
	GUIDelete()
EndIf
__QUIT()