[Setup]
WizardImageFile=WizardImage.bmp
WizardSmallImageFile=WizardSmallImage.bmp
SetupIconFile=1.ico
DiskSpanning=true
DiskSliceSize=max
DisableReadyPage=true
UsePreviousTasks=false
DirExistsWarning=no
ShowTasksTreeLines=true

[Languages]
Name: ru; MessagesFile: compiler:Languages\Russian.isl

[Code]
const
WM_USER = $0400;
PBM_SETPOS = WM_USER+2;
GWL_WNDPROC = -4;

function SetWindowLong(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): Longint; external 'SetWindowLongA@user32.dll stdcall';
function CallWindowProc(lpPrevWndFunc: Longint; hWnd: HWND; Msg: UINT; wParam, lParam: Longint): Longint; external 'CallWindowProcA@user32.dll stdcall';
function MulDiv(nNumber, nNumerator, nDenominator: Integer): Integer; external 'MulDiv@kernel32.dll stdcall';

var
OldProgressBarProc: Longint;
PercentLabel: TLabel;

function ProgressBarProc(hWnd: HWND; Msg: UINT; wParam: Longint; lParam: Longint): Longint;
begin
  case Msg of
   PBM_SETPOS:
    begin
     Result := CallWindowProc(OldProgressBarProc, hWnd, Msg, wParam, lParam);
      with WizardForm.ProgressGauge do
      PercentLabel.Caption := Format('%d %%', [MulDiv(Position, 100, Max)]);
    end;
   else
   Result := CallWindowProc(OldProgressBarProc, hWnd, Msg, wParam, lParam);
  end;
end;

procedure InitializeWizard1();
begin  
  with WizardForm do //  "" 
    begin
     PageNameLabel.Hide;
     PageDescriptionLabel.Hide;
     WizardSmallBitmapImage.Left:=WizardForm.WizardSmallBitmapImage.Left-440
     WizardSmallBitmapImage.Width:=497
     PageNameLabel.Width:=350
     PageDescriptionLabel.Width:=350
    end; //  "" 
    
 OldProgressBarProc := SetWindowLong(WizardForm.ProgressGauge.Handle, GWL_WNDPROC, CallbackAddr('ProgressBarProc')); //   
 PercentLabel := TLabel.Create(WizardForm);
  with PercentLabel do
    begin
     Parent := WizardForm.ProgressGauge;
     Align := alClient;
     Alignment := taCenter;
     Font.Color:=clBlack;
     Font.Style:=[fsBold];
     Font.Height := -16;
     Transparent:=True;
    end; //   
end;

procedure RedesignWizardForm1();
  begin
    with WizardForm.LicenseNotAcceptedRadio do  // 
      begin
       Checked := False;
       TabStop := False;
      end;

    with WizardForm.LicenseAcceptedRadio do
      begin
       Checked := True;
       TabStop := True;
      end; // 
    
    with WizardForm.TasksList do  //
      begin
       Top := ScaleY(25);
       Height := ScaleY(208);
      end;

    with WizardForm.SelectTasksLabel do
      begin
       Caption := '-    -';
       Height := ScaleY(20);
       Left := ScaleX(85);
       Width := ScaleX(250);
       Font.Color := clNavy;
       Font.Height := -12;
       Font.Style := [fsBold];
       ParentFont := False;
      end;

    with WizardForm.ComponentsList do
      begin
       Top := ScaleY(60);
       Height := ScaleY(145);
      end;

    with WizardForm.TypesCombo do
      begin
       Top := ScaleY(20);
      end;

    with WizardForm.SelectComponentsLabel do
      begin
       Caption := '-    -';
       Height := ScaleY(20);
       Left := ScaleX(120);
       Width := ScaleX(200);
       Font.Color := clNavy;
       Font.Height := -12;
       Font.Style := [fsBold];
       ParentFont := False;
      end; //
  end;

procedure DeinitializeSetup1();
begin
 SetWindowlong(WizardForm.ProgressGauge.Handle, GWL_WNDPROC, OldProgressBarProc);
end;