unit emulate;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, inifiles,
  shellapi;

type
  TForm4 = class(TForm)
    RadioGroup1: TRadioGroup;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    GroupBox1: TGroupBox;
    ComboBox1: TComboBox;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    procedure CheckBox1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form4: TForm4;

implementation

uses unit1;
{$R *.dfm}

procedure TForm4.Button1Click(Sender: TObject);
begin
  close;
end;

procedure TForm4.Button2Click(Sender: TObject);
var
  Ininfile: TIniFile;
begin

  if (GB_Write_allowed) then
  begin

    Ininfile := TIniFile.Create(GB_INI_PATH);

    Ininfile.WriteBool('emulation', 'Emulate', CheckBox1.Checked);
    Ininfile.WriteInteger('emulation', 'Arch', RadioGroup1.ItemIndex);
    Ininfile.WriteString('emulation', 'System',
      GB_Oses.Names[ComboBox1.ItemIndex]);

    if Assigned(Ininfile) then
      Ininfile.Free;

    ShellExecute(Form1.Handle, 'open', pchar(paramstr(0)), nil,
      nil, SW_show);
      Application.Terminate;

  end
  else
    ShowMessage('Emulation could not Activate from CD');

end;

procedure TForm4.CheckBox1Click(Sender: TObject);
begin

  case CheckBox1.Checked of
    true:
      begin
        GroupBox1.Enabled := true;
        RadioGroup1.Enabled := true;
        ComboBox1.Enabled := true;
      end;
    false:
      begin
        GroupBox1.Enabled := false;
        RadioGroup1.Enabled := false;
        ComboBox1.Enabled := false;

      end;
  end;

end;

procedure TForm4.FormCreate(Sender: TObject);
var
  i: Integer;
begin

  // for I := 0 to GB_Oses.Count-1 do
  ComboBox1.Items.Assign(GB_Oses);
  ComboBox1.ItemIndex := 0;

end;

procedure TForm4.FormShow(Sender: TObject);
var
  Ininfile: TIniFile;
begin

  if (GB_Write_allowed) then
  begin

    Ininfile := TIniFile.Create(GB_INI_PATH);

    CheckBox1.Checked := Ininfile.ReadBool('emulation', 'Emulate', false);
    RadioGroup1.ItemIndex := Ininfile.readInteger('emulation', 'Arch', 0);
    ComboBox1.ItemIndex := GB_Oses.IndexOfName(Ininfile.readString('emulation',
      'System', GB_Oses.Strings[0]));
    CheckBox1Click(CheckBox1);
    if Assigned(Ininfile) then
      Ininfile.Free;

  end
  else
    ShowMessage('Emulation could not Activate from CD');

end;

end.
