; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Far Manager"
!define PRODUCT_VER "1.70"
; MUI 1.67 compatible ------
!include "MUI.nsh"
;SetCompress off
SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
; Welcome page
!insertmacro MUI_PAGE_WELCOME
;dir
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
;!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
  !define MUI_UNFINISHPAGE_NOAUTOCLOSE
  !insertmacro MUI_UNPAGE_INSTFILES
;  !insertmacro MUI_UNPAGE_FINISH


; Language files
!insertmacro MUI_LANGUAGE "Russian"
; MUI end ------

!include "LogicLib.nsh"
!define StrLoc "!insertmacro StrLoc"
 !macro StrLoc ResultVar String SubString StartPoint
  Push "${String}"
  Push "${SubString}"
  Push "${StartPoint}"
  Call StrLoc
  Pop "${ResultVar}"
!macroend
 
Function StrLoc
/*
${StrLoc} $0 "This is just an example" "just" "<"
After this point:
  ------------------------------------------
   $R0 = StartPoint (input)
   $R1 = SubString (input)
   $R2 = String (input)
   $R3 = SubStringLen (temp)
   $R4 = StrLen (temp)
   $R5 = StartCharPos (temp)
   $R6 = TempStr (temp)*/
 
  ;Get input from user
  Exch $R0
  Exch
  Exch $R1
  Exch 2
  Exch $R2
  Push $R3
  Push $R4
  Push $R5
  Push $R6
 
  ;Get "String" and "SubString" length
  StrLen $R3 $R1
  StrLen $R4 $R2
  ;Start "StartCharPos" counter
  StrCpy $R5 0
 
  ;Loop until "SubString" is found or "String" reaches its end
  ${Do}
    ;Remove everything before and after the searched part ("TempStr")
    StrCpy $R6 $R2 $R3 $R5
 
    ;Compare "TempStr" with "SubString"
    ${If} $R6 == $R1
      ${If} $R0 == '<'
        IntOp $R6 $R3 + $R5
        IntOp $R0 $R4 - $R6
      ${Else}
        StrCpy $R0 $R5
      ${EndIf}
      ${ExitDo}
    ${EndIf}
    ;If not "SubString", this could be "String"'s end
    ${If} $R5 >= $R4
      StrCpy $R0 ''
      ${ExitDo}
    ${EndIf}
    ;If not, continue the loop
    IntOp $R5 $R5 + 1
  ${Loop}
 
  ;Return output to user
  Pop $R6
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Exch
  Pop $R1
  Exch $R0
FunctionEnd

Name "${PRODUCT_NAME}"
Caption " ${PRODUCT_NAME} ${PRODUCT_VER}"
OutFile "far_setup.exe"
InstallDir "$PROGRAMFILES\FAR"
ShowInstDetails show
ShowUninstDetails show

Section "Core" SEC01
  SetOutPath "$INSTDIR"
  File /r  "c:\far\*.*"
  ExecWait 'regedit.exe /S "$INSTDIR\farsave1.reg"' $1
  pop $1  
  ExecWait 'regedit.exe /S "$INSTDIR\farsave2.reg"' $1
  pop $1
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\far" "DisplayName" "${PRODUCT_NAME} ${PRODUCT_VER}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\far" "UninstallString" '"$INSTDIR\unfar.exe"'
  ReadRegStr $1 HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "Path"
 # DetailPrint "Path is $1"
  ${StrLoc} $2 $1 "$INSTDIR\TOOLS\ARC\" ">"
 # DetailPrint "Env Flag is $2"
  ${If} $2 == ''
	WriteRegExpandStr HKLM "SYSTEM\ControlSet001\Control\Session Manager\Environment" "Path" "$1;$INSTDIR\TOOLS\ARC\"
  ${EndIf}
  pop $1
  pop $2
  WriteUninstaller "unfar.exe"
  SetShellVarContext All
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$INSTDIR\far.exe" "" "$INSTDIR\far.ico" 0
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ ${PRODUCT_NAME}.lnk" "$INSTDIR\unfar.exe" "" "$INSTDIR\unfar.exe" 0
SectionEnd

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\far"
  ; Remove directories used
  SetShellVarContext All
  RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
  RMDir /r "$INSTDIR"
 SectionEnd

Function un.onInit
    MessageBox MB_YESNO|MB_ICONQUESTION  " ${PRODUCT_NAME} ${PRODUCT_VER}?" IDYES NoAbort
      Abort ; causes uninstaller to quit.
    NoAbort:
  FunctionEnd

