!define PRODUCT_NAME "Foxit PDF Reader"
!define PRODUCT_VERSION "2.3.2008.2923"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "Russian"

; MUI end ------

Name "${PRODUCT_NAME}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
Caption " ${PRODUCT_NAME} ${PRODUCT_VERSION}"
InstallDir "$PROGRAMFILES\Foxit Software\Foxit Reader"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  File /r "D:\Foxit Reader\*.*"
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\Foxit PDF Reader"
  CreateShortCut "$SMPROGRAMS\Foxit PDF Reader\Foxit PDF Reader.lnk" "$INSTDIR\Foxit Reader.exe" "" "$INSTDIR\Foxit Reader.exe" 0
  WriteRegStr HKCU  "Software\Foxit Software\Foxit Reader\LANGUAGE" "" "40827d"
  ; 
  ;.pdf
  WriteRegStr HKLM	"SOFTWARE\Classes\.pdf" "" "FoxitReader.Document"
  WriteRegStr HKLM	"SOFTWARE\Classes\.pdf" "Content Type" "FoxitReader.Document"
  ;FoxitReader.Document
  WriteRegStr HKLM	"SOFTWARE\Classes\FoxitReader.Document" "BrowseInPlace" "1"
  WriteRegDWORD HKLM "SOFTWARE\Classes\FoxitReader.Document" "EditFlags" 0
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\DefaultIcon" "" "$INSTDIR\Foxit Reader.exe,1"
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\DocObject" "" "0"
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\Insertable" "" ""
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\shell\open\command" "" "$INSTDIR\Foxit Reader.exe $\"%1$\""
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\shell\print\command" "" "$INSTDIR\Foxit Reader.exe /p $\"%1$\""
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\shell\printto\command" "" "$INSTDIR\Foxit Reader.exe /t $\"%1$\" $\"%2$\" $\"%3$\" $\"%4$\""
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\protocol\StdFileEditing\server" "" "$INSTDIR\Foxit Reader.exe"
  WriteRegStr HKLM "SOFTWARE\Classes\FoxitReader.Document\protocol\StdFileEditing\verb\0" "" "&Edit"
  ;mime
  WriteRegStr HKLM "SOFTWARE\Classes\MIME\Database\Content Type\application/pdf" "CLSID" "{14E8BBD8-1D1C-4D56-A4DA-D20B75EB814E}"
  WriteRegStr HKLM "SOFTWARE\Classes\MIME\Database\Content Type\application/pdf" "Extension" ".pdf"
  ; 
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowEditorAd1.3" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowEditorAd1.3" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowReaderAd1.3" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowTypewriterAd1.3" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowEditorAd_908" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowReaderAd_908" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowTypewriterAd_908" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowPOAd_908" "0"
  WriteRegStr HKCU "Software\Foxit Software\Foxit Reader\MainFrame" "ShowSDKAd_908" "0"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  CreateShortCut "$SMPROGRAMS\Foxit PDF Reader\Uninstall Foxit PDF Reader.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\uninst.exe" 0
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\Foxit Reader.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "  $(^Name)   ."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "   ,    $(^Name)    ?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  RMDir /r "$INSTDIR"
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\Foxit PDF Reader"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM	"SOFTWARE\Classes\.pdf"
  DeleteRegKey HKLM	"SOFTWARE\Classes\FoxitReader.Document"
  DeleteRegKey HKLM "SOFTWARE\Classes\MIME\Database\Content Type\application/pdf"
  DeleteRegKey HKCU "Software\Foxit Software\Foxit Reader\"
  SetAutoClose true
SectionEnd