!define PRODUCT_NAME "Punto Switcher"
!define PRODUCT_VERSION "2.96.3"

; MUI 1.67 compatible ------
!include "MUI.nsh"
SetCompressor lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
; Installer pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH
;Lang
!insertmacro MUI_LANGUAGE "Russian"
; MUI end ------

Name "${PRODUCT_NAME}"
Caption "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\Punto Switcher\"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  File   /r "D:\Punto Switcher\"
  WriteUninstaller "$INSTDIR\uninst.exe"
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\Punto Switcher"
  CreateShortCut "$SMPROGRAMS\Punto Switcher\Punto Switcher.lnk" "$INSTDIR\ps.exe" "" "$INSTDIR\ps.exe" 0
  CreateShortCut "$SMPROGRAMS\Punto Switcher\ .lnk" "$INSTDIR\ChooseLayouts.exe" "" "$INSTDIR\ChooseLayouts.exe" 0
  CreateShortCut "$SMPROGRAMS\Punto Switcher\ .lnk" "$INSTDIR\whatsnew.htm"
  CreateShortCut "$SMPROGRAMS\Punto Switcher\ .lnk" "$INSTDIR\dview.exe" "" "$INSTDIR\dview.exe" 0  
  CreateShortCut "$SMPROGRAMS\Punto Switcher\ .lnk" "$INSTDIR\DicEditor.exe" "" "$INSTDIR\DicEditor.exe" 0
  CreateShortCut "$SMPROGRAMS\Punto Switcher\  .lnk" "$INSTDIR\ps.chm"
  CreateShortCut "$SMPROGRAMS\Punto Switcher\.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\uninst.exe" 0
  WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Run" "Punto Switcher" "$INSTDIR\ps.exe"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" "DisplayName" "$(^Name)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" "DisplayIcon" "$INSTDIR\ps.exe"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" "UninstallString" "$INSTDIR\uninst.exe"
  ExecWait "regedit.exe /S $\"$INSTDIR\ps.reg$\""
  Delete "$INSTDIR\ps.reg"
SectionEnd


; Function un.onUninstSuccess
  ; HideWindow
  ; MessageBox MB_ICONINFORMATION|MB_OK "  $(^Name)   ."
; FunctionEnd
Section Uninstall
  RMDir /r "$INSTDIR"
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\Punto Switcher\"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
  DeleteRegValue HKCU "Software\Microsoft\Windows\CurrentVersion\Run" "Punto Switcher"
  SetAutoClose true
SectionEnd