; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Remote Administrator Server"
!define PRODUCT_VER "2.1"
; MUI 1.67 compatible ------
!include "MUI.nsh"
;SetCompress off
SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install-colorful.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall-colorful.ico"
; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
;!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
; Language files
!insertmacro MUI_LANGUAGE "Russian"

; MUI end ------

Name "${PRODUCT_NAME}"
OutFile "radsrv21.exe"
InstallDir "$SYSDIR"
ShowInstDetails show
ShowUninstDetails show

Section "Core" SEC01
  SetOutPath "$INSTDIR"
  File /r  "D:\radmin\*.*"
  DetailPrint "Registering R_server"
  ExecWait "$INSTDIR\r_server.exe /install /silence" $0
  pop $0
  ExecWait 'regedit.exe /S "$INSTDIR\radmin.reg"' $1
  pop $1
  DetailPrint "Finalizing..."
  Delete "$INSTDIR\radmin.reg"
  ExecWait "net start r_server" $2
  pop $2
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\r_server" "DisplayName" "${PRODUCT_NAME} ${PRODUCT_VER}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\r_server" "UninstallString" '"$INSTDIR\un_r_srv.exe"'
  WriteUninstaller "un_r_srv.exe"

  SetShellVarContext All
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME} ${PRODUCT_VER}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME} ${PRODUCT_VER}\ ${PRODUCT_NAME} ${PRODUCT_VER}.lnk" "$INSTDIR\r_server.exe" "/setup" "$INSTDIR\r_server.exe" 0
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME} ${PRODUCT_VER}\  ${PRODUCT_NAME} ${PRODUCT_VER}.lnk" "$INSTDIR\r_server.exe" "/install" "$INSTDIR\r_server.exe" 0
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME} ${PRODUCT_VER}\  ${PRODUCT_NAME} ${PRODUCT_VER}.lnk" "$INSTDIR\r_server.exe" "/uninstall" "$INSTDIR\r_server.exe" 0
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME} ${PRODUCT_VER}\  ${PRODUCT_NAME} ${PRODUCT_VER}.lnk" "$INSTDIR\un_r_srv.exe" "" "$INSTDIR\un_r_srv.exe" 0
SectionEnd

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\r_server"
  ExecWait "net stop r_server" $0
  pop $0
  ExecWait "$INSTDIR\r_server.exe /uninstall /silence" $1
  pop $1
  ; Remove files and uninstaller
  Delete "$INSTDIR\raddrv.dll"
  Delete "$INSTDIR\admdll.dll"
  Delete "$INSTDIR\r_server.exe"
  Delete "$INSTDIR\un_r_srv.exe"

 
  ; Remove directories used
  SetShellVarContext All
  RMDir /r "$SMPROGRAMS\${PRODUCT_NAME} ${PRODUCT_VER}"
 SectionEnd

Function un.onInit
    MessageBox MB_YESNO|MB_ICONQUESTION  " ${PRODUCT_NAME} ${PRODUCT_VER}?" IDYES NoAbort
      Abort ; causes uninstaller to quit.
    NoAbort:
  FunctionEnd

