; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Taskinfo"
!define PRODUCT_VERSION "7.2.0.250"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install-colorful.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall-colorful.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "Russian"

; MUI end ------

Name "${PRODUCT_NAME}"
Caption "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "tskinfXP.exe"
InstallDir "$PROGRAMFILES\taskinfo"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  File /r /x "Tsknf700.sys" "D:\taskinfo\*.*"
  SetOutPath "$SYSDIR\drivers\"
  File "D:\taskinfo\Tsknf700.sys"
  SetShellVarContext all
  CreateShortCut "$SMPROGRAMS\Taskinfo.lnk" "$INSTDIR\TaskInfo.exe" "" "$INSTDIR\TaskInfo.exe" 0
SectionEnd

Section -Post
	WriteUninstaller "$INSTDIR\uninst.exe"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
	WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"

	WriteRegStr HKCU "Software\Iarsn\TaskInfo_70\Registration\Current" "UserName" "Name Name"
	WriteRegStr HKCU "Software\Iarsn\TaskInfo_70\Registration\Current" "RegKey" "XXXXX-XXXXXXXXX-XXXXXXX"
	  
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "ShowGraphBar" 0
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "ShowHandlesNmb" 0
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "ShowPortNumbers" 1
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "Showprocdescr" 0
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "ShowProcessesTree" 1
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "DSIGMode" 2
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "LowResourceAlertEnable" 0
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "HandlesAlertEnable" 0
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\Screan" "VirtMemAlertEnable" 0
  
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\CheckUpdateParams" "Checkreleasesonly" 0
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\CheckUpdateParams" "LastCheckDay" 13826
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\CheckUpdateParams" "DayToCheck" 13826
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\CheckUpdateParams" "CheckPeriod" 0
	WriteRegDWORD HKCU "Software\Iarsn\TaskInfo_70\CheckUpdateParams" "CheckFlags" 0
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "  $(^Name)   ."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "   ,    $(^Name)    ?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  RMDir /r "$INSTDIR"
  SetShellVarContext all
  Delete  "$SMPROGRAMS\Taskinfo.lnk"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd