; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Total Commander"
!define PRODUCT_VERSION "7.04a"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "Russian"



; MUI end ------
Name "${PRODUCT_NAME}"
Caption "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "iTC.exe"
InstallDir "D:\TotalCMD"
ShowInstDetails show
ShowUnInstDetails show
BrandingText "By Happy Bulldozer860"
Var SysDrive
Function .onInit
	StrCpy $SysDrive $WINDIR 2
	StrCpy $INSTDIR "$SysDrive\totalcmd"
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  File  /r /x "wincmd.ini" "D:\tc\*.*" 
  RegDLL "$INSTDIR\plugins\Download\DPMenu.dll"
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\Total Commander"
  CreateShortCut "$SMPROGRAMS\Total Commander\Total Commander.lnk" "$INSTDIR\totalcmd.exe" "" "$INSTDIR\totalcmd.exe" 0
  CreateShortCut "$SMPROGRAMS\Total Commander\ .lnk" "$INSTDIR\plugman\plugman.exe" "" "$INSTDIR\plugman\plugman.exe" 0  
  CreateShortCut "$SMPROGRAMS\Total Commander\ Total Commander.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\uninst.exe" 0
  SetOutPath $APPDATA\Ghisler
  File "d:\tc\wincmd.ini"

  WriteRegStr HKLM "SOFTWARE\Ghisler\Total Commander" "IniFileName" "$APPDATA\Ghisler\wincmd.ini"
  WriteRegStr HKLM "SOFTWARE\Ghisler\Total Commander" "FtpIniName" "$APPDATA\Ghisler\ftp.ini"
  WriteRegStr HKLM "SOFTWARE\Ghisler\Total Commander" "InstallDir" "$INSTDIR"


SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "  $(^Name)   ."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "   ,    $(^Name)    ?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  UnRegDLL "$INSTDIR\plugins\Download\DPMenu.dll"
  RMDir /r "$INSTDIR"
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\Total Commander"
  DeleteRegKey HKLM "SOFTWARE\Ghisler\Total Commander"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd