
!define PRODUCT_NAME "Unlocker"
!define PRODUCT_VERSION "1.8.7"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define BRANDING "By Happy Bulldozer860"

; MUI 1.67 compatible ------
!include "MUI.nsh"

SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
; installer pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "Russian"
; MUI end ------



Name "${PRODUCT_NAME}"
Caption " ${PRODUCT_NAME} ${PRODUCT_VERSION}"
UninstallCaption " ${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
ShowInstDetails show
ShowUninstDetails show
BrandingText "${BRANDING}"

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  File /r "D:\unlocker\*.*"
  RegDLL "$INSTDIR\UnlockerCOM.dll"
  WriteUninstaller "$INSTDIR\uninst.exe"
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\  ${PRODUCT_NAME}.lnk" "$INSTDIR\UnlockerAssistant.exe"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ .lnk" "$INSTDIR\README.TXT"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ .lnk" "$INSTDIR\Unlocker.url"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ ${PRODUCT_NAME}.lnk" "$INSTDIR\uninst.exe"
  
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Unlocker.exe" "" "$INSTDIR\Unlocker.exe"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "Language" "1049"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "DisplayName" "${PRODUCT_NAME}"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\Unlocker.exe"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "http://ccollomb.free.fr/unlocker/"
  SetAutoClose true
SectionEnd

Section Uninstall
  UnRegDLL "$INSTDIR\UnlockerCOM.dll"
  RMDir /r "$INSTDIR"
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
  DeleteRegKey HKLM "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd