; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "WinDjView"
!define PRODUCT_VERSION "0.5"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install-colorful.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall-colorful.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "Russian"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "iWinDjV.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  File /r "D:\commons\WinDjView\*.*"
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$INSTDIR\WinDjView-0.5.exe" "" "$INSTDIR\WinDjView-0.5.exe" 0

  WriteRegStr HKCR ".djv" "" "DjVu.Document"
  WriteRegStr HKCR ".djv" "Content Type" "image/vnd.djvu"
  WriteRegStr HKCR ".djvu" "" "DjVu.Document"
  WriteRegStr HKCR ".djvu" "Content Type" "image/vnd.djvu"
  WriteRegStr HKCR "DjVu.Document" "" "Djv " 
  WriteRegStr HKCR "DjVu.Document\DefaultIcon" "" "$INSTDIR\WinDjView-0.5.exe"
  WriteRegStr HKCR "DjVu.Document\Shell\open\command" "" '"$INSTDIR\WinDjView-0.5.exe" "%1"'
  WriteRegDWORD HKCU "Software\Andrew Zhezherun\WinDjView\Settings" "language" 0x00000419
  WriteRegStr HKCU "Software\Andrew Zhezherun\WinDjView\Settings" "version" "0.5"
  WriteRegDWORD HKCU "Software\Andrew Zhezherun\WinDjView\Display" "child-maximized" 0x00000001
  WriteRegDWORD HKCU "Software\Andrew Zhezherun\WinDjView\Display" "maximized" 0x00000001
  WriteRegDWORD HKCU "Software\Andrew Zhezherun\WinDjView\Display" "zoom" 0xFFFFFFFF

SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ ${PRODUCT_NAME}.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\uninst.exe" 0
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "  $(^Name)   ."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "   ,    $(^Name)    ?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  RMDir /r "$INSTDIR"
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd