; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "WinRar"
!define PRODUCT_VERSION "3.71"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "FileFunc.nsh"

SetCompressor /SOLID lzma
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
; installer pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "Russian"
; MUI end ------

!insertmacro RefreshShellIcons


Name "${PRODUCT_NAME}"
Caption " ${PRODUCT_NAME} ${PRODUCT_VERSION} ( )"
UninstallCaption " ${PRODUCT_NAME} ${PRODUCT_VERSION} ( )"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\WinRar"
ShowInstDetails show
ShowUninstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  File   /r "D:\WinRar\"
  
  WriteRegStr HKCU  "Software\WinRAR\Paths" "AppData" "$INSTDIR"
  WriteRegStr HKCU  "Software\Winrar\Interface\Themes" "ActivePath" "$INSTDIR\Themes\WinRAR_Jr"
  WriteRegStr HKCU  "Software\Winrar\Interface\Themes" "ShellExtBMP" "$INSTDIR\Themes\WinRAR_Jr\RarSmall.bmp"  
  
  ExecWait "$INSTDIR\uninstall.exe /setup /s"
  
  ExecWait "regedit.exe /S $\"$INSTDIR\Winrar.reg$\""
  Delete "$INSTDIR\Winrar.reg"
  
  ; WriteRegStr HKLM  "SOFTWARE\Classes\.rar\ShellNew" "FileName" "$INSTDIR\rarnew.dat"
  ; WriteRegStr HKLM  "SOFTWARE\Classes\.zip\ShellNew" "FileName" "$INSTDIR\zipnew.dat"
  ; WriteRegStr HKLM  "SOFTWARE\Classes\CLSID\{B41DB860-8EE4-11D2-9906-E49FADC173CA}\InProcServer32" "" "$INSTDIR\rarext.dll"
  WriteRegStr HKLM  "SOFTWARE\Classes\WinRAR\DefaultIcon" "" "$INSTDIR\Themes\WinRAR_Jr\RAR.ico"
  ; WriteRegStr HKLM  "SOFTWARE\Classes\WinRAR\shell\open\command" "" "$\"$INSTDIR\WinRAR.exe$\" $\"%1$\""
  WriteRegStr HKLM  "SOFTWARE\Classes\WinRAR.REV\DefaultIcon" "" "$INSTDIR\Themes\WinRAR_Jr\REV.ico"
  ; WriteRegStr HKLM  "SOFTWARE\Classes\WinRAR.REV\shell\open\command" "" "$\"$INSTDIR\WinRAR.exe$\" $\"%1$\""
  WriteRegStr HKLM  "SOFTWARE\Classes\WinRAR.ZIP\DefaultIcon" "" "$INSTDIR\Themes\WinRAR_Jr\RAR.ico"
  ; WriteRegStr HKLM  "SOFTWARE\Classes\WinRAR.ZIP\shell\open\command" "" "$\"$INSTDIR\WinRAR.exe$\" $\"%1$\""
  
  

  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  
  WriteUninstaller "$INSTDIR\uninst.exe"
  
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$INSTDIR\WinRar.exe" "" "$INSTDIR\Themes\WinRAR_Jr\RAR.ico" 0
  SetShellVarContext all
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$INSTDIR\WinRar.exe" "" "$INSTDIR\Themes\WinRAR_Jr\RAR.ico" 0
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ ${PRODUCT_NAME}.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\uninst.exe" 0
  ${RefreshShellIcons}
  SetAutoClose true
SectionEnd

Section Uninstall
  ExecWait "$INSTDIR\Uninstall.exe /s"	
  RMDir /r "$INSTDIR"
  RMDir /r "$SMPROGRAMS\WinRar\"
  SetShellVarContext all
  RMDir /r "$SMPROGRAMS\WinRar\"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKCU "Software\WinRAR"
  DeleteRegKey HKCU "Software\WinRAR SFX"
  SetAutoClose true
SectionEnd