#cs
OPENBARCODES project
http://grandzebu.net/index.php?page=/informatique/codbar-en/codbar.htm
translation from original Pascal sources to AutoIt: Zedna
#ce

Func barcode_128 ($ps_data_in) ; barcode - code 128
	Local $I,$L,$V,$R,$M, $TableB, $la_data_out[1] ; array for possibility of writing to desired position - by the index

	if $ps_data_in = '' then return $ps_data_in

	$L = StringLen($ps_data_in)

	for $I=1 to $L
		Switch Asc(StringMid($ps_data_in,$I,1))
			case 32 To 126, 198
				; ok - do nothing
			case else
				return ''
		EndSwitch
	next

	; only get length of output code - just for ReDim
	; required min.: starting char, checksum, ending char #206
	$R = 3
	$TableB = True
	$I = 1

	While $I <= $L
	  If $TableB Then
	    If ($I = 1) Or ($I = ($L - 3)) Then
			$V = 4
	    Else
			$V = 6
		 endif

	    If barcode_128_TestNum($V,$I,$ps_data_in) Then
	      If $I > 1 Then $R+=1 ; 1 char to Switch to table C
	      $TableB = False
	    endif
	  endif

	  If Not $TableB Then
	    ; We are on table C, try to process 2 digits
	    If barcode_128_TestNum(2,$I,$ps_data_in) Then
			$I += 2 ;OK for 2 digits, process it
	    Else
			$TableB = True ; We haven't 2 digits, switch to table B
	 	 endif
	    $R+=1
	  endif

	  If $TableB Then
	    ; Process 1 digit with table B
	    $R+=1
	    $I+=1
	  endif
	WEnd

	ReDim $la_data_out[$R+2] ; Inicialization of length of output variable (allocation)

	$R = 1 ; Indice d'enregistrement du caractre en cours du rsultat
	$TableB = True
	$I = 1

	While $I <= $L
	  If $TableB Then
		If ($I = 1) Or ($I = ($L - 3)) Then
			$V = 4
		Else
			$V = 6
		endif

		If barcode_128_TestNum($V,$I,$ps_data_in) Then
		  If $I = 1 Then
				$la_data_out[1] = Chr(205) ; Starting with table C
		  Else
				$la_data_out[$R] = Chr(199) ; Switch to table C
			endif
		  $R+=1
		  $TableB = False
		Else
		  If $I = 1 Then
				$la_data_out[1] = Chr(204) ; Starting with table B
				$R+=1
			endif
		endif
	  endif

	  If Not $TableB Then
		; We are on table C, try to process 2 digits
		If barcode_128_TestNum(2,$I,$ps_data_in) Then ; OK for 2 digits, process it
		  $V = (Asc(StringMid($ps_data_in,$I,1)) - 48) * 10 + Asc(StringMid($ps_data_in,$I+1,1)) - 48
		  If $V < 95 Then
				$V += 32
			Else
				$V += 100
			endif
		  $la_data_out[$R] = Chr($V)
		  $I += 2
		Else ; We haven't 2 digits, switch to table B
		  $la_data_out[$R] = Chr(200)
		  $TableB = True
		endif
		$R+=1
	  endif

	  If $TableB Then
		; Process 1 digit with table B
		$la_data_out[$R] = StringMid($ps_data_in,$I,1)
		$R+=1
		$I+=1
	  endif
	WEnd

	; Calculation of the checksum
	For $I = 1 To $R - 1
	  $V = Asc($la_data_out[$I])

	  If $V > 126 Then
			$V -= 100
	  Else
			$V -= 32
	  EndIf

	  If $I = 1 Then $M = $V
	  $M = Mod(($M + ($I - 1) * $V), 103)
	Next

	; Calculation of the checksum ASCII code
	If $M < 95 Then
		$M += 32
	Else
		$M += 100
	EndIf

	; Add the checksum and the STOP
	$la_data_out[$R] = Chr($M)
	$la_data_out[$R + 1] = Chr(206)

	; copy composed array of chars into output string
	return __ArrayToString($la_data_out)
EndFunc

; helper function called from barcode_128()
; Return True if the N characters from I are numeric
Func barcode_128_testnum ($n, $i, $s)
	Local $J, $K

	$N -= 1
	If ($I + $N) > StringLen($S) Then return False

	$K = $I + $N
	For $J = $I To $K
		Switch StringMid($S,$J,1)
			case '0' To '9'
				; ok - do nothing
			case else
				return False
		EndSwitch
	Next

	return True
EndFunc

Func barcode_ean8 ($ps_data_in) ; barcode - code EAN 8
	Local $I,$J, $li_char, $li_checksum, $la_data_out[12] ; array for possibility of writing to desired position - by the index

	if $ps_data_in = '' then return $ps_data_in

	$J = StringLen($ps_data_in)
	if $J <> 7 then return ''

	; only chars '0' .. '9'
	for $I=1 to $J
		$li_char = Asc(StringMid($ps_data_in,$I,1))
		if ($li_char < 48) or ($li_char > 57) then return ''
	next

	; calculate checksum
	for $I=1 to 7 step 2 ; odd
		$li_char = Asc(StringMid($ps_data_in,$I,1))
		$li_checksum += $li_char - 48
	next
	$li_checksum = $li_checksum * 3

	for $I=2 to 6 step 2 ; even
		$li_char = Asc(StringMid($ps_data_in,$I,1))
		$li_checksum += $li_char - 48
	next
	$li_checksum = Mod(10 - Mod($li_checksum,10),10)

	; first 4 chars from table A
	for $I=1 to 4
		$la_data_out[$I+1] = Chr(Asc(StringMid($ps_data_in,$I,1)) + 17) ; 48 + 17 = 65
	next

	for $I=5 to 7
		$la_data_out[$I+2] = Chr(Asc(StringMid($ps_data_in,$I,1)) + 49) ; 48 + 49 = 97
	next

	$la_data_out[1] = ':'
	$la_data_out[6] = '*'
	$la_data_out[10] = Chr($li_checksum + 97)
	$la_data_out[11] = '+'

	; copy composed array of chars into output string
	return __ArrayToString($la_data_out)
EndFunc

Func barcode_ean13 ($ps_data_in) ; barcode - code EAN 13
	Local $I,$J, $li_char, $li_checksum, $TableA, $la_data_out[16] ; array for possibility of writing to desired position - by the index

	if $ps_data_in = '' then return $ps_data_in

	$J = StringLen($ps_data_in)
	if $J <> 12 then return ''

	; only chars '0' .. '9'
	for $I=1 to $J
		$li_char = Asc(StringMid($ps_data_in,$I,1))
		if ($li_char < 48) or ($li_char > 57) then return ''
	next

	; calculate checksum
	for $I=2 to 12 step 2 ; even
		$li_char = Asc(StringMid($ps_data_in,$I,1))
		$li_checksum += $li_char - 48
	next
	$li_checksum = $li_checksum * 3

	for $I=1 to 11 step 2 ; odd
		$li_char = Asc(StringMid($ps_data_in,$I,1))
		$li_checksum += $li_char - 48
	next
	$li_checksum = Mod(10 - Mod($li_checksum,10),10)

	$li_char = Asc(StringLeft($ps_data_in,1)) - 48 ; first char
	for $I=3 to 7
		$TableA = False

		Switch $I
			case 3
				Switch $li_char
					case 0 To 3
						$TableA = True
				EndSwitch
			case 4
				Switch $li_char
					case 0, 4, 7, 8
						$TableA = True
				EndSwitch
			case 5
				Switch $li_char
					case 0, 1, 4, 5, 9
						$TableA = True
				EndSwitch
			case 6
				Switch $li_char
					case 0, 2, 5, 6, 7
						$TableA = True
				EndSwitch
			case 7
				Switch $li_char
					case 0, 3, 6, 8, 9
						$TableA = True
				EndSwitch
		EndSwitch

		If $TableA Then
			$la_data_out[$I] = Chr(Asc(StringMid($ps_data_in,$I,1)) + 17) ; 48 + 17 = 65
		Else
			$la_data_out[$I] = Chr(Asc(StringMid($ps_data_in,$I,1)) + 27) ; 48 + 27 = 75
		EndIf
	next

	for $I=9 to 13
		$la_data_out[$I] = Chr(Asc(StringMid($ps_data_in,$I - 1,1)) + 49) ; 48 + 49 = 97
	next

	; first char is taken as is, second from table A
	$la_data_out[1] = StringLeft($ps_data_in,1)
	$la_data_out[2] = Chr(Asc(StringMid($ps_data_in,2,1)) + 17) ; - 48 + 65
	$la_data_out[8] = '*'
	$la_data_out[14] = Chr($li_checksum + 97)
	$la_data_out[15] = '+'

	; copy composed array of chars into output string
	return __ArrayToString($la_data_out)
EndFunc

Func barcode_25i ($ps_data_in, $pi_checksum = 1) ; barcode - code 2 of 5 interleaved
	Local $I,$J, $li_char, $li_checksum, $ls_data_out

	if $ps_data_in = '' then return $ps_data_in

	$J = StringLen($ps_data_in)

	; only chars '0' .. '9'
	for $I=1 to $J
		$li_char = Asc(StringMid($ps_data_in,$I,1))
		if ($li_char < 48) or ($li_char > 57) then return ''
	next

	; event. calculate checksum
	$I = 0
	if $pi_checksum = 1 then
		for $I=$J to 1 step -2
			$li_checksum += Asc(StringMid($ps_data_in,$I,1)) - 48
		next
		$li_checksum = $li_checksum * 3

		for $I=$J - 1 to 1 step -2
			$li_checksum += Asc(StringMid($ps_data_in,$I,1)) - 48
		next

		$li_checksum = Mod(10 - Mod($li_checksum,10),10)
		$I = 1
	endif

	; check if length (included event. checksum) is odd
	if Mod($J + $I,2) <> 0 then return ''

	for $I=1 to $J - 1 step 2
		$li_char = (Asc(StringMid($ps_data_in,$I,1)) - 48) * 10 + Asc(StringMid($ps_data_in,$I + 1,1)) - 48
		if $li_char < 94 then
			$li_char += 33
		else
			$li_char += 101
		endif
		$ls_data_out &= Chr($li_char)
	next

	; event. add checksum (to last char)
	if $pi_checksum = 1 then
		$li_char = (Asc(StringMid($ps_data_in,$J,1)) - 48) * 10 + $li_checksum
		if $li_char < 94 then
			$li_char += 33
		else
			$li_char += 101
		endif
		$ls_data_out &= Chr($li_char)
	endif

	return Chr(201) & $ls_data_out & Chr(202)
EndFunc

Func barcode_39 ($ps_data_in, $pi_checksum = 1) ; barcode - code 3 of 9
	Local $I,$J,$M,$C,$P, $li_char, $ls_data_out
	Local $table[128] = _
	 ['%U', '$A', '$B', '$C', '$D', '$E', '$F', '$G', '$H', '$I', _
	  '$J', '$K', '$L', '$M', '$N', '$O', '$P', '$Q', '$R', '$S', _
	  '$T', '$U', '$V', '$W', '$X', '$Y', '$Z', '%A', '%B', '%C', _
	  '%D', '%E', '  ', '/A', '/B', '/C', '/D', '/E', '/F', '/G', _
	  '/H', '/I', '/J', '/K', '/L', ' -', ' .', '/O', ' 0', ' 1', _
	  ' 2', ' 3', ' 4', ' 5', ' 6', ' 7', ' 8', ' 9', '/Z', '%F', _
	  '%G', '%H', '%I', '%J', '%V', ' A', ' B', ' C', ' D', ' E', _
	  ' F', ' G', ' H', ' I', ' J', ' K', ' L', ' M', ' N', ' O', _
	  ' P', ' Q', ' R', ' S', ' T', ' U', ' V', ' W', ' X', ' Y', _
	  ' Z', '%K', '%L', '%M', '%N', '%O', '%W', '+A', '+B', '+C', _
	  '+D', '+E', '+F', '+G', '+H', '+I', '+J', '+K', '+L', '+M', _
	  '+N', '+O', '+P', '+Q', '+R', '+S', '+T', '+U', '+V', '+W', _
	  '+X', '+Y', '+Z', '%P', '%Q', '%R', '%S', '%T']

	if $ps_data_in = '' then return $ps_data_in

	$J = StringLen($ps_data_in)

	for $I=1 to $J
		if Asc(StringMid($ps_data_in,$I,1)) > 127 then return ''
	next

	for $I=1 to $J
		$C = StringMid($ps_data_in,$I,1)
		$li_char = Asc($C)
		$P = StringLeft($table[$li_char],1)

		if $P <> ' ' then
			$ls_data_out &= $P
			$C = StringMid($table[$li_char],2,1)
		endif

		$ls_data_out &= $C
	next

	if $pi_checksum = 1 then
		$M = 0
		$J = StringLen($ls_data_out)

		for $I=1 to $J
			$C = StringMid($ls_data_out,$I,1)

			Switch $C
				case '0' To '9'
					$M += Asc($C) - 48
				case 'A' To 'Z'
					$M += Asc($C) - 55
				case '-'
					$M += 36
				case '.'
					$M += 37
				case ' '
					$M += 38
				case '$'
					$M += 39
				case '/'
					$M += 40
				case '+'
					$M += 41
				case '%'
					$M += 42
			EndSwitch
		next

		$M = Mod($M, 43)

		Switch $M
			case 0 To 9
				$C = Chr($M + 48)
			case 10 To 35
				$C = Chr($M + 55)
			case 36
				$C = '-'
			case 37
				$C = '.'
			case 38
				$C = ' '
			case 39
				$C = '$'
			case 40
				$C = '/'
			case 41
				$C = '+'
			case 42
				$C = '%'
		EndSwitch

		$ls_data_out &= $C
	endif

	return '*' & $ls_data_out & '*'

	; original method: with limited set of chars

	; check if all chars are in allowed range
	; if some char isn't in tolerance then function returns empty string
;~ 	$J = StringLen($ps_data_in)
;~ 	for $I=1 to $J
;~ 		Switch Asc(StringMid($ps_data_in,$I,1))
;~ 			case 32, 36, 37, 43, 45 To 57, 65 To 90
;~ 				; ok - do nothing
;~ 			case else
;~ 				return ''
;~ 		EndSwitch
;~ 	next

;~ 	$ls_data_out = $ps_data_in

;~ 	if $pi_checksum = 1 then $ls_data_out &= $C

;~ 	return '*' & $ls_data_out & '*'
EndFunc

; optimized _ArrayToString()
Func __ArrayToString(Const ByRef $avArray)
	Local $sResult

	For $i = 1 To UBound($avArray) - 1
		$sResult &= $avArray[$i]
	Next

	Return $sResult
EndFunc
