[Setup]
AppName=test
AppVerName=test
CreateAppDir=no
DefaultDirName={tmp}
Uninstallable=no
CreateUninstallRegKey=no
ShowLanguageDialog=no

[Languages]
Name: ru; MessagesFile: compiler:Languages\Russian.isl
Name: en; MessagesFile: compiler:Default.isl

[Code]
type
  TProcessInformation = record
    hProcess: THandle;
    hThread: THandle;
    dwProcessId: DWORD;
    dwThreadId: DWORD;
  end;

  TStartupInfo = record
    cb: DWORD;
    lpReserved: string;
    lpDesktop: string;
    lpTitle: string;
    dwX: DWORD;
    dwY: DWORD;
    dwXSize: DWORD;
    dwYSize: DWORD;
    dwXCountChars: DWORD;
    dwYCountChars: DWORD;
    dwFillAttribute: DWORD;
    dwFlags: DWORD;
    wShowWindow: Word;
    cbReserved2: Word;
    lpReserved2: LongWord;
    hStdInput: THandle;
    hStdOutput: THandle;
    hStdError: THandle;
  end;

  TIconInfo = record
    fIcon: BOOL;
    xHotspot: DWORD;
    yHotspot: DWORD;
    hbmMask: HBITMAP;
    hbmColor: HBITMAP;
  end;


const
  NORMAL_PRIORITY_CLASS = $0020;

  CREATE_NEW_CONSOLE        = $0010;
  CREATE_NEW_PROCESS_GROUP  = $0200;

  STARTF_USESHOWWINDOW = 1;

  IMAGE_ICON = 1;
  LR_DEFAULTCOLOR = 0;
  DI_NORMAL = $3;

  LOCALE_USER_DEFAULT         = $0400;
  LOCALE_SISO639LANGNAME      = $0059;
  LOCALE_SNATIVEDISPLAYNAME   = $0073;
  LOCALE_SNATIVELANGUAGENAME  = $0004;
  LOCALE_SNATIVECOUNTRYNAME   = $0008;

// Process and Thread Functions
function CreateProcess(const lpApplicationName: string; lpCommandLine: string;
  lpProcessAttributes, lpThreadAttributes: LongWord;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: LongWord;
  lpCurrentDirectory: string; var lpStartupInfo: TStartupInfo;
  var lpProcessInformation: TProcessInformation): BOOL; external 'CreateProcessW@kernel32.dll stdcall';
// Dynamic-Link Library Functions
function GetModuleHandle(lpModuleName: string): THandle; external 'GetModuleHandleW@kernel32.dll stdcall';
// Resource Functions
function LoadImage(hInst: THandle; lpszName: string; uType: UINT; cxDesired, cyDesired: Integer; fuLoad: UINT): THandle; external 'LoadImageW@user32.dll stdcall';
// Icon Functions
function DrawIconEx(hdc: THandle; xLeft, yTop: Integer; hIcon: THandle; cxWidth, cyWidth: Integer;
  istepIfAniCur: UINT; hbrFlickerFreeDraw: THandle; diFlags: UINT): BOOL; external 'DrawIconEx@user32.dll stdcall';
// Device Context Functions
function DeleteObject(hObject: THandle): BOOL; external 'DeleteObject@gdi32.dll stdcall';
// National Language Support Functions
function GetLocaleInfo(Locale, LCType: DWORD; lpLCData: string; cchData: Integer): Integer; external 'GetLocaleInfoW@kernel32.dll stdcall';
function Rfc1766ToLcid(var pLocale: DWORD; pszRfc1766: string): HResult; external 'Rfc1766ToLcidW@mlang.dll stdcall';

function InternalLocaleInfo(ALCID, ALCType: DWORD): string;
begin
  SetLength(Result, GetLocaleInfo(ALCID, ALCType, Result, 0));
  GetLocaleInfo(ALCID, ALCType, Result, Length(Result));
  Result := Trim(Result);
end;

function LocaleToLCID(const ALocale: string): DWORD;
begin
  OleCheck(Rfc1766ToLcid(Result, ALocale));
end;

function LCIDToLocale(const ALCID: DWORD): string;
begin
  Result := InternalLocaleInfo(ALCID, LOCALE_SISO639LANGNAME);
end;

function LocaleToLangName(const ALocale: string): string;
var
  LCID: DWORD;
begin
  LCID := LocaleToLCID(ALocale);
  if GetWindowsVersion() > $06010000 then
    Result := InternalLocaleInfo(LCID, LOCALE_SNATIVEDISPLAYNAME) else
    Result := Format('%s (%s)', [
      InternalLocaleInfo(LCID, LOCALE_SNATIVELANGUAGENAME),
      InternalLocaleInfo(LCID, LOCALE_SNATIVECOUNTRYNAME)]);
end;

// Window Functions
function SetForegroundWindow(hWnd: HWND): BOOL; external 'SetForegroundWindow@user32.dll stdcall';
function AllowSetForegroundWindow(dwProcessId: DWORD): BOOL; external 'AllowSetForegroundWindow@user32.dll stdcall';

procedure CreateCustomLanguageDialog();
var
  LSelectLanguageForm: TForm;
  LBevel: TBevel;
  LOKButton, LCancelButton: TNewButton;
  LMainPanel: TPanel;
  LIconBitmapImage: TBitmapImage;
  LMainIconHandle: THandle;
  LangCombo: TNewComboBox;
  LSelectLabel: TNewStaticText;
  Locale, LCommandLine: string;
  LStartupInfo: TStartupInfo;
  LProcessInformation: TProcessInformation;
begin
  LSelectLanguageForm := TForm.Create(nil);
  with LSelectLanguageForm do
  begin
    BorderIcons := [biSystemMenu];
    BorderStyle := bsDialog;
    Caption := SetupMessage(msgSelectLanguageTitle);
    ClientHeight := ScaleX(140);
    ClientWidth := ScaleY(297);
    Position := poMainFormCenter;
  end;

  LBevel := TBevel.Create(LSelectLanguageForm);
  with LBevel do
  begin
    Parent := LSelectLanguageForm;
    Align := alBottom;
    Height := LSelectLanguageForm.ClientHeight - ScaleY(97);
  #if Ver >> 0x10 >= 0x0600
    Anchors := [akLeft, akRight, akBottom];
  #endif
    Shape := bsTopLine;
  end;

  LCancelButton := TNewButton.Create(LSelectLanguageForm);
  with LCancelButton do
  begin
    Parent := LSelectLanguageForm;
    Width := ScaleX(75);
    Height := ScaleY(23);
    Left := LSelectLanguageForm.ClientWidth - Width - ScaleX(8);
    Top := LBevel.Top + (LSelectLanguageForm.ClientHeight - LBevel.Top - Height) div 2;
  #if Ver >> 0x10 >= 0x0600
    Anchors := [akRight, akBottom];
  #endif
    Cancel := True;
    Caption := Setupmessage(msgButtonCancel);
    ModalResult := mrCancel;
    TabOrder := 2;
  end;

  LOKButton := TNewButton.Create(LSelectLanguageForm);
  with LOKButton do
  begin
    Parent := LSelectLanguageForm;
    Width := ScaleX(75);
    Height := ScaleY(23);
    Left := LCancelButton.Left - Width - ScaleX(8);
    Top := LCancelButton.Top;
  #if Ver >> 0x10 >= 0x0600
    Anchors := [akRight, akBottom];
  #endif
    Caption := SetupMessage(msgButtonOK);
    Default := True;
    ModalResult := mrOk;
    TabOrder := 1;
  end;

  LMainPanel := TPanel.Create(LSelectLanguageForm);
  with LMainPanel do
  begin
    Parent := LSelectLanguageForm;
    Align := alClient;
    BevelOuter := bvNone;
    ParentBackground := False;
    Color := clWindow;
    TabOrder := 0;
  end;

  LIconBitmapImage := TBitmapImage.Create(LMainPanel);
  with LIconBitmapImage do
  begin
    Parent := LMainPanel;
    SetBounds(ScaleX(8), ScaleY(8), ScaleX(32), ScaleY(32));
    Bitmap.Width := Width;
    Bitmap.Height := Height;
    LMainIconHandle := LoadImage(GetModuleHandle(''), 'MAINICON', IMAGE_ICON, Width, Height, LR_DEFAULTCOLOR);
    DrawIconEx(Bitmap.Canvas.Handle, 0, 0, LMainIconHandle, Width, Height, 0, 0, DI_NORMAL);
    DeleteObject(LMainIconHandle);
  end;

  LangCombo := TNewComboBox.Create(LMainPanel);
  with LangCombo do
  begin
    Parent := LMainPanel;
    Height := ScaleY(21);
    Left := LIconBitmapImage.Left + LIconBitmapImage.Width + ScaleX(16);
    Top := LMainPanel.ClientHeight - Height - ScaleY(16);
    Width := LMainPanel.ClientWidth - Left - ScaleX(8);
    Style := csDropDownList;
  #if Ver >> 0x10 >= 0x0600
    Anchors := [akLeft, akTop, akRight];
  #endif
    DropDownCount := 16;
    Sorted := True;
    TabOrder := 1;

    { Add items. }
    ItemIndex := Items.Add(LocaleToLangName('en'));
    if ItemIndex > -1 then
      Items.Objects[ItemIndex] := TObject(Integer(LocaleToLCID('en')));
    ItemIndex := Items.Add(LocaleToLangName('ru'));
    if ItemIndex > -1 then
      Items.Objects[ItemIndex] := TObject(Integer(LocaleToLCID('ru')));

    { Set UI language. }
    ItemIndex := Items.IndexOf(LocaleToLangName(ExpandConstant('{language}')));
    if (ItemIndex = -1) and (Items.Count > 0) then
      ItemIndex := 0;
  end;

  LSelectLabel := TNewStaticText.Create(LMainPanel);
  with LSelectLabel do
  begin
    Parent := LMainPanel;
    Left := LangCombo.Left;
    Top := LIconBitmapImage.Top;
    Width := LangCombo.Width;
    Height := LangCombo.Top - Top - ScaleY(8);
  #if Ver >> 0x10 >= 0x0600
    Anchors := [akLeft, akTop, akRight];
  #endif
    AutoSize := False;
    Caption := SetupMessage(msgSelectLanguageLabel);
    TabOrder := 0;
    WordWrap := True;
  end;

  { Restart installer. }
  if (LSelectLanguageForm.ShowModal() = mrOk) and
    (LangCombo.ItemIndex > -1) then
  try
    Locale := LCIDToLocale(DWORD(Integer(LangCombo.Items.Objects[LangCombo.ItemIndex])));
    LStartupInfo.cb := SizeOf(LStartupInfo);
    LStartupInfo.dwFlags := STARTF_USESHOWWINDOW;
    LStartupInfo.wShowWindow := SW_SHOWMAXIMIZED;
    LCommandLine := Format('"%s" /LANG=%s', [ExpandConstant('{srcexe}'), Locale]);
    if not CreateProcess(ExpandConstant('{srcexe}'), LCommandLine, 0, 0, False,
      NORMAL_PRIORITY_CLASS or CREATE_NEW_CONSOLE or CREATE_NEW_PROCESS_GROUP,
      0, ExtractFileDir(ExpandConstant('{srcexe}')), LStartupInfo, LProcessInformation) then
        RaiseException(SysErrorMessage(DLLGetLastError));
    AllowSetForegroundWindow(LProcessInformation.dwProcessId);
  except
    ShowExceptionMessage();
  finally
    LSelectLanguageForm.Free();
  end;
end;

function InitializeSetup(): Boolean;
begin
  Result := ExpandConstant('{param:LANG|}') <> '';
  if not Result then
    CreateCustomLanguageDialog();
end;

procedure InitializeWizard();
begin
  SetForegroundWindow(WizardForm.Handle);
end;