//Part of AssTools (c)2007-2008 Sergey V. Bulba <vorobey@mail.khstu.ru>

unit AssViewU;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Grids, AssLib, Windows;

type

  { TForm1 }

  TForm1 = class(TForm)
   Button1: TButton;
   Button2: TButton;
   Button3: TButton;
   Button4: TButton;
   CheckGroup1: TCheckGroup;
   Edit1: TEdit;
   Label1: TLabel;
   Label2: TLabel;
   PageControl1: TPageControl;
   SaveDialog1: TSaveDialog;
   StringGrid1: TStringGrid;
   StringGrid2: TStringGrid;
   TabSheet1: TTabSheet;
   TabSheet2: TTabSheet;
   procedure Button1Click(Sender: TObject);
   function CallSaveDialog(const Tp:string):boolean;
   procedure Button2Click(Sender: TObject);
   procedure Button3Click(Sender: TObject);
   procedure Button4Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 
  FTypes:TAssFTypes;
  Ass:TAssAsses;
  ftn,asn:integer;

implementation

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var
 kn,i:integer;
 lkname:longword;
 Keys:TAssArrayOfString;
begin
if RegQueryInfoKey(HKEY_CLASSES_ROOT,nil,nil,nil,@kn,@lkname,nil,nil,nil,nil,nil,nil) <> ERROR_SUCCESS then exit;

Button2.Enabled := False;
Button3.Enabled := False;
Button4.Enabled := False;

StringGrid1.RowCount:=1; StringGrid2.RowCount:=1;

GetKeys(Keys,kn,lkname);

ftn := GetFTypes(WideUpperCase(Utf8Decode(Edit1.Text)),FTypes,Keys); if ftn = 0 then exit;
StringGrid1.RowCount := ftn + 1;
for i := 0 to ftn - 1 do
 begin
  StringGrid1.Cells[0,1+i] := IntToStr(i+1);
  StringGrid1.Cells[1,1+i] := AnsiToUtf8(FTypes[i].Name);
  StringGrid1.Cells[2,1+i] := AnsiToUtf8(FTypes[i].Descr);
  StringGrid1.Cells[3,1+i] := AnsiToUtf8(FTypes[i].CommandOpen);
  StringGrid1.Cells[4,1+i] := AnsiToUtf8(FTypes[i].CommandView);
  StringGrid1.Cells[5,1+i] := AnsiToUtf8(FTypes[i].Icon);
 end;
StringGrid1.AutoSizeColumns;

asn := GetAsses(Ass,FTypes,ftn,Keys);
StringGrid2.RowCount := asn + 1;
for i := 0 to asn - 1 do
 begin
  StringGrid2.Cells[0,1+i] := IntToStr(i+1);
  StringGrid2.Cells[1,1+i] := AnsiToUtf8(Ass[i].Name);
  StringGrid2.Cells[2,1+i] := AnsiToUtf8(FTypes[Ass[i].Tp].Name);
 end;

Button2.Enabled := True;
Button3.Enabled := True;
Button4.Enabled := True;
end;

function TForm1.CallSaveDialog(const Tp:string):boolean;
begin
SaveDialog1.DefaultExt := Tp;
SaveDialog1.Filter := Tp + '-файл|*.' + Tp;
Result := SaveDialog1.Execute;
if Result then SaveDialog1.InitialDir := ExtractFilePath(SaveDialog1.FileName);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if CallSaveDialog('CMD') then
 SaveCMD(Utf8ToAnsi(SaveDialog1.FileName),Ass,asn,FTypes,ftn,CheckGroup1.Checked[0],CheckGroup1.Checked[1],CheckGroup1.Checked[2]);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
if CallSaveDialog('REG') then
 SaveREG(Utf8ToAnsi(SaveDialog1.FileName),Ass,asn,FTypes,ftn);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
if CallSaveDialog('INF') then
 SaveINF(Utf8ToAnsi(SaveDialog1.FileName),Ass,asn,FTypes,ftn,CheckGroup1.Checked[1],CheckGroup1.Checked[2]);
end;

initialization
  {$I AssViewU.lrs}

end.

