[Setup]
AppName=Adobe Photoshop CS4 Extended
AppVerName=Adobe Photoshop CS4 Extended 11.0
DefaultDirName={pf}\Adobe\Adobe Photoshop CS4
DefaultGroupName=Adobe Photoshop CS4
DisableProgramGroupPage=true
OutputDir=.\
OutputBaseFilename=Setup
SetupIconFile=.\embedded\Icon.ico
Compression=lzma/ultra
SolidCompression=true
InternalCompressLevel=ultra
AllowRootDirectory=true
UsePreviousAppDir=false
AppendDefaultDirName=false
UsePreviousGroup=false
WizardImageFile=.\embedded\WizardImage.bmp
WizardSmallImageFile=.\embedded\WizardSmallImage.bmp
AppCopyright=Adobe Systems, Copyright 2005-2008.  All rights reserved.
VersionInfoCompany=Adobe Systems, Copyright 2005-2008
VersionInfoDescription=Adobe Setup
VersionInfoVersion=2.0.133.0
VersionInfoCopyright=Adobe Systems, Copyright 2005-2008.  All rights reserved.
VersionInfoTextVersion=2,0,133,0
ChangesAssociations=true
AlwaysRestart=false
UninstallRestartComputer=false
RestartIfNeededByRun=false
CreateUninstallRegKey=false

[Languages]
Name: russian; MessagesFile: compiler:Default.isl
Name: english; MessagesFile: compiler:Languages\English.isl

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}

[Files]
Source: .\Files\ProgramFiles\Adobe\Adobe Photoshop CS4\*; DestDir: {app}; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Adobe Anchor Service CS4.m.070\*; DestDir: {cf}\Adobe Anchor Service CS4.m.070\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Adobe PCD\*; DestDir: {cf}\Adobe\Adobe PCD\; Flags: ignoreversion recursesubdirs createallsubdirs; Attribs: readonly
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Adobe Version Cue CS4\*; DestDir: {cf}\Adobe\Adobe Version Cue CS4\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Camera Raw 5\*; DestDir: {cf}\Adobe\Camera Raw 5\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Color\*; DestDir: {cf}\Adobe\Color\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\DefaultLanguage\*; DestDir: {cf}\Adobe\DefaultLanguage\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Help\en_GB\*; DestDir: {cf}\Adobe\Help\en_GB\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Plug-Ins\*; DestDir: {cf}\Adobe\Plug-Ins\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Scripting Dictionaries CS4\*; DestDir: {cf}\Adobe\Scripting Dictionaries CS4\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\Startup Scripts CS4\*; DestDir: {cf}\Adobe\Startup Scripts CS4\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\TypeSupport\*; DestDir: {cf}\Adobe\TypeSupport\; Flags: ignoreversion recursesubdirs createallsubdirs
Source: .\Files\ProgramFiles\CommonFiles\Adobe\XMP\*; DestDir: {cf}\Adobe\XMP\; Flags: ignoreversion recursesubdirs createallsubdirs

[Dirs]
Name: {cf}\Adobe\Help\ru_RU\Photoshop\11.0; Flags: uninsalwaysuninstall

[Icons]
Name: {commonprograms}\Adobe Photoshop CS4; Filename: {app}\Photoshop.exe; WorkingDir: {app}; IconFilename: {app}\Photoshop.exe; IconIndex: 0
Name: {commondesktop}\Adobe Photoshop CS4; Filename: {app}\Photoshop.exe; WorkingDir: {app}; IconFilename: {app}\Photoshop.exe; Tasks: desktopicon; IconIndex: 0
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\Adobe Photoshop CS4; Filename: {app}\Photoshop.exe; WorkingDir: {app}; IconFilename: {app}\Photoshop.exe; Tasks: quicklaunchicon; IconIndex: 0

[Run]
Filename: {app}\Photoshop.exe; Description: {cm:LaunchProgram,Adobe Photoshop CS4}; Flags: nowait postinstall skipifsilent; WorkingDir: {app}

[Registry]
Root: HKLM; SubKey: SOFTWARE\Adobe\Photoshop\11.0; ValueType: dword; ValueName: FreeBeforeSlopAdjust; ValueData: $001d122c; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Adobe\Photoshop\11.0; ValueType: dword; ValueName: FreeSpace; ValueData: $000fb531; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Adobe\Photoshop\11.0; ValueType: string; ValueName: ApplicationPath; ValueData: {app}\; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Adobe\Photoshop\11.0; ValueType: string; ValueName: PluginPath; ValueData: {app}\Plug-Ins\; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Adobe\Photoshop\11.0\ApplicationPath; ValueType: string; ValueName: ; ValueData: {app}\; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Adobe\Photoshop\11.0\PluginPath; ValueType: string; ValueName: ; ValueData: {app}\Plug-Ins\; Flags: uninsdeletevalue
Root: HKCU; SubKey: Software\Adobe\Photoshop\11.0; ValueType: dword; ValueName: oldPaletteFontTypeKey CS4; ValueData: $00000000; Flags: uninsdeletevalue
Root: HKCU; SubKey: Software\Adobe\Photoshop\11.0; ValueType: string; ValueName: SettingsFilePath; ValueData: {userappdata}\Adobe\Adobe Photoshop CS4\Adobe Photoshop CS4 Settings\; Flags: uninsdeletevalue
Root: HKCU; SubKey: Software\Adobe\Photoshop\11.0\VisitedDirs; ValueType: string; ValueName: STARTUPIMAGEDIRECTORY; ValueData: {userdocs}\; Flags: uninsdeletevalue

Root: HKLM; SubKey: SOFTWARE\Adobe\DefaultLanguage; ValueType: string; ValueName: AdobeProductLanguage; ValueData: ru_RU; Flags: uninsdeletekeyifempty uninsdeletevalue; Languages: russian
Root: HKCU; SubKey: Software\Adobe\Photoshop\11.0; ValueType: string; ValueName: uiLanguageKey CS4; ValueData: ru_RU; Flags: uninsdeletekeyifempty uninsdeletevalue; Languages: russian

Root: HKLM; SubKey: SOFTWARE\Adobe\DefaultLanguage; ValueType: string; ValueName: AdobeProductLanguage; ValueData: en_GB; Flags: uninsdeletekeyifempty uninsdeletevalue; Languages: english
Root: HKCU; SubKey: Software\Adobe\Photoshop\11.0; ValueType: string; ValueName: uiLanguageKey CS4; ValueData: en_GB; Flags: uninsdeletekeyifempty uninsdeletevalue; Languages: english

Root: HKCR; SubKey: Photoshop.PlugIn\DefaultIcon; ValueType: string; ValueData: {app}\Photoshop.exe,2; Flags: uninsdeletekey
Root: HKCR; SubKey: Photoshop.PlugIn\shell\open\command; ValueType: string; ValueData: {app}\Photoshop.exe; Flags: uninsdeletekey
Root: HKCR; SubKey: .8ba; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8bc; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8be; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8bf; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8bi; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8bp; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8bs; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8bx; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8by; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey
Root: HKCR; SubKey: .8li; ValueType: string; ValueData: Photoshop.PlugIn; Flags: uninsdeletekey

Root: HKCR; SubKey: Photoshop.Image.11; ValueType: string; ValueName: ; ValueData: Adobe Photoshop Image 11; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\CLSID; ValueType: string; ValueName: ; ValueData: {{6A104E4C-74AB-4C4F-BC77-10FC0FD1B172}; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\DefaultIcon; ValueType: string; ValueName: ; ValueData: {app}\Photoshop.exe,1; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\Insertable; ValueType: string; ValueName: ; ValueData: ; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\protocol\StdFileEditing\server; ValueType: string; ValueName: ; ValueData: D:\Program Files\Adobe\Adobe Photoshop CS4\Photoshop.exe; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\shell\edit\command; ValueType: string; ValueName: ; ValueData: """{app}\Photoshop.exe\"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\shell\open\command; ValueType: string; ValueName: ; ValueData: """{app}\Photoshop.exe\"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\shell\preview\command; ValueType: string; ValueName: ; ValueData: """{app}\Photoshop.exe\"" ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: Photoshop.Image.11\shell\print\command; ValueType: string; ValueName: ; ValueData: """{app}\Photoshop.exe\"" -p ""%1"""; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKCR; SubKey: .psd; ValueType: string; ValueName: ; ValueData: Photoshop.Image.11; Flags: uninsdeletevalue uninsdeletekeyifempty

Root: HKCU; SubKey: Software\Microsoft\Windows\CurrentVersion\Explorer\Discardable\PostSetup\ShellNew; ValueType: binary; ValueName: Adobe Photoshop Image 11; ValueData: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 00 64 00 6f 00 62 00 65 00 20 00 50 00 68 00 6f 00 74 00 6f 00 73 00 68 00 6f 00 70 00 20 00 49 00 6d 00 61 00 67 00 65 00 20 00 31 00 31 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 2e 00 70 00 73 00 64 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 50 00 68 00 6f 00 74 00 6f 00 73 00 68 00 6f 00 70 00 2e 00 49 00 6d 00 61 00 67 00 65 00 2e 00 31 00 31 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ff ff ff ff 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00; Flags: uninsdeletevalue

Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: DisplayName; ValueData: Adobe Photoshop CS4; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: DisplayVersion; ValueData: 11.0; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: Publisher; ValueData: Adobe Systems Incorporated; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: HelpLink; ValueData: http://www.adobe.com/go/ps_support; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: HelpTelephone; ValueData: http://www.adobe.com/go/ps_support; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: URLInfoAbout; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: URLUpdateInfo; ValueData: http://www.adobe.com/downloads/updates; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: Comments; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: DisplayIcon; ValueData: {uninstallexe},0; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: string; ValueName: UninstallString; ValueData: {uninstallexe}; Flags: uninsdeletevalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe_faf656ef605427ee2f42989c3ad31b8; ValueType: dword; ValueName: EstimatedSize; ValueData: $00137093; Flags: uninsdeletevalue

[UninstallDelete]
Name: {app}\*; Type: filesandordirs
Name: {cf}\Adobe\Adobe Anchor Service CS4.m.070; Type: filesandordirs
Name: {cf}\Adobe\Adobe PCD; Type: filesandordirs
Name: {cf}\Adobe\Adobe Photoshop CS4; Type: filesandordirs
Name: {cf}\Adobe\Adobe Version Cue CS4; Type: filesandordirs
Name: {cf}\Adobe\Camera Raw 5; Type: filesandordirs
Name: {cf}\Adobe\Color; Type: filesandordirs
Name: {cf}\Adobe\DefaultLanguage; Type: filesandordirs
Name: {cf}\Adobe\Plug-Ins; Type: filesandordirs
Name: {cf}\Adobe\Scripting Dictionaries CS4; Type: filesandordirs
Name: {cf}\Adobe\Startup Scripts CS4; Type: filesandordirs
Name: {cf}\Adobe\TypeSupport; Type: filesandordirs
Name: {cf}\Adobe\XMP; Type: filesandordirs
Name: {cf}\Adobe\backup\*; Type: filesandordirs
Name: {cf}\Adobe\caps\*; Type: filesandordirs
Name: {cf}\Adobe; Type: dirifempty
Name: {pf}\Adobe; Type: dirifempty
Name: {localappdata}\Adobe\Adobe PDF; Type: filesandordirs
Name: {localappdata}\Adobe\ISO-19770; Type: filesandordirs
Name: {localappdata}\Adobe\*; Type: dirifempty
Name: {userappdata}\Adobe\Adobe Photoshop CS4; Type: filesandordirs
Name: {userappdata}\Adobe\Adobe PDF; Type: filesandordirs
Name: {userappdata}\Adobe\Color; Type: filesandordirs
Name: {userappdata}\Adobe\CS4ServiceManager; Type: filesandordirs
Name: {userappdata}\Adobe; Type: dirifempty

[Messages]
BeveledLabel=Adobe Systems, Copyright 2005-2008.

[Code]
procedure InitializeWizard();
begin
 WizardForm.PageNameLabel.Hide;
 WizardForm.PageDescriptionLabel.Hide;
 WizardForm.FileNameLabel.Visible:= False;

 with WizardForm do
 begin

   with MainPanel do
   begin
     with WizardSmallBitmapImage do
      begin
       Left:= ScaleX(0);
       Top:= ScaleY(0);
       Height:=Mainpanel.Height;
       Width:=MainPanel.Width;
     end
    end
  end
end;
