#include-once
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

;Global Const $WM_TIMER = 0x0113

Global $iTotalReadySize = 0
Global $iTotalDirSize = 0
Global $iFilesCount = 0
Global $iMainCounter = 0

Global $hCopyProgrss_GUI
Global $SubFile_Progress
Global $Cancel_Button
Global $Remained_Label
Global $IsCanceled = False

Func _CopyWithProgress($SourcePath, $DestPath, $iReplace=0, $Title="", $Width=-1, $Height=-1, $Left=-1, $Top=-1, $hWnd=0)
	If Not FileExists($SourcePath) Then Return SetError(1, 0, -1)
	If Not StringInStr(FileGetAttrib($DestPath), "D") And Not DirCreate($DestPath) Then Return SetError(2, 0, "")
	If $iReplace <> 0 And $iReplace <> 1 Then SetError(3, 0, "")
	
	Local $PathName = StringRegExpReplace($SourcePath, "^.*\\", "")
	Local $Progress = 0, $CurrReadySize, $MidlePath
	Local $CurrentFilePath, $CurrentFileName, $CurrentFilePathName, $CurrParDirName, $CurrParDestDirName
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_DISABLE)
	
	$hCopyProgrss_GUI = GUICreate($Title, $Width, $Height, $Left, $Top, $WS_SYSMENU+$WS_CAPTION, -1, $hWnd)
	GUISetIcon("shell32.dll", 4)
	
	GUICtrlCreateAvi(@SystemDir & "\Shell32.dll", 161, 25, 0, $Width-50)
	GUICtrlSetState(-1, 1)
	
	Local $Main_Label = GUICtrlCreateLabel("", 20, 70, $Width-40, 40)
	
	Local $Main_Progress = GUICtrlCreateProgress(20, $Height-58, $Width-120, 15)
	$SubFile_Progress = GUICtrlCreateProgress(20, $Height-40, $Width-120, 10)
	
	$Cancel_Button = GUICtrlCreateButton("", $Width-80, $Height-50, 60, 22)
	$Remained_Label = GUICtrlCreateLabel(": 00:00:00", 20, $Height-23, $Width-120)
	
	GUISetState(@SW_SHOW, $hCopyProgrss_GUI)
	
	Local $aTotalDirSize = DirGetSize($SourcePath, 1)
	$iTotalDirSize = $aTotalDirSize[0]
	$iFilesCount = $aTotalDirSize[1]
	
	_AdlibEnable("_CheckCancel_Proc", $hCopyProgrss_GUI, 10)
	
	GUICtrlSetData($Main_Label, "  ...")
	Local $FilesArr = _FileListToArrayEx($SourcePath)
	
	If IsArray($FilesArr) Then
		For $i = 1 To UBound($FilesArr)-1
			If $IsCanceled Then ExitLoop
			
			;$aCurInfo = GUIGetCursorInfo($hCopyProgrss_GUI)
			;If IsArray($aCurInfo) And $aCurInfo[2] = 1 And $aCurInfo[4] = $Cancel_Button Then ExitLoop
			
			If StringInStr(FileGetAttrib($FilesArr[$i]), "D") Then ContinueLoop
			
			$CurrentFilePath = $FilesArr[$i]
			$CurrentFileName = StringRegExpReplace($CurrentFilePath, "^.*\\", "")
			$CurrentFilePathName = StringReplace($CurrentFilePath, $SourcePath & "\", "")
			$CurrParDirName = _GetParentDirName($CurrentFilePath)
			$CurrParDestDirName = _GetMidlePath($DestPath & "\" & $CurrParDirName)
			
			$CurrReadySize = FileGetSize($CurrentFilePath)
			$iTotalReadySize += $CurrReadySize
			$Progress = $iTotalReadySize / $iTotalDirSize * 100
			
			$MidlePath = _GetMidlePath($CurrentFilePath)
			
			GUICtrlSetData($Main_Progress, $Progress)
			GUICtrlSetData($Main_Label, $CurrentFileName & @LF & ' "' & $CurrParDirName & '"  "' & $CurrParDestDirName & '"')
			
			_FileCopyEx($CurrentFilePath, $DestPath & "\" & $CurrentFilePathName, 8+$iReplace)
			GUICtrlSetData($SubFile_Progress, 0)
			
			If $IsCanceled Then ExitLoop
		Next
	EndIf
	
	_AdlibDisable($hCopyProgrss_GUI)
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($hCopyProgrss_GUI)
EndFunc

Func _FileCopyEx($sSource, $sDest, $iFlag=0, $sProgressRoutineFunc="_CopyProgressRoutine")
	If Not FileExists($sSource) Then Return SetError(1)
	
	If ($iFlag = 0 Or $iFlag = 8) And FileExists($sDest) Then Return 0
	If BitAND($iFlag, 8) Then DirCreate(StringRegExpReplace($sDest, "\\[^\\]*$", ""))
	
	$hCopyProgressRoutine = DllCallbackRegister($sProgressRoutineFunc, "int", "uint64;uint64;uint64;uint64;dword;dword;ptr;ptr;ptr")
	
	DllCall("kernel32.dll", "int", "CopyFileExA", _
		"str", $sSource, _
		"str", $sDest, _
		"ptr", DllCallbackGetPtr($hCopyProgressRoutine), _
		"ptr", 0, _
		"int", 0, _
		"int", 0)
	
	DllCallBackFree($hCopyProgressRoutine)
EndFunc

Func _CopyProgressRoutine($TotalFileSize, $TotalBytesTransferred, $StreamSize, $StreamBytesTransferred, $dwStreamNumber, $dwCallbackReason, $hSourceFile, $hDestinationFile, $lpData)
	$iMainCounter += 1
	
	Local $Precent = $TotalBytesTransferred/$TotalFileSize*100
	Local $TimeRemained = _GetTimeRemained($iTotalDirSize, $TotalBytesTransferred, $iFilesCount, $iMainCounter)
	
	GUICtrlSetData($Remained_Label, ": " & $TimeRemained)
	GUICtrlSetData($SubFile_Progress, $Precent)
	
	Return 0
EndFunc

Func _AdlibEnable($sFunction, $hWnd, $iTime=250)
	GUIRegisterMsg($WM_TIMER, $sFunction)
	DllCall("User32.dll", "int", "SetTimer", "hwnd", $hWnd, "int", 50, "int", $iTime, "int", 0)
EndFunc

Func _AdlibDisable($hWnd)
	GUIRegisterMsg($WM_TIMER, "")
	DllCall("user32.dll", "int", "KillTimer", "hwnd", $hWnd, "int_ptr", 50)
EndFunc

Func _CheckCancel_Proc()
	Switch GUIGetMsg()
		Case -3, $Cancel_Button
			$IsCanceled = True
			_AdlibDisable($hCopyProgrss_GUI)
	EndSwitch
EndFunc

Func _FileListToArrayEx($sPath, $sMask="*", $iMode=-1)
	Local $PathesArr[2] = [1, $sPath]
	Local $hSearch, $sFindNext, $i
	
	While $i < $PathesArr[0]
		$i += 1
		$hSearch = FileFindFirstFile($PathesArr[$i] & "\" & $sMask)
		If $hSearch = -1 Then ContinueLoop
		
		While 1
			If $IsCanceled Then Return SetError(1, 0, 0)
			
			$sFindNext = FileFindNextFile($hSearch)
			If @error Then ExitLoop
			
			$sFindNext = $PathesArr[$i] & "\" & $sFindNext
			
			If $iMode <= 0 Or ($iMode = 1 And StringInStr(FileGetAttrib($sFindNext), "D")) Then
				$PathesArr[0] += 1
				ReDim $PathesArr[$PathesArr[0]+1]
				$PathesArr[$PathesArr[0]] = $sFindNext
			EndIf
		WEnd
		
		FileClose($hSearch)
	Wend
	
	Return $PathesArr
EndFunc

Func _GetMidlePath($sPath, $iMinLen=40)
	If StringLen($sPath) <= $iMinLen Then Return $sPath
	Local $StartPath = StringLeft($sPath, 25)
	Local $EndPath = StringTrimLeft($sPath, StringInStr($sPath, "\", 0, -2)-1)
	Return $StartPath & "..." & $EndPath
EndFunc

Func _GetParentDirName($FullName)
	Local $LastSlashPos = StringInStr($FullName, "\", 0, -1)
	Local $SecondLastSlashPos = StringInStr($FullName, "\", 0, -2)
	Return StringMid($FullName, $SecondLastSlashPos+1, $LastSlashPos-$SecondLastSlashPos-1)
EndFunc

Func _GetTimeRemained($TotalSize, $CurrentSize, $FilesCount, $CurrentFilesCount)
	Local $nLevl = 0.5
	If $TotalSize <= $CurrentSize Then Return _SecondsToTime(0)
	
	Switch $FilesCount - $CurrentFilesCount
		Case 0 To 100
			$nLevl = 0.1
		Case 100 To 1000
			$nLevl = 0.2
		Case 1000 To 2000
			$nLevl = 1
		Case Else
			$nLevl = 1.5
	EndSwitch
	
	Local $Secs = ($TotalSize * $nLevl) / (3600 * $CurrentFilesCount) - ($CurrentSize * $nLevl) / (3600 * $CurrentFilesCount)
	Return _SecondsToTime($Secs)
EndFunc

Func _SecondsToTime($iTicks, $Delim=":")
	If Number($iTicks) >= 0 Then
		$iHours = Int($iTicks / 3600)
		$iTicks = Mod($iTicks, 3600)
		$iMins = Int($iTicks / 60)
		$iSecs = Round(Mod($iTicks, 60))
		If StringLen($iHours) = 1 Then $iHours = "0" & $iHours
		If StringLen($iMins) = 1 Then $iMins = "0" & $iMins
		If StringLen($iSecs) = 1 Then $iSecs = "0" & $iSecs
		Return $iHours & $Delim & $iMins & $Delim & $iSecs
	EndIf
	
	Return SetError(1, 0, 0)
EndFunc

