/*
	sort2cabs.js v0.9
	Marek, 19.07.2005
	
	- tested with Office 2003 SP1 slipstreamed
	- sorts files according to msi-file into ddf-files for processing with makecab
	- creates cabs
	- neccessary tables (exported via orca):
		CabinetDetail.idt
		Component.idt
		Directory.idt
		File.idt
		Media.idt
	- CabinetDetail.idt, File.idt and Media.idt are updated

	requirements:
	- windows scripting host 5.6
	- makecab.exe
	- md5sum.exe
	- orca.exe
*/

// set to 0 or 1 depending on short or long names used
// do not use long names, not testet -> errors!
// always use SHORTFILENAMES=TRUE for msiexec
var FN_LONG = 0;
// table names and index names
var DIRLISTFILE = "tabledirs.lst";
var XMLLISTFILE = "xmlfiles.lst";
var T_CABDETAIL = "CabinetDetail.idt";
var T_CABDETAIL_NEW = "CabinetDetail.new.idt";
var T_COMPONENT = "Component.idt";
var I_COMPONENT = "Component";
var T_DIRECTORY = "Directory.idt";
var I_DIRECTORY = "Directory";
var T_FILE = "File.idt";
var T_FILE_NEW = "File.new.idt";
var I_FILE = "File";
var T_MEDIA = "Media.idt";
var T_MEDIA_NEW = "Media.new.idt";
var I_MEDIA = "DiskId";
// constants for FileSystemObject
var OTF_READ = 1;
var OTF_WRITE = 2;
var OTF_APPEND = 8;
var OTF_SYSDEFAULT = -2;
var OTF_UNICODE = -1;
var OTF_ASCII = 0;

var fso = new ActiveXObject("Scripting.FileSystemObject");
var wsh = new ActiveXObject("WScript.Shell");

function readTable(sFName, sIndex) {
	var arTmp = new Array();
	var fTmp, sCols, sRows, iIndex, i, arCols, arRows;
	var iCounter = 0;

	WScript.Echo("opening " + sFName);
	fTmp = fso.OpenTextFile(sFName, OTF_READ, false, OTF_ASCII);

	sCols = fTmp.ReadLine();
	arCols = sCols.split("\t");
	for (i in arCols) {
		if (arCols[i] == sIndex) {
			iIndex = i;
			break;
		}
	}
	// skip lines with table information
	fTmp.SkipLine();
	fTmp.SkipLine();
	while (!fTmp.AtEndOfStream) {
		sRows = fTmp.ReadLine();
		arRows = sRows.split("\t");
		iCounter++;
		// built hash table
		arTmp[arRows[iIndex]] = new Array();
		for (i in arRows) {
			if (i != iIndex) {
				arTmp[arRows[iIndex]][arCols[i]] = arRows[i];
			}
		}
	}
	fTmp.close();
	WScript.Echo(" -> " + iCounter + " rows imported");
	return arTmp;
}

function sortBySequence(arFirst, arSecond) {
	return arFirst["Sequence"] - arSecond["Sequence"];
}

function sortBySequenceArray(arFirst, arSecond) {
	var i;
	
	for (i in arDirectories) {
		if (arFirst["Sequence"][i] != arSecond["Sequence"][i]) return arFirst["Sequence"][i] - arSecond["Sequence"][i];
	}
	return 0;
}

function readList(sFName) {
	var arList = new Array();
	var sTmp, fTmp;
	
	fTmp = fso.OpenTextFile(sFName, OTF_READ, false, OTF_ASCII);
	while (!fTmp.AtEndOfStream) {
		sTmp = fTmp.ReadLine();
		if ((sTmp.length != 0) && (sTmp.charAt(0) != "#")) {
			arList.push(sTmp);
		}
	}
	fTmp.close();
	return arList;
}

function readDirlist(sFName) {
	// read directories to search, check for neccessary tables
	var arTmp, i;
	var arDirs = new Array();

	arTmp = readList(sFName);
	for (i in arTmp) {
		if (fso.FolderExists(arTmp[i]) && fso.FileExists(arTmp[i] + "\\" + T_CABDETAIL)
		    && fso.FileExists(arTmp[i] + "\\" + T_DIRECTORY) && fso.FileExists(arTmp[i] + "\\" + T_FILE)
		    && fso.FileExists(arTmp[i] + "\\" + T_MEDIA) && fso.FileExists(arTmp[i] + "\\" + T_COMPONENT)) {
			arDirs.push(arTmp[i]);
		}
	}
	return arDirs;
}

function md5sum(sFName) {
	var sMD5sum = "";
	var oExec;
	
	oExec = wsh.Exec("md5sum -b " + sFName);
	while (oExec.Status != 1) {
		WScript.Sleep(100);
		while (!oExec.StdOut.AtEndOfStream) sMD5sum += oExec.StdOut.Read(1);
//		while (!oExec.StdErr.AtEndOfStream) WScript.StdErr.Write(oExec.StdErr.Read(1));
	}
	return sMD5sum.match(/[0-9abcdef]{32}/)[0].toUpperCase();
}

function collectFiles(arDirectories) {
	var arTDir = new Array();
	var arTFile = new Array();
	var arTMedia = new Array();
	var arTCompo = new Array();
	var arFiles = new Array();
	var arTmp;
	var i, x, y, p, bWork, bCont, bAnyChanges, bAnyUndefined;
	var iSequence, iMaxSequence, iLastSequence, sMedia, sFileSource, iUnDefPos, iUnDefLast;
	var fTmpIn, fTmpOut, sLine, arLine;

	for (i in arDirectories) {
		// read *.idt: directory, file, media, component
		arTDir[i] = readTable(arDirectories[i] + "\\" + T_DIRECTORY, I_DIRECTORY);
		arTFile[i] = readTable(arDirectories[i] + "\\" + T_FILE, I_FILE);
		arTMedia[i] = readTable(arDirectories[i] + "\\" + T_MEDIA, I_MEDIA);
		arTCompo[i] = readTable(arDirectories[i] + "\\" + T_COMPONENT, I_COMPONENT);
		//
		// modify arTDir
		// 
		// set new root
		arTDir[i]["TARGETDIR"]["DefaultDir"] = "..";
		// parse for "s|l" and choose one -> FN_LONG should always be 0
		// search for strings like ".:MS" and make valid dir -> "MS" ... no idea what this means or what it is good for ...
		for (x in arTDir[i]) {
			if (arTDir[i][x]["DefaultDir"].indexOf(".:") > -1) {
				arTDir[i][x]["DefaultDir"] = arTDir[i][x]["DefaultDir"].split(".:").join("");
			}
			if (arTDir[i][x]["DefaultDir"].indexOf("|") > -1) {
				arTDir[i][x]["DefaultDir"] = arTDir[i][x]["DefaultDir"].split("|")[FN_LONG];
			}
		}
		// and now expand all
		bWork = true;
		while (bWork) {
			bWork = false;
			for (x in arTDir[i]) {
				if (arTDir[i][x]["Directory_Parent"] != "") {
					bWork = true;
					arTDir[i][x]["DefaultDir"] = arTDir[i][arTDir[i][x]["Directory_Parent"]]["DefaultDir"] + "\\" + arTDir[i][x]["DefaultDir"];
					arTDir[i][x]["Directory_Parent"] = arTDir[i][arTDir[i][x]["Directory_Parent"]]["Directory_Parent"];
				}
			}
		}
		// modify arTFile
		// 
		// parse for "s|l" and choose one -> FN_LONG should always be 0
		for (x in arTFile[i]) {
			if (arTFile[i][x]["FileName"].indexOf("|") > -1) {
				arTFile[i][x]["FileName"] = arTFile[i][x]["FileName"].split("|")[FN_LONG];
			}
		}
	}
	// sort files to array by media, add sequence numbers and path to source
	// important: unique sequence numbers for compressed files!
	// - sorting of files in cabs has to be the same as in file table sorted by sequence numbers!
	// - sorting over all msi using same cabs, extensive sequence array -> later correction of sequence numbers
	WScript.Echo("sorting files...");
	for (i in arDirectories) {
		for (x in arTFile[i]) {
			iSequence = parseInt(arTFile[i][x]["Sequence"]);
			for (y in arTMedia[i]) {
				sMedia = arTMedia[i][y]["Cabinet"];
				iLastSequence = parseInt(arTMedia[i][y]["LastSequence"]);
				if (iSequence <= iLastSequence) break;
			}
			sFileSource = arTDir[i][arTCompo[i][arTFile[i][x]["Component_"]]["Directory_"]]["DefaultDir"] + "\\" + arTFile[i][x]["FileName"];
			if (!arFiles[sMedia]) arFiles[sMedia] = new Array();
			if (!arFiles[sMedia][x]) {
				arFiles[sMedia][x] = new Array();
				arFiles[sMedia][x]["File"] = x;
				arFiles[sMedia][x]["FileSource"] = sFileSource;
				// array of sequences for later cab sorting & renumbering (to eliminate duplicate sequence numbers, necessary for compression says M$)
				arFiles[sMedia][x]["Sequence"] = new Array();
				arFiles[sMedia][x]["Sequence"][i] = iSequence;
				arFiles[sMedia][x]["included"] = new Array();
				arFiles[sMedia][x]["included"][i] = true;
			} else {
				// file already in media/cab
				// check if identical
				if (sFileSource != arFiles[sMedia][x]["FileSource"]) {
//					WScript.Echo(sFileSource + " <--> " + arFiles[sMedia][x]["FileSource"]);
					if (md5sum(sFileSource) != md5sum(arFiles[sMedia][x]["FileSource"])) {
						throw "duplicate Filesource for File " + x + " in " + sMedia + "\n -> " + sFileSource + " != " + arFiles[sMedia][x]["FileSource"] + "\nfiles are not identical, script stopped!";
					}
				}
				// set sequence number, duplicate files are not possible
				arFiles[sMedia][x]["Sequence"][i] = iSequence;
				arFiles[sMedia][x]["included"][i] = true;
			}
		}
	}
	// sorting & renumbering - complete sequence array before!
	WScript.Echo("sorting cabs...");
	for (i in arFiles) {
		// fill unset colums with '0' for faster processing
		for (x in arDirectories) {
			for (y in arFiles[i]) {
				if (arFiles[i][y]["Sequence"][x] == undefined) {
					arFiles[i][y]["Sequence"][x] = 0;
				} else {
					for (p in arFiles[i]) {
						if (p == y) break;
						arFiles[i][p]["Sequence"][x] = undefined;
					}
					break;
				}
			}
		}
		// fill sequence array with 0, only last unset values, for easier compare function
		for (x in arFiles[i]) {
			for (y = arDirectories.length - 1; y > 0; y--) {
				if ((arFiles[i][x]["Sequence"][y] == undefined) || (arFiles[i][x]["Sequence"][y] == 0)) {
					arFiles[i][x]["Sequence"][y] = 0;
				} else {
					break;
				}
			}
		}
		// add remaining unset values with values from nearest neighbours
		do {
			bAnyChanges = false;
			bAnyUndefined = false;
			for (x in arFiles[i]) {
				do {
					bCont = false;
					// find unset values
					for (y in arDirectories) {
						if (arFiles[i][x]["Sequence"][y] == undefined) {
							bCont = true;
							iUnDefPos = y;
							break;
						}
					}
					if (bCont) {
						// find following defined position, must exist
						y = iUnDefPos;
						do y++; while ((arFiles[i][x]["Sequence"][y] == undefined) || (arFiles[i][x]["Sequence"][y] == 0)); // 'y' should never exceed arDirectories.lenght
						// work on area, shall fasten up the whole thing
						iUnDefLast = y;
						// loop through all following positions, pointer is 'y'
						do {
							// find nearest value in other files at position 'y'
							bFound = false;
							for (p in arFiles[i]) {
								if ((p != x) && (arFiles[i][p]["Sequence"][y] != undefined) && (arFiles[i][p]["Sequence"][y] != 0) && (arFiles[i][p]["Sequence"][iUnDefPos] != undefined)) {
									iTmpDist = Math.abs(arFiles[i][p]["Sequence"][y] - arFiles[i][x]["Sequence"][y]);
									if (bFound) {
										if (iTmpDist < iDistance) {
											iDistance = iTmpDist;
											FNameDist = p;
										}
									} else {
										bFound = true;
										iDistance = iTmpDist;
										FNameDist = p;
									}
								}
							}
							if (bFound) {
								// copy area iUnDefPos..iUnDefLast
								for (y = iUnDefPos; y < iUnDefLast; y++) {
									arFiles[i][x]["Sequence"][y] = arFiles[i][FNameDist]["Sequence"][y];
								}
								y = undefined;
								bAnyChanges = true;
							} else {
								do y++; while ((y < arDirectories.length) && (arFiles[i][x]["Sequence"][y] != undefined) && (arFiles[i][x]["Sequence"][y] != 0));
								if ((y > (arDirectories.length - 1)) || (arFiles[i][x]["Sequence"][y] == 0)) {
									y = undefined;
									bAnyUndefined = true;
									bCont = false;
								}
							}
						} while (y);
					}
				} while (bCont);
			}
		} while (bAnyChanges && bAnyUndefined);
		// set all remaining unset values to '0'
		if (bAnyUndefined) {
			for (x in arFiles[i]) {
				for (y in arDirectories) {
					if (arFiles[i][x]["Sequence"][y] == undefined) arFiles[i][x]["Sequence"][y] = 0;
				}
			}
		}
		// sort files in media, convert hash table to array then sort
		arTmp = new Array();
		for (x in arFiles[i]) {
			arTmp.push(arFiles[i][x]);
		}
		arFiles[i] = arTmp.sort(sortBySequenceArray);
	}
	// correct sequence numbers in file and media tables
	WScript.Echo("renumbering...");
	for (i in arDirectories) {
		iLastSequence = 0;
		for (x in arTMedia[i]) {
			sMedia = arTMedia[i][x]["Cabinet"];
			for (y in arFiles[sMedia]) {
				if (arFiles[sMedia][y]["included"][i]) arTFile[i][arFiles[sMedia][y]["File"]]["Sequence"] = ++iLastSequence;
			}
			arTMedia[i][x]["LastSequence"] = iLastSequence;
		}
	}
	// write new file and media tables
	for (i in arDirectories) {
		fTmpIn = fso.OpenTextFile(arDirectories[i] + "\\" + T_FILE, OTF_READ, false, OTF_ASCII);
		fTmpOut = fso.OpenTextFile(arDirectories[i] + "\\" + T_FILE_NEW, OTF_WRITE, true, OTF_ASCII);
		sLine = fTmpIn.ReadLine();
		arLine = sLine.split("\t");
		for (x in arLine) {
			if (arLine[x] == "File") iIndex_1 = x;
			if (arLine[x] == "Sequence") iIndex_2 = x;
		}
		fTmpOut.WriteLine(sLine);
		fTmpOut.WriteLine(fTmpIn.ReadLine());
		fTmpOut.WriteLine(fTmpIn.ReadLine());
		while (!fTmpIn.AtEndOfStream) {
			sLine = fTmpIn.ReadLine();
			arLine = sLine.split("\t");
			arLine[iIndex_2] = arTFile[i][arLine[iIndex_1]]["Sequence"];
			fTmpOut.WriteLine(arLine.join("\t"));
		}
		fTmpIn.Close();
		fTmpOut.Close();
		fTmpIn = fso.OpenTextFile(arDirectories[i] + "\\" + T_MEDIA, OTF_READ, false, OTF_ASCII);
		fTmpOut = fso.OpenTextFile(arDirectories[i] + "\\" + T_MEDIA_NEW, OTF_WRITE, true, OTF_ASCII);
		sLine = fTmpIn.ReadLine();
		arLine = sLine.split("\t");
		for (x in arLine) {
			if (arLine[x] == "DiskId") iIndex_1 = x;
			if (arLine[x] == "LastSequence") iIndex_2 = x;
		}
		fTmpOut.WriteLine(sLine);
		fTmpOut.WriteLine(fTmpIn.ReadLine());
		fTmpOut.WriteLine(fTmpIn.ReadLine());
		while (!fTmpIn.AtEndOfStream) {
			sLine = fTmpIn.ReadLine();
			arLine = sLine.split("\t");
			arLine[iIndex_2] = arTMedia[i][arLine[iIndex_1]]["LastSequence"];
			fTmpOut.WriteLine(arLine.join("\t"));
		}
		fTmpIn.Close();
		fTmpOut.Close();
	}
	return arFiles;
}

function builtCabs(arFiles) {
	var i, x;
	var fTmp, oExec;

	for (i in arFiles) {
		fTmp = fso.OpenTextFile(i + ".ddf", OTF_WRITE, true, OTF_ASCII);
		for (x in arFiles[i]) {
			fTmp.WriteLine("\"" + arFiles[i][x]["FileSource"] + "\" " + arFiles[i][x]["File"]);
		}
		fTmp.close();
		WScript.Echo("\ncreating " + i + ":\n");
		oExec = wsh.Exec("makecab /D CabinetNameTemplate=..\\" + i + " /F settings.ddf /F " + i + ".ddf");
		while (oExec.Status != 1) {
			WScript.Sleep(100); // too large? ... 
			// following is simply sick! ... ReadAll produces buffer overflow ... Read waits for LF, too! ...
			while (!oExec.StdOut.AtEndOfStream) WScript.StdOut.Write(oExec.StdOut.Read(40)); // >1 for faster looping
			while (!oExec.StdErr.AtEndOfStream) WScript.StdErr.Write(oExec.StdErr.Read(1));
		}
		fso.DeleteFile(i + ".ddf");
	}
}

function builtNewCabDetail(arDirectories) {
	var i, x;
	var fTmpIn, fTmpOut, arLine, sLine;

	// create new CabinetDetail.idt with corrected md5 sums
	for (i in arDirectories) {
		WScript.Echo("writing " + arDirectories[i] + "\\" + T_CABDETAIL_NEW);
		fTmpIn = fso.OpenTextFile(arDirectories[i] + "\\" + T_CABDETAIL, OTF_READ, false, OTF_ASCII);
		fTmpOut = fso.OpenTextFile(arDirectories[i] + "\\" + T_CABDETAIL_NEW, OTF_WRITE, true, OTF_ASCII);
		
		sLine = fTmpIn.ReadLine();
		arLine = sLine.split("\t");
		for (x in arLine) {
			if (arLine[x] == "MD5") iIndexMD5 = x;
			if (arLine[x] == "Cabinet") iIndexCab = x;
			if (arLine[x] == "Size") iIndexSize = x;
		}
		// copy lines with table information
		fTmpOut.WriteLine(sLine);
		fTmpOut.WriteLine(fTmpIn.ReadLine());
		fTmpOut.WriteLine(fTmpIn.ReadLine());
		while (!fTmpIn.AtEndOfStream) {
			sLine = fTmpIn.ReadLine();
			arLine = sLine.split("\t");
			arLine[iIndexMD5] = arMD5sums[arLine[iIndexCab]];
			arLine[iIndexSize] = arCabSize[arLine[iIndexCab]];
			fTmpOut.WriteLine(arLine.join("\t"));
		}
		fTmpIn.Close();
		fTmpOut.Close();
	}
}

function modifyXMLs(arXMLs, arMD5sums, arCabSize) {
	var xml_doc = new ActiveXObject("Microsoft.XMLDOM"); 
	var i, x;
	var iFileElem, nlFileElem, nlAttributes, ndID, ndSource;

	for (i in arXMLs) {
		xml_doc.async = false; 
		WScript.Echo("modifying " + arXMLs[i]);
		xml_doc.load(arXMLs[i]); 
		nlFileElem = xml_doc.getElementsByTagName("File");
		iFileElem = nlFileElem.length;
		for (x = 0; x < iFileElem; x++) {
			nlAttributes = nlFileElem[x].attributes;
			ndId = nlAttributes.getNamedItem("Id");
			ndSource = nlAttributes.getNamedItem("RelativeSourcePath");
			if ((arMD5sums[ndId.nodeValue]) && (arCabSize[ndId.nodeValue])) {
				nlFileElem[x].setAttribute("MD5", arMD5sums[ndId.nodeValue]);
				nlFileElem[x].setAttribute("Size", arCabSize[ndId.nodeValue]);
			} else {
				if (fso.FileExists("..\\" + ndSource.nodeValue)) {
					nlFileElem[x].setAttribute("MD5", md5sum("..\\" + ndSource.nodeValue));
					nlFileElem[x].setAttribute("Size", fso.GetFile("..\\" + ndSource.nodeValue).Size);
				}
			}
		}
		xml_doc.save(arXMLs[i]); 
	}
}

// main
var arDirectories, arFiles, arXMLs;
var arMD5sums = new Array();
var arCabSize = new Array();
var i, j;

try {
	if (WScript.Arguments.length != 0) {
		switch (WScript.Arguments.Item(0)) {
			case "-help"   : j = 0; break;
			case "-xmlonly": j = 10; break;
			default        : j = 1;
		}
	} else j = 1;
	switch (j) {
		case 0:
			WScript.Echo("-xmlonly   skip all and run only xml modifications");
			break;
		case 1:
			arDirectories = readDirlist(DIRLISTFILE);
			WScript.Echo("directories found: " + arDirectories);
			arFiles = collectFiles(arDirectories);
			builtCabs(arFiles);
			// read size of new cabinet and calculate MD5
			for (i in arFiles) {
				arCabSize[i] = fso.GetFile("..\\" + i).Size;
				WScript.Echo("calculating md5 for " + i + " (" + arCabSize[i] + "):");
				arMD5sums[i] = md5sum("..\\" + i);
				WScript.Echo(" -> " + arMD5sums[i]);
				WScript.Echo(" OK ");
			}
			builtNewCabDetail(arDirectories);
//			WScript.StdOut.Write("\nNow update your MSI files with the new tables and press <enter> to continue ...");
//			WScript.StdIn.ReadLine();
		case 10:
			arXMLs = readList(XMLLISTFILE);
			WScript.Echo("xml files found: " + arXMLs);
			modifyXMLs(arXMLs, arMD5sums, arCabSize);
	}
}
catch(e) {
	WScript.Echo("\nError: " + e);
	fTmp = fso.OpenTextFile("Error.txt", OTF_WRITE, true, OTF_ASCII);
	fTmp.WriteLine("Error: " + e);
	fTmp.Close();
	WScript.StdOut.Write("\nPress <enter> to exit ...");
	WScript.StdIn.ReadLine();
}

