unit mainform;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RXCtrls, ExtCtrls,StdCtrls, ComCtrls, Menus, ToolWin, ImgList,
  XPMan;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    mnuFile: TMenuItem;
    mnuRereadIni: TMenuItem;
    N1: TMenuItem;
    mneClose: TMenuItem;
    mnuSelection: TMenuItem;
    mnuAll: TMenuItem;
    mnuSelNone: TMenuItem;
    mnuInvertSel: TMenuItem;
    StatusBar1: TStatusBar;
    Memo1: TMemo;
    mnuSet: TMenuItem;
    Panel2: TPanel;
    RXItems: TRxCheckListBox;
    RxGroups: TRxCheckListBox;
    Splitter1: TSplitter;
    mnuRun: TMenuItem;
    mnuExitAfter: TMenuItem;
    ProgressBar1: TProgressBar;
    ImageList1: TImageList;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    N2: TMenuItem;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    N3: TMenuItem;
    N4: TMenuItem;
    Timer2: TTimer;
    mnuBuildCache: TMenuItem;
    XPManifest1: TXPManifest;
    procedure FormCreate(Sender: TObject);
    procedure RxGroupsClick(Sender: TObject);
    procedure SetGroupState;
    procedure mneCloseClick(Sender: TObject);
    procedure mnuRereadIniClick(Sender: TObject);
    procedure mnuAllClick(Sender: TObject);
    procedure mnuSelNoneClick(Sender: TObject);
    procedure mnuInvertSelClick(Sender: TObject);
    procedure RXItemsClickCheck(Sender: TObject);
    procedure RxGroupsClickCheck(Sender: TObject);
    procedure mnuRunClick(Sender: TObject);
    procedure RXItemsClick(Sender: TObject);
    procedure mnuExitAfterClick(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure N4Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure mnuBuildCacheClick(Sender: TObject);
  private
    { Private declarations }
  public
    nThreadResult:integer;
    { Public declarations }
  end;



TSendThread = class(TThread)     //  ,   TThread
private
  iIdx:integer;
  stext:string;
 protected
  procedure Execute; override;
  procedure InitUI;
  procedure UpdateProgress;
  procedure UpdateMemo;
  Procedure FinalizeUI;
 public
  constructor Create;
 end;










var
  Form1: TForm1;

implementation

{$R *.dfm}
uses inifiles,shellapi, StrUtils, splashform;
type ItemInfo = record
  GroupID: integer;
  Description: string;
  fpexefile:string;
  params:string;
  itemindex:integer;
  Checked:boolean;
end;

var oIni:tinifile;
    cIniFile,cCacheFile:string;
    cSoftDir:string;
    lAutoMode:Boolean;
    soft:array[1..1000] of ItemInfo;
    iItemCount:integer;

function StartProcess(cmdline:string):boolean;
var si:STARTUPINFO;
    pi:PROCESS_INFORMATION;
begin
    ZeroMemory(@si,sizeof(si));
    si.cb:=SizeOf(si);
    si.dwFlags:=STARTF_USESHOWWINDOW;
    si.wShowWindow:=SW_SHOWNORMAL;
    result:=CreateProcess( nil, // No module name (use command line).
        PChar(cmdline),  // Command line.
        nil,             // Process handle not inheritable.
        nil,             // Thread handle not inheritable.
        False,           // Set handle inheritance to FALSE.
        0,               // No creation flags.
        nil,             // Use parent's environment block.
        nil,             // Use parent's starting directory.
        si,              // Pointer to STARTUPINFO structure.
        pi );             // Pointer to PROCESS_INFORMATION structure.
    WaitForSingleObject( pi.hProcess, INFINITE );
    CloseHandle( pi.hProcess );
    CloseHandle( pi.hThread );
end;



function ReplaceEnvStrings(InputString:string):string;
var
     pname,s:string;
     p: pChar;

function DosToWin(St: string): string;
var
  Ch: PChar;
begin
  Ch := StrAlloc(Length(St) + 1);
  OemToAnsi(PChar(St), Ch);
  Result := Ch;
  StrDispose(Ch)
end;

begin
    result:=InputString;
    p := GetEnvironmentStrings;
    while p^ <> #0 do
      begin
        try try
        s:=DosToWin(StrPas(p));
        pname:=copy(s,1,pos('=',s)-1);
        delete(s,1,length(pname)+1);
        result:=StringReplace(result,'%'+pname+'%',s,[rfReplaceAll, rfIgnoreCase]);
        inc(p, lStrLen(p) + 1);
        except end;
        finally end;
      end;
  FreeEnvironmentStrings(p);
end;


procedure TForm1.FormCreate(Sender: TObject);
var i,p,pe,j:integer;
    sr: TSearchRec;
    SResult:integer;
    cMask,cDescription: string;
    iGroupID: integer;
    cParams:string;
    lChecked:boolean;
    cPrefix:string;
    GroupsShift:array[1..1000] of integer;
    lUseCache:boolean;
begin
try
try
    panel1.Visible:=false;
    panel2.Visible:=true;
    panel2.Align:=alClient;
    mnuSelection.Enabled:=true;
    mnuSet.Enabled:=true;
    SetCurrentDir(ExtractFilePath(paramstr(0)));
    cIniFile:=ExtractFilePath(paramstr(0))+ChangeFileExt(ExtractFileName(paramstr(0)),'.ini');
    cCacheFile:=ExtractFilePath(paramstr(0))+'itemcach.ini';
    oIni:=TIniFile.Create(cIniFile);
    Caption:=oIni.ReadString('main','caption',' ');
    lAutoMode:=FindCmdLineSwitch('a',['/','-'],true);
    lUseCache:=FindCmdLineSwitch('c',['/','-'],true);
    Timer1.tag:=oIni.ReadInteger('main','timeout',30);
    Label1.Caption:='   :'#13#10+inttostr(timer1.tag);
    Timer1.enabled:=lAutoMode;
    RxItems.enabled:=not lAutoMode;
    RxGroups.enabled:=not lAutoMode;
    GroupBox1.visible:=lAutoMode;
    mnuExitAfter.Checked:=lAutoMode;
    ToolButton6.Down:=lAutoMode;
    cSoftDir:=oIni.ReadString('main','softdir','.');
    if cSoftDir[length(cSoftDir)]<>'\'  then
              cSoftDir:=cSoftDir+'\';
    cSoftDir:=ReplaceEnvStrings(cSoftDir);
    RxGroups.Clear;
    RXItems.Clear;
    if (not lUseCache) or (not FileExists(cCacheFile)) then
    begin
 		    Form2:=TForm2.Create(Form1);
		    form2.ProgressBar1.Max:=oIni.ReadInteger('main','itemcount',0);
		    Form2.Show;
		    iItemCount:=0;

		    j:=0;
		    for i:=1 to oIni.ReadInteger('main','groupcount',0) do
				begin
					if length(oIni.ReadString('main','group'+inttostr(i),''))>0 then
					begin
						inc(j);
						GroupsShift[i]:=j;
						RxGroups.Items.Add(oIni.ReadString('main','group'+inttostr(i),''))
		            end;
				end;//for
		    for i:=1 to oIni.ReadInteger('main','itemcount',0) do
		        begin
		            application.ProcessMessages;
		            cMask:=oIni.ReadString('item'+inttostr(i),'mask','');
		            iGroupID:=oIni.ReadInteger('item'+inttostr(i),'GroupID',0);
		            cParams:=oIni.ReadString('item'+inttostr(i),'Params','');
		            lChecked:=oIni.ReadInteger('item'+inttostr(i),'Checked',0)=1;
		            cDescription:=oIni.ReadString('item'+inttostr(i),'Descr','');
		            SResult:= FindFirst(cSoftDir+cMask, faAnyFile, sr);
		            cPrefix:='';

		            p:=Pos('\',cMask);
		            pe:=p;
		            while pe<>0 do
		              begin
		              p:=pe;
		              pe:=posEx('\',cMask,pe+1);
		              end;

		            cPrefix:=copy(cMask,1,p);
		            while SResult=0 do begin
		                application.ProcessMessages;
		                inc(iItemCount);
		                soft[iItemCount].GroupID := GroupsShift[iGroupID];
		                if length(cDescription)=0 then
		                  soft[iItemCount].Description:=sr.name
		                else
		                  soft[iItemCount].Description:=cDescription;
		                soft[iItemCount].fpexefile:=cSoftDir+cPrefix+sr.name;
		                soft[iItemCount].params:=cParams;
		                soft[iItemCount].Checked:=lChecked;
		                SResult:=FindNext(sr);
		            end;//while
		            FindClose(sr);
                form2.ProgressBar1.stepit;
		        end;//for
        end //not use cache
        else
        begin//use cache
            oIni.Free;
            oIni:=TIniFile.Create(cCacheFile);
            for i:=1 to oIni.ReadInteger('main','groupcount',0) do
				          	RxGroups.Items.Add(oIni.ReadString('main','group'+inttostr(i),''));
            for i:=1 to oIni.ReadInteger('main','itemcount',0) do
              begin
                     soft[i].GroupID := oini.ReadInteger('item'+inttostr(i),'GroupID',0);
                     soft[i].params  := oIni.ReadString('item'+inttostr(i),'Params','');
                     soft[i].Checked := oIni.ReadInteger('item'+inttostr(i),'Checked',0)=1;
                     soft[i].Description:=oIni.ReadString('item'+inttostr(i),'Descr','');
                     soft[i].fpexefile := oIni.ReadString('item'+inttostr(i),'fpexefile','');
              end;//for
              iItemCount:=i;
        end;//use cache
        RxGroups.Selected[0]:=true;
        RxGroups.OnClick(RxGroups);
        SetGroupState;
        if Form2<>nil then Form2.Hide;
except on e:exception do messagebox(handle,pchar(e.Message),'',mb_ok or mb_iconError) end;
finally oini.free; if Form2<>nil then Form2.free; end;
end;

procedure TForm1.SetGroupState;
var i:integer;
    j:integer;
    lGrayed:boolean;
    lPrevState,lCurrState,FirstItem:boolean;
begin
  for i:=1 to RxGroups.Items.Count do
      begin
          lGrayed:=false;
          lPrevState:=false;
          lCurrState:=false;
          FirstItem:=true;
          for j:=1 to iItemCount do
            begin
              if soft[j].GroupID=i then
                 if FirstItem then
                    begin
                        lPrevState:=soft[j].checked;
                        lCurrState:=soft[j].checked;
                        FirstItem:=false;
                    end
                 else
                    lCurrState:=soft[j].checked;
                lGrayed:=lPrevState<>lCurrState;
                if lGrayed then break;
             end;//for j
            if lGrayed then
               RxGroups.State[i-1]:=cbGrayed
              else
               RxGroups.Checked[i-1]:=lPrevState;
      end;//for i
end;

procedure TForm1.RxGroupsClick(Sender: TObject);
var iCurrIndex:integer;
    i:integer;
begin
iCurrIndex:=RxGroups.ItemIndex;
if iCurrIndex<0 then exit;
RXItems.Clear;
for i:=1 to iItemCount do
      soft[i].itemindex:=-1;
for i:=1 to iItemCount do
    if soft[i].GroupID=iCurrIndex+1 then
      begin
      RXItems.Items.Add(soft[i].Description);
      RXItems.Checked[RXItems.Items.Count-1]:=soft[i].Checked;
      soft[i].itemindex:=RXItems.Items.Count-1;
      end;

end;

procedure TForm1.mneCloseClick(Sender: TObject);
begin
close;
end;

procedure TForm1.mnuRereadIniClick(Sender: TObject);
begin
if timer1.Enabled then exit;
OnCreate(Form1);
end;

procedure TForm1.mnuAllClick(Sender: TObject);
var i:integer;
begin
if timer1.Enabled then exit;
for i:=1 to iItemCount do
    soft[i].Checked:=true;
RxGroups.OnClick(RxGroups);
SetGroupState;
end;

procedure TForm1.mnuSelNoneClick(Sender: TObject);
var i:integer;
begin
if timer1.Enabled then exit;
for i:=1 to iItemCount do
    soft[i].Checked:=false;
RxGroups.OnClick(RxGroups);
SetGroupState;
end;

procedure TForm1.mnuInvertSelClick(Sender: TObject);
var i:integer;
begin
if timer1.Enabled then exit;
for i:=1 to iItemCount do
    soft[i].Checked:=not soft[i].Checked;
RxGroups.OnClick(RxGroups);
SetGroupState;
end;

procedure TForm1.RXItemsClickCheck(Sender: TObject);
var i,j:integer;
begin
for j:=0 to RXItems.items.Count-1 do
for i:=1 to iItemCount do
  if soft[i].itemindex=j then
      soft[i].Checked:=RXItems.Checked[j];
SetGroupState;
end;

procedure TForm1.RxGroupsClickCheck(Sender: TObject);
var i,j:integer;
begin
//for j:=1 to RxGroups.items.Count do
 j:=RxGroups.ItemIndex+1;
for i:=1 to iItemCount do
    if soft[i].GroupID=j then
      soft[i].checked:=RxGroups.Checked[j-1];
RxGroupsClick(RxGroups);
end;

procedure TForm1.RXItemsClick(Sender: TObject);
var i:integer;
begin
for i:=1 to iItemCount do
  if soft[i].itemindex=RXItems.ItemIndex then
      begin
      StatusBar1.SimpleText:=soft[i].fpexefile+' '+soft[i].params;
      break;
      end;
end;

procedure TForm1.mnuExitAfterClick(Sender: TObject);
begin
toolbutton6.Down:=mnuExitAfter.Checked;
end;

procedure TForm1.ToolButton6Click(Sender: TObject);
begin
mnuExitAfter.Checked:=ToolButton6.Down;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
timer1.Tag:=timer1.Tag-1;
Label1.Caption:='   :'#13#10+inttostr(timer1.tag);
timer1.enabled:=timer1.Tag<>0;
if timer1.enabled then exit;
GroupBox1.Visible:=false;
mnuRunClick(mnuRun);
end;

procedure TForm1.N2Click(Sender: TObject);
begin
ShellExecute(0,'open',pChar(cIniFile),nil,nil,sw_shownormal);
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if Key<>27 then exit;
timer1.enabled:=false;
GroupBox1.visible:=false;
RxItems.enabled:=true;
RxGroups.enabled:=true;
lAutoMode:=false;
end;

procedure TForm1.N4Click(Sender: TObject);
begin
messagebox(handle,pchar(
    '  1.0 alpha'#13#10'By hb860'#13#10+
    '   : '+cSoftDir),' ',mb_ok or MB_ICONINFORMATION);
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
close;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
GroupBox1.left:=(Clientwidth div 2)-(GroupBox1.Width div 2);
GroupBox1.Top:=(ClientHeight div 2)-(GroupBox1.Height div 2);
end;

procedure TForm1.mnuBuildCacheClick(Sender: TObject);
var i:integer;
begin
  if FileExists(cCacheFile) then
      if Messagebox(Handle,'   . ?','',mb_yesno or mb_iconwarning)<>mryes then exit;
try try
  oIni:=TIniFile.Create(cCacheFile);
  oini.WriteInteger('main','groupcount',RxGroups.Items.Count);
  for i:=1 to RxGroups.Items.Count do
       oini.WriteString('main','group'+inttostr(i),RxGroups.Items[i-1]);
  oIni.WriteInteger('main','itemcount',iItemCount);
  for i:=1 to iItemCount do
    begin
      oIni.WriteString('item'+inttostr(i),'Descr',soft[i].Description);
      oIni.WriteString('item'+inttostr(i),'params',soft[i].params);
      oIni.WriteString('item'+inttostr(i),'fpexefile',soft[i].fpexefile);
      oIni.WriteInteger('item'+inttostr(i),'Checked',integer(soft[i].Checked));
      oIni.WriteInteger('item'+inttostr(i),'GroupID',soft[i].GroupID);
    end;
   messagebox(handle,pchar('.    :'#13#10+cCacheFile),'',mb_ok or mb_iconInformation);
except on e:exception do messagebox(handle,pchar(e.Message),'',mb_ok or mb_iconError) end;
finally oini.free; end;
end;





constructor TSendThread.Create; //  .     
begin
 inherited Create(False); //   Create.  False 
                       // ,        (Execute)
end;

procedure TSendThread.InitUI;
var i:integer;
begin
with form1 do begin
  memo1.Clear;
  Panel2.Visible:=false;
  Panel1.Align:=alClient;
  Panel1.Visible:=true;
  for i:=1 to iItemCount do
    if soft[i].Checked then
      ProgressBar1.Max:=ProgressBar1.Max+1;
end;//with
end;

procedure TSendThread.UpdateProgress;
var i:integer;
begin
i:=iIdx;
with form1 do begin
    ProgressBar1.StepIt;
    StatusBar1.SimpleText:=' '+inttostr(ProgressBar1.Position)+'  '+inttostr(ProgressBar1.Max);
    memo1.lines.add('['+TimeToStr(now)+'] '+soft[i].fpexefile+' '+soft[i].params+'...');
end;//with
end;
procedure UpdateMemo;
begin
with form1 do
    memo1.lines[memo1.Lines.Count-1]:=memo1.lines[memo1.Lines.Count-1]+stext;
end;

Procedure FinalizeUI;
begin
with form1 do begin
    memo1.lines.add('['+TimeToStr(now)+'] ' );
    StatusBar1.SimpleText:='';
    mnuSelection.Enabled:=false;
    mnuSet.Enabled:=false;
    timer2.enabled:=mnuExitAfter.Checked;
end;
end;


procedure TSendThread.Execute;
var i:integer;
begin
if Form1.timer1.Enabled then exit;
if not lAutoMode then
if MessageBox(Form1.Handle,' ','',MB_YESNO or MB_ICONQUESTION)<>mrYes then exit;
Synchronize(InitUI);
for i:=1 to iItemCount do
  if soft[i].Checked then
    begin
   // Application.ProcessMessages;
        iIdx:=i;
        Synchronize( UpdateProgress );
        if StartProcess(soft[i].fpexefile+' '+soft[i].params) then
              stext:='[OK]';
        else
              stext:='[]';
        Synchronize( UpdateMemo );
    end;
   Synchronize( FinalizeUI );
end;




procedure TForm1.mnuRunClick(Sender: TObject);
var hThread:THandle;
    theThread:TSendThread;
begin
theThread:=TSendThread.Create(true);
NewThread.FreeOnTerminate:=true;
theThread.Resume;
end;

end.







