<?
class IPTCInfo extends Object 
{

	protected $author;
	protected $authorTitle;
	protected $caption;
	protected $captionWriter;
	protected $categoryCode;
	protected $categoryName;
	protected $suppCategoryCode;
	protected $suppCategoryName;
	protected $creationDate;
	protected $creationTime;
	protected $city;
	protected $countryCode;
	protected $countryName;
	protected $credit;
	protected $headline;
	protected $instructions;
	protected $objectName;
	protected $source;
	protected $state;	
	protected $urgency;


	protected $fieldsWithNoVars;
	
	
	
	function __construct()
	{
		$this->fieldsWithNoVars=array();
	}
	
	
	
	
	function addField(IPTCField $field)
	{
		$varName=IPTCInfo::$varsToFields[$field->get("type")];
		
		if(!empty($varName))
		{
			$value=$field->get("data");
			if(is_array($value)) $value=implode(" ",$value);
			
			$this->set($varName,trim($value));
		}
		else 
		{
			$this->fieldsWithNoVars[$field->get("type")]=trim($field->get("data"));
		}
	}
	
	
	
	private function set_countryCode($value)
	{
		$this->countryCode=$value;
		
		$this->countryName=IPTCCodes::$countries[$value];
	}
					
	private function set_countryName($value)
	{
		$this->countryName=$value;
		
		//Error by Associated Press: CountryName was CountryCode
		$nameIsCode=key_exists($value,IPTCCodes::$countries);		
		if($nameIsCode) $this->countryName=IPTCCodes::$countries[$value];
	}
	
	
	
	private function set_categoryCode($value)
	{
		$this->categoryCode=$value;
		
		$this->categoryName=IPTCCodes::$categories[$value];
	}

	
	
	private function set_suppCategoryCode($value)
	{
		$this->suppCategoryCode=$value;
		
		$this->suppCategoryName=IPTCCodes::$suppCategories[$value];
		if(empty($this->suppCategoryName)) $this->suppCategoryName=IPTCCodes::$categories[$value];
	}
	
	
	
	
public static $varsToFields= array(
// Envelope Record
"1#000" => "",   //"Model Version",
"1#005" => "",   //"Destination",
"1#020" => "",   //"File Format",
"1#022" => "",   //"File Format Version",
"1#030" => "",   //"Service Identifier",
"1#040" => "",   //"Envelope Number",
"1#050" => "",   //"Product ID",
"1#060" => "",   //"Envelope Priority",
"1#070" => "",   //"Date Sent",
"1#080" => "",   //"Time Sent",
"1#090" => "",   //"Coded Character Set",
"1#100" => "",   //"UNO (Unique Name of Object)",
"1#120" => "",   //"ARM Identifier",
"1#122" => "",   //"ARM Version",

// Application Record
"2#000" => "",   //"Record Version",
"2#003" => "",   //"Object Type Reference",
"2#005" => "objectName",   //"Object Name (Title)",
"2#007" => "",   //"Edit Status",
"2#008" => "",   //"Editorial Update",
"2#010" => "urgency",   //"Urgency",
"2#012" => "",   //"Subject Reference",
"2#015" => "categoryCode",   //"Category",
"2#020" => "suppCategoryCode",   //"Supplemental Category",
"2#022" => "",   //"Fixture Identifier",
"2#025" => "",   //"Keywords",
"2#026" => "",   //"Content Location Code",
"2#027" => "",   //"Content Location Name",
"2#030" => "",   //"Release Date",
"2#035" => "",   //"Release Time",
"2#037" => "",   //"Expiration Date",
"2#035" => "",   //"Expiration Time",
"2#040" => "instructions",   //"Special Instructions",
"2#042" => "",   //"Action Advised",
"2#045" => "",   //"Reference Service",
"2#047" => "",   //"Reference Date",
"2#050" => "",   //"Reference Number",
"2#055" => "creationDate",   //"Date Created",
"2#060" => "creationTime",   //"Time Created",
"2#062" => "",   //"Digital Creation Date",
"2#063" => "",   //"Digital Creation Time",
"2#065" => "",   //"Originating Program",
"2#070" => "",   //"Program Version",
"2#075" => "",   //"Object Cycle",
"2#080" => "author",   //"By-Line (Author)",
"2#085" => "authorTitle",   //"By-Line Title (Author Position) [Not used in Photoshop 7]",
"2#090" => "city",   //"City",
"2#092" => "",   //"Sub-Location",
"2#095" => "state",   //"Province/State",
"2#100" => "countryCode",   //"Country/Primary Location Code",
"2#101" => "countryName",   //"Country/Primary Location Name",
"2#103" => "",   //"Original Transmission Reference",
"2#105" => "headline",   //"Headline",
"2#110" => "credit",   //"Credit",
"2#115" => "source",   //"Source",
"2#116" => "",   //"Copyright Notice",
"2#118" => "",   //"Contact",
"2#120" => "caption",   //"Caption/Abstract",
"2#122" => "captionWriter",   //"Caption Writer/Editor",
"2#125" => "",   //"Rasterized Caption",
"2#130" => "",   //"Image Type",
"2#131" => "",   //"Image Orientation",
"2#135" => "",   //"Language Identifier",
"2#150" => "",   //"Audio Type",
"2#151" => "",   //"Audio Sampling Rate",
"2#152" => "",   //"Audio Sampling Resolution",
"2#153" => "",   //"Audio Duration",
"2#154" => "",   //"Audio Outcue",
"2#200" => "",   //"ObjectData Preview File Format",
"2#201" => "",   //"ObjectData Preview File Format Version",
"2#202" => "",   //"ObjectData Preview Data",

// Pre-ObjectData Descriptor Record
"7#010"  => "",   //"Size Mode",
"7#020"  => "",   //"Max Subfile Size",
"7#090"  => "",   //"ObjectData Size Announced",
"7#095"  => "",   //"Maximum ObjectData Size",

// ObjectData Record
"8#010"  => "",   //"Subfile",

// Post ObjectData Descriptor Record
"9#010"  => ""   //"Confirmed ObjectData Size"
);	



/**************************************************************************
*
*IPTC FIELD Description
*
*************************************************************************/
/*
// Envelope Record
"1#000" => "2 byte binary version number",
"1#005" => "Max 1024 characters of Destination",
"1#020" => "2 byte binary file format number, see IPTC-NAA V4 Appendix A",
"1#022" => "Binary version number of file format",
"1#030" => "Max 10 characters of Service Identifier",
"1#040" => "8 Character Envelope Number",
"1#050" => "Product ID - Max 32 characters",
"1#060" => "Envelope Priority - 1 numeric characters",
"1#070" => "Date Sent - 8 numeric characters CCYYMMDD",
"1#080" => "Time Sent - 11 characters HHMMSS�HHMM",
"1#090" => "Coded Character Set - Max 32 characters",
"1#100" => "UNO (Unique Name of Object) - 14 to 80 characters",
"1#120" => "ARM Identifier - 2 byte binary number",
"1#122" => "ARM Version - 2 byte binary number",

// Application Record
"2#000" => "Record Version - 2 byte binary number",
"2#003" => "Object Type Reference -  3 plus 0 to 64 Characters",
"2#005" => "Object Name (Title) - Max 64 characters",
"2#007" => "Edit Status - Max 64 characters",
"2#008" => "Editorial Update - 2 numeric characters",
"2#010" => "Urgency - 1 numeric character",
"2#012" => "Subject Reference - 13 to 236 characters",
"2#015" => "Category - Max 3 characters",
"2#020" => "Supplemental Category - Max 32 characters",
"2#022" => "Fixture Identifier - Max 32 characters",
"2#025" => "Keywords - Max 64 characters",
"2#026" => "Content Location Code - 3 characters",
"2#027" => "Content Location Name - Max 64 characters",
"2#030" => "Release Date - 8 numeric characters CCYYMMDD",
"2#035" => "Release Time - 11 characters HHMMSS�HHMM",
"2#037" => "Expiration Date - 8 numeric characters CCYYMMDD",
"2#035" => "Expiration Time - 11 characters HHMMSS�HHMM",
"2#040" => "Special Instructions - Max 256 Characters",
"2#042" => "Action Advised - 2 numeric characters",
"2#045" => "Reference Service - Max 10 characters",
"2#047" => "Reference Date - 8 numeric characters CCYYMMDD",
"2#050" => "Reference Number - 8 characters",
"2#055" => "Date Created - 8 numeric characters CCYYMMDD",
"2#060" => "Time Created - 11 characters HHMMSS�HHMM",
"2#062" => "Digital Creation Date - 8 numeric characters CCYYMMDD",
"2#063" => "Digital Creation Time - 11 characters HHMMSS�HHMM",
"2#065" => "Originating Program - Max 32 characters",
"2#070" => "Program Version - Max 10 characters",
"2#075" => "Object Cycle - 1 character",
"2#080" => "By-Line (Author) - Max 32 Characters",
"2#085" => "By-Line Title (Author Position) - Max 32 characters",
"2#090" => "City - Max 32 Characters",
"2#092" => "Sub-Location - Max 32 characters",
"2#095" => "Province/State - Max 32 Characters",
"2#100" => "Country/Primary Location Code - 3 alphabetic characters",
"2#101" => "Country/Primary Location Name - Max 64 characters",
"2#103" => "Original Transmission Reference - Max 32 characters",
"2#105" => "Headline - Max 256 Characters",
"2#110" => "Credit - Max 32 Characters",
"2#115" => "Source - Max 32 Characters",
"2#116" => "Copyright Notice - Max 128 Characters",
"2#118" => "Contact - Max 128 characters",
"2#120" => "Caption/Abstract - Max 2000 Characters",
"2#122" => "Caption Writer/Editor - Max 32 Characters",
"2#125" => "Rasterized Caption - 7360 bytes, 1 bit per pixel, 460x128pixel image",
"2#130" => "Image Type - 2 characters",
"2#131" => "Image Orientation - 1 alphabetic character",
"2#135" => "Language Identifier - 2 or 3 aphabetic characters",
"2#150" => "Audio Type - 2 characters",
"2#151" => "Audio Sampling Rate - 6 numeric characters",
"2#152" => "Audio Sampling Resolution - 2 numeric characters",
"2#153" => "Audio Duration - 6 numeric characters",
"2#154" => "Audio Outcue - Max 64 characters",
"2#200" => "ObjectData Preview File Format - 2 byte binary number",
"2#201" => "ObjectData Preview File Format Version - 2 byte binary number",
"2#202" => "ObjectData Preview Data - Max 256000 binary bytes",

// Pre-ObjectData Descriptor Record
"7#010"  => "Size Mode - 1 numeric character",
"7#020"  => "Max Subfile Size",
"7#090"  => "ObjectData Size Announced",
"7#095"  => "Maximum ObjectData Size",

// ObjectData Record
"8#010"  => "Subfile",

// Post ObjectData Descriptor Record
"9#010"  => "Confirmed ObjectData Size"





/******************************************************************************
* IPTC_File Formats
*******************************************************************************

00 => "No ObjectData",
01 => "IPTC-NAA Digital Newsphoto Parameter Record",
02 => "IPTC7901 Recommended Message Format",
03 => "Tagged Image File Format (Adobe/Aldus Image data)",
04 => "Illustrator (Adobe Graphics data)",
05 => "AppleSingle (Apple Computer Inc)",
06 => "NAA 89-3 (ANPA 1312)",
07 => "MacBinary II",
08 => "IPTC Unstructured Character Oriented File Format (UCOFF)",
09 => "United Press International ANPA 1312 variant",
10 => "United Press International Down-Load Message",
11 => "JPEG File Interchange (JFIF)",
12 => "Photo-CD Image-Pac (Eastman Kodak)",
13 => "Microsoft Bit Mapped Graphics File [*.BMP]",
14 => "Digital Audio File [*.WAV] (Microsoft & Creative Labs)",
15 => "Audio plus Moving Video [*.AVI] (Microsoft)",
16 => "PC DOS/Windows Executable Files [*.COM][*.EXE]",
17 => "Compressed Binary File [*.ZIP] (PKWare Inc)",
18 => "Audio Interchange File Format AIFF (Apple Computer Inc)",
19 => "RIFF Wave (Microsoft Corporation)",
20 => "Freehand (Macromedia/Aldus)",
21 => "Hypertext Markup Language - HTML (The Internet Society)",
22 => "MPEG 2 Audio Layer 2 (Musicom), ISO/IEC",
23 => "MPEG 2 Audio Layer 3, ISO/IEC",
24 => "Portable Document File (*.PDF) Adobe",
25 => "News Industry Text Format (NITF)",
26 => "Tape Archive (*.TAR)",
27 => "Tidningarnas Telegrambyr� NITF version (TTNITF DTD)",
28 => "Ritzaus Bureau NITF version (RBNITF DTD)",
29 => "Corel Draw [*.CDR]"

*/
}//CLASS END
?>