<?
/** 
 * Hauptklasse fuer alle 'Object'.
 * Hier werden die StandartFunktionen wie set(Attribut) und get(Attribut) definiert,
 * und auch Funktionen zur Arbeit mir der DatenBank.
 * 
 * @package OBJECT
 */

class Object
{
protected $errors=array();


/**
 * Konstruktor
 *
 */
function __construct()
{
	
}

/**
 * Die Funktion setzt ein Attribut auf ein bestimmtes Wert.
 * Dabei wird immer ueberprueft, ob es eine Funktion Namens "set_'attribut'" existiert:
 * wenn ja, dann wird sie aufgerufen, wenn nein, dann wird das Attribut direkt auf einen Wert gesetzt
 * Das ist sehr praktisch, weil man so zuerst beliebige Aktionen durchfuehren kann, bevor das Attribut auf einen Wert zu setzen
 *
 * @param string $class_member
 * @param mixed $value
 * @return boolean $status
 */
function set($class_member,$value)
{
	$set_func="set_".strtolower($class_member);
	
	if(method_exists($this,$set_func)) $this->$set_func($value); 
	else $this->$class_member=$value;
	
	return TRUE;
}

/**
 * Die Funktion gibt den Wert eines bestimmten Attributs zurueck. 
 * Dabei wird immer ueberprueft, ob es eine Funktion Namens "get_'attribut'" existiert:
 * wenn ja, dann wird sie aufgerufen, wenn nein, dann wird das Attribut direkt zurueckgegeben
 * Das ist sehr praktisch, weil man so zuerst beliebige Aktionen durchfuehren kann, bevor den Wert zurueckzuliefern
 *
 * @param string $class_member
 * @return mixed
 */
function get($class_member)
{
	$get_func="get_".$class_member;
	
	if(method_exists($this,$get_func)) return $this->$get_func();
	else return $this->$class_member;
}


function debug()
{
	echo "<pre>";
	print_r($this);
	echo "</pre>";
}


//======================ERRORS FUNCS====================================================================

/**
 * Ein neuer Fehler wird erzeugt und gespeichert
 *
 * @param string $text
 */
function new_error($text)
{
	$this->errors[]=$text;
	
	if(class_exists("LOGGER") && class_exists("EVENT"))
	{
		$logger=LOGGER::getInstance();
		$event=new EVENT("ClassInternError","text=".$text);
		$logger->write($event);
	}	
}

/**
 * Alle Fehler werden als ARRAY zurueckgegeben
 *
 * @return array $errors
 */
function get_errors()
{
	return $this->errors;
}

/**
 * Prueft, ob es Fehler existieren (entstanden sind)
 *
 * @return boolean
 */
function errors_exist()
{
	if(sizeof($this->errors)>0) return TRUE;
	else return FALSE;
}


/**
 * Alle ObjectAttributen und ihre Werte werden zurueckgeliefert
 *
 * @return array
 */
function object_vars()
{
	return get_object_vars($this);
}


function classMemberExists($classMember)
{
	return array_key_exists($classMember,$this->object_vars());
}

}//CLASS END
?>