<?
/** 
 * Klasse zur Verwaltung von ObjectList-en.
 * Alle Objekten werden in einem internen Array gespeichert.
 * Funktionen zum: Einfuegen neuer Objekte, Loeschen der Liste, Iterieren durch die Liste,
 * Sortieren der Liste.
 * Objekte muessen von einem Typ(sprich von einer Klasse) sein.
 * Die Unterklassen muessen den konstruktor von ObjectList aufrufen, damit die DB_QUERY-variable
 * auch dort erreichbar sein koennte.
 * 
 * @package OBJECT_LIST
 */
class ObjectList
{

protected $objects=array();
private $cur_sort_class_member=NULL;
private $counter=0;
protected $errors=array();

protected $OBJECT_CLASS_NAME;

function __construct()
{
	
}


function getObjectInstance()
{
	return new $this->OBJECT_CLASS_NAME();
}



/**
 * Ein neues Objekt wird in das interne Array eingefuegt.
 *
 * @param object $object
 */
function add_object($object)
{
	$this->objects[]=$object;
}

/**
 * Funktion zum iterieren durch die Liste.
 * Wenn keine mehr Elementen vorhanden, dann FALSE
 *
 * @return object
 */
function next_object()
{
	if($this->counter<self::num_objects())
	{
		return $this->objects[$this->counter++];
	}
	else return FALSE;
}
function next_exists()
{
	if($this->counter<self::num_objects()) return true;
	else return false;
}

function reverse()
{
	$this->counter=0;
}

function step_back()
{
	if($this->counter>0) $this->counter--;
}
/**
 * Liefert die Anzahl der Elemente in der Liste zurueck.
 *
 * @return int $number
 */
function num_objects()
{
	return sizeof($this->objects);
}

/**
 * Die Liste wieder auf 0 Elemente gesetzt
 *
 */
function clean_list()
{
	$this->objects=array();
}

/**
 * Die Liste wird aufsteigend nach einem ObjektAttribut sortiert.
 * Dafuer wird eine DienstFunktion benutzt ('sort_func_class_member').
 *
 * @param string $class_member
 * @return boolean $status
 */
function sort_by_class_member($class_member)
{
	$this->cur_sort_class_member=$class_member;
	return usort($this->objects,array("ObjectList","sort_func_class_member"));
}

function sort($param)
{
	$sort_func="sort_by_".$param;
	
	if(method_exists($this,$sort_func)) return $this->$sort_func(); 
	else return $this->sort_by_class_member($param);
}

/**
 * Die Liste wird absteigend nach einem ObjektAttribut sortiert.
 * Dafuer wird eine DienstFunktion benutzt ('sort_func_class_member').
 *
 * @param string $class_member
 * @return boolean $status
 */
function sort_desc_by_class_member($class_member)
{
	if(!self::sort_by_class_member($class_member)) return FALSE;
	
	$this->objects=array_reverse($this->objects);
	return TRUE;
}

function sort_desc($param)
{
	if(!self::sort($param)) return FALSE;
	
	$this->objects=array_reverse($this->objects);
	return TRUE;	
}

/**
 * DienstFunktion zur Sortierung der Liste.
 *
 * @param mixed $a
 * @param mixed $b
 * @return int $vergleichsResultat
 */
private function sort_func_class_member($a,$b)
{
	if($a->get($this->cur_sort_class_member)<$b->get($this->cur_sort_class_member)) return -1;
	elseif($a->get($this->cur_sort_class_member)==$b->get($this->cur_sort_class_member)) return 0;
	else return +1;
}


//======================ERRORS FUNCS====================================================================

/**
 * Ein neuer Fehler wird angemeldet und gespeichert.
 *
 * @param string $text
 */
function new_error($text)
{
	$this->errors[]=$text;
	
	$logger=LOGGER::getInstance();
	$event=new EVENT("ClassInternError","text=".$text);
	$logger->write($event);
		
}

/**
 * Array mit alen Fehlern wird zurueckgegeben.
 *
 * @return array
 */
function get_errors()
{
	return $this->errors;
}

/**
 * Prueft, ob es Fehler entstanden sind
 *
 * @return booleean $status
 */
function errors_exist()
{
	if(sizeof($this->errors)>0) return TRUE;
	else return FALSE;
}

}//END CLASS
?>