#define AppId "DAEMON Tools Lite"
#define AppName "DAEMON Tools Lite"
#define AppVersion "4.35.6.0091"
#define Appfile "DTlite.exe"
#define AppPublisherURL "http://www.daemon-tools.cc"
#define VersionInfoCompany "www.daemon-tools.cc"
#define Appsetting "{userappdata}\DAEMON Tools Lite"
#define Autorun "HKCU"

[Setup]
AppId={#AppId}
AppName={#AppName}
AppVerName={#AppName} {#AppVersion}
AppVersion={#AppVersion}
AppPublisherURL={#AppPublisherURL}
DefaultDirName={pf}\{#AppName}
DefaultGroupName={#AppId}
VersionInfoCompany={#VersionInfoCompany}
VersionInfoTextVersion={#AppVersion}
VersionInfoCopyright={#VersionInfoCompany}
SetupIconFile=DTools.ico
OutputBaseFilename=DTools
;WizardImageFile=compiler:WizModernImage-IS.bmp
;WizardSmallImageFile=compiler:wizmodernsmallimage-IS.bmp
WizardImageFile=modern-wizard.bmp
WizardSmallImageFile=modern-header.bmp
AppPublisher=Cleric
Compression=lzma2
SolidCompression=true
AllowNoIcons=true
WindowVisible=false
DirExistsWarning=yes
VersionInfoVersion={#AppVersion}
VersionInfoProductName={#AppName}
VersionInfoProductVersion={#AppVersion}
DisableFinishedPage=false
ShowLanguageDialog=no

[Components]
Name: Daemon; Description: DAEMON Tools Lite; Flags: fixed; Types: full custom
Name: yasu; Description: Y.A.S.U; Types: full

[Types]
Name: full; Description:  
Name: custom; Description:  ; Flags: iscustom

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: SPTD; Description:   SPTD 1.75; Flags: unchecked restart; GroupDescription:  :
Name: Autostart; Description:   Windows; Flags: unchecked; GroupDescription:  :
Name: Automount; Description:  ; Flags: unchecked; GroupDescription:  :
Name: Integration_MountOnEmpty; Description:     ; Flags: unchecked; GroupDescription:  :
Name: MNDStartup; Description:  Mount'n'Drive Manager  ; Flags: unchecked; GroupDescription:  :
Name: assoc; Description:    ; GroupDescription:  :
Name: assoc\ISO; Description: ISO
Name: assoc\MDX; Description: MDX
Name: assoc\MDS; Description: MDS
Name: assoc\MDF; Description: MDF
Name: assoc\B5T; Description: B5T
Name: assoc\B6T; Description: B6T
Name: assoc\BWT; Description: BWT
Name: assoc\CCD; Description: CCD
Name: assoc\ISZ; Description: ISZ
Name: assoc\PDI; Description: PDI
Name: assoc\CDI; Description: CDI
Name: assoc\CUE; Description: CUE; Flags: unchecked
Name: assoc\NRG; Description: NRG; Flags: unchecked

[Files]
;Source: SPTDinst.exe; Flags: deleteafterinstall ignoreversion; DestDir: {tmp}
Source: SPTDinst-x86.exe; DestDir: {tmp}; MinVersion: 0.0,5.01.2600; Flags: ignoreversion deleteafterinstall; Check: not IsWin64
Source: SPTDinst-x64.exe; DestDir: {tmp}; Check: IsWin64; MinVersion: 0.0,5.01.2600; Flags: ignoreversion 64bit deleteafterinstall
Source: {App}\*; DestDir: {app}; Flags: ignoreversion recursesubdirs createallsubdirs
Source: YASU\*; DestDir: {app}; Flags: ignoreversion

[Run]
Filename: {app}\{#Appfile}; WorkingDir: {app}; Description:  {#AppName}; Flags: postinstall unchecked nowait
Filename: {tmp}\SPTDinst-x86.exe; Parameters: add /q; Flags: Unchecked WaitUntilIdle 32bit; Tasks: SPTD; Check: not IsWin64; 
Filename: {tmp}\SPTDinst-x64.exe; Parameters: add /q; Flags: Unchecked WaitUntilIdle 64bit; Tasks: SPTD; Check: IsWin64; 

[Icons]
Name: {group}\{#AppName}; Filename: {app}\{#Appfile}; WorkingDir: {app}
Name: {group}\YASU; Filename: {app}\YASU.exe; WorkingDir: {app}; Components: yasu
Name: {group}\ {#AppName}; Filename: {uninstallexe}; IconFilename: {app}\{#Appfile}; Iconindex: 0
Name: {commondesktop}\{#AppName}; Filename: {app}\{#Appfile}; Tasks: desktopicon; WorkingDir: {app}
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\{#AppName}; Filename: {app}\{#Appfile}; Tasks: quicklaunchicon; WorkingDir: {app}

[Registry]
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: Autostart; ValueData: $00000000; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: Automount; ValueData: $00000000; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: Integration_MountOnEmpty; ValueData: $00000000; Components: ; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: MNDStartup; ValueData: $00000000; Components: ; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\View; ValueType: dword; ValueName: Language; ValueData: $00000419; Flags: uninsdeletekey
Root: HKLM; SubKey: SOFTWARE\14919ea49a8f3b4aa3cf1058d9a64cec; ValueType: string; ValueName: s; ValueData: 1; Flags: uninsdeletekey dontcreatekey
Root: HKLM; Subkey: Software\DT Soft; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: CheckForUpdate; ValueData: $00000000
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: UpdateCheckCounter; ValueData: $00000000
;Tasks
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: Autostart; ValueData: $00000001; Tasks: Autostart; Flags: uninsdeletekey

Root: HKCU; SubKey: Software\Microsoft\Windows\CurrentVersion\Run; ValueType: string; ValueName: DAEMON Tools Lite; ValueData: """{app}\DTLite.exe"" -autorun"; Flags: uninsdeletevalue; Components: ; Tasks: Autostart

Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: Automount; ValueData: $00000001; Tasks: Automount; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: Integration_MountOnEmpty; ValueData: $00000001; Tasks: Integration_MountOnEmpty; Flags: uninsdeletekey
Root: HKCU; SubKey: Software\DT Soft\DAEMON Tools Pro\Config; ValueType: dword; ValueName: MNDStartup; ValueData: $00000001; Flags: uninsdeletekey; Tasks: MNDStartup
Root: HKCR; SubKey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Flags: uninsdeletekey
Root: HKCR; SubKey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Flags: uninsdeletekey
; .iso
Root: HKCR; Subkey: .iso; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('iso'); Tasks: assoc\iso
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\iso
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\iso
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\iso

; .mdx
Root: HKCR; Subkey: .mdx; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('mdx'); Tasks: assoc\mdx
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\mdx
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\mdx
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\mdx

; .mds
Root: HKCR; Subkey: .mds; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('mds'); Tasks: assoc\mds
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\mds
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\mds
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\mds

; .mdf
Root: HKCR; Subkey: .mdf; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('mdf'); Tasks: assoc\mdf
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\mdf
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\mdf
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\mdf

; .b5t
Root: HKCR; Subkey: .b5t; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('b5t'); Tasks: assoc\b5t
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\b5t
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\b5t
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\b5t

; .b6t
Root: HKCR; Subkey: .b6t; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('b6t'); Tasks: assoc\b6t
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\b6t
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\b6t
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\b6t

; .bwt
Root: HKCR; Subkey: .bwt; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('bwt'); Tasks: assoc\bwt
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\bwt
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\bwt
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\bwt

; .ccd
Root: HKCR; Subkey: .ccd; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('ccd'); Tasks: assoc\ccd
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\ccd
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\ccd
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\ccd

; .isz
Root: HKCR; Subkey: .isz; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('isz'); Tasks: assoc\isz
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\isz
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\isz
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\isz

; .pdi
Root: HKCR; Subkey: .pdi; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('pdi'); Tasks: assoc\pdi
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\pdi
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\pdi
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\pdi

; .cdi
Root: HKCR; Subkey: .cdi; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('cdi'); Tasks: assoc\cdi
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\cdi
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\cdi
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\cdi

; .cue
Root: HKCR; Subkey: .cue; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('cue'); Tasks: assoc\cue
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: assoc\cue
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: assoc\cue
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: assoc\cue

; .nrg
Root: HKCR; Subkey: .nrg; ValueType: string; ValueName: ; ValueData: DAEMON.Tools.Lite; Flags: uninsdeletevalue; BeforeInstall: BackupData('nrg'); Tasks: Assoc\NRG
Root: HKCR; Subkey: DAEMON.Tools.Lite; ValueType: string; Flags: uninsdeletekey; Tasks: Assoc\NRG
Root: HKCR; Subkey: DAEMON.Tools.Lite\DefaultIcon; ValueType: string; ValueData: {app}\{#Appfile},0; Tasks: Assoc\NRG
Root: HKCR; Subkey: DAEMON.Tools.Lite\shell\open\command; ValueType: string; ValueData: """{app}\{#Appfile}"" -shellmount ""%1"""; Tasks: Assoc\NRG

[UninstallDelete]
Name: {commonappdata}\DAEMON Tools Lite; Type: filesandordirs

[Languages]
Name: russian; MessagesFile: compiler:Languages\Russian.isl

[Messages]
BeveledLabel= Created by Cleric

[Code]
//procedure CurStepChanged(CurStep: TSetupStep);
//  var
//  ResultCode: Integer;
//begin
//  if CurStep=ssInstall then
//  begin
//  If not FileExists(ExpandConstant('{sys}')+'\drivers\sptd.sys') then
//      begin
//      Exec('SPTDinst.exe', ' -y -gm2 -fm0', '', SW_SHOW, ewWaitUntilIdle, ResultCode)
//      end
//  else
//     begin
//     end
//  end;
//end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
  var
  ResultCode: Integer;
begin
  if CurUninstallStep = usUninstall then
        begin
	      UninstallProgressForm.Visible:= False;
		  if Exec(ExpandConstant('{app}\uninst.exe'), '', '', SW_SHOW, ewWaitUntilTerminated, ResultCode) then
          begin
//              MsgBox('!     ' #13 '    , ' #13 '    !',mbInformation, mb_Ok)
              MsgBox('!     ' #13 '    , ' #13 '    !',mbError, mb_Ok)
              DelTree(ExpandConstant('{app}'), True, True, True);
              DelTree(ExpandConstant('{#Appsetting}'), True, True, True);
              RegDeleteValue({#Autorun},'Software\Microsoft\Windows\CurrentVersion\Run', '{#AppName}');
              DelTree(ExpandConstant('{#Appsetting}'), True, True, True);
//            UninstallProgressForm.Visible:= True;
            end
        end;
end;

procedure BackupData(FileExt: String);
var
  OldValueData: string;
begin
  if RegKeyExists(HKCR, '.' + FileExt) then
    begin
      RegQueryStringValue(HKCR, '.' + FileExt, '', OldValueData);
      RegWriteStringValue(HKLM, 'SOFTWARE\DT Soft\DAEMON Tools Pro\FileTypesSave\.' + FileExt, 'Type', OldValueData);
    end;
end;
