#RequireAdmin
#NoTrayIcon

#include <GUIConstantsEx.au3>
#include <ButtonConstants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#include <GUIScrollbars_Ex.au3>

Global $sProgs1 = 'Setup1.exe=Opera|Seup2.exe=2|Seup3.exe=3|Seup4.exe=4|Seup5.exe=5'
Global $sProgs2 = 'Setup1.exe=1|Seup2.exe=2|Seup3.exe=3|Seup4.exe=4|Seup5.exe=5'

;Only for tests
$sProgs1 &= 'Setup1.exe=1|Seup2.exe=2|Seup3.exe=3|Seup4.exe=4|Seup5.exe=5'
$sProgs1 &= 'Setup1.exe=1|Seup2.exe=2|Seup3.exe=3|Seup4.exe=4|Seup5.exe=5'

Global Const $aProgs1 = StringSplit($sProgs1, '|'), $aProgs2 = StringSplit($sProgs2, '|')

Global $anCheckBoxes1[$aProgs1[0] + 1], $anCheckBoxes2[$aProgs2[0] + 1]
Global $aCheckedIcons1[$aProgs1[0] + 1], $aCheckedIcons2[$aProgs2[0] + 1]
Global $aUnCheckedIcons1[$aProgs1[0] + 1], $aUnCheckedIcons2[$aProgs2[0] + 1]
Global $aCompleteIcons1[$aProgs1[0] + 1], $aCompleteIcons2[$aProgs2[0] + 1]
Global $aInstalledIcons1[$aProgs1[0] + 1], $aInstalledIcons2[$aProgs2[0] + 1]
Global $aDescription1[$aProgs1[0] + 1], $aDescription2[$aProgs1[0] + 1]

$hGUI = GUICreate("My GUI Tab", 600, 550)
GUISetBkColor(0xFFFFFF)

$hChild_Ctrls1 = _SetProgrs_Proc("images", $aProgs1, $anCheckBoxes1, $aCheckedIcons1, $aUnCheckedIcons1, $aInstalledIcons1, $aCompleteIcons1)
$hChild_Ctrls2 = _SetProgrs_Proc("images", $aProgs2, $anCheckBoxes2, $aCheckedIcons2, $aUnCheckedIcons2, $aInstalledIcons2, $aCompleteIcons2)

$hTab = GUICtrlCreateTab(10, 10, 580, 480)

$nTab1 = GUICtrlCreateTabItem("Tab1")
$nTab2 = GUICtrlCreateTabItem("Tab2")
GUICtrlCreateTabItem("")

$nStart = GUICtrlCreateButton("", 30, 510, 150, 30)

GUISetState(@SW_SHOW, $hGUI)

While 1
	$nMsg = GUIGetMsg()
	
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			Exit
		Case $hTab
			_SwitchTabs_Proc(GUICtrlRead($hTab), -1)
		Case $nStart
			_SwitchTabs_Proc(GUICtrlRead($hTab), 0)
			
			Switch GUICtrlRead($hTab)
				Case 0
					_CheckProgrs_Proc($hChild_Ctrls1, $aProgs1, $anCheckBoxes1, $aCheckedIcons1, $aUnCheckedIcons1, $aInstalledIcons1, $aCompleteIcons1)
				Case 1
					_CheckProgrs_Proc($hChild_Ctrls2, $aProgs2, $anCheckBoxes2, $aCheckedIcons2, $aUnCheckedIcons2, $aInstalledIcons2, $aCompleteIcons2)
			EndSwitch
		Case Else
			If $nMsg <= 0 Then
				ContinueLoop
			EndIf
			
			For $iPrg = 1 To 2
				$aProgs = Execute('$aProgs' & $iPrg)
				
				For $i = 1 To $aProgs[0]
					$aCheckBox = Execute('$anCheckBoxes' & $iPrg & '[$i]')
					
					If $nMsg = $aCheckBox[2] Then
						If GUICtrlRead($nMsg - 1) = $GUI_CHECKED Then
							GUICtrlSetState($nMsg - 1, $GUI_UNCHECKED)
						Else
							GUICtrlSetState($nMsg - 1, $GUI_CHECKED)
						EndIf
						
						ExitLoop
					EndIf
				Next
			Next
	EndSwitch
WEnd

Func _SetProgrs_Proc($sIconsPath, $aProgs, ByRef $anCheckBoxes, ByRef $aCheckedIcons, ByRef $aUnCheckedIcons, ByRef $aInstalledIcons, ByRef $aCompleteIcons)
	Local $iTop = 40, $iLeft = 40
	
	Local $hChild_Ctrls = GUICreate("", 570, 450, 12, 33, $WS_CHILD, -1, $hGUI)
	GUISetBkColor(0xFFFFFF)
	
	For $i = 1 To $aProgs[0]
		$aCheckedIcons[$i] = $sIconsPath & "\01.ico"
		$aUnCheckedIcons[$i] = $sIconsPath & "\01.ico"
		$aInstalledIcons[$i] = $sIconsPath & "\03.ico"
		$aCompleteIcons[$i] = $sIconsPath & "\02.ico"
		
		$anCheckBoxes[$i] = _GUICtrlCreateCheckboxEx(StringRegExpReplace($aProgs[$i], '^.*=', ''), $iLeft, $iTop, -1, 15, $aUnCheckedIcons[$i], 0, 0xFFFFFF, 0xFF0000)
		
		$iTop += 40
		
;~ 		If $iTop > 480 Then
;~ 			$iTop = 40
;~ 			$iLeft += 170
;~ 		EndIf
	Next
	
	If $iTop > 470 Then
		_GUIScrollbars_Generate($hChild_Ctrls, 0, $iTop, 0, 0, 1)
	EndIf
	
	GUISetState(@SW_SHOW, $hChild_Ctrls)
	GUISwitch($hGUI)
	
	Return $hChild_Ctrls
EndFunc

Func _CheckProgrs_Proc($hChild_Ctrls, $aProgs, $anCheckBoxes, $aCheckedIcons, $aUnCheckedIcons, $aInstalledIcons, $aCompleteIcons)
	Local $aCheckBox, $iScrollPos
	
	For $i = 1 To $aProgs[0]
		$aCheckBox = $anCheckBoxes[$i]
		
		If GUICtrlRead($aCheckBox[1]) = $GUI_CHECKED Then
			$sProgName = StringRegExpReplace($aProgs[$i], '^.*=', '')
			$sProgExe = StringRegExpReplace($aProgs[$i], '=.*$', '')
			
			_GUICtrlSetImageEx($hChild_Ctrls, $aCheckBox[0], $aInstalledIcons[$i])
			MsgBox(64, $sProgName, "zz", 3)
			_GUICtrlSetImageEx($hChild_Ctrls, $aCheckBox[0], $aCompleteIcons[$i])
		Else
			_GUICtrlSetImageEx($hChild_Ctrls, $aCheckBox[0], $aUnCheckedIcons[$i])
		EndIf
	Next
EndFunc

Func _SwitchTabs_Proc($iTab, $iMode = -1)
	Switch $iTab
		Case 0
			If $iMode = -1 Then
				GUISetState(@SW_HIDE, $hChild_Ctrls2)
				GUISetState(@SW_SHOW, $hChild_Ctrls1)
			EndIf
			
			ControlFocus($hChild_Ctrls1, "", "")
		Case 1
			If $iMode = -1 Then
				GUISetState(@SW_HIDE, $hChild_Ctrls1)
				GUISetState(@SW_SHOW, $hChild_Ctrls2)
			EndIf
			
			ControlFocus($hChild_Ctrls2, "", "")
	EndSwitch
EndFunc

Func _GUICtrlSetImageEx($hWnd, $nCtrlID, $sFileName, $iIconName = "", $iIconType = 0)
	Local $iScrollPage, $iScrollPos
	
	$iScrollPage = _GUIScrollBars_GetScrollInfoPage($hWnd, $SB_VERT)
	
	If $iScrollPage > 0 Then
		$iScrollPos = _GUIScrollBars_GetScrollPos($hWnd, $SB_VERT)
		_GUIScrollBars_SetScrollInfoPos($hWnd, $SB_VERT, 0)
		GUICtrlSetImage($nCtrlID, $sFileName, $iIconName, $iIconType)
		_GUIScrollBars_SetScrollInfoPos($hWnd, $SB_VERT, $iScrollPos)
	Else
		GUICtrlSetImage($nCtrlID, $sFileName, $iIconName, $iIconType)
	EndIf
EndFunc

Func _GUICtrlCreateCheckboxEx($sText, $iLeft, $iTop, $iWidth, $iHeight, $sIconFile = "", $nIconIndex = 0, $sBackColor = "" , $sTextColor = "")
    Local $aCheckBoxID[3]
	
	$aCheckBoxID[0] = GUICtrlCreateIcon($sIconFile, $nIconIndex, $iLeft - 20, $iTop - 1, 16, 16)
	GUICtrlSetState($aCheckBoxID[0], $GUI_DISABLE)
	
    $aCheckBoxID[1] = GUICtrlCreateCheckbox("", $iLeft, $iTop, 16, 16)
    $aCheckBoxID[2] = GUICtrlCreateLabel($sText, $iLeft + 15, $iTop, $iWidth, $iHeight)
	
    If $sTextColor <> "" And $aCheckBoxID[2] Then
        GUICtrlSetColor($aCheckBoxID[2], $sTextColor)
    EndIf
	
    If $sBackColor <> "" And $aCheckBoxID[2] Then
        GUICtrlSetBkColor($aCheckBoxID[2], $sBackColor)
    EndIf
	
    Return $aCheckBoxID
EndFunc
