; <AUT2EXE VERSION: 3.1.1.0>

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\DiskPartitioner\DiskPartitioner.au3>
; ----------------------------------------------------------------------------

#Region - Compiler Directives

#Compiler_Prompt = n
#Compiler_AUT2EXE = Icons\Aut2Exe.exe
#Compiler_Icon = Icons\0.ico
#Compiler_Compression = 0
#Compiler_Allow_Decompile = n
#Compiler_PassPhrase =
#Compiler_Res_Fileversion = 1.5.0.0
#Compiler_Res_Description = Disk Partitioner
#Compiler_Res_LegalCopyright = tonedeaf
#Compiler_Res_Comment = Front-end for DISKPART.EXE
#Compiler_Res_Field1Name = Platform
#Compiler_Res_Field1Value = NT
#Compiler_Res_Field2Name = Autoit version
#Compiler_res_Field2Value = 3.1.1.106(beta)
#Compiler_Run_AU3Check = y
#Compiler_Run_Before =
#Compiler_Run_After =

#EndRegion

Opt("MustDeclareVars", 1)	; Variables must be pre-declared
Opt("GUICloseOnEsc", 0)
Opt("TrayIconHide", 1)	; Hide the AutoIt tray icon
Opt("WinWaitDelay", 10)

; Flags declarations
;If Not IsDeclared("CB_SETCURSEL") Then Global Const $CB_SETCURSEL = 0x14E

; Global variable declarations
Global $msg	; application wide message variable
Global $DebugMode = False	; Set to TRUE to echo all communication with Diskpart.exe

Global $afrmDiskPart
Global $afrmSelectDisk
Global $afrmCreatePartition
Global $afrmDeletePartition
Global $afrmEditPartition

; Global variables
Global $asDisks
Global $asPartitions

Global $sCurrentDisk

; Deal with difference in output from Diskpart in XP and Vista
Global $sNewLine
If (@OSBuild >= 6000) Then
	$sNewLine = @CRLF & @CRLF
Else
	$sNewLine = @LF & @LF
EndIf


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\Constants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Author(s):      Jeremy Landes <jlandes at landeserve dot com>
;                 David Nuttall <danuttall at rocketmail dot com>
;                 Philip Gump   <cyberslug at autoitscript dot com>
;                 Holger Kotsch   <Holger dot Kotsch at GMX dot de>
;                 Dave...
; Description:    This file is meant to be included in an AutoIt v3 script to
;                 provide access to these constants.
;
; ------------------------------------------------------------------------------


;==============================================
; AutoIt Options Constants
;==============================================
; Sets the way coords are used in the mouse and pixel functions
Global Const $OPT_COORDSRELATIVE   =    0 ; Relative coords to the active window
Global Const $OPT_COORDSABSOLUTE   =    1 ; Absolute screen coordinates (default)
Global Const $OPT_COORDSCLIENT     =    2 ; Relative coords to client area

; Sets how errors are handled if a Run/RunWait function fails
Global Const $OPT_ERRORSILENT      =    0 ; Silent error (@error set to 1)
Global Const $OPT_ERRORFATAL       =    1 ; Fatal error (default)

; Alters the use of Caps Lock
Global Const $OPT_CAPSNOSTORE      =    0 ; Don't store/restore Caps Lock state
Global Const $OPT_CAPSSTORE        =    1 ; Store/restore Caps Lock state (default)

; Alters the method that is used to match window titles
Global Const $OPT_MATCHSTART       =    1 ; Match the title from the start (default)
Global Const $OPT_MATCHANY         =    2 ; Match any substring in the title
Global Const $OPT_MATCHEXACT       =    3 ; Match the title exactly
Global Const $OPT_MATCHADVANCED    =    4 ; Use advanced window matching (deprecated)


;==============================================
; File Constants
;==============================================
; Indicates file copy and install options
Global Const $FC_NOOVERWRITE       =    0 ; Do not overwrite existing files (default)
Global Const $FC_OVERWRITE         =    1 ; Overwrite existing files

; Indicates file date and time options
Global Const $FT_MODIFIED          =    0 ; Date and time file was last modified (default)
Global Const $FT_CREATED           =    1 ; Date and time file was created
Global Const $FT_ACCESSED          =    2 ; Date and time file was last accessed

; Indicates the mode to open a file
Global Const $FO_READ              =    0   ; Read mode
Global Const $FO_APPEND            =    1   ; Write mode (append)
Global Const $FO_OVERWRITE         =    2   ; Write mode (erase previous contents)
Global Const $FO_BINARY            =    16  ; Read/Write mode binary
Global Const $FO_UNICODE           =    32  ; Write mode Unicode UTF16-LE
Global Const $FO_UTF16_LE          =    32  ; Write mode Unicode UTF16-LE
Global Const $FO_UTF16_BE          =    64  ; Write mode Unicode UTF16-BE
Global Const $FO_UTF8              =    128 ; Write mode Unicode UTF8

; Indicates file read options
Global Const $EOF                  =   -1 ; End-of-file reached

; Indicates file open and save dialog options
Global Const $FD_FILEMUSTEXIST     =    1 ; File must exist
Global Const $FD_PATHMUSTEXIST     =    2 ; Path must exist
Global Const $FD_MULTISELECT       =    4 ; Allow multi-select
Global Const $FD_PROMPTCREATENEW   =    8 ; Prompt to create new file
Global Const $FD_PROMPTOVERWRITE   =   16 ; Prompt to overWrite file


;==============================================
; Keyboard Constants
;==============================================
; Changes how keys are processed
Global Const $KB_SENDSPECIAL       =    0 ; Special characters indicate key presses (default)
Global Const $KB_SENDRAW           =    1 ; Keys are sent raw

; Sets the state of the Caps Lock key
Global Const $KB_CAPSOFF           =    0 ; Caps Lock is off
Global Const $KB_CAPSON            =    1 ; Caps Lock is on


;==============================================
; Message Box Constants
;==============================================
; Indicates the buttons displayed in the message box
Global Const $MB_OK                =    0 ; One push button: OK
Global Const $MB_OKCANCEL          =    1 ; Two push buttons: OK and Cancel
Global Const $MB_ABORTRETRYIGNORE  =    2 ; Three push buttons: Abort, Retry, and Ignore
Global Const $MB_YESNOCANCEL       =    3 ; Three push buttons: Yes, No, and Cancel
Global Const $MB_YESNO             =    4 ; Two push buttons: Yes and No
Global Const $MB_RETRYCANCEL       =    5 ; Two push buttons: Retry and Cancel

; Displays an icon in the message box
Global Const $MB_ICONHAND          =   16 ; Stop-sign icon
Global Const $MB_ICONQUESTION      =   32 ; Question-mark icon
Global Const $MB_ICONEXCLAMATION   =   48 ; Exclamation-point icon
Global Const $MB_ICONASTERISK      =   64 ; Icon consisting of an 'i' in a circle

; Indicates the default button
Global Const $MB_DEFBUTTON1        =    0 ; The first button is the default button
Global Const $MB_DEFBUTTON2        =  256 ; The second button is the default button
Global Const $MB_DEFBUTTON3        =  512 ; The third button is the default button

; Indicates the modality of the dialog box
Global Const $MB_APPLMODAL         =    0 ; Application modal
Global Const $MB_SYSTEMMODAL       = 4096 ; System modal
Global Const $MB_TASKMODAL         = 8192 ; Task modal

; Indicates miscellaneous message box attributes
Global Const $MB_TOPMOST            = 262144 ; top-most attribute
Global Const $MB_RIGHTJUSTIFIED     = 524288 ; right-justified title and text

; Indicates the button selected in the message box
Global Const $IDTIMEOUT            =   -1 ; The message box timed out
Global Const $IDOK                 =    1 ; OK button was selected
Global Const $IDCANCEL             =    2 ; Cancel button was selected
Global Const $IDABORT              =    3 ; Abort button was selected
Global Const $IDRETRY              =    4 ; Retry button was selected
Global Const $IDIGNORE             =    5 ; Ignore button was selected
Global Const $IDYES                =    6 ; Yes button was selected
Global Const $IDNO                 =    7 ; No button was selected
Global Const $IDTRYAGAIN           =   10 ; Try Again button was selected
Global Const $IDCONTINUE           =   11 ; Continue button was selected


;==============================================
; Progress and Splash Constants
;==============================================
; Indicates properties of the displayed progress or splash dialog
Global Const $DLG_NOTITLE          =    1 ; Titleless window
Global Const $DLG_NOTONTOP         =    2 ; Without "always on top" attribute
Global Const $DLG_TEXTLEFT         =    4 ; Left justified text
Global Const $DLG_TEXTRIGHT        =    8 ; Right justified text
Global Const $DLG_MOVEABLE         =   16 ; Window can be moved

Global Const $DLG_TEXTVCENTER      =   32 ; Splash text centered vertically


;==============================================
; Tray Tip Constants
;==============================================
; Indicates the type of Balloon Tip to display
Global Const $TIP_ICONNONE         =    0 ; No icon (default)
Global Const $TIP_ICONASTERISK     =    1 ; Info icon
Global Const $TIP_ICONEXCLAMATION  =    2 ; Warning icon
Global Const $TIP_ICONHAND         =    3 ; Error icon
Global Const $TIP_NOSOUND          =   16 ; No sound


;==============================================
; Mouse Constants
;==============================================
; Indicates current mouse cursor
Global Const $IDC_UNKNOWN          =    0 ; Unknown cursor
Global Const $IDC_APPSTARTING      =    1 ; Standard arrow and small hourglass
Global Const $IDC_ARROW            =    2 ; Standard arrow
Global Const $IDC_CROSS            =    3 ; Crosshair
Global Const $IDC_HELP             =    4 ; Arrow and question mark
Global Const $IDC_IBEAM            =    5 ; I-beam
Global Const $IDC_ICON             =    6 ; Obsolete
Global Const $IDC_NO               =    7 ; Slashed circle
Global Const $IDC_SIZE             =    8 ; Obsolete
Global Const $IDC_SIZEALL          =    9 ; Four-pointed arrow pointing N, S, E, and W
Global Const $IDC_SIZENESW         =   10 ; Double-pointed arrow pointing NE and SW
Global Const $IDC_SIZENS           =   11 ; Double-pointed arrow pointing N and S
Global Const $IDC_SIZENWSE         =   12 ; Double-pointed arrow pointing NW and SE
Global Const $IDC_SIZEWE           =   13 ; Double-pointed arrow pointing W and E
Global Const $IDC_UPARROW          =   14 ; Vertical arrow
Global Const $IDC_WAIT             =   15 ; Hourglass


;==============================================
; Process Constants
;==============================================
; Indicates the type of shutdown
Global Const $SD_LOGOFF            =    0 ; Logoff
Global Const $SD_SHUTDOWN          =    1 ; Shutdown
Global Const $SD_REBOOT            =    2 ; Reboot
Global Const $SD_FORCE             =    4 ; Force
Global Const $SD_POWERDOWN         =    8 ; Power down


;==============================================
; String Constants
;==============================================
; Indicates if string operations should be case sensitive
Global Const $STR_NOCASESENSE      =    0 ; Not case sensitive (default)
Global Const $STR_CASESENSE        =    1 ; Case sensitive

; IndicateS the type of stripping that should be performed
Global Const $STR_STRIPLEADING     =    1 ; Strip leading whitespace
Global Const $STR_STRIPTRAILING    =    2 ; Strip trailing whitespace
Global Const $STR_STRIPSPACES      =    4 ; Strip double (or more) spaces between words
Global Const $STR_STRIPALL         =    8 ; Strip all spaces (over-rides all other flags)


;==============================================
; Tray Constants
;==============================================
; Tray predefined ID's
Global Const $TRAY_ITEM_EXIT			= 3
Global Const $TRAY_ITEM_PAUSE			= 4
Global Const $TRAY_ITEM_FIRST			= 7

; Tray menu/item state values
Global Const $TRAY_CHECKED				= 1
Global Const $TRAY_UNCHECKED			= 4
Global Const $TRAY_ENABLE				= 64
Global Const $TRAY_DISABLE				= 128
Global Const $TRAY_FOCUS				= 256
Global Const $TRAY_DEFAULT				= 512

; Tray event values
Global Const $TRAY_EVENT_SHOWICON		= -3
Global Const $TRAY_EVENT_HIDEICON		= -4
Global Const $TRAY_EVENT_FLASHICON		= -5
Global Const $TRAY_EVENT_NOFLASHICON	= -6
Global Const $TRAY_EVENT_PRIMARYDOWN	= -7
Global Const $TRAY_EVENT_PRIMARYUP		= -8
Global Const $TRAY_EVENT_SECONDARYDOWN	= -9
Global Const $TRAY_EVENT_SECONDARYUP	= -10
Global Const $TRAY_EVENT_MOUSEOVER		= -11
Global Const $TRAY_EVENT_MOUSEOUT		= -12
Global Const $TRAY_EVENT_PRIMARYDOUBLE	= -13
Global Const $TRAY_EVENT_SECONDARYDOUBLE= -14

;==============================================
; STDIO Constants
;==============================================
Global Const $STDIN_CHILD	= 1
Global Const $STDOUT_CHILD	= 2
Global Const $STDERR_CHILD	= 4

;==============================================
; Colour Constants
;==============================================
Global Const $COLOR_BLACK   = 0x000000
Global Const $COLOR_SILVER  = 0xC0C0C0
Global Const $COLOR_GRAY    = 0x808080
Global Const $COLOR_WHITE   = 0xFFFFFF
Global Const $COLOR_MAROON  = 0x800000
Global Const $COLOR_RED     = 0xFF0000
Global Const $COLOR_PURPLE  = 0x800080
Global Const $COLOR_FUCHSIA = 0xFF00FF
Global Const $COLOR_GREEN   = 0x008000
Global Const $COLOR_LIME    = 0x00FF00
Global Const $COLOR_OLIVE   = 0x808000
Global Const $COLOR_YELLOW  = 0xFFFF00
Global Const $COLOR_NAVY    = 0x000080
Global Const $COLOR_BLUE    = 0x0000FF
Global Const $COLOR_TEAL    = 0x008080
Global Const $COLOR_AQUA    = 0x00FFFF

;==============================================
; Reg Value type Constants
;==============================================
Global Const $REG_NONE							= 0
Global Const $REG_SZ							= 1
Global Const $REG_EXPAND_SZ						= 2
Global Const $REG_BINARY						= 3
Global Const $REG_DWORD							= 4
Global Const $REG_DWORD_BIG_ENDIAN				= 5
Global Const $REG_LINK							= 6
Global Const $REG_MULTI_SZ						= 7
Global Const $REG_RESOURCE_LIST					= 8
Global Const $REG_FULL_RESOURCE_DESCRIPTOR		= 9
Global Const $REG_RESOURCE_REQUIREMENTS_LIST	= 10

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\Constants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\GUIConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Stub file providing compatibility between the new
;						library design and the old.
;
; ------------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\GUIDefaultConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Language:       English
; Description:    AutoIt-GUI default control styles.
;
; ------------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\WindowsConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Windows constants.
;
; ------------------------------------------------------------------------------

; Window Styles
Global Const $WS_TILED				= 0
Global Const $WS_OVERLAPPED 		= 0
Global Const $WS_MAXIMIZEBOX		= 0x00010000
Global Const $WS_MINIMIZEBOX		= 0x00020000
Global Const $WS_TABSTOP			= 0x00010000
Global Const $WS_GROUP				= 0x00020000
Global Const $WS_SIZEBOX			= 0x00040000
Global Const $WS_THICKFRAME			= 0x00040000
Global Const $WS_SYSMENU			= 0x00080000
Global Const $WS_HSCROLL			= 0x00100000
Global Const $WS_VSCROLL			= 0x00200000
Global Const $WS_DLGFRAME 			= 0x00400000
Global Const $WS_BORDER				= 0x00800000
Global Const $WS_CAPTION			= 0x00C00000
Global Const $WS_OVERLAPPEDWINDOW	= 0x00CF0000
Global Const $WS_TILEDWINDOW		= 0x00CF0000
Global Const $WS_MAXIMIZE			= 0x01000000
Global Const $WS_CLIPCHILDREN		= 0x02000000
Global Const $WS_CLIPSIBLINGS		= 0x04000000
Global Const $WS_DISABLED 			= 0x08000000
Global Const $WS_VISIBLE			= 0x10000000
Global Const $WS_MINIMIZE			= 0x20000000
Global Const $WS_CHILD				= 0x40000000
Global Const $WS_POPUP				= 0x80000000
Global Const $WS_POPUPWINDOW		= 0x80880000

; Dialog Styles
Global Const $DS_MODALFRAME 		= 0x80
Global Const $DS_SETFOREGROUND		= 0x00000200
Global Const $DS_CONTEXTHELP		= 0x00002000

; Window Extended Styles
Global Const $WS_EX_ACCEPTFILES			= 0x00000010
Global Const $WS_EX_MDICHILD			= 0x00000040
Global Const $WS_EX_APPWINDOW			= 0x00040000
Global Const $WS_EX_CLIENTEDGE			= 0x00000200
Global Const $WS_EX_CONTEXTHELP			= 0x00000400
Global Const $WS_EX_DLGMODALFRAME 		= 0x00000001
Global Const $WS_EX_LEFTSCROLLBAR 		= 0x00004000
Global Const $WS_EX_OVERLAPPEDWINDOW	= 0x00000300
Global Const $WS_EX_RIGHT				= 0x00001000
Global Const $WS_EX_STATICEDGE			= 0x00020000
Global Const $WS_EX_TOOLWINDOW			= 0x00000080
Global Const $WS_EX_TOPMOST				= 0x00000008
Global Const $WS_EX_TRANSPARENT			= 0x00000020
Global Const $WS_EX_WINDOWEDGE			= 0x00000100
Global Const $WS_EX_LAYERED				= 0x00080000

; Messages
Global Const $WM_SIZE = 0x05
Global Const $WM_SIZING = 0x0214
Global Const $WM_USER = 0X400
Global Const $WM_GETTEXTLENGTH = 0x000E
Global Const $WM_GETTEXT = 0x000D

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\WindowsConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\AVIConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    AVI Constants.
;
; ------------------------------------------------------------------------------

; Styles
Global Const $ACS_CENTER			= 1
Global Const $ACS_TRANSPARENT		= 2
Global Const $ACS_AUTOPLAY			= 4
Global Const $ACS_TIMER				= 8
Global Const $ACS_NONTRANSPARENT	= 16

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\AVIConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ComboConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    ComboBox constants.
;
; ------------------------------------------------------------------------------
; Combo
Global Const $CBS_SIMPLE			= 0x0001
Global Const $CBS_DROPDOWN			= 0x0002
Global Const $CBS_DROPDOWNLIST		= 0x0003
Global Const $CBS_AUTOHSCROLL		= 0x0040
Global Const $CBS_OEMCONVERT		= 0x0080
Global Const $CBS_SORT				= 0x0100
Global Const $CBS_NOINTEGRALHEIGHT	= 0x0400
Global Const $CBS_DISABLENOSCROLL	= 0x0800
Global Const $CBS_UPPERCASE			= 0x2000
Global Const $CBS_LOWERCASE			= 0x4000

; Error checking
Global Const $CB_ERR = -1
Global Const $CB_ERRATTRIBUTE = -3
Global Const $CB_ERRREQUIRED = -4
Global Const $CB_ERRSPACE = -2
Global Const $CB_OKAY = 0

; Messages to send to combobox
Global Const $CB_ADDSTRING = 0x143
Global Const $CB_DELETESTRING = 0x144
Global Const $CB_DIR = 0x145
Global Const $CB_FINDSTRING = 0x14C
Global Const $CB_FINDSTRINGEXACT = 0x158
Global Const $CB_GETCOUNT = 0x146
Global Const $CB_GETCURSEL = 0x147
Global Const $CB_GETDROPPEDCONTROLRECT = 0x152
Global Const $CB_GETDROPPEDSTATE = 0x157
Global Const $CB_GETDROPPEDWIDTH = 0X15f
Global Const $CB_GETEDITSEL = 0x140
Global Const $CB_GETEXTENDEDUI = 0x156
Global Const $CB_GETHORIZONTALEXTENT = 0x15d
Global Const $CB_GETITEMDATA = 0x150
Global Const $CB_GETITEMHEIGHT = 0x154
Global Const $CB_GETLBTEXT = 0x148
Global Const $CB_GETLBTEXTLEN = 0x149
Global Const $CB_GETLOCALE = 0x15A
Global Const $CB_GETMINVISIBLE = 0x1702
Global Const $CB_GETTOPINDEX = 0x15b
Global Const $CB_INITSTORAGE = 0x161
Global Const $CB_LIMITTEXT = 0x141
Global Const $CB_RESETCONTENT = 0x14B
Global Const $CB_INSERTSTRING = 0x14A
Global Const $CB_SELECTSTRING = 0x14D
Global Const $CB_SETCURSEL = 0x14E
Global Const $CB_SETDROPPEDWIDTH = 0x160
Global Const $CB_SETEDITSEL = 0x142
Global Const $CB_SETEXTENDEDUI = 0x155
Global Const $CB_SETHORIZONTALEXTENT = 0x15e
Global Const $CB_SETITEMDATA = 0x151
Global Const $CB_SETITEMHEIGHT = 0x153
Global Const $CB_SETLOCALE = 0x15
Global Const $CB_SETMINVISIBLE = 0x1701
Global Const $CB_SETTOPINDEX = 0x15c
Global Const $CB_SHOWDROPDOWN = 0x14F

; attributes
Global Const $CB_DDL_ARCHIVE = 0x20
Global Const $CB_DDL_DIRECTORY = 0x10
Global Const $CB_DDL_DRIVES = 0x4000
Global Const $CB_DDL_EXCLUSIVE = 0x8000
Global Const $CB_DDL_HIDDEN = 0x2
Global Const $CB_DDL_READONLY = 0x1
Global Const $CB_DDL_READWRITE = 0x0
Global Const $CB_DDL_SYSTEM = 0x4

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ComboConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\DateTimeConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.1.1 (beta)
; Language:       English
; Description:    DateTime Control Constants.
;
; ------------------------------------------------------------------------------

; Date
Global Const $DTS_SHORTDATEFORMAT	= 0
Global Const $DTS_UPDOWN			= 1
Global Const $DTS_SHOWNONE			= 2
Global Const $DTS_LONGDATEFORMAT	= 4
Global Const $DTS_TIMEFORMAT		= 9
Global Const $DTS_RIGHTALIGN		= 32

; MonthCal
Global Const $MCS_NOTODAY			= 16
Global Const $MCS_NOTODAYCIRCLE		= 8
Global Const $MCS_WEEKNUMBERS		= 4

Global Const $MCM_FIRST = 0x1000
Global Const $MCM_GETCOLOR = ($MCM_FIRST + 11)
Global Const $MCM_GETFIRSTDAYOFWEEK = ($MCM_FIRST + 16)
Global Const $MCM_GETMAXSELCOUNT = ($MCM_FIRST + 3)
Global Const $MCM_GETMAXTODAYWIDTH = ($MCM_FIRST + 21)
Global Const $MCM_GETMINREQRECT = ($MCM_FIRST + 9)
Global Const $MCM_GETMONTHDELTA = ($MCM_FIRST + 19)
Global Const $MCS_MULTISELECT = 0x2
Global Const $MCM_SETCOLOR = ($MCM_FIRST + 10)
Global Const $MCM_SETFIRSTDAYOFWEEK = ($MCM_FIRST + 15)
Global Const $MCM_SETMAXSELCOUNT = ($MCM_FIRST + 4)
Global Const $MCM_SETMONTHDELTA = ($MCM_FIRST + 20)

Global Const $MCSC_BACKGROUND = 0
Global Const $MCSC_MONTHBK = 4
Global Const $MCSC_TEXT = 1
Global Const $MCSC_TITLEBK = 2
Global Const $MCSC_TITLETEXT = 3
Global Const $MCSC_TRAILINGTEXT = 5

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\DateTimeConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\EditConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Language:       English
; Description:    Edit Constants.
;
; ------------------------------------------------------------------------------

; Styles
Global Const $ES_LEFT				= 0
Global Const $ES_CENTER				= 1
Global Const $ES_RIGHT				= 2
Global Const $ES_MULTILINE			= 4
Global Const $ES_UPPERCASE			= 8
Global Const $ES_LOWERCASE			= 16
Global Const $ES_PASSWORD			= 32
Global Const $ES_AUTOVSCROLL		= 64
Global Const $ES_AUTOHSCROLL		= 128
Global Const $ES_NOHIDESEL			= 256
Global Const $ES_OEMCONVERT			= 1024
Global Const $ES_READONLY			= 2048
Global Const $ES_WANTRETURN			= 4096
Global Const $ES_NUMBER				= 8192
;Global Const $ES_DISABLENOSCROLL = 8192
;Global Const $ES_SUNKEN = 16384
;Global Const $ES_VERTICAL = 4194304
;Global Const $ES_SELECTIONBAR = 16777216

; Error checking
Global Const $EC_ERR = -1

; Messages to send to edit control
Global Const $ECM_FIRST = 0X1500
Global Const $EM_CANUNDO = 0xC6
Global Const $EM_EMPTYUNDOBUFFER = 0xCD
Global Const $EM_GETFIRSTVISIBLELINE = 0xCE
Global Const $EM_GETLINE = 0xC4
Global Const $EM_GETLINECOUNT = 0xBA
Global Const $EM_GETMODIFY = 0xB8
Global Const $EM_GETRECT = 0xB2
Global Const $EM_GETSEL = 0xB0
Global Const $EM_LINEFROMCHAR = 0xC9
Global Const $EM_LINEINDEX = 0xBB
Global Const $EM_LINELENGTH = 0xC1
Global Const $EM_LINESCROLL = 0xB6
Global Const $EM_REPLACESEL = 0xC2
Global Const $EM_SCROLL = 0xB5
Global Const $EM_SCROLLCARET = 0x00B7
Global Const $EM_SETMODIFY = 0xB9
Global Const $EM_SETSEL = 0xB1
Global Const $EM_UNDO = 0xC7
Global Const $EM_SETREADONLY = 0x00CF
Global Const $EM_SETTABSTOPS = 0x00CB

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\EditConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\StaticConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Static (label, pic, icon) Constants.
;
; ------------------------------------------------------------------------------

; Label/Pic/Icon
Global Const $SS_LEFT			= 0
Global Const $SS_CENTER			= 1
Global Const $SS_RIGHT			= 2
Global Const $SS_ICON			= 3
Global Const $SS_BLACKRECT		= 4
Global Const $SS_GRAYRECT		= 5
Global Const $SS_WHITERECT		= 6
Global Const $SS_BLACKFRAME		= 7
Global Const $SS_GRAYFRAME		= 8
Global Const $SS_WHITEFRAME		= 9
Global Const $SS_SIMPLE			= 11
Global Const $SS_LEFTNOWORDWRAP	= 12
Global Const $SS_BITMAP			= 15
Global Const $SS_ETCHEDHORZ		= 16
Global Const $SS_ETCHEDVERT		= 17
Global Const $SS_ETCHEDFRAME	= 18
Global Const $SS_NOPREFIX		= 0x0080
Global Const $SS_NOTIFY			= 0x0100
Global Const $SS_CENTERIMAGE	= 0x0200
Global Const $SS_RIGHTJUST		= 0x0400
Global Const $SS_SUNKEN			= 0x1000

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\StaticConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ListBoxConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    ListBox Constants.
;
; ------------------------------------------------------------------------------

; Styles
Global Const $LBS_NOTIFY			= 0x0001
Global Const $LBS_SORT				= 0x0002
Global Const $LBS_USETABSTOPS		= 0x0080
Global Const $LBS_NOINTEGRALHEIGHT	= 0x0100
Global Const $LBS_DISABLENOSCROLL	= 0x1000
Global Const $LBS_NOSEL				= 0x4000
Global Const $LBS_STANDARD			= 0xA00003

; Errors
Global Const $LB_ERR = -1
Global Const $LB_ERRATTRIBUTE = -3
Global Const $LB_ERRREQUIRED = -4
Global Const $LB_ERRSPACE = -2

; Messages to send to listbox
Global Const $LB_ADDSTRING = 0x180
Global Const $LB_DELETESTRING = 0x182
Global Const $LB_DIR = 0x18D
Global Const $LB_FINDSTRING = 0x18F
Global Const $LB_FINDSTRINGEXACT = 0x1A2
Global Const $LB_GETANCHORINDEX = 0x019D
Global Const $LB_GETCARETINDEX = 0x019F
Global Const $LB_GETCOUNT = 0x18B
Global Const $LB_GETCURSEL = 0x188
Global Const $LB_GETHORIZONTALEXTENT = 0x193
Global Const $LB_GETITEMRECT = 0x198
Global Const $LB_GETLISTBOXINFO = 0x01B2
Global Const $LB_GETLOCALE = 0x1A6
Global Const $LB_GETSEL = 0x0187
Global Const $LB_GETSELCOUNT = 0x0190
Global Const $LB_GETSELITEMS = 0X191
Global Const $LB_GETTEXT = 0x0189
Global Const $LB_GETTEXTLEN = 0x018A
Global Const $LB_GETTOPINDEX = 0x018E
Global Const $LB_INSERTSTRING = 0x181
Global Const $LB_RESETCONTENT = 0x184
Global Const $LB_SELECTSTRING = 0x18C
Global Const $LB_SETITEMHEIGHT = 0x1A0
Global Const $LB_SELITEMRANGE = 0x19B
Global Const $LB_SELITEMRANGEEX = 0x0183
Global Const $LB_SETANCHORINDEX = 0x19C
Global Const $LB_SETCARETINDEX = 0x19E
Global Const $LB_SETCURSEL = 0x186
Global Const $LB_SETHORIZONTALEXTENT = 0x194
Global Const $LB_SETLOCALE = 0x1A5
Global Const $LB_SETSEL = 0x0185
Global Const $LB_SETTOPINDEX = 0x197

Global Const $LBS_MULTIPLESEL = 0x8

; attributes
Global Const $DDL_ARCHIVE = 0x20
Global Const $DDL_DIRECTORY = 0x10
Global Const $DDL_DRIVES = 0x4000
Global Const $DDL_EXCLUSIVE = 0x8000
Global Const $DDL_HIDDEN = 0x2
Global Const $DDL_READONLY = 0x1
Global Const $DDL_READWRITE = 0x0
Global Const $DDL_SYSTEM = 0x4

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ListBoxConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ListViewConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    ListView Constants.
;
; ------------------------------------------------------------------------------

; Styles
Global Const $LVS_ICON	 			= 0x0000
Global Const $LVS_REPORT 			= 0x0001
Global Const $LVS_SMALLICON			= 0x0002
Global Const $LVS_LIST				= 0x0003
Global Const $LVS_EDITLABELS		= 0x0200
Global Const $LVS_NOCOLUMNHEADER	= 0x4000
Global Const $LVS_NOSORTHEADER		= 0x8000
Global Const $LVS_SINGLESEL			= 0x0004
Global Const $LVS_SHOWSELALWAYS		= 0x0008
Global Const $LVS_SORTASCENDING		= 0X0010
Global Const $LVS_SORTDESCENDING	= 0x0020
Global Const $LVS_NOLABELWRAP		= 0x0080

; listView Extended Styles
Global Const $LVS_EX_FULLROWSELECT		= 0x00000020
Global Const $LVS_EX_GRIDLINES			= 0x00000001
Global Const $LVS_EX_SUBITEMIMAGES		= 0x00000002
Global Const $LVS_EX_CHECKBOXES			= 0x00000004
Global Const $LVS_EX_TRACKSELECT		= 0x00000008
Global Const $LVS_EX_HEADERDRAGDROP		= 0x00000010
Global Const $LVS_EX_FLATSB				= 0x00000100
Global Const $LVS_EX_BORDERSELECT		= 0x00008000
;Global Const $LVS_EX_MULTIWORKAREAS		= 0x00002000
;Global Const $LVS_EX_SNAPTOGRID			= 0x00080000
;Global Const $LVS_EX_DOUBLEBUFFER		= 0x00010000
Global Const $LVS_EX_HIDELABELS = 0x20000
Global Const $LVS_EX_INFOTIP = 0x400
Global Const $LVS_EX_LABELTIP = 0x4000
Global Const $LVS_EX_ONECLICKACTIVATE = 0x40
Global Const $LVS_EX_REGIONAL = 0x200
Global Const $LVS_EX_SINGLEROW = 0x40000
Global Const $LVS_EX_TWOCLICKACTIVATE = 0x80
;~ Global Const $LVS_EX_TRACKSELECT = 0x8
Global Const $LVS_EX_UNDERLINEHOT = 0x800
Global Const $LVS_EX_UNDERLINECOLD = 0x1000

; error
Global Const $LV_ERR = -1


; Messages to send to listview
Global Const $CCM_FIRST = 0x2000
Global Const $CCM_GETUNICODEFORMAT = ($CCM_FIRST + 6)
Global Const $CCM_SETUNICODEFORMAT = ($CCM_FIRST + 5)
Global Const $CLR_NONE = 0xFFFFFFFF
Global Const $LVM_FIRST = 0x1000

Global Const $LV_VIEW_DETAILS = 0x1
Global Const $LV_VIEW_ICON = 0x0
Global Const $LV_VIEW_LIST = 0x3
Global Const $LV_VIEW_SMALLICON = 0x2
Global Const $LV_VIEW_TILE = 0x4

Global Const $LVCF_FMT = 0x1
Global Const $LVCF_WIDTH = 0x2
Global Const $LVCF_TEXT = 0x4
Global Const $LVCFMT_CENTER = 0x2
Global Const $LVCFMT_LEFT = 0x0
Global Const $LVCFMT_RIGHT = 0x1

Global Const $LVA_ALIGNLEFT = 0x1
Global Const $LVA_ALIGNTOP = 0x2
Global Const $LVA_DEFAULT = 0x0
Global Const $LVA_SNAPTOGRID = 0x5

Global Const $LVIF_STATE = 0x8
Global Const $LVIF_TEXT = 0x1

Global Const $LVFI_PARAM = 0x1
Global Const $LVFI_PARTIAL = 0x8
Global Const $LVFI_STRING = 0x2
Global Const $LVFI_WRAP = 0x20

Global Const $VK_LEFT = 0x25
Global Const $VK_RIGHT = 0x27
Global Const $VK_UP = 0x26
Global Const $VK_DOWN = 0x28
Global Const $VK_END = 0x23
Global Const $VK_PRIOR = 0x21
Global Const $VK_NEXT = 0x22

Global Const $LVIR_BOUNDS = 0

Global Const $LVIS_CUT = 0x4
Global Const $LVIS_DROPHILITED = 0x8
Global Const $LVIS_FOCUSED = 0x1
Global Const $LVIS_OVERLAYMASK = 0xF00
Global Const $LVIS_SELECTED = 0x2
Global Const $LVIS_STATEIMAGEMASK = 0xF000

Global Const $LVM_ARRANGE = ($LVM_FIRST + 22)
Global Const $LVM_CANCELEDITLABEL = ($LVM_FIRST + 179)
Global Const $LVM_DELETECOLUMN = 0x101C
Global Const $LVM_DELETEITEM = 0x1008
Global Const $LVM_DELETEALLITEMS = 0x1009
Global Const $LVM_EDITLABELA = ($LVM_FIRST + 23)
Global Const $LVM_EDITLABEL = $LVM_EDITLABELA
Global Const $LVM_ENABLEGROUPVIEW = ($LVM_FIRST + 157)
Global Const $LVM_ENSUREVISIBLE = ($LVM_FIRST + 19)
Global Const $LVM_FINDITEM = ($LVM_FIRST + 13)
Global Const $LVM_GETBKCOLOR = ($LVM_FIRST + 0)
Global Const $LVM_GETCALLBACKMASK = ($LVM_FIRST + 10)
Global Const $LVM_GETCOLUMNORDERARRAY = ($LVM_FIRST + 59)
Global Const $LVM_GETCOLUMNWIDTH = ($LVM_FIRST + 29)
Global Const $LVM_GETCOUNTPERPAGE = ($LVM_FIRST + 40)
Global Const $LVM_GETEDITCONTROL = ($LVM_FIRST + 24)
Global Const $LVM_GETEXTENDEDLISTVIEWSTYLE = ($LVM_FIRST + 55)
Global Const $LVM_GETHEADER = ($LVM_FIRST + 31)
Global Const $LVM_GETHOTCURSOR = ($LVM_FIRST + 63)
Global Const $LVM_GETHOTITEM = ($LVM_FIRST + 61)
Global Const $LVM_GETHOVERTIME = ($LVM_FIRST + 72)
Global Const $LVM_GETIMAGELIST = ($LVM_FIRST + 2)
Global Const $LVM_GETITEMA = ($LVM_FIRST + 5)
Global Const $LVM_GETITEMCOUNT = 0x1004
Global Const $LVM_GETITEMSTATE = ($LVM_FIRST + 44)
Global Const $LVM_GETITEMTEXTA = ($LVM_FIRST + 45);
Global Const $LVM_GETNEXTITEM = 0x100c
Global Const $LVM_GETSELECTEDCOLUMN = ($LVM_FIRST + 174)
Global Const $LVM_GETSELECTEDCOUNT = ($LVM_FIRST + 50)
Global Const $LVM_GETSUBITEMRECT = ($LVM_FIRST + 56);
Global Const $LVM_GETTOPINDEX = ($LVM_FIRST + 39)
Global Const $LVM_GETUNICODEFORMAT = $CCM_GETUNICODEFORMAT
Global Const $LVM_GETVIEW = ($LVM_FIRST + 143)
Global Const $LVM_GETVIEWRECT = ($LVM_FIRST + 34)
Global Const $LVM_INSERTCOLUMNA = ($LVM_FIRST + 27)
Global Const $LVM_INSERTITEMA = ($LVM_FIRST + 7)
Global Const $LVM_REDRAWITEMS = ($LVM_FIRST + 21)
Global Const $LVM_SETUNICODEFORMAT = $CCM_SETUNICODEFORMAT
Global Const $LVM_SCROLL = ($LVM_FIRST + 20)
Global Const $LVM_SETBKCOLOR = 0x1001
Global Const $LVM_SETCALLBACKMASK = ($LVM_FIRST + 11)
Global Const $LVM_SETCOLUMNA = ($LVM_FIRST + 26)
Global Const $LVM_SETCOLUMNORDERARRAY = ($LVM_FIRST + 58)
Global Const $LVM_SETCOLUMNWIDTH = 0x101E
Global Const $LVM_SETEXTENDEDLISTVIEWSTYLE = 0x1036
Global Const $LVM_SETHOTITEM = ($LVM_FIRST + 60)
Global Const $LVM_SETHOVERTIME = ($LVM_FIRST + 71)
Global Const $LVM_SETICONSPACING = ($LVM_FIRST + 53)
Global Const $LVM_SETITEMCOUNT = ($LVM_FIRST + 47)
Global Const $LVM_SETITEMPOSITION = ($LVM_FIRST + 15)
Global Const $LVM_SETITEMSTATE = ($LVM_FIRST + 43)
Global Const $LVM_SETITEMTEXTA = ($LVM_FIRST + 46)
Global Const $LVM_SETSELECTEDCOLUMN = ($LVM_FIRST + 140)
Global Const $LVM_SETTEXTCOLOR = ($LVM_FIRST + 36)
Global Const $LVM_SETTEXTBKCOLOR = ($LVM_FIRST + 38)
Global Const $LVM_SETVIEW = ($LVM_FIRST + 142)
Global Const $LVM_UPDATE = ($LVM_FIRST + 42)

Global Const $LVNI_ABOVE = 0x100
Global Const $LVNI_BELOW = 0x200
Global Const $LVNI_TOLEFT = 0x400
Global Const $LVNI_TORIGHT = 0x800
Global Const $LVNI_ALL = 0x0
Global Const $LVNI_CUT = 0x4
Global Const $LVNI_DROPHILITED = 0x8
Global Const $LVNI_FOCUSED = 0x1
Global Const $LVNI_SELECTED = 0x2

Global Const $LVSCW_AUTOSIZE = -1
Global Const $LVSCW_AUTOSIZE_USEHEADER = -2

Global Const $LVSICF_NOINVALIDATEALL = 0x1
Global Const $LVSICF_NOSCROLL = 0x2

Global Const $LVSIL_NORMAL = 0
Global Const $LVSIL_SMALL = 1
Global Const $LVSIL_STATE = 2

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ListViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\SliderConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Slider Constants
;
; ------------------------------------------------------------------------------

; Styles
Global Const $TBS_AUTOTICKS	= 0x0001
Global Const $TBS_VERT		= 0x0002
Global Const $TBS_HORZ		= 0x0000
Global Const $TBS_TOP		= 0x0004
Global Const $TBS_BOTTOM	= 0x0000
Global Const $TBS_LEFT		= 0x0004
Global Const $TBS_RIGHT		= 0x0000
Global Const $TBS_BOTH		= 0x0008
Global Const $TBS_NOTICKS	= 0x0010
Global Const $TBS_NOTHUMB	= 0x0080

; Messages
Global Const $TWM_USER = 0x400	; WM_USER
Global Const $TBM_CLEARTICS = ($TWM_USER + 9)
Global Const $TBM_GETLINESIZE = ($TWM_USER + 24)
Global Const $TBM_GETPAGESIZE = ($TWM_USER + 22)
Global Const $TBM_GETNUMTICS = ($TWM_USER + 16)
Global Const $TBM_GETPOS = $TWM_USER
Global Const $TBM_GETRANGEMAX = ($TWM_USER + 2)
Global Const $TBM_GETRANGEMIN = ($TWM_USER + 1)
Global Const $TBM_SETLINESIZE = ($TWM_USER + 23)
Global Const $TBM_SETPAGESIZE = ($TWM_USER + 21)
Global Const $TBM_SETPOS = ($TWM_USER + 5)
Global Const $TBM_SETTICFREQ = ($TWM_USER + 20)

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\SliderConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\TreeViewConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    TreeView Constants.
;
; ------------------------------------------------------------------------------

; Styles
Global Const $TVS_HASBUTTONS     	= 0x0001
Global Const $TVS_HASLINES       	= 0x0002
Global Const $TVS_LINESATROOT    	= 0x0004
;Global Const $TVS_EDITLABELS      = 0x0008
Global Const $TVS_DISABLEDRAGDROP	= 0x0010
Global Const $TVS_SHOWSELALWAYS		= 0x0020
;Global Const $TVS_RTLREADING     = 0x0040
Global Const $TVS_NOTOOLTIPS		= 0x0080
Global Const $TVS_CHECKBOXES		= 0x0100
Global Const $TVS_TRACKSELECT		= 0x0200
Global Const $TVS_SINGLEEXPAND		= 0x0400
;Global Const $TVS_INFOTIP        = 0x0800
Global Const $TVS_FULLROWSELECT		= 0x1000
Global Const $TVS_NOSCROLL			= 0x2000
Global Const $TVS_NONEVENHEIGHT		= 0x4000

Global Const $TVE_COLLAPSE			= 0x0001
Global Const $TVE_EXPAND			= 0x0002
Global Const $TVE_TOGGLE			= 0x0003
Global Const $TVE_EXPANDPARTIAL		= 0x4000
Global Const $TVE_COLLAPSERESET = 0x8000

Global Const $TVGN_ROOT				= 0x0000
Global Const $TVGN_NEXT				= 0x0001
Global Const $TVGN_PARENT			= 0x0003
Global Const $TVGN_CHILD			= 0x0004
Global Const $TVGN_CARET			= 0x0009

Global Const $TVI_ROOT				= 0xFFFF0000
Global Const $TVI_FIRST				= 0xFFFF0001
Global Const $TVI_LAST				= 0xFFFF0002
Global Const $TVI_SORT				= 0xFFFF0003

Global Const $TVIF_TEXT = 0x0001
Global Const $TVIF_IMAGE			= 0x0002
Global Const $TVIF_PARAM			= 0x0004
Global Const $TVIF_STATE			= 0x0008
Global Const $TVIF_HANDLE			= 0x0010
Global Const $TVIF_SELECTEDIMAGE	= 0x0020
Global Const $TVIF_CHILDREN			= 0x0040

Global Const $TVIS_SELECTED			= 0x0002
Global Const $TVIS_CUT				= 0x0004
Global Const $TVIS_DROPHILITED		= 0x0008
Global Const $TVIS_BOLD				= 0x0010
Global Const $TVIS_EXPANDED			= 0x0020
Global Const $TVIS_EXPANDEDONCE		= 0x0040
Global Const $TVIS_EXPANDPARTIAL	= 0x0080
Global Const $TVIS_OVERLAYMASK		= 0x0F00
Global Const $TVIS_STATEIMAGEMASK = 0xF000

; Messages to send to TreeView
Global Const $TV_FIRST				= 0x1100
Global Const $TVM_INSERTITEM		= $TV_FIRST + 0
Global Const $TVM_DELETEITEM		= $TV_FIRST + 1
Global Const $TVM_EXPAND			= $TV_FIRST + 2
Global Const $TVM_GETCOUNT			= $TV_FIRST + 5
Global Const $TVM_GETINDENT			= $TV_FIRST + 6
Global Const $TVM_SETINDENT			= $TV_FIRST + 7
Global Const $TVM_GETIMAGELIST		= $TV_FIRST + 8
Global Const $TVM_SETIMAGELIST		= $TV_FIRST + 9
Global Const $TVM_GETNEXTITEM		= $TV_FIRST + 10
Global Const $TVM_SELECTITEM		= $TV_FIRST + 11
Global Const $TVM_GETITEM			= $TV_FIRST + 12
Global Const $TVM_SETITEM			= $TV_FIRST + 13
Global Const $TVM_SORTCHILDREN		= $TV_FIRST + 19
Global Const $TVM_ENSUREVISIBLE		= $TV_FIRST + 20
Global Const $TVM_SETBKCOLOR		= $TV_FIRST + 29
Global Const $TVM_SETTEXTCOLOR		= $TV_FIRST + 30
Global Const $TVM_GETBKCOLOR		= $TV_FIRST + 31
Global Const $TVM_GETTEXTCOLOR		= $TV_FIRST + 32
Global Const $TVM_SETLINECOLOR		= $TV_FIRST + 40
Global Const $TVM_GETLINECOLOR		= $TV_FIRST + 41

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\TreeViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\UpDownConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    UpDown Constants.
;
; ------------------------------------------------------------------------------

; Styles
Global Const $UDS_WRAP 				= 0x0001
Global Const $UDS_SETBUDDYINT		= 0x0002
Global Const $UDS_ALIGNRIGHT 		= 0x0004
Global Const $UDS_ALIGNLEFT			= 0x0008
Global Const $UDS_ARROWKEYS 		= 0x0020
Global Const $UDS_HORZ 				= 0x0040
Global Const $UDS_NOTHOUSANDS 		= 0x0080

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\UpDownConstants.au3>
; ----------------------------------------------------------------------------


; Control default styles
Global Const $GUI_SS_DEFAULT_AVI		= $ACS_TRANSPARENT
Global Const $GUI_SS_DEFAULT_BUTTON		= 0
Global Const $GUI_SS_DEFAULT_CHECKBOX	= 0
Global Const $GUI_SS_DEFAULT_COMBO		= BitOR($CBS_DROPDOWN, $CBS_AUTOHSCROLL, $WS_VSCROLL)
Global Const $GUI_SS_DEFAULT_DATE		= $DTS_LONGDATEFORMAT
Global Const $GUI_SS_DEFAULT_EDIT		= BitOR($ES_WANTRETURN, $WS_VSCROLL, $WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL)
Global Const $GUI_SS_DEFAULT_GRAPHIC	= 0
Global Const $GUI_SS_DEFAULT_GROUP		= 0
Global Const $GUI_SS_DEFAULT_ICON		= $SS_NOTIFY
Global Const $GUI_SS_DEFAULT_INPUT		= BitOR($ES_LEFT, $ES_AUTOHSCROLL)
Global Const $GUI_SS_DEFAULT_LABEL		= 0
Global Const $GUI_SS_DEFAULT_LIST		= BitOR($LBS_SORT, $WS_BORDER, $WS_VSCROLL, $LBS_NOTIFY)
Global Const $GUI_SS_DEFAULT_LISTVIEW	= BitOR($LVS_SHOWSELALWAYS, $LVS_SINGLESEL)
Global Const $GUI_SS_DEFAULT_MONTHCAL	= 0
Global Const $GUI_SS_DEFAULT_PIC		= $SS_NOTIFY
Global Const $GUI_SS_DEFAULT_PROGRESS	= 0
Global Const $GUI_SS_DEFAULT_RADIO		= 0
Global Const $GUI_SS_DEFAULT_SLIDER		= $TBS_AUTOTICKS
Global Const $GUI_SS_DEFAULT_TAB		= 0
Global Const $GUI_SS_DEFAULT_TREEVIEW	= BitOR($TVS_HASBUTTONS, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_DISABLEDRAGDROP, $TVS_SHOWSELALWAYS)
Global Const $GUI_SS_DEFAULT_UPDOWN		= $UDS_ALIGNRIGHT
Global Const $GUI_SS_DEFAULT_GUI		= BitOR($WS_MINIMIZEBOX, $WS_CAPTION, $WS_POPUP, $WS_SYSMENU)

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\GUIDefaultConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\GUIConstantsEx.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Constants to be used in GUI applications.
;
; ------------------------------------------------------------------------------


; Events and messages
Global Const $GUI_EVENT_CLOSE			= -3
Global Const $GUI_EVENT_MINIMIZE		= -4
Global Const $GUI_EVENT_RESTORE			= -5
Global Const $GUI_EVENT_MAXIMIZE		= -6
Global Const $GUI_EVENT_PRIMARYDOWN		= -7
Global Const $GUI_EVENT_PRIMARYUP		= -8
Global Const $GUI_EVENT_SECONDARYDOWN	= -9
Global Const $GUI_EVENT_SECONDARYUP		= -10
Global Const $GUI_EVENT_MOUSEMOVE		= -11
Global Const $GUI_EVENT_RESIZED			= -12
Global Const $GUI_EVENT_DROPPED			= -13

Global Const $GUI_RUNDEFMSG				= 'GUI_RUNDEFMSG'

; State
Global Const $GUI_AVISTOP		= 0
Global Const $GUI_AVISTART		= 1
Global Const $GUI_AVICLOSE		= 2

Global Const $GUI_CHECKED		= 1
Global Const $GUI_INDETERMINATE	= 2
Global Const $GUI_UNCHECKED		= 4

Global Const $GUI_DROPACCEPTED	= 8
Global Const $GUI_NODROPACCEPTED = 4096
Global Const $GUI_ACCEPTFILES	= $GUI_DROPACCEPTED	; to be suppressed

Global Const $GUI_SHOW			= 16
Global Const $GUI_HIDE 			= 32
Global Const $GUI_ENABLE		= 64
Global Const $GUI_DISABLE		= 128

Global Const $GUI_FOCUS			= 256
Global Const $GUI_NOFOCUS		= 8192
Global Const $GUI_DEFBUTTON		= 512

Global Const $GUI_EXPAND		= 1024
Global Const $GUI_ONTOP			= 2048


; Font
Global Const $GUI_FONTITALIC	= 2
Global Const $GUI_FONTUNDER		= 4
Global Const $GUI_FONTSTRIKE	= 8


; Resizing
Global Const $GUI_DOCKAUTO			= 0x0001
Global Const $GUI_DOCKLEFT			= 0x0002
Global Const $GUI_DOCKRIGHT			= 0x0004
Global Const $GUI_DOCKHCENTER		= 0x0008
Global Const $GUI_DOCKTOP			= 0x0020
Global Const $GUI_DOCKBOTTOM		= 0x0040
Global Const $GUI_DOCKVCENTER		= 0x0080
Global Const $GUI_DOCKWIDTH			= 0x0100
Global Const $GUI_DOCKHEIGHT		= 0x0200

Global Const $GUI_DOCKSIZE			= 0x0300	; width+height
Global Const $GUI_DOCKMENUBAR		= 0x0220	; top+height
Global Const $GUI_DOCKSTATEBAR		= 0x0240	; bottom+height
Global Const $GUI_DOCKALL			= 0x0322	; left+top+width+height
Global Const $GUI_DOCKBORDERS		= 0x0066	; left+top+right+bottom

; Graphic
Global Const $GUI_GR_CLOSE		= 1
Global Const $GUI_GR_LINE		= 2
Global Const $GUI_GR_BEZIER		= 4
Global Const $GUI_GR_MOVE		= 6
Global Const $GUI_GR_COLOR		= 8
Global Const $GUI_GR_RECT		= 10
Global Const $GUI_GR_ELLIPSE	= 12
Global Const $GUI_GR_PIE		= 14
Global Const $GUI_GR_DOT		= 16
Global Const $GUI_GR_PIXEL		= 18
Global Const $GUI_GR_HINT		= 20
Global Const $GUI_GR_REFRESH	= 22
Global Const $GUI_GR_PENSIZE	= 24
Global Const $GUI_GR_NOBKCOLOR	= -2

; Background color special flags
Global Const $GUI_BKCOLOR_DEFAULT = -1
Global Const $GUI_BKCOLOR_TRANSPARENT = -2
Global Const $GUI_BKCOLOR_LV_ALTERNATE = 0xFE000000

; Other
Global Const $GUI_WS_EX_PARENTDRAG =      0x00100000

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\GUIConstantsEx.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\WindowsConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\WindowsConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ComboConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ComboConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ListViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ListViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\StaticConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\StaticConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ButtonConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Button (Group, Radio, Checkbox, Button) Constants.
;
; ------------------------------------------------------------------------------

; Group
Global Const $BS_GROUPBOX		= 0x0007

; Button
Global Const $BS_BOTTOM			= 0x0800
Global Const $BS_CENTER			= 0x0300
Global Const $BS_DEFPUSHBUTTON	= 0x0001
Global Const $BS_LEFT			= 0x0100
Global Const $BS_MULTILINE		= 0x2000
Global Const $BS_PUSHBOX		= 0x000A
Global Const $BS_PUSHLIKE		= 0x1000
Global Const $BS_RIGHT			= 0x0200
Global Const $BS_RIGHTBUTTON	= 0x0020
Global Const $BS_TOP			= 0x0400
Global Const $BS_VCENTER		= 0x0C00
Global Const $BS_FLAT			= 0x8000
Global Const $BS_ICON			= 0x0040
Global Const $BS_BITMAP			= 0x0080
Global Const $BS_NOTIFY			= 0x4000

; Checkbox
Global Const $BS_3STATE			= 0x0005
Global Const $BS_AUTO3STATE		= 0x0006
Global Const $BS_AUTOCHECKBOX	= 0x0003
Global Const $BS_CHECKBOX		= 0x0002

; Radio
Global Const $BS_AUTORADIOBUTTON	= 0x0009

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ButtonConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ListBoxConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ListBoxConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\TabConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Tab Constants.
;
; ------------------------------------------------------------------------------
; Styles
Global Const $TCS_SCROLLOPPOSITE	= 0x0001
Global Const $TCS_BOTTOM			= 0x0002
Global Const $TCS_RIGHT				= 0x0002
Global Const $TCS_MULTISELECT		= 0x0004
Global Const $TCS_FLATBUTTONS		= 0x0008
Global Const $TCS_FORCEICONLEFT		= 0x0010
Global Const $TCS_FORCELABELLEFT	= 0x0020
Global Const $TCS_HOTTRACK			= 0x0040
Global Const $TCS_VERTICAL			= 0x0080
Global Const $TCS_TABS				= 0x0000
Global Const $TCS_BUTTONS			= 0x0100
Global Const $TCS_SINGLELINE		= 0x0000
Global Const $TCS_MULTILINE			= 0x0200
Global Const $TCS_RIGHTJUSTIFY		= 0x0000
Global Const $TCS_FIXEDWIDTH		= 0x0400
Global Const $TCS_RAGGEDRIGHT		= 0x0800
Global Const $TCS_FOCUSONBUTTONDOWN = 0x1000
Global Const $TCS_OWNERDRAWFIXED	= 0x2000
Global Const $TCS_TOOLTIPS			= 0x4000
Global Const $TCS_FOCUSNEVER		= 0x8000

; Tab Extended Styles
Global Const $TCS_EX_FLATSEPARATORS 	= 0x1
;Global Const $TCS_EX_REGISTERDROP 		= 0x2

; Error checking
Global Const $TC_ERR = -1

; event(s)
Global Const $TCIS_BUTTONPRESSED = 0x1

; extended styles
;~ Global Const $TCS_EX_FLATSEPARATORS = 0x1
Global Const $TCS_EX_REGISTERDROP = 0x2

; Messages to send to Tab control
Global Const $TCM_FIRST = 0x1300
Global Const $TCM_DELETEALLITEMS = ($TCM_FIRST + 9)
Global Const $TCM_DELETEITEM = ($TCM_FIRST + 8)
Global Const $TCM_DESELECTALL = ($TCM_FIRST + 50)
Global Const $TCM_GETCURFOCUS = ($TCM_FIRST + 47)
Global Const $TCM_GETCURSEL = ($TCM_FIRST + 11)
Global Const $TCM_GETEXTENDEDSTYLE = ($TCM_FIRST + 53)
Global Const $TCM_GETITEMCOUNT = ($TCM_FIRST + 4)
Global Const $TCM_GETITEMRECT = ($TCM_FIRST + 10)
Global Const $TCM_GETROWCOUNT = ($TCM_FIRST + 44)
Global Const $TCM_SETITEMSIZE = $TCM_FIRST + 41

Global Const $TCCM_FIRST = 0X2000
Global Const $TCCM_GETUNICODEFORMAT = ($TCCM_FIRST + 6)
Global Const $TCM_GETUNICODEFORMAT = $TCCM_GETUNICODEFORMAT

Global Const $TCM_HIGHLIGHTITEM = ($TCM_FIRST + 51)
Global Const $TCM_SETCURFOCUS = ($TCM_FIRST + 48)
Global Const $TCM_SETCURSEL = ($TCM_FIRST + 12)
Global Const $TCM_SETMINTABWIDTH = ($TCM_FIRST + 49)
Global Const $TCM_SETPADDING = ($TCM_FIRST + 43)

Global Const $TCCM_SETUNICODEFORMAT = ($TCCM_FIRST + 5)
Global Const $TCM_SETUNICODEFORMAT = $TCCM_SETUNICODEFORMAT

Global Const $TCN_FIRST = -550
Global Const $TCN_SELCHANGE = ($TCN_FIRST - 1)
Global Const $TCN_SELCHANGING = ($TCN_FIRST - 2)

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\TabConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\EditConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\EditConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\DateTimeConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\DateTimeConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\SliderConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\SliderConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\TreeViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\TreeViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ProgressConstants.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2
; Description:    Progress Constants.
;
; ------------------------------------------------------------------------------

; Styles
Global Const $PBS_SMOOTH	= 1
Global Const $PBS_VERTICAL	= 4

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ProgressConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\AVIConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\AVIConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\UpDownConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\UpDownConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\GUIConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\GUIListView.au3>
; ----------------------------------------------------------------------------



; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\ListViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\ListViewConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\Array.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\GuiConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\GuiConstants.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\GuiListView.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\GuiListView.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.0
; Language:       English
; Description:    Functions that assist with array management.
;
; Apr 28, 2005 - Fixed _ArrayTrim(): $iTrimDirection test.
; ------------------------------------------------------------------------------




;===============================================================================
;
; Function Name:  _ArrayAdd()
; Description:    Adds a specified value at the end of an array, returning the
;                 adjusted array.
; Author(s):      Jos van der Zande <jdeb at autoitscript dot com>
;
;===============================================================================
Func _ArrayAdd(ByRef $avArray, $sValue)
	If IsArray($avArray) Then
		ReDim $avArray[UBound($avArray) + 1]
		$avArray[UBound($avArray) - 1] = $sValue
		SetError(0)
		Return 1
	Else
		SetError(1)
		Return 0
	EndIf
EndFunc   ;==>_ArrayAdd


;===============================================================================
;
; Function Name:  _ArrayBinarySearch()
; Description:    Uses the binary search algorithm to search through a
;                 1-dimensional array.
; Author(s):      Jos van der Zande <jdeb at autoitscript dot com>
;
;===============================================================================
Func _ArrayBinarySearch(ByRef $avArray, $sKey, $i_Base = 0)
	Local $iLwrLimit = $i_Base
	Local $iUprLimit
	Local $iMidElement

	If (Not IsArray($avArray)) Then
		SetError(1)
		Return ""
	EndIf
	$iUprLimit = UBound($avArray) - 1
	$iMidElement = Int(($iUprLimit + $iLwrLimit) / 2)
	; sKey is smaller than the first entry
	If $avArray[$iLwrLimit] > $sKey Or $avArray[$iUprLimit] < $sKey Then
		SetError(2)
		Return ""
	EndIf

	While $iLwrLimit <= $iMidElement And $sKey <> $avArray[$iMidElement]
		If $sKey < $avArray[$iMidElement] Then
			$iUprLimit = $iMidElement - 1
		Else
			$iLwrLimit = $iMidElement + 1
		EndIf
		$iMidElement = Int(($iUprLimit + $iLwrLimit) / 2)
	WEnd
	If $iLwrLimit > $iUprLimit Then
		; Entry not found
		SetError(3)
		Return ""
	Else
		;Entry found , return the index
		SetError(0)
		Return $iMidElement
	EndIf
EndFunc   ;==>_ArrayBinarySearch

;===============================================================================
;
; Function Name:    _ArrayCreate()
; Description:      Create a small array and quickly assign values.
; Parameter(s):     $v_0  - The first element of the array.
;                   $v_1  - The second element of the array (optional).
;                   ...
;                   $v_20 - The twentyfirst element of the array (optional).
; Requirement(s):   None.
; Return Value(s):  The array with values.
; Author(s):        Dale (Klaatu) Thompson, rewritten JdeB to avoid Eval() errors in Obsufcator
; Note(s):          None.
;
;===============================================================================
Func _ArrayCreate($v_0, $v_1 = 0, $v_2 = 0, $v_3 = 0, $v_4 = 0, $v_5 = 0, $v_6 = 0, $v_7 = 0, $v_8 = 0, $v_9 = 0, $v_10 = 0, $v_11 = 0, $v_12 = 0, $v_13 = 0, $v_14 = 0, $v_15 = 0, $v_16 = 0, $v_17 = 0, $v_18 = 0, $v_19 = 0, $v_20 = 0)
	Local $av_Array[21] = [$v_0, $v_1, $v_2, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_10, $v_11, $v_12, $v_13, $v_14, $v_15, $v_16, $v_17, $v_18, $v_19, $v_20]
	ReDim $av_Array[@NumParams]
	Return $av_Array
	; Create fake usage for the variables to suppress Au3Check -w 6
EndFunc   ;==>_ArrayCreate


;===============================================================================
;
; Function Name:  _ArrayDelete()
; Description:    Deletes the specified element from the given array, returning
;                 the adjusted array.
; Author(s)       Cephas <cephas at clergy dot net>
; Modifications   Array is passed via Byref  - Jos van der zande
;===============================================================================
Func _ArrayDelete(ByRef $avArray, $iElement)
	Local $iCntr = 0, $iUpper = 0

	If (Not IsArray($avArray)) Then
		SetError(1)
		Return ""
	EndIf

	; We have to define this here so that we're sure that $avArray is an array
	; before we get it's size.
	$iUpper = UBound($avArray)    ; Size of original array

	; If the array is only 1 element in size then we can't delete the 1 element.
	If $iUpper = 1 Then
		SetError(2)
		Return ""
	EndIf

	Local $avNewArray[$iUpper - 1]
	If $iElement < 0 Then
		$iElement = 0
	EndIf
	If $iElement > ($iUpper - 1) Then
		$iElement = ($iUpper - 1)
	EndIf
	If $iElement > 0 Then
		For $iCntr = 0 To $iElement - 1
			$avNewArray[$iCntr] = $avArray[$iCntr]
		Next
	EndIf
	If $iElement < ($iUpper - 1) Then
		For $iCntr = ($iElement + 1) To ($iUpper - 1)
			$avNewArray[$iCntr - 1] = $avArray[$iCntr]
		Next
	EndIf
	$avArray = $avNewArray
	SetError(0)
	Return 1
EndFunc   ;==>_ArrayDelete


;===============================================================================
;
; Function Name:  _ArrayDisplay()
;
; Parameter(s):     $ar_2DArray      - Name of Array to display; 1 or 2 dimensional
;                   $sTitle          - [optional] The new title for Array Display ListView.
;                   $i_ShowOver4000  - [optional] 	0 = Limit number of rows displayed to 4000 for speed
;                                    - 				1 = (default) Display all rows [may slow down over 4000]
;                   $i_Transpose     - [optional] 	0 = (default) don't transpose view
;                                    - 				1 = transpose view
;                   $GUIDataSeparatorChar - [optional] 	(default="|") change option of character for ListView display [see Opt("GUIDataSeparatorChar", $GUIDataSeparatorChar)]
;                   $GUIDataReplace       - [optional] 	(default="~") change character to use in items of display if the item contains the separator character
; Requirement(s):   None
; Return Value(s):  On Success -  Returns 1
;                   On Failure -  0 , @error is set to 1.
; Author(s):        randallc
;
;=====================================================================
Func _ArrayDisplay($ar_2DArray, $sTitle = "ListView array 1D and 2D Display", $i_ShowOver4000 = 1, $i_Transpose = 0, $GUIDataSeparatorChar = "|", $GUIDataReplace = "~")
	Local $searchlistView, $hndButton_Close, $sTempHeader = 'Row', $i_Pos, $size, $ar_ExcelValueTrans[1][1], $s_NotDoneLine, $ret
	Local $ar_TempSingle[1], $msg, $hndButton_Array1Box_TextSelect, $searchGUI, $ar_2dCurrent[1][1], $GUICtrlCreateListViewItem
	If Not IsArray($ar_2DArray) Then Return SetError(1, 0, 0)
	; Create GUI and Buttons =========================================================================================
	$searchGUI = GUICreate($sTitle, 810, 623, (@DesktopWidth - 800) / 2, (@DesktopHeight - 600) / 2, $WS_MAXIMIZEBOX + $WS_MINIMIZEBOX)
	$hndButton_Array1Box_TextSelect = GUICtrlCreateButton('&Text' & 'Selected', 10, 550, 70, 24)
	GUICtrlSetResizing($hndButton_Array1Box_TextSelect, BitOR($GUI_DockRight, $GUI_DockBottom, $GUI_DockSize))
	$hndButton_Close = GUICtrlCreateButton('&Close', 190, 550, 70, 24)
	GUICtrlSetResizing($hndButton_Close, BitOR($GUI_DockRight, $GUI_DockBottom, $GUI_DockSize))
	GUICtrlSetState($hndButton_Array1Box_TextSelect, ($GUI_DefButton))
	; for 1D; add index column; change to 2D array==================================================================
	If UBound($ar_2DArray, 0) = 1 Then
		ReDim $ar_2dCurrent[UBound($ar_2DArray) ][1]
		For $i = 0 To UBound($ar_2DArray) - 1
			$ar_2dCurrent[$i][0] = $ar_2DArray[$i]
		Next
		$ar_2DArray = $ar_2dCurrent
	EndIf
	; transpose if requested==================================================================
	If $i_Transpose And IsArray($ar_2DArray) And UBound($ar_2DArray, 0) = 2 Then ; transpose if requested
		ReDim $ar_ExcelValueTrans[UBound($ar_2DArray, 2) ][UBound($ar_2DArray, 1) ]
		For $j = 0 To UBound($ar_2DArray, 2) - 1
			For $numb = 0 To UBound($ar_2DArray, 1) - 1
				If $numb > 250 Then ExitLoop  ; limit cols to about 250 as limitation  of GUICreatelistView?
				$ar_ExcelValueTrans[$j][$numb] = $ar_2DArray[$numb][$j]
			Next
		Next
		$ar_2DArray = $ar_ExcelValueTrans
	EndIf
	;Replace any array items containing the LV separator character =============================================
	Opt("GUIDataSeparatorChar", $GUIDataSeparatorChar) ;"|" is the default
	For $x = 0 To UBound($ar_2DArray) - 1 Step 1
		For $y = 0 To UBound($ar_2DArray, 2) - 1 Step 1
			$ar_2DArray[$x][$y] = StringReplace($ar_2DArray[$x][$y], $GUIDataSeparatorChar, $GUIDataReplace)
		Next
	Next
	;; make LV header==================================================================
	For $i = 1 To UBound($ar_2DArray, 2)
		$sTempHeader &= $GUIDataSeparatorChar & 'Col ' & $i - 1
	Next
	StringReplace($sTempHeader, $GUIDataSeparatorChar, "<")
	If @extended > 252 Then
		$i_Pos = StringInStr($sTempHeader, $GUIDataSeparatorChar, 0, 252)
		$sTempHeader = StringLeft($sTempHeader, $i_Pos - 1)
	EndIf
	$s_NotDoneLine = StringReplace($sTempHeader, "Col", "ND")
	;change 2D array to Array LV formatted rows==================================================================
	If UBound($ar_2DArray, 0) = 2 Then
		ReDim $ar_TempSingle[UBound($ar_2DArray) ]
		For $i = 0 To UBound($ar_2DArray) - 1
			$ar_TempSingle[$i] = "[" & $i & "]"
			For $c = 0 To UBound($ar_2DArray, 2) - 1 ;0 is base
				If $c < 251 Then
					$ar_TempSingle[$i] &= $GUIDataSeparatorChar & $ar_2DArray[$i][$c]
				Else
					ExitLoop;$c = UBound($ar_2DArray, 2) - 1
				EndIf
			Next
			$ar_TempSingle[$i] = StringMid($ar_TempSingle[$i], 1, StringLen($ar_TempSingle) - 1)
		Next
	Else
		$ar_TempSingle = $ar_2DArray
	EndIf
	;Create Listview==================================================================
	$size = WinGetClientSize($sTitle)
	GUICtrlDelete($searchlistView)
	$searchlistView = GUICtrlCreateListView($sTempHeader, 0, 16, $size[0] - 10, $size[1] - 90, BitOR($LVS_SHOWSELALWAYS, $LVS_EDITLABELS), BitOR($LVS_EX_GRIDLINES, $LVS_EX_HEADERDRAGDROP, $LVS_EX_FULLROWSELECT, $LVS_EX_REGIONAL))
	GUICtrlSetResizing($searchlistView, BitOR($GUI_DockLeft, $GUI_DockTop, $GUI_DockRight, $GUI_DockBottom))
	For $c = 0 To UBound($ar_TempSingle) - 1
		If ($c < 3999) Or $i_ShowOver4000 Then
			If $c < 3999 Then
				$GUICtrlCreateListViewItem = GUICtrlCreateListViewItem($ar_TempSingle[$c], $searchlistView)
				If Not $GUICtrlCreateListViewItem Then GUICtrlCreateListViewItem($s_NotDoneLine, $searchlistView)
			Else
				$ret = _GUICtrlListViewInsertItem($searchlistView, -1, $ar_TempSingle[$c])
				If ($ret = $LV_ERR) Then _GUICtrlListViewInsertItem($searchlistView, -1, $s_NotDoneLine)
			EndIf
		ElseIf ($c >= 3999) Then
			ExitLoop
		EndIf
	Next
	_GUICtrlListViewSetColumnWidth($searchlistView, 2, $LVSCW_AUTOSIZE)
	If UBound($ar_2DArray, 2) = 1 Then _GUICtrlListViewSetColumnWidth($searchlistView, 1, $LVSCW_AUTOSIZE)
	GUISetState()
	Local $SaveEventMode = Opt("GUIOnEventMode",0)
	Do ; LOOP
		$msg = GUIGetMsg(1)
		Select
			;Copy all to clipboard(default); or multiple selected rows===============================================================)
			Case $msg[0] = $hndButton_Array1Box_TextSelect
				Local $a_indices[1], $s_CopyLines = ""
				If _GUICtrlListViewGetItemCount($searchlistView) Then $a_indices = _GUICtrlListViewGetSelectedIndices($searchlistView, 1)
				If (IsArray($a_indices)) Then
					ClipPut("")
					For $i = 1 To $a_indices[0]
						$s_CopyLines &= $ar_TempSingle[ $a_indices[$i]] & @LF
					Next
				Else
					For $i = 0 To UBound($ar_TempSingle) - 1
						$s_CopyLines &= $ar_TempSingle[$i] & @LF
					Next
				EndIf
				ClipPut($s_CopyLines)
		EndSelect
	Until $msg[0] = $GUI_EVENT_CLOSE Or $msg[0] = $hndButton_Close
	GUIDelete($searchGUI)
	Opt("GUIOnEventMode",$SaveEventMode)
	Return SetError(0, 0, 1)
EndFunc   ;==>_ArrayDisplay

;===============================================================================
;
; Function Name:  _ArrayInsert()
; Description:    Add a new value at the specified position.
;
; Author(s):      Jos van der Zande <jdeb at autoitscript dot com>
;
;===============================================================================
Func _ArrayInsert(ByRef $avArray, $iElement, $sValue = "")
	Local $iCntr = 0

	If Not IsArray($avArray) Then
		SetError(1)
		Return 0
	EndIf
	; Add 1 to the Array
	ReDim $avArray[UBound($avArray) + 1]
	; Move all entries one up till the specified Element
	For $iCntr = UBound($avArray) - 1 To $iElement + 1 Step - 1
		$avArray[$iCntr] = $avArray[$iCntr - 1]
	Next
	; add the value in the specified element
	$avArray[$iCntr] = $sValue
	Return 1
EndFunc   ;==>_ArrayInsert


;===============================================================================
;
; Function Name:  _ArrayMax()
; Description:    Returns the highest value held in an array.
; Author(s):      Cephas <cephas at clergy dot net>
;
;                 Jos van der Zande
; Modified:       Added $iCompNumeric and $i_Base parameters and logic
;===============================================================================
Func _ArrayMax(Const ByRef $avArray, $iCompNumeric = 0, $i_Base = 0)
	If IsArray($avArray) Then
		Return $avArray[_ArrayMaxIndex($avArray, $iCompNumeric, $i_Base) ]
	Else
		SetError(1)
		Return ""
	EndIf
EndFunc   ;==>_ArrayMax


;===============================================================================
;
; Function Name:  _ArrayMaxIndex()
; Description:    Returns the index where the highest value occurs in the array.
; Author(s):      Cephas <cephas at clergy dot net>
;
;                 Jos van der Zande
; Modified:       Added $iCompNumeric and $i_Base parameters and logic
;===============================================================================
Func _ArrayMaxIndex(Const ByRef $avArray, $iCompNumeric = 0, $i_Base = 0)
	Local $iCntr, $iMaxIndex = $i_Base

	If Not IsArray($avArray) Then
		SetError(1)
		Return ""
	EndIf

	Local $iUpper = UBound($avArray)
	For $iCntr = $i_Base To ($iUpper - 1)
		If $iCompNumeric = 1 Then
			If Number($avArray[$iMaxIndex]) < Number($avArray[$iCntr]) Then
				$iMaxIndex = $iCntr
			EndIf
		Else
			If $avArray[$iMaxIndex] < $avArray[$iCntr] Then
				$iMaxIndex = $iCntr
			EndIf
		EndIf
	Next
	SetError(0)
	Return $iMaxIndex
EndFunc   ;==>_ArrayMaxIndex


;===============================================================================
;
; Function Name:  _ArrayMin()
; Description:    Returns the lowest value held in an array.
; Author(s):      Cephas <cephas ay clergy dot net>
;
;                 Jos van der Zande
; Modified:       Added $iCompNumeric and $i_Base parameters and logic
;===============================================================================
Func _ArrayMin(Const ByRef $avArray, $iCompNumeric = 0, $i_Base = 0)
	If IsArray($avArray) Then
		Return $avArray[_ArrayMinIndex($avArray, $iCompNumeric, $i_Base) ]
	Else
		SetError(1)
		Return ""
	EndIf
EndFunc   ;==>_ArrayMin


;===============================================================================
;
; Function Name:  _ArrayMinIndex()
; Description:    Returns the index where the lowest value occurs in the array.
; Author(s):      Cephas <cephas at clergy dot net>
;
;                 Jos van der Zande
; Modified:       Added $iCompNumeric and $i_Base parameters and logic
;===============================================================================
Func _ArrayMinIndex(Const ByRef $avArray, $iCompNumeric = 0, $i_Base = 0)
	Local $iCntr = 0, $iMinIndex = $i_Base

	If Not IsArray($avArray) Then
		SetError(1)
		Return ""
	EndIf

	Local $iUpper = UBound($avArray)
	For $iCntr = $i_Base To ($iUpper - 1)
		If $iCompNumeric = 1 Then
			If Number($avArray[$iMinIndex]) > Number($avArray[$iCntr]) Then
				$iMinIndex = $iCntr
			EndIf
		Else
			If $avArray[$iMinIndex] > $avArray[$iCntr] Then
				$iMinIndex = $iCntr
			EndIf
		EndIf
	Next
	SetError(0)
	Return $iMinIndex
EndFunc   ;==>_ArrayMinIndex


;===============================================================================
;
; Function Name:  _ArrayPop()
; Description:    Returns the last element of an array, deleting that element
;                 from the array at the same time.
; Author(s):      Cephas <cephas at clergy dot net>
; Modified:       Use Redim to remove last entry.
;===============================================================================
Func _ArrayPop(ByRef $avArray)
	Local $sLastVal
	If (Not IsArray($avArray)) Then
		SetError(1)
		Return ""
	EndIf
	$sLastVal = $avArray[UBound($avArray) - 1]
	; remove the last value
	If UBound($avArray) = 1 Then
		$avArray = ""
	Else
		ReDim $avArray[UBound($avArray) - 1]
	EndIf
	; return last value
	Return $sLastVal
EndFunc   ;==>_ArrayPop

;=====================================================================================
;
; Function Name:    _ArrayPush
; Description:      Add new values without increasing array size.Either by inserting
;                   at the end the new value and deleting the first one or vice versa.
; Parameter(s):     $avArray      - Array
;                   $sValue       - The new value.It can be an array too.
;                   $i_Direction  - 0 = Leftwise slide (adding at the end) (default)
;                                   1 = Rightwise slide (adding at the start)
; Requirement(s):   None
; Return Value(s):  On Success -  Returns 1
;                   On Failure -  0 if $avArray is not an array.
;								 -1 if $sValue array size is greater than $avArray size.
;								 In both cases @error is set to 1.
; Author(s):        Helias Gerassimou(hgeras)
;
;======================================================================================
Func _ArrayPush(ByRef $avArray, $sValue, $i_Direction = 0)
	Local $i, $j

	If (Not IsArray($avArray)) Then
		SetError(1)
		Return 0
	EndIf
	;
	If (Not IsArray($sValue)) Then
		If $i_Direction = 1 Then
			For $i = (UBound($avArray) - 1) To 1 Step - 1
				$avArray[$i] = $avArray[$i - 1]
			Next
			$avArray[0] = $sValue
		Else
			For $i = 0 To (UBound($avArray) - 2)
				$avArray[$i] = $avArray[$i + 1]
			Next
			$i = (UBound($avArray) - 1)
			$avArray[$i] = $sValue
		EndIf
		;
		SetError(0)
		Return 1
	Else
		If UBound($sValue) > UBound($avArray) Then
			SetError(1)
			Return -1
		Else
			For $j = 0 To (UBound($sValue) - 1)
				If $i_Direction = 1 Then
					For $i = (UBound($avArray) - 1) To 1
						$avArray[$i] = $avArray[$i - 1]
					Next
					$avArray[$j] = $sValue[$j]
				Else
					For $i = 0 To (UBound($avArray) - 2)
						$avArray[$i] = $avArray[$i + 1]
					Next
					$i = (UBound($avArray) - 1)
					$avArray[$i] = $sValue[$j]
				EndIf
			Next
		EndIf
	EndIf
	;
	SetError(0)
	Return 1
	;
EndFunc   ;==>_ArrayPush

;===============================================================================
;
; Function Name:  _ArrayReverse()
; Description:    Takes the given array and reverses the order in which the
;                 elements appear in the array.
; Author(s):      Brian Keene <brian_keene at yahoo dot com>
;
; Modified:       Added $i_Base parameter and logic (Jos van der Zande)
;                 Added $i_UBound parameter and rewrote it for speed. (Tylo)
;===============================================================================

Func _ArrayReverse(ByRef $avArray, $i_Base = 0, $i_UBound = 0)
	If Not IsArray($avArray) Then
		SetError(1)
		Return 0
	EndIf
	Local $tmp, $last = UBound($avArray) - 1
	If $i_UBound < 1 Or $i_UBound > $last Then $i_UBound = $last
	For $i = $i_Base To $i_Base + Int(($i_UBound - $i_Base - 1) / 2)
		$tmp = $avArray[$i]
		$avArray[$i] = $avArray[$i_UBound]
		$avArray[$i_UBound] = $tmp
		$i_UBound = $i_UBound - 1
	Next
	Return 1
EndFunc   ;==>_ArrayReverse

;===============================================================================
;
; Function Name:    _ArraySearch()
; Description:      Finds an entry within a one-dimensional array. (Similar to _ArrayBinarySearch() except the array does not need to be sorted.)
; Syntax:           _ArraySearch($avArray, $vWhat2Find, $iStart = 0, $iEnd = 0,$iCaseSense=0, $fPartialSearch = False)
;
; Parameter(s):     $avArray           = The array to search
;                   $vWhat2Find        = What to search $avArray for
;                   $iStart (Optional) = Start array index for search, normally set to 0 or 1. If omitted it is set to 0
;                   $iEnd  (Optional)  = End array index for search. If omitted or set to 0 it is set to Ubound($AvArray)-
;					$iCaseSense (Optional) = If set to 1 then search is case sensitive
;					$fPartialSearch (Optional) = If set to True then executes a partial search. If omitted it is set to False
; Requirement(s):   None
;
; Return Value(s):  On Success - Returns the position of an item in an array.
;                   On Failure - Returns an -1 if $vWhat2Find is not found
;                        @Error=1 $avArray is not an array
;                        @Error=2 $iStart is greater than UBound($AvArray)-1
;                        @Error=3 $iEnd is greater than UBound($AvArray)-1
;                        @Error=4 $iStart is greater than $iEnd
;						 @Error=5 $iCaseSense was invalid. (Must be 0 or 1)
;						 @Error=6 $vWhat2Find was not found in $avArray
;
; Author(s):        SolidSnake <MetalGX91 at GMail dot com> - updated by gcriaco <gcriaco at gmail dot com>
; Note(s):          This might be slower than _ArrayBinarySearch() but is useful when the array's order can't be altered.
;===============================================================================
Func _ArraySearch(Const ByRef $avArray, $vWhat2Find, $iStart = 0, $iEnd = 0, $iCaseSense = 0, $fPartialSearch = False)
	Local $iCurrentPos, $iUBound, $iResult
	If Not IsArray($avArray) Then
		SetError(1)
		Return -1
	EndIf
	$iUBound = UBound($avArray) - 1
	If $iEnd = 0 Then $iEnd = $iUBound
	If $iStart > $iUBound Then
		SetError(2)
		Return -1
	EndIf
	If $iEnd > $iUBound Then
		SetError(3)
		Return -1
	EndIf
	If $iStart > $iEnd Then
		SetError(4)
		Return -1
	EndIf
	If Not ($iCaseSense = 0 Or $iCaseSense = 1) Then
		SetError(5)
		Return -1
	EndIf
	For $iCurrentPos = $iStart To $iEnd
		Select
			Case $iCaseSense = 0
				If $fPartialSearch = False Then
					If $avArray[$iCurrentPos] = $vWhat2Find Then
						SetError(0)
						Return $iCurrentPos
					EndIf
				Else
					$iResult = StringInStr($avArray[$iCurrentPos], $vWhat2Find, $iCaseSense)
					If $iResult > 0 Then
						SetError(0)
						Return $iCurrentPos
					EndIf
				EndIf
			Case $iCaseSense = 1
				If $fPartialSearch = False Then
					If $avArray[$iCurrentPos] == $vWhat2Find Then
						SetError(0)
						Return $iCurrentPos
					EndIf
				Else
					$iResult = StringInStr($avArray[$iCurrentPos], $vWhat2Find, $iCaseSense)
					If $iResult > 0 Then
						SetError(0)
						Return $iCurrentPos
					EndIf
				EndIf
		EndSelect
	Next
	SetError(6)
	Return -1
EndFunc   ;==>_ArraySearch

;===============================================================================
;
; Function Name:    _ArraySort()
; Description:      Sort an 1 or 2 dimensional Array on a specific index
;                   using the quicksort/insertsort algorithms.
; Parameter(s):     $a_Array      - Array
;                   $i_Descending - Sort Descending when 1
;                   $i_Base       - Start sorting at this Array entry.
;                   $I_Ubound     - End sorting at this Array entry.
;                                   Default UBound($a_Array) - 1
;                   $i_Dim        - Elements to sort in second dimension
;                   $i_SortIndex  - The Index to Sort the Array on.
;                                   (for 2-dimensional arrays only)
; Requirement(s):   None
; Return Value(s):  On Success - 1 and the sorted array is set
;                   On Failure - 0 and sets @ERROR = 1
; Author(s):        Jos van der Zande <jdeb at autoitscript dot com>
;                   LazyCoder - added $i_SortIndex option
;                   Tylo - implemented stable QuickSort algo
;                   Jos - Changed logic to correctly Sort arrays with mixed Values and Strings
;
;===============================================================================
;
Func _ArraySort(ByRef $a_Array, $i_Decending = 0, $i_Base = 0, $i_UBound = 0, $i_Dim = 1, $i_SortIndex = 0)
	; Set to ubound when not specified
	If Not IsArray($a_Array) Then
		SetError(1)
		Return 0
	EndIf
	Local $last = UBound($a_Array) - 1
	If $i_UBound < 1 Or $i_UBound > $last Then $i_UBound = $last

	If $i_Dim = 1 Then
		__ArrayQSort1($a_Array, $i_Base, $i_UBound)
		If $i_Decending Then _ArrayReverse($a_Array, $i_Base, $i_UBound)
	Else
		__ArrayQSort2($a_Array, $i_Base, $i_UBound, $i_Dim, $i_SortIndex, $i_Decending)
	EndIf
	Return 1
EndFunc   ;==>_ArraySort

; Private
Func __ArrayQSort1(ByRef $array, ByRef $left, ByRef $right)
	Local $i, $j, $t
	If $right - $left < 10 Then
		; InsertSort - fastest on small segments (= 25% total speedup)
		For $i = $left + 1 To $right
			$t = $array[$i]
			$j = $i
			While $j > $left _
					And ((IsNumber($array[$j - 1]) = IsNumber($t) And $array[$j - 1] > $t) _
					Or (IsNumber($array[$j - 1]) <> IsNumber($t) And String($array[$j - 1]) > String($t)))
				$array[$j] = $array[$j - 1]
				$j = $j - 1
			WEnd
			$array[$j] = $t
		Next
		Return
	EndIf

	; QuickSort - fastest on large segments
	Local $pivot = $array[Int(($left + $right) / 2) ]
	Local $L = $left
	Local $R = $right
	Do
		While ((IsNumber($array[$L]) = IsNumber($pivot) And $array[$L] < $pivot) _
				Or (IsNumber($array[$L]) <> IsNumber($pivot) And String($array[$L]) < String($pivot)))
			;While $array[$L] < $pivot
			$L = $L + 1
		WEnd
		While ((IsNumber($array[$R]) = IsNumber($pivot) And $array[$R] > $pivot) _
				Or (IsNumber($array[$R]) <> IsNumber($pivot) And String($array[$R]) > String($pivot)))
			;	While $array[$R] > $pivot
			$R = $R - 1
		WEnd
		; Swap
		If $L <= $R Then
			$t = $array[$L]
			$array[$L] = $array[$R]
			$array[$R] = $t
			$L = $L + 1
			$R = $R - 1
		EndIf
	Until $L > $R

	__ArrayQSort1($array, $left, $R)
	__ArrayQSort1($array, $L, $right)
EndFunc   ;==>__ArrayQSort1

; Private
Func __ArrayQSort2(ByRef $array, ByRef $left, ByRef $right, ByRef $dim2, ByRef $sortIdx, ByRef $decend)
	If $left >= $right Then Return
	Local $t, $d2 = $dim2 - 1
	Local $pivot = $array[Int(($left + $right) / 2) ][$sortIdx]
	Local $L = $left
	Local $R = $right
	Do
		If $decend Then
			While ((IsNumber($array[$L][$sortIdx]) = IsNumber($pivot) And $array[$L][$sortIdx] > $pivot) _
					Or (IsNumber($array[$L][$sortIdx]) <> IsNumber($pivot) And String($array[$L][$sortIdx]) > String($pivot)))
				;While $array[$L][$sortIdx] > $pivot
				$L = $L + 1
			WEnd
			While ((IsNumber($array[$R][$sortIdx]) = IsNumber($pivot) And $array[$R][$sortIdx] < $pivot) _
					Or (IsNumber($array[$R][$sortIdx]) <> IsNumber($pivot) And String($array[$R][$sortIdx]) < String($pivot)))
				;While $array[$R][$sortIdx] < $pivot
				$R = $R - 1
			WEnd
		Else
			While ((IsNumber($array[$L][$sortIdx]) = IsNumber($pivot) And $array[$L][$sortIdx] < $pivot) _
					Or (IsNumber($array[$L][$sortIdx]) <> IsNumber($pivot) And String($array[$L][$sortIdx]) < String($pivot)))
				;While $array[$L][$sortIdx] < $pivot
				$L = $L + 1
			WEnd
			While ((IsNumber($array[$R][$sortIdx]) = IsNumber($pivot) And $array[$R][$sortIdx] > $pivot) _
					Or (IsNumber($array[$R][$sortIdx]) <> IsNumber($pivot) And String($array[$R][$sortIdx]) > String($pivot)))
				;While $array[$R][$sortIdx] > $pivot
				$R = $R - 1
			WEnd
		EndIf
		If $L <= $R Then
			For $x = 0 To $d2
				$t = $array[$L][$x]
				$array[$L][$x] = $array[$R][$x]
				$array[$R][$x] = $t
			Next
			$L = $L + 1
			$R = $R - 1
		EndIf
	Until $L > $R

	__ArrayQSort2($array, $left, $R, $dim2, $sortIdx, $decend)
	__ArrayQSort2($array, $L, $right, $dim2, $sortIdx, $decend)
EndFunc   ;==>__ArrayQSort2



;===============================================================================
;
; Function Name:  _ArraySwap()
; Description:    Swaps two elements of an array.
; Author(s):      David Nuttall <danuttall at rocketmail dot com>
;
;===============================================================================
Func _ArraySwap(ByRef $svector1, ByRef $svector2)
	Local $sTemp = $svector1

	$svector1 = $svector2
	$svector2 = $sTemp

	SetError(0)
EndFunc   ;==>_ArraySwap


;===============================================================================
;
; Function Name:  _ArrayToClip()
; Description:    Sends the contents of an array to the clipboard.
; Author(s):      Cephas <cephas at clergy dot net>
;
;                 Jos van der Zande
; Modified:       Added $i_Base parameter and logic
;===============================================================================
Func _ArrayToClip(Const ByRef $avArray, $i_Base = 0)
	Local $iCntr, $iRetVal = 0, $sCr = "", $sText = ""

	If (IsArray($avArray)) Then
		For $iCntr = $i_Base To (UBound($avArray) - 1)
			$iRetVal = 1
			If $iCntr > $i_Base Then
				$sCr = @CR
			EndIf
			$sText = $sText & $sCr & $avArray[$iCntr]
		Next
	EndIf
	ClipPut($sText)
	Return $iRetVal
EndFunc   ;==>_ArrayToClip


;===============================================================================
;
; Function Name:  _ArrayToString()
; Description:    Places the elements of an array into a single string,
;                 separated by the specified delimiter.
; Author(s):      Brian Keene <brian_keene at yahoo dot com>
;						Rewritten by: Valik
;
;===============================================================================
Func _ArrayToString(Const ByRef $avArray, $sDelim, $iStart = Default, $iEnd = Default)
	; Declare local variables.
	Local $iUBound = UBound($avArray) - 1

	; Validate the array
	If ($iUBound + 1) < 2 Or UBound($avArray, 0) > 1 Then Return SetError(1, 0, "")

	; Expand Default parameters
	If $iStart = Default Or $iStart = -1 Then $iStart = 0
	If $iEnd = Default Or $iEnd = -1 Then $iEnd = $iUBound

	; Validate that the start and end indices are valid.
	If ($iStart < 0) Or ($iEnd < 0) Or ($iStart > $iEnd) Then Return SetError(2, 0, "")

	; Make sure that $iEnd <= to the size of the array.
	If ($iEnd > $iUBound) Then
		$iEnd = $iUBound
	EndIf

	Local $sResult
	; Combine the elements into the string.
	For $i = $iStart To $iEnd
		$sResult &= $avArray[$i] & $sDelim
	Next

	Return StringTrimRight($sResult, StringLen($sDelim))
EndFunc   ;==>_ArrayToString

;===============================================================================
;
; FunctionName:     _ArrayTrim()
; Description:      Trims all elements in an array a certain number of characters.
; Syntax:           _ArrayTrim( $aArray, $iTrimNum , [$iTrimDirection] , [$iBase] , [$iUbound] )
; Parameter(s):     $aArray              - The array to trim the items of
;                   $iTrimNum            - The amount of characters to trim
;                    $iTrimDirection     - 0 to trim left, 1 to trim right
;                                            [Optional] : Default = 0
;                   $iBase               - Start trimming at this element in the array
;                                            [Optional] : Default = 0
;                   $iUbound             - End trimming at this element in the array
;                                            [Optional] : Default = Full Array
; Requirement(s):   None
; Return Value(s):  1 - If invalid array
;                   2 - Invalid base boundry parameter
;                   3 - Invalid end boundry parameter
;                   4 - If $iTrimDirection is not a zero or a one
;                    Otherwise it returns the new trimmed array
; Author(s):        Adam Moore (redndahead)
; Note(s):          None
;
;===============================================================================
Func _ArrayTrim($aArray, $iTrimNum, $iTrimDirection = 0, $iBase = 0, $iUBound = 0)
	Local $i

	;Validate array and options given
	If UBound($aArray) = 0 Then
		SetError(1)
		Return $aArray
	EndIf

	If $iBase < 0 Or Not IsNumber($iBase) Then
		SetError(2)
		Return $aArray
	EndIf

	If UBound($aArray) <= $iUBound Or Not IsNumber($iUBound) Then
		SetError(3)
		Return $aArray
	EndIf

	; Set to ubound when not specified
	If $iUBound < 1 Then $iUBound = UBound($aArray) - 1

	If $iTrimDirection < 0 Or $iTrimDirection > 1 Then
		SetError(4)
		Return
	EndIf
	;Trim it off
	For $i = $iBase To $iUBound
		If $iTrimDirection = 0 Then
			$aArray[$i] = StringTrimLeft($aArray[$i], $iTrimNum)
		Else
			$aArray[$i] = StringTrimRight($aArray[$i], $iTrimNum)
		EndIf
	Next
	Return $aArray
EndFunc   ;==>_ArrayTrim

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\Array.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\Misc.au3>
; ----------------------------------------------------------------------------

; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.1.1++
; Language:       English
; Description:    Functions that assist with Common Dialogs.
;
; ------------------------------------------------------------------------------
; Color Dialog constants
Global Const $CC_ANYCOLOR = 0x100
Global Const $CC_FULLOPEN = 0x2
Global Const $CC_RGBINIT = 0x1
; Font Dialog constants
Global Const $CF_EFFECTS = 0x100
Global Const $CF_PRINTERFONTS = 0x2
Global Const $CF_SCREENFONTS = 0x1
Global Const $CF_NOSCRIPTSEL = 0x800000
Global Const $CF_INITTOLOGFONTSTRUCT = 0x40
Global Const $DEFAULT_PITCH = 0
Global Const $FF_DONTCARE = 0
Global Const $LOGPIXELSX = 88
;===============================================================================
;
; Description:            _ChooseColor
; Parameter(s):        $i_ReturnType - Optional: determines return type
;                            $i_colorref - Optional: default selected Color
;                            $i_refType - Optional: Type of $i_colorref passed in
; Requirement:            None
; Return Value(s):    Returns COLORREF rgbcolor if $i_refType = 0 (default)
;                            Returns Hex RGB value if $i_refType = 1
;                            Returns Hex BGR Color if $i_refType = 2
;                            if error occurs, @error is set
; User CallTip:        _ChooseColor([$i_ReturnType = 0[, $i_colorref = 0[, $i_refType=0]]]) Creates a Color dialog box that enables the user to select a color. (required: <Misc.au3>)
; Author(s):            Gary Frost (custompcs at charter dot net)
; Note(s):                $i_ReturnType = 0 then COLORREF rgbcolor is returned (default)
;                            $i_ReturnType = 1 then Hex BGR Color is returned
;                            $i_ReturnType = 2 Hex RGB Color is returned
;
;                            $i_colorref = 0 (default)
;
;                            $i_refType = 0 then $i_colorref is COLORREF rgbcolor value (default)
;                            $i_refType = 1 then $i_colorref is BGR hex value
;                            $i_refType = 2 then $i_colorref is RGB hex value
;
;===============================================================================
Func _ChooseColor($i_ReturnType = 0, $i_colorref = 0, $i_refType = 0)
;~ typedef struct {
;~     DWORD lStructSize;
;~     HWND hwndOwner;
;~     HWND hInstance;
;~     COLORREF rgbResult;
;~     COLORREF *lpCustColors;
;~     DWORD Flags;
;~     LPARAM lCustData;
;~     LPCCHOOKPROC lpfnHook;
;~     LPCTSTR lpTemplateName;
;~ } CHOOSECOLOR, *LPCHOOSECOLOR;
	Local $custcolors = "int[16]"
	Local $struct = "dword;int;int;int;ptr;dword;int;ptr;ptr"
	Local $p = DllStructCreate($struct)
	If @error Then
		;MsgBox(0,"","Error in DllStructCreate " & @error);
		SetError(-1)
		Return -1
	EndIf
	Local $cc = DllStructCreate($custcolors)
	If @error Then
		; MsgBox(0,"","Error in DllStructCreate " & @error);
		;        DllStructDelete ($p)
		SetError(-2)
		Return -1
	EndIf
	If ($i_refType == 1) Then
		$i_colorref = Int($i_colorref)
	ElseIf ($i_refType == 2) Then
		$i_colorref = Hex(String($i_colorref), 6)
		$i_colorref = '0x' & StringMid($i_colorref, 5, 2) & StringMid($i_colorref, 3, 2) & StringMid($i_colorref, 1, 2)
	EndIf
	DllStructSetData($p, 1, DllStructGetSize($p))
	DllStructSetData($p, 2, 0)
	DllStructSetData($p, 4, $i_colorref)
	DllStructSetData($p, 5, DllStructGetPtr($cc))
	DllStructSetData($p, 6, BitOR($CC_ANYCOLOR, $CC_FULLOPEN, $CC_RGBINIT))
	Local $ret = DllCall("comdlg32.dll", "long", "ChooseColor", "ptr", DllStructGetPtr($p))
	If ($ret[0] == 0) Then
		; user selected cancel or struct settings incorrect
		;        DllStructDelete ($p)
		;        DllStructDelete ($cc)
		SetError(-3)
		Return -1
	EndIf
	Local $color_picked = DllStructGetData($p, 4)
	;    DllStructDelete ($p)
	;    DllStructDelete ($cc)
	If ($i_ReturnType == 1) Then
		; return Hex BGR Color
		Return '0x' & Hex(String($color_picked), 6)
	ElseIf ($i_ReturnType == 2) Then
		; return Hex RGB Color
		$color_picked = Hex(String($color_picked), 6)
		Return '0x' & StringMid($color_picked, 5, 2) & StringMid($color_picked, 3, 2) & StringMid($color_picked, 1, 2)
	ElseIf ($i_ReturnType == 0) Then
		Return $color_picked
	Else
		SetError(-4)
		Return -1
	EndIf
EndFunc   ;==>_ChooseColor
;===============================================================================
;
; Description:			_ChooseFont
; Parameter(s):		$s_FontName - Optional: Default font name
;							$i_size - Optional: pointsize of font
;							$i_colorref - Optional: COLORREF rgbColors
;							$i_FontWeight - Optional: Font Weight
;							$i_Italic - Optional: Italic
;							$i_Underline - Optional: Underline
;							$i_Strikethru - Optional: Strikethru
; Requirement:			None.
; Return Value(s):	Returns Array, $array[0] contains the number of elements
;							if error occurs, @error is set
; User CallTip:		_ChooseFont([$s_FontName = "Courier New"[, $i_size = 10[, $i_colorref = 0[, $i_FontWeight = 0[, $i_Italic= 0[, $i_Underline = [0, $i_Strikethru = 0]]]]]]) Creates a Font dialog box that enables the user to choose attributes for a logical font. (required: <Misc.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				$array[1] - attributes = BitOr of italic:2, undeline:4, strikeout:8
;							$array[2] - fontname
;							$array[3] - font size = point size
;							$array[4] - font weight = = 0-1000
;							$array[5] - COLORREF rgbColors
;							$array[6] - Hex BGR Color
;							$array[7] - Hex RGB Color
;
;===============================================================================
Func _ChooseFont($s_FontName = "Courier New", $i_size = 10, $i_colorref = 0, $i_FontWeight = 0, $i_Italic = 0, $i_Underline = 0, $i_Strikethru = 0)
;~ typedef struct {
;~     DWORD lStructSize;
;~     HWND hwndOwner;
;~     HDC hDC;
;~     LPLOGFONT lpLogFont;
;~     INT iPointSize;
;~     DWORD Flags;
;~     COLORREF rgbColors;
;~     LPARAM lCustData;
;~     LPCFHOOKPROC lpfnHook;
;~     LPCTSTR lpTemplateName;
;~     HINSTANCE hInstance;
;~     LPTSTR lpszStyle;
;~     WORD nFontType;
;~     INT nSizeMin;
;~     INT nSizeMax;
;~ } CHOOSEFONT, *LPCHOOSEFONT;
;~ typedef struct tagLOGFONT {
;~   LONG lfHeight;
;~   LONG lfWidth;
;~   LONG lfEscapement;
;~   LONG lfOrientation;
;~   LONG lfWeight;
;~   BYTE lfItalic;
;~   BYTE lfUnderline;
;~   BYTE lfStrikeOut;
;~   BYTE lfCharSet;
;~   BYTE lfOutPrecision;
;~   BYTE lfClipPrecision;
;~   BYTE lfQuality;
;~   BYTE lfPitchAndFamily;
;~   TCHAR lfFaceName[LF_FACESIZE]; 32 chars max
;~ } LOGFONT, *PLOGFONT;
	Local $ret = DllCall("gdi32.dll", "long", "GetDeviceCaps", "long", 0, "long", $LOGPIXELSX)
	If ($ret[0] == -1) Then
		SetError(-3)
		Return -1
	EndIf
	Local $lfHeight = Round(($i_size * $ret[2]) / 72, 0)
	Local $logfont = "int;int;int;int;int;byte;byte;byte;byte;byte;byte;byte;byte;char[32]"
	Local $struct = "dword;int;int;ptr;int;dword;int;int;ptr;ptr;int;ptr;dword;int;int"
	Local $p = DllStructCreate($struct)
	If @error Then
		;MsgBox(0,"","Error in DllStructCreate " & @error);
		SetError(-1)
		Return -1
	EndIf
	Local $lf = DllStructCreate($logfont)
	If @error Then
		; MsgBox(0,"","Error in DllStructCreate " & @error);
		;		DllStructDelete ($p)
		SetError(-2)
		Return -1
	EndIf
	DllStructSetData($p, 1, DllStructGetSize($p))
	DllStructSetData($p, 2, 0)
	DllStructSetData($p, 4, DllStructGetPtr($lf))
	DllStructSetData($p, 5, $i_size)
	DllStructSetData($p, 6, BitOR($CF_SCREENFONTS, $CF_PRINTERFONTS, $CF_EFFECTS, $CF_INITTOLOGFONTSTRUCT, $CF_NOSCRIPTSEL))
	DllStructSetData($p, 7, $i_colorref)
	DllStructSetData($p, 13, 0)
	DllStructSetData($lf, 1, $lfHeight + 1)
	DllStructSetData($lf, 5, $i_FontWeight)
	DllStructSetData($lf, 6, $i_Italic)
	DllStructSetData($lf, 7, $i_Underline)
	DllStructSetData($lf, 8, $i_Strikethru)
	DllStructSetData($lf, 14, $s_FontName)
	$ret = DllCall("comdlg32.dll", "long", "ChooseFont", "ptr", DllStructGetPtr($p))
	If ($ret[0] == 0) Then
		; user selected cancel or struct settings incorrect
		;		DllStructDelete ($p)
		;		DllStructDelete ($lf)
		SetError(-3)
		Return -1
	EndIf
	Local $fontname = DllStructGetData($lf, 14)
	If (StringLen($fontname) == 0 And StringLen($s_FontName) > 0) Then
		$fontname = $s_FontName
	EndIf
	Local $italic = 0
	Local $underline = 0
	Local $strikeout = 0
	If (DllStructGetData($lf, 6)) Then
		$italic = 2
	EndIf
	If (DllStructGetData($lf, 7)) Then
		$underline = 4
	EndIf
	If (DllStructGetData($lf, 8)) Then
		$strikeout = 8
	EndIf
	Local $attributes = BitOR($italic, $underline, $strikeout)
	Local $size = DllStructGetData($p, 5) / 10
	Local $weight = DllStructGetData($lf, 5)
	Local $colorref = DllStructGetData($p, 7)
	;	DllStructDelete ($p)
	;	DllStructDelete ($lf)
	Local $color_picked = Hex(String($colorref), 6)
	Return StringSplit($attributes & "," & $fontname & "," & $size & "," & $weight & "," & $colorref & "," & '0x' & $color_picked & "," & '0x' & StringMid($color_picked, 5, 2) & StringMid($color_picked, 3, 2) & StringMid($color_picked, 1, 2), ",")
EndFunc   ;==>_ChooseFont
;===============================================================================
;
; Description:      Copy Files to Clipboard Like Explorer does
; Parameter(s):     $sFile      - Full Path to File(s)
;                   $sSeperator - Seperator for multiple Files, Default = '|'
; Requirement(s):   v3.1.1.122+
; Return Value(s):  On Success - True
;                   On Failure - False and
;									Sets @ERROR to:	1 - Unable to Open Clipboard
;													2 - Unable to Empty Cipboard
;													3 - GlobalAlloc Failed
;													4 - GlobalLock Failed
;													5 - Unable to Create H_DROP
;													6 - Unable to Update Clipboard
;													7 - Unable to Close Clipboard
;													8 - GlobalUnlock Failed
; Author(s):        Piccaso (Florian Fida)
; Note(s):
;
;===============================================================================
Func _ClipPutFile($sFile, $sSeperator = "|")
	Local $vDllCallTmp, $nGlobMemSize, $hGlobal, $DROPFILES, $i, $hLock
	Local $GMEM_MOVEABLE = 0x0002, $CF_HDROP = 15
	$sFile = $sFile & $sSeperator & $sSeperator
	$nGlobMemSize = StringLen($sFile) + 20 ; 20 = size of DROPFILES whitout buffer
	$vDllCallTmp = DllCall("user32.dll", "int", "OpenClipboard", "hwnd", 0)
	If @error Or $vDllCallTmp[0] = 0 Then
		SetError(1)
		Return False
	EndIf
	$vDllCallTmp = DllCall("user32.dll", "int", "EmptyClipboard")
	If @error Or $vDllCallTmp[0] = 0 Then
		SetError(2)
		Return False
	EndIf
	$vDllCallTmp = DllCall("kernel32.dll", "long", "GlobalAlloc", "int", $GMEM_MOVEABLE, "int", $nGlobMemSize)
	If @error Or $vDllCallTmp[0] < 1 Then
		SetError(3)
		Return False
	EndIf
	$hGlobal = $vDllCallTmp[0]
	$vDllCallTmp = DllCall("kernel32.dll", "long", "GlobalLock", "long", $hGlobal)
	If @error Or $vDllCallTmp[0] < 1 Then
		SetError(4)
		Return False
	EndIf
	$hLock = $vDllCallTmp[0]
	$DROPFILES = DllStructCreate("dword;ptr;int;int;int;char[" & StringLen($sFile) & "]", $hLock)
	If @error Then
		SetError(5)
		Return False
	EndIf
	DllStructSetData($DROPFILES, 1, DllStructGetSize($DROPFILES) - StringLen($sFile))
	DllStructSetData($DROPFILES, 2, 0)
	DllStructSetData($DROPFILES, 3, 0)
	DllStructSetData($DROPFILES, 4, 0)
	DllStructSetData($DROPFILES, 5, 0)
	DllStructSetData($DROPFILES, 6, $sFile)
	For $i = 1 To StringLen($sFile)
		If DllStructGetData($DROPFILES, 6, $i) = Asc($sSeperator) Then DllStructSetData($DROPFILES, 6, 0, $i)
	Next
	$vDllCallTmp = DllCall("user32.dll", "long", "SetClipboardData", "int", $CF_HDROP, "long", $hGlobal)
	If @error Or $vDllCallTmp[0] < 1 Then
		SetError(6)
		$DROPFILES = 0
		Return False
	EndIf
	$vDllCallTmp = DllCall("user32.dll", "int", "CloseClipboard")
	If @error Or $vDllCallTmp[0] = 0 Then
		SetError(7)
		$DROPFILES = 0
		Return False
	EndIf
	$vDllCallTmp = DllCall("kernel32.dll", "int", "GlobalUnlock", "long", $hGlobal)
	If @error Then
		SetError(8)
		$DROPFILES = 0
		Return False
	EndIf
	$vDllCallTmp = DllCall("kernel32.dll", "int", "GetLastError")
	If $vDllCallTmp = 0 Then
		$DROPFILES = 0
		SetError(8)
		Return False
	Else
		$DROPFILES = 0
		Return True
	EndIf
EndFunc   ;==>_ClipPutFile
;
;===============================================================================
;
; Function Name:    _Iif()
; Description:      Perform a boolean test within an expression.
; Parameter(s):     $f_Test     - Boolean test.
;                   $v_TrueVal  - Value to return if $f_Test is true.
;                   $v_FalseVal - Value to return if $f_Test is false.
; Requirement(s):   None.
; Return Value(s):  One of $v_TrueVal or $v_FalseVal.
; Author(s):        Dale (Klaatu) Thompson
;
;===============================================================================
Func _Iif($f_Test, $v_TrueVal, $v_FalseVal)
	If $f_Test Then
		Return $v_TrueVal
	Else
		Return $v_FalseVal
	EndIf
EndFunc   ;==>_Iif
;===============================================================================
;
; Description:    _MouseTrap
; Parameter(s):	$i_left - Left coord
;                 $i_top - Top coord
;                 $i_right - Right coord
;                 $i_bottom - Bottom coord
; User CallTip:   _MouseTrap([$i_left = 0[, $i_top = 0[, $i_right = 0[, $i_bottom = 0]]]]) Confine the Mouse Cursor to specified coords. (required: <Misc.au3>)
; Author(s):      Gary Frost (custompcs at charter dot net)
; Note(s):        Use _MouseTrap() with no params to release the Mouse Cursor
;
;===============================================================================
Func _MouseTrap($i_left = 0, $i_top = 0, $i_right = 0, $i_bottom = 0)
	Local $av_ret
	If @NumParams == 0 Then
		$av_ret = DllCall("user32.dll", "int", "ClipCursor", "int", 0)
	Else
		If @NumParams == 2 Then
			$i_right = $i_left + 1
			$i_bottom = $i_top + 1
		EndIf
		Local $Rect = DllStructCreate("int;int;int;int")
		If @error Then Return 0
		DllStructSetData($Rect, 1, $i_left)
		DllStructSetData($Rect, 2, $i_top)
		DllStructSetData($Rect, 3, $i_right)
		DllStructSetData($Rect, 4, $i_bottom)
		$av_ret = DllCall("user32.dll", "int", "ClipCursor", "ptr", DllStructGetPtr($Rect))
		;		DllStructDelete($Rect)
	EndIf
	Return $av_ret[0]
EndFunc   ;==>_MouseTrap
;===============================================================================
;
; Description:    _Singleton
; Parameter(s):	$occurenceName
;               $flag
; User CallTip:   _Singleton($occurenceName [,$flag = 0]) Check if no other occurence is running. (required: <Misc.au3>)
; Return Value(s):  if $flag = 1
; Author(s):      Valik
;
;===============================================================================
Func _Singleton($occurenceName, $flag = 0)
	Local $ERROR_ALREADY_EXISTS = 183
	$occurenceName = StringReplace($occurenceName, "\", "") ; to avoid error
	;    Local $handle = DllCall("kernel32.dll", "int", "CreateSemaphore", "int", 0, "long", 1, "long", 1, "str", $occurenceName)
	Local $handle = DllCall("kernel32.dll", "int", "CreateMutex", "int", 0, "long", 1, "str", $occurenceName)
	Local $lastError = DllCall("kernel32.dll", "int", "GetLastError")
	If $lastError[0] = $ERROR_ALREADY_EXISTS Then
		If $flag = 0 Then
			Exit -1
		Else
			SetError($lastError[0])
			Return 0
		EndIf
	EndIf
	Return $handle[0]
EndFunc   ;==>_Singleton
;
;===============================================================================
;
; Description:    _IsPressed
; Parameter(s):	$s_hexKey - key to check for
;						$v_dll = Handle to dll or default to user32.dll
;
; User CallTip:   _IsPressed($s_hexKey[, $v_dll = 'user32.dll']) Check if key has been pressed. (required: <Misc.au3>)
; Return Value(s):  1 if true
;							0 if false
; Author(s):      ezzetabi and Jon
;
;===============================================================================
Func _IsPressed($s_hexKey, $v_dll = 'user32.dll')
	; $hexKey must be the value of one of the keys.
	; _Is_Key_Pressed will return 0 if the key is not pressed, 1 if it is.
	Local $a_R = DllCall($v_dll, "int", "GetAsyncKeyState", "int", '0x' & $s_hexKey)
	If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1
	Return 0
EndFunc   ;==>_IsPressed
;
;===============================================================================
;
; Description:    _SendMessage
; Parameter(s): hwnd - window/control handle
;                  msg    - message to send to control (number)
;                  wParam - Specifies additional message-specific information (Optional: Default 0)
;                  lParam - Specifies additional message-specific information (Optional: Default 0)
;                  return - what to return (Optional: Default 0)
;                  wParam Type    - Specifies what type of additional information (Optional: Default "int")
;                  lParam Type    - Specifies what type of additional information (Optional: Default "int")
;
; User CallTip:   _SendMessage(hWnd, msg[, wParam = 0[, lParam = 0[, return = 0[, wParam Type = "int"[, lParam Type = "int"]]]]]) Wrapper for commonly used Dll Call. (required: <Misc.au3>)
; Return Value(s):
;    Success - User selected value from the DllCall() result.
;                     return = 0 thru 4 corresponds to the parameter of the _SendMessage Wrapper
;                     return < 0 or > 4 returns array same as DllCall
;    Failure - Sets @error if DllCall() fails.
; Author(s):      Valik
;
;===============================================================================
Func _SendMessage($h_hWnd, $i_msg, $wParam = 0, $lParam = 0, $i_r = 0, $s_t1 = "int", $s_t2 = "int")
	Local $a_ret = DllCall("user32.dll", "long", "SendMessage", "hwnd", $h_hWnd, "int", $i_msg, $s_t1, $wParam, $s_t2, $lParam)
	If @error Then Return SetError(@error, @extended, "")
	If $i_r >= 0 And $i_r <= 4 Then Return $a_ret[$i_r]
	Return $a_ret
EndFunc   ;==>_SendMessage

;===============================================================================
;
; Description:    _IsClassName
; Parameter(s): 	 $h_hWnd - control ID/Handle
;
; User CallTip:   _IsClassName($h_hWnd, $s_ClassName) Wrapper to return ClassName of the control. (required: <Misc.au3>)
; Return Value(s):
;    Success - 1.
;    Failure - Sets @error and returns 0.
; Author(s):			Gary Frost (custompcs at charter dot net)
;
;===============================================================================
Func _IsClassName($h_hWnd, $s_ClassName)
	If Not IsHWnd($h_hWnd) Then $h_hWnd = GUICtrlGetHandle($h_hWnd)
	Local $aResult = DllCall("user32.dll", "int", "GetClassNameA", "hwnd", $h_hWnd, "str", "", "int", 256)
	If @error Then Return SetError(@error, @error, "")
	If IsArray($aResult) Then
		If StringUpper(StringMid($aResult[2], 1, StringLen($s_ClassName))) = StringUpper($s_ClassName) Then
			Return 1
		Else
			Return 0
		EndIf
	Else
		Return SetError(-1, -1, 0)
	EndIf
EndFunc   ;==>_IsClassName

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\Misc.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\Memory.au3>
; ----------------------------------------------------------------------------

; ====================================================================================================
; AutoIt Version : 3.2.+++
; Author ........: Paul Campbell
; Modified.......: Gary Frost
; Description ...: Memory management routines
; Notes .........:
; ====================================================================================================

; ====================================================================================================
; MEMMAP Definition
; ====================================================================================================

Global Const $MEM_MAP = "uint;uint;ptr"

; ====================================================================================================
; MemMap Position Constants
; ====================================================================================================

Global Const $MEM_MAP_HPROC = 1
Global Const $MEM_MAP_ISIZE = 2
Global Const $MEM_MAP_PMEM = 3

; ====================================================================================================
; VirtualAlloc Allocation Type Constants
; ====================================================================================================

;Global Const $MEM_COMMIT = 0x00001000
;Global Const $MEM_RESERVE = 0x00002000
;Global Const $MEM_TOP_DOWN = 0x00100000
;Global Const $MEM_SHARED = 0x08000000

; ====================================================================================================
; VirtualFree FreeType Constants
; ====================================================================================================

;Global Const $MEM_DECOMMIT = 0x00004000
;Global Const $MEM_RELEASE = 0x00008000

; ====================================================================================================
; VirtualAlloc Protection Constants
; ====================================================================================================

;Global Const $PAGE_NOACCESS = 0x00000001
;Global Const $PAGE_READONLY = 0x00000002
;Global Const $PAGE_READWRITE = 0x00000004
;Global Const $PAGE_EXECUTE = 0x00000010
;Global Const $PAGE_EXECUTE_READ = 0x00000020
;Global Const $PAGE_EXECUTE_READWRITE = 0x00000040
;Global Const $PAGE_GUARD = 0x00000100
;Global Const $PAGE_NOCACHE = 0x00000200

; ====================================================================================================
; OpenProcess Access Constants
; ====================================================================================================

;Global Const $PROCESS_TERMINATE = 0x00000001
;Global Const $PROCESS_CREATE_THREAD = 0x00000002
;Global Const $PROCESS_VM_OPERATION = 0x00000008
;Global Const $PROCESS_VM_READ = 0x00000010
;Global Const $PROCESS_VM_WRITE = 0x00000020
;Global Const $PROCESS_DUP_HANDLE = 0x00000040
;Global Const $PROCESS_CREATE_PROCESS = 0x00000080
;Global Const $PROCESS_SET_INFORMATION = 0x00000200
;Global Const $PROCESS_QUERY_INFORMATION = 0x00000400
;Global Const $SYNCHRONIZE = 0x00100000
;Global Const $PROCESS_ALL_ACCESS = 0x001F0FFF

; ====================================================================================================
; Description ..: Releases a memory map structure
; Parameters ...: $rMemMap      - The MEM_MAP structure to release
; Return values : True  - Success
;                 False - Function failed
; Notes ........: $rMemMap must have first been initialized with a call to _MemInit
; ====================================================================================================
Func _MemFree(ByRef $rMemMap)
	Local $hProcess
	Local $pMemory
	Local $bResult
	Local $MEM_RELEASE = 0x00008000

	$hProcess = DllStructGetData($rMemMap, $MEM_MAP_HPROC)
	$pMemory = DllStructGetData($rMemMap, $MEM_MAP_PMEM)
	Switch @OSVersion
		Case "WIN_ME", "WIN_98", "WIN_95"
			$bResult = _VirtualFree($pMemory, 0, $MEM_RELEASE)
		Case Else
			$bResult = _VirtualFreeEx($hProcess, $pMemory, 0, $MEM_RELEASE)
	EndSwitch
	_CloseHandle($hProcess)
	$rMemMap = 0
	Return $bResult
EndFunc   ;==>_MemFree

; ====================================================================================================
; Description ..: Closes an open object handle
; Parameters ...: $hObject      - Handle of object to close
; Return values : Success - True
;                 Failure - False
; ====================================================================================================
Func _CloseHandle($hObject)
	Local $aResult = DllCall("Kernel32.dll", "int", "CloseHandle", "int", $hObject)
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	Return $aResult[0]
EndFunc   ;==>_CloseHandle

; ====================================================================================================
; Description ..: Reserves or commits a region of pages in the virtual address space  of  the  calling
;                 process. Memory allocated by this function is automatically initialized to zero.
; Parameters ...: $pAddress     - Specifies the desired starting address of the  region  to  allocate.
;                   If the memory is being reserved, the specified address is rounded down to the next
;                   64-kilobyte boundary. If the memory is already reserved and  is  being  committed,
;                   the address is rounded down to the next page boundary. To determine the size of a
;                   page on the host computer, use the GetSystemInfo function.   If this parameter is
;                   0, the system determines where to allocate the region.
;                 $iSize        - Specifies the size, in bytes, of  the  region.    If  the  $pAddress
;                   parameter is 0, this value is rounded up to the next page boundary. Otherwise, the
;                   allocated pages include all pages containing one or more bytes in the  range  from
;                   $pAddress to ($pAddress + $iSize).   This means that a 2-byte range  straddling  a
;                   page boundary causes both pages to be included in the allocated region.
;                 $iAllocation  - Specifies the type of allocation:
;                   MEM_COMMIT   - Allocates physical storage in memory or in the paging file on  disk
;                     for the specified region of pages.  An attempt to commit  an  already  committed
;                     page will not cause the function to fail.  This means that a range of  committed
;                     or decommitted pages can be committed without having to worry about a failure.
;                   MEM_RESERVE  - Reserves a range of the process's  virtual  address  space  without
;                     allocating any physical storage.  The reserved range cannot be used by any other
;                     allocation operations until it is released.   Reserved pages can be committed in
;                     subsequent calls to VirtualAlloc.
;                   MEM_TOP_DOWN - Allocates memory at the highest possible address.
;                 $iProtect     - Type of access protection:
;                   PAGE_READONLY          - Enables read access to the committed region of pages.  An
;                     attempt to write to the committed region results in an access violation.
;                   PAGE_READWRITE         - Enables read and write access to the committed region
;                   PAGE_EXECUTE           - Enables execute access to the committed region
;                   PAGE_EXECUTE_READ      - Enables execute and read access to the committed region
;                   PAGE_EXECUTE_READWRITE - Enables execute, read, and write access to the  committed
;                     region of pages.
;                   PAGE_GUARD             - Pages in the region become guard pages.   Any attempt  to
;                     read from or write to a guard page  causes  the  operating  system  to  raise  a
;                     STATUS_GUARD_PAGE exception and turn off the guard page status.
;                   PAGE_NOACCESS          - Disables all access to the committed region of pages
;                   PAGE_NOCACHE           - Allows no caching of the committed regions of pages.  The
;                     hardware attributes for the physical memory should be specified as "no cache."
; Return values : Memory address pointer
; ====================================================================================================
Func _VirtualAlloc($pAddress, $iSize, $iAllocation, $iProtect)
	Local $aResult = DllCall("Kernel32.dll", "ptr", "VirtualAlloc", "ptr", $pAddress, "int", $iSize, "int", $iAllocation, "int", $iProtect)
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	Return $aResult[0]
EndFunc   ;==>_VirtualAlloc

; ====================================================================================================
; Description ..: Reserves a region of memory within the virtual address space of a specified process
; Parameters ...: $hProcess     - Handle to a process.   The function allocates memory in the  virtual
;                   address space of this process.   You must have PROCESS_VM_OPERATION access to  the
;                   process. If you do not, the function fails.
;                 $pAddress     - Same as VirtualAlloc
;                 $iSize        - Same as VirtualAlloc
;                 $iAllocation  - Same as VirtualAlloc
;                 $iProtect     - Same as VirtualAlloc
; Return values : Memory address pointer
; ====================================================================================================
Func _VirtualAllocEx($hProcess, $pAddress, $iSize, $iAllocation, $iProtect)
	Local $aResult = DllCall("Kernel32.dll", "ptr", "VirtualAllocEx", "int", $hProcess, "ptr", $pAddress, "int", $iSize, "int", $iAllocation, "int", $iProtect)
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	Return $aResult[0]
EndFunc   ;==>_VirtualAllocEx

; ====================================================================================================
; Description ..: Releases a region of pages within the virtual address space of a process
; Parameters ...: $pAddress     - Points to the base address of the region of pages to be  freed.   If
;                   the $iFreeType parameter includes MEM_RELEASE this  parameter  must  be  the  base
;                   address returned by VirtualAlloc when the region of pages was reserved.
;                 $iSize        - Specifies the size, in bytes, of the region to  be  freed.   If  the
;                   $iFreeType parameter includes the MEM_RELEASE flag, this parameter must  be  zero.
;                   Otherwise, the region of affected pages includes all pages containing one or  more
;                   bytes in the range from the  $pAddress  parameter  to  ($pAddress + $iSize).  This
;                   means that a 2-byte range straddling a page boundary causes both pages to be freed.
;                 $iFreeType    - Specifies the type of free operation:
;                   MEM_DECOMMIT - Decommits the specified region of committed pages.   An attempt  to
;                     decommit an uncommitted page will not cause the function  to  fail.  This  means
;                     that a range of committed  or  uncommitted  pages  can  be  decommitted  without
;                     having to worry about a failure.
;                   MEM_RELEASE  - Releases the specified region of reserved pages.   If this flag  is
;                     specified, the $iSize parameter must be zero or the function fails.
; Return values : Success - True
;                 Failure - False
; ====================================================================================================
Func _VirtualFree($pAddress, $iSize, $iFreeType)
	Local $aResult = DllCall("Kernel32.dll", "ptr", "VirtualFree", "ptr", $pAddress, "int", $iSize, "int", $iFreeType)
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	Return $aResult[0]
EndFunc   ;==>_VirtualFree

; ====================================================================================================
; Description ..: Releases a region of pages within the virtual address space of a process
; Parameters ...: $hProcess     - Handle to a process.   The function frees memory within the  virtual
;                   address space of this process.   You must have PROCESS_VM_OPERATION access to this
;                   process. If you do not, the function fails.
;                 $pAddress     - See _VirtualFree
;                 $iSize        - See _VirtualFree
;                 $iFreeType    - See _VirtualFree
; Return values : Success - True
;                 Failure - False
; ====================================================================================================
Func _VirtualFreeEx($hProcess, $pAddress, $iSize, $iFreeType)
	Local $aResult = DllCall("Kernel32.dll", "ptr", "VirtualFreeEx", "hwnd", $hProcess, "ptr", $pAddress, "int", $iSize, "int", $iFreeType)
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	Return $aResult[0]
EndFunc   ;==>_VirtualFreeEx

; ====================================================================================================
; Description ..: Retrieves the identifier of the thread that created the  specified  window  and  the
;                 identifier of the process that created the window.
; Parameters ...: $hWnd         - Window handle
;                 $iProcessID   - Process ID of the specified window.  If this parameter is not 0, the
;                                 function copies the identifier of the process otherwise it does not.
; Return values : Thread ID of the specified window
; ====================================================================================================
Func _GetWindowThreadProcessId($hWnd, ByRef $iProcessID)
	Local $rProcessID, $aResult
	$rProcessID = DllStructCreate("int")
	$aResult = DllCall("User32.dll", "int", "GetWindowThreadProcessId", "hwnd", $hWnd, "ptr", DllStructGetPtr($rProcessID))
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	$iProcessID = DllStructGetData($rProcessID, 1)
	Return $aResult[0]
EndFunc   ;==>_GetWindowThreadProcessId

; ====================================================================================================
; Description ..: Returns a handle of an existing process object
; Parameters ...: $iAccess      - Specifies the access to the process object
;                 $bInherit     - Specifies whether the returned handle can be inherited
;                 $iProcessID   - Specifies the process identifier of the process to open
; Return values : Open process handle to the object
; ====================================================================================================
Func _OpenProcess($iAccess, $bInherit, $iProcessID)
	Local $aResult = DllCall("Kernel32.Dll", "int", "OpenProcess", "int", $iAccess, "int", $bInherit, "int", $iProcessID)
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	Return $aResult[0]
EndFunc   ;==>_OpenProcess

; ====================================================================================================
; Description ..: Read memory in a specified process
; Parameters ...: $hProcess     - Identifies an open handle of a process whose memory  is  read.   The
;                   handle must have PROCESS_VM_READ access to the process.
;                 $pBaseAddress - Points to the base address in the  specified  process  to  be  read.
;                   Before any data transfer occurs, the system verifies that all  data  in  the  base
;                   address and memory of the specified size is accessible for read access. If this is
;                   the case the function proceeds otherwise the function fails.
;                 $pBuffer      - Points to a buffer that receives the contents from the address space
;                   of the specified process.
;                 $iSize        - Specifies the requested number of bytes to read from  the  specified
;                   process.
;                 $iBytesRead   - The actual number of bytes transferred into the specified buffer. If
;                   $iBytesRead is 0, the parameter is ignored.
; Return values : Success - True
;                 Failure - False
; ====================================================================================================
Func _ReadProcessMemory($hProcess, $pBaseAddress, $pBuffer, $iSize, ByRef $iBytesRead)
	Local $rBytesRead = DllStructCreate("int")
	Local $aResult = DllCall("Kernel32.dll", "int", "ReadProcessMemory", "int", $hProcess, "int", $pBaseAddress, _
			"ptr", $pBuffer, "int", $iSize, "ptr", DllStructGetPtr($rBytesRead))
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	$iBytesRead = DllStructGetData($rBytesRead, 1)
	$rBytesRead = 0
	Return $aResult[0]
EndFunc   ;==>_ReadProcessMemory

; ====================================================================================================
; Description ..: Writes memory in a specified process
; Parameters ...: $hProcess     - Identifies an open handle to a process whose memory is to be written
;                   to.   The handle must have PROCESS_VM_WRITE and PROCESS_VM_OPERATION access to the
;                   process.
;                 $pBaseAddress - Points to the base address in the specified process to be written to
;                   Before any data transfer occurs, the system verifies that all  data  in  the  base
;                   address and memory of the specified size is accessible for write access. If so the
;                   function proceeds otherwise the function fails.
;                 $pBuffer      - Points to the buffer that supplies  data  to  be  written  into  the
;                   address space of the specified process.
;                 $iSize        - Specifies the number of bytes to write into the specified process
;                 $iBytesWritten- The actual number of bytes transferred into the  specified  process.
;                   This parameter is optional. If $iBytesWritten is 0, the parameter is ignored.
; Return values : Success - True
;                 Failure - False
; ====================================================================================================
Func _WriteProcessMemory($hProcess, $pBaseAddress, $pBuffer, $iSize, ByRef $iBytesWritten)
	Local $rBytesWritten = DllStructCreate("int")
	Local $aResult = DllCall("Kernel32.dll", "int", "WriteProcessMemory", "int", $hProcess, "int", $pBaseAddress, _
			"ptr", $pBuffer, "int", $iSize, "int", DllStructGetPtr($rBytesWritten))
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	$iBytesWritten = DllStructGetData($rBytesWritten, 1)
	$rBytesWritten = 0
	Return $aResult[0]
EndFunc   ;==>_WriteProcessMemory


; ====================================================================================================
; Description ..: Initializes a memory map structure based on a windows handle
; Parameters ...: $hWnd         - Window handle of the process where memory will be mapped
;                 $iSize        - Size in bytes of memory space
;                 $rMemMap      - MEM_MAP structure
;                 $pAddress     - Pointer that specifies a desired starting address for the region  of
;                   pages that you want to allocate.  If you are reserving memory, the function rounds
;                   this address down to the nearest 64K  boundary.  If you are committing memory that
;                   is already reserved, the function rounds this address down  to  the  nearest  page
;                   boundary. To determine the size of a page, use  the  GetSystemInfo  function.   If
;                   $pAddress is 0, the function will determine where to allocate the region.
; Return values : Pointer to reserved memory
; ====================================================================================================
Func _MemInit($hWnd, $iSize, ByRef $rMemMap, $pAddress = 0)
	Local $iAccess, $iAllocation
	Local $pMemory, $hProcess
	Local $iProcessID
	Local $PROCESS_VM_OPERATION = 0x00000008
	Local $PROCESS_VM_READ = 0x00000010
	Local $PROCESS_VM_WRITE = 0x00000020
	Local $MEM_RESERVE = 0x00002000
	Local $MEM_COMMIT = 0x00001000
	Local $MEM_SHARED = 0x08000000
	Local $PAGE_READWRITE = 0x00000004
;~ 	, $iThreadID

;~ 	$iThreadID = _GetWindowThreadProcessId($hWnd, $iProcessID)
	_GetWindowThreadProcessId($hWnd, $iProcessID)
	$iAccess = BitOR($PROCESS_VM_OPERATION, $PROCESS_VM_READ, $PROCESS_VM_WRITE)
	$hProcess = _OpenProcess($iAccess, False, $iProcessID)
	Switch @OSVersion
		Case "WIN_ME", "WIN_98", "WIN_95"
			$iAllocation = BitOR($MEM_RESERVE, $MEM_COMMIT, $MEM_SHARED)
			$pMemory = _VirtualAlloc($pAddress, $iSize, $iAllocation, $PAGE_READWRITE)
		Case Else
			$iAllocation = BitOR($MEM_RESERVE, $MEM_COMMIT)
			$pMemory = _VirtualAllocEx($hProcess, $pAddress, $iSize, $iAllocation, $PAGE_READWRITE)
	EndSwitch
	If @error Then Return SetError(-1, -1, 0)
	$rMemMap = DllStructCreate($MEM_MAP)
	DllStructSetData($rMemMap, $MEM_MAP_HPROC, $hProcess)
	DllStructSetData($rMemMap, $MEM_MAP_ISIZE, $iSize)
	DllStructSetData($rMemMap, $MEM_MAP_PMEM, $pMemory)
	Return $pMemory
EndFunc   ;==>_MemInit

; ====================================================================================================
; Description ..: Transfer memory from external address space to internal address space
; Parameters ...: $rMemMap      - MEM_MAP structure
;                 $pSrce        - Pointer to external memory
;                 $pDest        - Pointer to internal memory
;                 $iSize        - Size in bytes of memory to read
; Return values : True  - Success
;                 False - Failure
; ====================================================================================================
Func _MemRead($rMemMap, $pSrce, $pDest, $iSize)
	Local $hProcess
	Local $iWritten

	$hProcess = DllStructGetData($rMemMap, $MEM_MAP_HPROC)
	Return _ReadProcessMemory($hProcess, $pSrce, $pDest, $iSize, $iWritten)
EndFunc   ;==>_MemRead

; ====================================================================================================
; Description ..: Transfer memory to external address space from internal address space
; Parameters ...: $rMemMap      - MEM_MAP structure
;                 $pSrce        - Pointer to internal memory
;                 $pDest        - Pointer to external memory.    If this value is 0, then  the  memory
;                   pointer from $rMemMap will be used.
;                 $iSize        - Size in bytes of memory to write.  If this value is 0, then the size
;                   value from $rMemMap will be used.
; Return values : True  - Success
;                 False - Failure
; ====================================================================================================
Func _MemWrite($rMemMap, $pSrce, $pDest = 0, $iSize = 0)
	Local $hProcess
	Local $iWritten

	If $pDest = 0 Then
		$pDest = DllStructGetData($rMemMap, $MEM_MAP_PMEM)
	EndIf
	If $iSize = 0 Then
		$iSize = DllStructGetData($rMemMap, $MEM_MAP_ISIZE)
	EndIf
	$hProcess = DllStructGetData($rMemMap, $MEM_MAP_HPROC)
	Return _WriteProcessMemory($hProcess, $pDest, $pSrce, $iSize, $iWritten)
EndFunc   ;==>_MemWrite

; ====================================================================================================
; Description ..: Maps a character string to a wide-character (Unicode) string
; Parameters ...: $sText        - Text to be converted
;                 $iCodePage    - Specifies the code page to be used to perform the conversion:
;                   CP_ACP   - ANSI code page
;                   CP_MACCP - Macintosh code page
;                   CP_OEMCP - OEM code page
;                 $iFlags       - A set of bit flags that indicate whether to translate to precomposed
;                   or composite wide characters:
;                   MB_PRECOMPOSED   - Always use precomposed characters
;                   MB_COMPOSITE     - Always use composite characters
;                   MB_USEGLYPHCHARS - Use glyph characters instead of control characters
; Return values : Structure that contains the Unicode character string
; ====================================================================================================
Func _MultiByteToWideChar($s_Text, $i_CodePage = 0, $i_Flags = 1)
	Local $iBuffLen = StringLen($s_Text)
	Local $rUnicode = DllStructCreate("byte[" & ($iBuffLen * 2) & "]")
	Local $pUnicode = DllStructGetPtr($rUnicode)
	DllCall("Kernel32.dll", "int", "MultiByteToWideChar", "int", $i_CodePage, "int", $i_Flags, _
			"str", $s_Text, "int", $iBuffLen, "ptr", $pUnicode, "int", $iBuffLen * 2)
	If @error Then Return SetError(-1, -1, 0)
	Return DllStructGetData($rUnicode, 1)
EndFunc   ;==>_MultiByteToWideChar

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\Memory.au3>
; ----------------------------------------------------------------------------


; ------------------------------------------------------------------------------
;
; AutoIt Version: 3.2.3++
; Language:       English
; Description:    Functions that assist with ListView.
;
; ------------------------------------------------------------------------------

; ------------------------------------------------------------------------------
; These functions use some code developed by Paul Campbell (PaulIA) for the Auto3Lib project
; particularly the _Mem* function calls which can be found in Memory.au3
; ------------------------------------------------------------------------------

; ------------------------------------------------------------------------------
; ------------------------------------------------------------------------------
; ------------------------------------------------------------------------------
; These Will need to be added to the ListViewConstants.au3 when we are finished
; From A3LConstants.au3
Global Const $LVITEM = "int;int;int;int;int;ptr;int;int;int;int"
; converted from constants to Enum
Global Enum $LVI_MASK = 1, $LVI_IITEM, $LVI_ISUBITEM, $LVI_STATE, $LVI_STATEMASK, $LVI_PSZTEXT, _
		$LVI_CCHTEXTMAX, $LVI_IIMAGE, $LVI_LPARAM, $LVI_IINDENT

;~ Global Const $LVCOLUMN                          = "int;int;int;ptr;int;int;int;int"
Global $LVCOLUMN = "uint;int;int;ptr;int;int;int;int"
; converted from constants to Enum
Global Enum $LVC_MASK = 1, $LVC_FMT, $LVC_CX, $LVC_PSZTEXT, $LVC_CCHTEXTMAX, $LVC_ISUBITEM, $LVC_IIMAGE, $LVC_IORDER

; What I was using
;~ Global Const $LVITEM                            = "int;int;int;int;int;ptr;int;int;int;int;int;ptr"
; ------------------------------------------------------------------------------
; ------------------------------------------------------------------------------
; ------------------------------------------------------------------------------


; function list
;===============================================================================
; _GUICtrlListViewCopyItems
; _GUICtrlListViewDeleteAllItems
; _GUICtrlListViewDeleteColumn
; _GUICtrlListViewDeleteItem
; _GUICtrlListViewDeleteItemsSelected
; _GUICtrlListViewEnsureVisible
; _GUICtrlListViewGetBackColor
; _GUICtrlListViewGetCallBackMask
; _GUICtrlListViewGetCheckedState
; _GUICtrlListViewGetColumnOrder
; _GUICtrlListViewGetColumnWidth
; _GUICtrlListViewGetCounterPage
; _GUICtrlListViewGetCurSel
; _GUICtrlListViewGetExtendedListViewStyle
; _GUICtrlListViewGetHeader
; _GUICtrlListViewGetHotCursor
; _GUICtrlListViewGetHotItem
; _GUICtrlListViewGetHoverTime
; _GUICtrlListViewGetItemCount
; _GUICtrlListViewGetItemText
; _GUICtrlListViewGetItemTextArray
; _GUICtrlListViewGetNextItem
; _GUICtrlListViewGetSelectedCount
; _GUICtrlListViewGetSelectedIndices
; _GUICtrlListViewGetSubItemsCount
; _GUICtrlListViewGetTopIndex
; _GUICtrlListViewGetUnicodeFormat
; _GUICtrlListViewHideColumn
; _GUICtrlListViewInsertColumn
; _GUICtrlListViewInsertItem
; _GUICtrlListViewJustifyColumn
; _GUICtrlListViewScroll
; _GUICtrlListViewSetCheckState
; _GUICtrlListViewSetColumnHeaderText
; _GUICtrlListViewSetColumnOrder
; _GUICtrlListViewSetColumnWidth
; _GUICtrlListViewSetHotItem
; _GUICtrlListViewSetHoverTime
; _GUICtrlListViewSetItemCount
; _GUICtrlListViewSetItemSelState
; _GUICtrlListViewSetItemText
; _GUICtrlListViewSort
;===============================================================================

;===============================================================================
;
; Description:			_GUICtrlListViewCopyItems
; Parameter(s):		$h_Source_listview - controlID
;							$h_Destination_listview - control ID
;							$i_DelFlag - Delete after copying (Default: 0)
; Requirement:			None
; Return Value(s):	None
; User CallTip:		_GUICtrlListViewCopyItems($h_Source_listview, $h_Destination_listview[, $i_DelFlag = 0]) Copy Items between 2 list-view controls (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewCopyItems($h_Source_listview, $h_Destination_listview, $i_DelFlag = 0)
	If Not _IsClassName ($h_Source_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	If Not _IsClassName ($h_Destination_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	Local $a_indices, $i, $s_item, $items
	$items = _GUICtrlListViewGetItemCount($h_Source_listview)

	If BitAND(_GUICtrlListViewGetExtendedListViewStyle($h_Source_listview), $LVS_EX_CHECKBOXES) == $LVS_EX_CHECKBOXES Then
		For $i = 0 To $items - 1
			If (_GUICtrlListViewGetCheckedState($h_Source_listview, $i)) Then
				If IsArray($a_indices) Then
					ReDim $a_indices[UBound($a_indices) + 1]
				Else
					Local $a_indices[2]
				EndIf
				$a_indices[0] = $a_indices[0] + 1
				$a_indices[UBound($a_indices) - 1] = $i
			EndIf
		Next

		If (IsArray($a_indices)) Then
			For $i = 1 To $a_indices[0]
				$s_item = _GUICtrlListViewGetItemText($h_Source_listview, $a_indices[$i])
				_GUICtrlListViewSetCheckState($h_Source_listview, $a_indices[$i], 0)
				_GUICtrlListViewInsertItem($h_Destination_listview, _GUICtrlListViewGetItemCount($h_Destination_listview), $s_item)
			Next
			If $i_DelFlag Then
				For $i = $a_indices[0] To 1 Step - 1
					_GUICtrlListViewSetItemSelState($h_Source_listview, $a_indices[$i])
					_GUICtrlListViewDeleteItem($h_Source_listview, $a_indices[$i])
				Next
			EndIf
		EndIf
	EndIf
	If (_GUICtrlListViewGetSelectedCount($h_Source_listview)) Then
		$a_indices = _GUICtrlListViewGetSelectedIndices($h_Source_listview, 1)
		For $i = 1 To $a_indices[0]
			$s_item = _GUICtrlListViewGetItemText($h_Source_listview, $a_indices[$i])
			_GUICtrlListViewInsertItem($h_Destination_listview, _GUICtrlListViewGetItemCount($h_Destination_listview), $s_item)
		Next
		_GUICtrlListViewSetItemSelState($h_Source_listview, -1, 0)
		If $i_DelFlag Then
			For $i = $a_indices[0] To 1 Step - 1
				_GUICtrlListViewSetItemSelState($h_Source_listview, $a_indices[$i])
				_GUICtrlListViewDeleteItem($h_Source_listview, $a_indices[$i])
			Next
		EndIf
	EndIf
EndFunc   ;==>_GUICtrlListViewCopyItems

;===============================================================================
;
; Description:			_GUICtrlListViewDeleteAllItems
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
; User CallTip:		_GUICtrlListViewDeleteAllItems($h_listview) Removes all items from a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewDeleteAllItems($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	Local $i_index, $control_ID
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_DELETEALLITEMS)
	Else
		For $i_index = _GUICtrlListViewGetItemCount($h_listview) - 1 To 0 Step - 1
			_GUICtrlListViewSetItemSelState($h_listview, $i_index, 1)
			$control_ID = GUICtrlRead($h_listview)
			If $control_ID Then GUICtrlDelete($control_ID)
		Next
		If _GUICtrlListViewGetItemCount($h_listview) == 0 Then
			Return 1
		Else
			Return GUICtrlSendMsg($h_listview, $LVM_DELETEALLITEMS, 0, 0)
		EndIf
	EndIf
EndFunc   ;==>_GUICtrlListViewDeleteAllItems

;===============================================================================
;
; Description:			_GUICtrlListViewDeleteColumn
; Parameter(s):		$h_listview - controlID
;							$i_col - Index of the column to delete
; Requirement:			None
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
; User CallTip:		_GUICtrlListViewDeleteColumn($h_listview, $i_col) Removes a column from a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				Column zero of the list-view control cannot be deleted.
;							If you must delete column zero, insert a zero length dummy
;							column zero and delete column one and above
;
;===============================================================================
Func _GUICtrlListViewDeleteColumn($h_listview, $i_col)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_DELETECOLUMN, $i_col)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_DELETECOLUMN, $i_col, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewDeleteColumn

;===============================================================================
;
; Description:			_GUICtrlListViewDeleteItem
; Parameter(s):		$h_listview - controlID
;							$i_index - Index of the list-view item to delete
; Requirement:			None
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
; User CallTip:		_GUICtrlListViewDeleteItem($h_listview, $i_index) Removes an item from a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewDeleteItem($h_listview, $i_index)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	Local $control_ID, $ID_Check
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_DELETEITEM, $i_index)
	Else
		_GUICtrlListViewSetItemSelState($h_listview, -1, 0)
		_GUICtrlListViewSetItemSelState($h_listview, $i_index)
		$control_ID = GUICtrlRead($h_listview)
		If $control_ID Then
			GUICtrlDelete($control_ID)
			_GUICtrlListViewSetItemSelState($h_listview, $i_index)
			$ID_Check = GUICtrlRead($h_listview)
			_GUICtrlListViewSetItemSelState($h_listview, $i_index, 0)
			If $control_ID <> $ID_Check Then
				Return 1
			Else
				Return GUICtrlSendMsg($h_listview, $LVM_DELETEITEM, $i_index, 0)
			EndIf
		Else
			If Not GUICtrlSendMsg($h_listview, $LVM_DELETEITEM, $i_index, 0) Then
				Return _SendMessage($h_listview, $LVM_DELETEITEM, $i_index)
			Else
				Return 1
			EndIf
		EndIf
	EndIf
EndFunc   ;==>_GUICtrlListViewDeleteItem

;===============================================================================
;
; Description:			_GUICtrlListViewDeleteItemsSelected
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	None
; User CallTip:		_GUICtrlListViewDeleteItemsSelected($h_listview) Deletes item(s) selected (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				Idea from Holger
;
;===============================================================================
Func _GUICtrlListViewDeleteItemsSelected($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	Local $i, $ItemCount

	$ItemCount = _GUICtrlListViewGetItemCount($h_listview)
	If (_GUICtrlListViewGetSelectedCount($h_listview) == $ItemCount) Then
		_GUICtrlListViewDeleteAllItems($h_listview)
	Else
		Local $items = _GUICtrlListViewGetSelectedIndices($h_listview, 1)
		If Not IsArray($items) Then Return SetError($LV_ERR, $LV_ERR, 0)
		_GUICtrlListViewSetItemSelState($h_listview, -1, 0)
		For $i = $items[0] To 1 Step - 1
			_GUICtrlListViewDeleteItem($h_listview, $items[$i])
		Next
	EndIf
EndFunc   ;==>_GUICtrlListViewDeleteItemsSelected

;===============================================================================
;
; Description:			_GUICtrlListViewEnsureVisible
; Parameter(s):		$h_listview - controlID
;							$i_index - Index of the list-view item
;							$i_bool - Value specifying whether the item must be entirely visible
; Requirement:			None
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
; User CallTip:		_GUICtrlListViewEnsureVisible($h_listview, $i_index, $i_bool) Ensures that a list-view item is either entirely or partially visible (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				If $i_bool parameter is TRUE, no scrolling occurs if the item is at least partially visible
;
;===============================================================================
Func _GUICtrlListViewEnsureVisible($h_listview, $i_index, $i_bool)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_ENSUREVISIBLE, $i_index, $i_bool)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_ENSUREVISIBLE, $i_index, $i_bool)
	EndIf
EndFunc   ;==>_GUICtrlListViewEnsureVisible

;===============================================================================
;
; Description:			_GUICtrlListViewFindItem
; Parameter(s):		$h_listview 	- controlID
;							$v_find			- Text/Item Id to find (See Notes)
;							$i_Start			- Index of the item to begin the search with or -1 to start from the beginning.
;													The specified item is itself excluded from the search. (Optional: Default -1)
;							$v_SearchType	- Type of search to perform (See Notes)
;							$v_direction	- Virtual key code that specifies the direction to search (See Notes)
; Requirement:			None
; Return Value(s):	Returns index if successful, or -1 otherwise
; User CallTip:		_GUICtrlListViewFindItem($h_listview, $v_find[, $i_Start = -1[, $v_SearchType = 0x8[, $v_direction = 0x28]]]) Searches for a list-view item (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):
;	$v_SearchType:
;		$LVFI_PARAM
;			Search by Item Id
;		$LVFI_PARTIAL (Default)
;			Checks to see if the item text begins with the string pointed to by the psz member.
;			This value implies use of $LVFI_STRING.
;		$LVFI_STRING
;			Searches based on the item text.
;			Unless additional values are specified, the item text of the matching item must exactly
;			match the string pointed to by the psz member. However, the search is case-insensitive.
;		$LVFI_WRAP
;			Continues the search at the beginning if no match is found
;
;	$v_direction
;		$VK_LEFT
;		$VK_RIGHT
;		$VK_UP
;		$VK_DOWN
;		$VK_HOME
;		$VK_END
;===============================================================================
Func _GUICtrlListViewFindItem($h_listview, $v_find, $i_Start = -1, $v_SearchType = 0x8, $v_direction = 0x28)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $struct_String, $struct_LVFINDINFO, $iResult
	Local $i_Size, $struct_LVFINDINFO_pointer, $struct_MemMap, $Memory_pointer, $string_Memory_pointer, $sBuffer_pointer

	$struct_LVFINDINFO = DllStructCreate("uint;ptr;int;int[2];int")
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	DllStructSetData($struct_LVFINDINFO, 1, $v_SearchType)
	If BitAND($v_SearchType, $LVFI_PARAM) = $LVFI_PARAM Then
		DllStructSetData($struct_LVFINDINFO, 3, $v_find)
	Else
		If StringLen($v_find) = 0 Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		$struct_String = DllStructCreate("char[" & StringLen($v_find) + 1 & "]")
		$sBuffer_pointer = DllStructGetPtr($struct_String)
		DllStructSetData($struct_String, 1, $v_find)
	EndIf
	DllStructSetData($struct_LVFINDINFO, 6, $v_direction)

	If IsHWnd($h_listview) Then
		$i_Size = DllStructGetSize($struct_LVFINDINFO)
		$struct_LVFINDINFO_pointer = DllStructGetPtr($struct_LVFINDINFO)
		If BitAND($v_SearchType, $LVFI_PARAM) = $LVFI_PARAM Then
			$Memory_pointer = _MemInit ($h_listview, $i_Size, $struct_MemMap)
			If @error Then
				_MemFree ($struct_MemMap)
				Return SetError($LV_ERR, $LV_ERR, 0)
			EndIf
			_MemWrite ($struct_MemMap, $struct_LVFINDINFO_pointer)
		Else
			$Memory_pointer = _MemInit ($h_listview, $i_Size + StringLen($v_find) + 1, $struct_MemMap)
			If @error Then
				_MemFree ($struct_MemMap)
				Return SetError($LV_ERR, $LV_ERR, 0)
			EndIf
			$string_Memory_pointer = $Memory_pointer + $i_Size
			DllStructSetData($struct_LVFINDINFO, 2, $string_Memory_pointer)
			_MemWrite ($struct_MemMap, $struct_LVFINDINFO_pointer)
			_MemWrite ($struct_MemMap, $sBuffer_pointer, $string_Memory_pointer, 4096)

		EndIf
		$iResult = _SendMessage($h_listview, $LVM_FINDITEM, $i_Start, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, 0)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, 0)
		Return $iResult
	Else
		If BitAND($v_SearchType, $LVFI_PARAM) <> $LVFI_PARAM Then
			DllStructSetData($struct_LVFINDINFO, 2, DllStructGetPtr($struct_String))
		EndIf
		Return GUICtrlSendMsg($h_listview, $LVM_FINDITEM, $i_Start, DllStructGetPtr($struct_LVFINDINFO))
	EndIf
EndFunc   ;==>_GUICtrlListViewFindItem

;===============================================================================
;
; Description:			_GUICtrlListViewGetBackColor
; Parameter(s):		$h_listview - controlID
; Requirement:			_ReverseColorOrder
; Return Value(s):	Returns the Hex RGB background color of the list-view control
; User CallTip:		_GUICtrlListViewGetBackColor($h_listview) Retrieves the background color of a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetBackColor($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $v_color
	If IsHWnd($h_listview) Then
		$v_color = _SendMessage($h_listview, $LVM_GETBKCOLOR)
	Else
		$v_color = GUICtrlSendMsg($h_listview, $LVM_GETBKCOLOR, 0, 0)
	EndIf
	Return _ReverseColorOrder($v_color)
EndFunc   ;==>_GUICtrlListViewGetBackColor

;===============================================================================
;
; Description:			_GUICtrlListViewGetCallBackMask
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the callback mask
; User CallTip:		_GUICtrlListViewGetCallBackMask($h_listview) Retrieves the callback mask for a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetCallBackMask($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETCALLBACKMASK)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETCALLBACKMASK, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetCallBackMask

;===============================================================================
;
; Description:			_GUICtrlListViewGetCheckedState
; Parameter(s):		$h_listview - controlID
;							$i_index - zero-based index to retrieve item check state from
; Requirement:			$LVS_EX_CHECKBOXES used in extended style when creating listview
; Return Value(s):	Returns 1 if checked
;							Returns 0 if not checked
;							If error then $LV_ERR is returned
; User CallTip:		_GUICtrlListViewGetCheckedState($h_listview, $i_index) Returns the check state for a list-view control item (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetCheckedState($h_listview, $i_index)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $isChecked = 0, $ret
	If IsHWnd($h_listview) Then
		$ret = _SendMessage($h_listview, $LVM_GETITEMSTATE, $i_index, $LVIS_STATEIMAGEMASK)
	Else
		$ret = GUICtrlSendMsg($h_listview, $LVM_GETITEMSTATE, $i_index, $LVIS_STATEIMAGEMASK)
	EndIf
	If (Not $ret) Then
		$ret = _SendMessage($h_listview, $LVM_GETITEMSTATE, $i_index, $LVIS_STATEIMAGEMASK)
		If ($ret == -1) Then
			Return $LV_ERR
		Else
			If (BitAND($ret, 0x3000) == 0x3000) Then
				$isChecked = 0
			Else
				$isChecked = 1
			EndIf
		EndIf
	Else
		If (BitAND($ret, 0x2000) == 0x2000) Then $isChecked = 1
	EndIf
	Return $isChecked
EndFunc   ;==>_GUICtrlListViewGetCheckedState

;===============================================================================
;
; Description:			_GUICtrlListViewGetColumnOrder
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	"|" delimited string
;							If an error occurs, the return value is $LV_ERR.
; User CallTip:		_GUICtrlListViewGetColumnOrder($h_listview) Retrieves the current left-to-right order of columns in a list-view control. (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):
;
;===============================================================================
Func _GUICtrlListViewGetColumnOrder($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $i_cols = _GUICtrlListViewGetSubItemsCount($h_listview)
	Local $i, $ret
	Local $struct = ""
	For $i = 1 To $i_cols
		$struct &= "int;"
	Next
	$struct = StringTrimRight($struct, 1)
	Local $column_struct = DllStructCreate($struct)
	If @error Then Return $LV_ERR
	If IsHWnd($h_listview) Then
		Local $struct_MemMap, $sBuffer_pointer
		$sBuffer_pointer = DllStructGetPtr($column_struct)
		Local $i_Size = DllStructGetSize($column_struct)
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, 0)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_GETCOLUMNORDERARRAY, $i_cols, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, 0)
		EndIf
		_MemRead ($struct_MemMap, $Memory_pointer, $sBuffer_pointer, $i_Size)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, 0)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, 0)
	Else
		$ret = GUICtrlSendMsg($h_listview, $LVM_GETCOLUMNORDERARRAY, $i_cols, DllStructGetPtr($column_struct))
	EndIf
	If (Not $ret) Then Return $LV_ERR
	Local $s_cols
	For $i = 1 To $i_cols
		$s_cols &= DllStructGetData($column_struct, $i) & "|"
	Next
	$s_cols = StringTrimRight($s_cols, 1)
	Return $s_cols
EndFunc   ;==>_GUICtrlListViewGetColumnOrder

;===============================================================================
;
; Description:			_GUICtrlListViewGetColumnWidth
; Parameter(s):		$h_listview - controlID
;							$i_col - Index of the column. This parameter is ignored in list view
; Requirement:			None
; Return Value(s):	Returns the column width if successful, or zero otherwise
; User CallTip:		_GUICtrlListViewGetColumnWidth($h_listview, $i_col) Retrieves the width of a column in report or list view (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				If this message is sent to a list-view control with the LVS_REPORT style
;							and the specified column doesn't exist, the return value is undefined
;
;===============================================================================
Func _GUICtrlListViewGetColumnWidth($h_listview, $i_col)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETCOLUMNWIDTH, $i_col)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETCOLUMNWIDTH, $i_col, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetColumnWidth

;===============================================================================
;
; Description:			_GUICtrlListViewGetCounterPage
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the number of fully visible items if successful.
;							If the current view is icon or small icon view, the return value
;							is the total number of items in the list-view control.
; User CallTip:		_GUICtrlListViewGetCounterPage($h_listview) Calculates the number of items that can fit vertically in the visible area of a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetCounterPage($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETCOUNTPERPAGE)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETCOUNTPERPAGE, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetCounterPage

;===============================================================================
;
; Description:			_GUICtrlListViewGetCurSel
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Index of current selection (zero-based index)
;							returns $LV_ERR if error
; User CallTip:		_GUICtrlListViewGetCurSel($h_listview) Retrieve the index of current selection (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetCurSel($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If _GUICtrlListViewGetSelectedCount($h_listview) > 0 Then
		Return Int(_GUICtrlListViewGetSelectedIndices($h_listview))
	Else
		Return $LV_ERR
	EndIf
EndFunc   ;==>_GUICtrlListViewGetCurSel

;===============================================================================
;
; Description:			_GUICtrlListViewGetExtendedListViewStyle
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns a DWORD that represents the styles currently in use for a given list-view control.
;							This value can be a combination of Extended List-View Styles
; User CallTip:		_GUICtrlListViewGetExtendedListViewStyle($h_listview) Retrieves the extended styles that are currently in use for a given list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetExtendedListViewStyle($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETEXTENDEDLISTVIEWSTYLE)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetExtendedListViewStyle

;===============================================================================
;
; Description:			_GUICtrlListViewGetHeader
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the handle to the header control.
; User CallTip:		_GUICtrlListViewGetHeader($h_listview) Retrieves the handle to the header control used by the list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetHeader($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETHEADER)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETHEADER, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetHeader

;===============================================================================
;
; Description:			_GUICtrlListViewGetHotCursor
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns an HCURSOR value that is the handle to the cursor that
;							the list-view control uses when hot tracking is enabled.
; User CallTip:		_GUICtrlListViewGetHotCursor($h_listview) Retrieves the HCURSOR value used when the pointer is over an item while hot tracking is enabled (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				A list-view control uses hot tracking and hover selection when
;							the LVS_EX_TRACKSELECT style is set.
;
;===============================================================================
Func _GUICtrlListViewGetHotCursor($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETHOTCURSOR)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETHOTCURSOR, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetHotCursor

;===============================================================================
;
; Description:			_GUICtrlListViewGetHotItem
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the index of the item that is hot.
; User CallTip:		_GUICtrlListViewGetHotItem($h_listview) Retrieves the index of the hot item (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetHotItem($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETHOTITEM)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETHOTITEM, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetHotItem

;===============================================================================
;
; Description:			_GUICtrlListViewGetHoverTime
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the amount of time, in milliseconds,
;							that the mouse cursor must hover over an item
;							before it is selected.
;							If the return value is -1, then the hover
;							time is the default hover time.
; User CallTip:		_GUICtrlListViewGetHoverTime($h_listview) Retrieves the amount of time that the mouse cursor must hover over an item before it is selected (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				The hover time only affects list-view controls that have the
;							LVS_EX_TRACKSELECT, LVS_EX_ONECLICKACTIVATE, or
;							LVS_EX_TWOCLICKACTIVATE extended list-view style.
;
;===============================================================================
Func _GUICtrlListViewGetHoverTime($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETHOVERTIME)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETHOVERTIME, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetHoverTime

;===============================================================================
;
; Description:			_GUICtrlListViewGetItemCount
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the number of items.
; User CallTip:		_GUICtrlListViewGetItemCount($h_listview) Retrieves the number of items in a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetItemCount($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETITEMCOUNT)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETITEMCOUNT, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetItemCount

;===============================================================================
;
; Description:			_GUICtrlListViewGetItemText
; Parameter(s):		$h_listview - controlID
;							$i_Item - index of item to retrieve from (zero-based index)
;							$i_SubItem - column of item to retrieve from (zero-based index)
; Requirement:			None
; Return Value(s):	If $i_SubItem = -1 then row is returned pipe delimited
;							else text from $i_SubItem position is returned
;							If error $LV_ERR is returned
; User CallTip:		_GUICtrlListViewGetItemText($h_listview[, $i_Item=-1[, $i_SubItem=-1]]) Retrieves some or all of a list-view item (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetItemText($h_listview, $i_Item = -1, $i_SubItem = -1)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $sBuffer_pointer
	Local $LVITEM_pointer
	Local $Memory_pointer, $struct_MemMap
	Local $i_Size, $string_Memory_pointer
	Local $struct_LVITEM, $struct_String

	$struct_LVITEM = DllStructCreate($LVITEM)
	If @error Then Return SetError($LV_ERR, $LV_ERR, "")
	$struct_String = DllStructCreate("char[4096]")
	If @error Then Return SetError($LV_ERR, $LV_ERR, "")
	If $i_Item = -1 Then $i_Item = Int(_GUICtrlListViewGetSelectedIndices($h_listview))
	If $i_Item = -1 Then Return SetError($LV_ERR, $LV_ERR, "")

	DllStructSetData($struct_LVITEM, $LVI_MASK, $LVIF_TEXT)
	DllStructSetData($struct_LVITEM, $LVI_CCHTEXTMAX, 4096)

	Local $x_indice, $count, $str = ""

	$count = _GUICtrlListViewGetSubItemsCount($h_listview)
	If Not $count Then $count = 1

	DllStructSetData($struct_LVITEM, $LVI_IITEM, $i_Item)
	If ($i_SubItem == -1) Then; return all the subitems in the item
		For $x_indice = 0 To $count - 1 Step 1
			If IsHWnd($h_listview) Then

				$sBuffer_pointer = DllStructGetPtr($struct_String)
				$LVITEM_pointer = DllStructGetPtr($struct_LVITEM)
				$i_Size = DllStructGetSize($struct_LVITEM)
				$Memory_pointer = _MemInit ($h_listview, $i_Size + 4096, $struct_MemMap)
				If @error Then
					_MemFree ($struct_MemMap)
					Return SetError($LV_ERR, $LV_ERR, "")
				EndIf
				$string_Memory_pointer = $Memory_pointer + 4096
				DllStructSetData($struct_LVITEM, $LVI_ISUBITEM, $x_indice)
				DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, $string_Memory_pointer)
				_MemWrite ($struct_MemMap, $LVITEM_pointer)
				If @error Then
					_MemFree ($struct_MemMap)
					Return SetError($LV_ERR, $LV_ERR, "")
				EndIf
				_SendMessage($h_listview, $LVM_GETITEMA, 0, $Memory_pointer)
				If @error Then
					_MemFree ($struct_MemMap)
					Return SetError($LV_ERR, $LV_ERR, "")
				EndIf
				_MemRead ($struct_MemMap, $string_Memory_pointer, $sBuffer_pointer, 4096)
				If @error Then
					_MemFree ($struct_MemMap)
					Return SetError($LV_ERR, $LV_ERR, "")
				EndIf
				_MemFree ($struct_MemMap)
				If @error Then Return SetError($LV_ERR, $LV_ERR, "")
			Else
				DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, DllStructGetPtr($struct_String))
				DllStructSetData($struct_LVITEM, $LVI_ISUBITEM, $x_indice)
				If Not GUICtrlSendMsg($h_listview, $LVM_GETITEMA, 0, DllStructGetPtr($struct_LVITEM)) Then
					SetError($LV_ERR)
				EndIf
			EndIf
			If Not @error Then
				If $x_indice Then
					$str = $str & "|" & DllStructGetData($struct_String, 1)
				Else
					$str = DllStructGetData($struct_String, 1)
				EndIf
			Else
				If StringLen($str) Then
					$str = $str & "|"
				EndIf
			EndIf
		Next
		Return $str
	ElseIf ($i_SubItem < $count) Then; return the subitem in the item
		If IsHWnd($h_listview) Then
			$sBuffer_pointer = DllStructGetPtr($struct_String)
			$LVITEM_pointer = DllStructGetPtr($struct_LVITEM)
			$i_Size = DllStructGetSize($struct_LVITEM)
			$Memory_pointer = _MemInit ($h_listview, $i_Size + 4096, $struct_MemMap)
			If @error Then
				_MemFree ($struct_MemMap)
				Return SetError($LV_ERR, $LV_ERR, "")
			EndIf
			$string_Memory_pointer = $Memory_pointer + 4096
			DllStructSetData($struct_LVITEM, $LVI_ISUBITEM, $i_SubItem)
			DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, $string_Memory_pointer)
			_MemWrite ($struct_MemMap, $LVITEM_pointer)
			If @error Then
				_MemFree ($struct_MemMap)
				Return SetError($LV_ERR, $LV_ERR, "")
			EndIf
			_SendMessage($h_listview, $LVM_GETITEMA, 0, $Memory_pointer)
			If @error Then
				_MemFree ($struct_MemMap)
				Return SetError($LV_ERR, $LV_ERR, "")
			EndIf
			_MemRead ($struct_MemMap, $string_Memory_pointer, $sBuffer_pointer, 4096)
			If @error Then
				_MemFree ($struct_MemMap)
				Return SetError($LV_ERR, $LV_ERR, "")
			EndIf
			_MemFree ($struct_MemMap)
			If @error Then Return SetError($LV_ERR, $LV_ERR, "")
		Else
			DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, DllStructGetPtr($struct_String))
			DllStructSetData($struct_LVITEM, $LVI_ISUBITEM, $i_SubItem)
			If Not GUICtrlSendMsg($h_listview, $LVM_GETITEMA, 0, DllStructGetPtr($struct_LVITEM)) Then Return SetError($LV_ERR, $LV_ERR, "")
		EndIf
		Return DllStructGetData($struct_String, 1)
	Else
		; subitem is out of range
		Return SetError($LV_ERR, $LV_ERR, "")
	EndIf
EndFunc   ;==>_GUICtrlListViewGetItemText

;===============================================================================
;
; Description:			_GUICtrlListViewGetItemTextArray
; Parameter(s):		$h_listview - controlID/handle
;							$i_Item - index of item to retrieve from (zero-based index)
; Requirement:			None
; Return Value(s):	Returns an array of the subitems
;							If $i_Item = -1 current selection is used
;							If error $LV_ERR is returned
; User CallTip:		_GUICtrlListViewGetItemTextA($h_listview[, $i_Item=-1]) Retrieves all of a list-view item (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetItemTextArray($h_listview, $i_Item = -1)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $v_ret = _GUICtrlListViewGetItemText($h_listview, $i_Item)
	If @error Or $v_ret = "" Then Return SetError($LV_ERR, $LV_ERR, "")
	Return StringSplit($v_ret, "|")
EndFunc   ;==>_GUICtrlListViewGetItemTextArray

;===============================================================================
;
; Description:			_GUICtrlListViewGetNextItem
; Parameter(s):		$h_GUI - GUI Window handle
;							$h_listview - controlID
;							$i_index - Index of the item to begin the search with
;							$i_direction - Specifies the relationship to the item specified in $i_index
; Requirement:			None
; Return Value(s):	Returns the index of the next item if successful, or $LV_ERR otherwise.
; User CallTip:		_GUICtrlListViewGetNextItem($h_GUI, $h_listview[, $i_index=-1[, $i_direction=0x0]]) Returns the index of the next item (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				If $i_index = -1 then find the first item that matches the specified $i_direction.
;							The specified item itself is excluded from the search.
;
;							$i_direction
;								Searches by index.
;									$LVNI_ALL
;										Searches for a subsequent item by index, the default value.
;								Searches by physical relationship to the index of the item where the search is to begin.
;									$LVNI_ABOVE
;										Searches for an item that is above the specified item.
;									$LVNI_BELOW
;										Searches for an item that is below the specified item.
;									$LVNI_TOLEFT
;										Searches for an item to the left of the specified item.
;									$LVNI_TORIGHT
;										Searches for an item to the right of the specified item.
;
;===============================================================================
Func _GUICtrlListViewGetNextItem($h_GUI, $h_listview, $i_index = -1, $i_direction = 0x0)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $h_lv
	If IsHWnd($h_listview) Then
		$h_lv = $h_listview
	Else
		$h_lv = ControlGetHandle($h_GUI, "", $h_listview)
	EndIf
	If ($i_direction == $LVNI_ALL Or $i_direction == $LVNI_ABOVE Or _
			$i_direction == $LVNI_BELOW Or $i_direction == $LVNI_TOLEFT Or _
			$i_direction == $LVNI_TORIGHT) Then
		Return _SendMessage($h_lv, $LVM_GETNEXTITEM, $i_index, $i_direction)
	Else
		Return $LV_ERR
	EndIf
EndFunc   ;==>_GUICtrlListViewGetNextItem

;===============================================================================
;
; Description:			_GUICtrlListViewGetSelectedCount
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the number of selected items
; User CallTip:		_GUICtrlListViewGetSelectedCount($h_listview) Determines the number of selected items in a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetSelectedCount($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETSELECTEDCOUNT)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETSELECTEDCOUNT, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetSelectedCount

;===============================================================================
;
; Description:			_GUICtrlListViewGetSelectedIndices
; Parameter(s):		$h_listview - controlID
;							$i_ReturnType - Optional: return a string or array
; Requirement:			None
; Return Value(s):	If $i_ReturnType = 0 then Return pipe delimited string of indices of selected item(s)
;							If $i_ReturnType = 1 then Return array of indices of selected item(s)
;							If no items selected return $LV_ERR
; User CallTip:		_GUICtrlListViewGetSelectedIndices($h_listview[, $i_ReturnType=0]) Retrieve indices of selected item(s) in a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetSelectedIndices($h_listview, $i_ReturnType = 0)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $v_indices
	Local $x_indice, $v_ret
	For $x_indice = 0 To _GUICtrlListViewGetItemCount($h_listview)
		If IsHWnd($h_listview) Then
			$v_ret = _SendMessage($h_listview, $LVM_GETITEMSTATE, $x_indice, $LVIS_SELECTED)
			If $v_ret Then
				If (Not $i_ReturnType) Then
					If StringLen($v_indices) Then
						$v_indices = $v_indices & "|" & $x_indice
					Else
						$v_indices = $x_indice
					EndIf
				Else
					If Not IsArray($v_indices) Then
						Dim $v_indices[2]
					Else
						ReDim $v_indices[UBound($v_indices) + 1]
					EndIf
					$v_indices[0] = UBound($v_indices) - 1
					$v_indices[UBound($v_indices) - 1] = $x_indice
				EndIf
			EndIf
		Else
			$v_ret = GUICtrlSendMsg($h_listview, $LVM_GETITEMSTATE, $x_indice, $LVIS_SELECTED)
			If $v_ret Then
				If (Not $i_ReturnType) Then
					If StringLen($v_indices) Then
						$v_indices = $v_indices & "|" & $x_indice
					Else
						$v_indices = $x_indice
					EndIf
				Else
					If Not IsArray($v_indices) Then
						Dim $v_indices[2]
					Else
						ReDim $v_indices[UBound($v_indices) + 1]
					EndIf
					$v_indices[0] = UBound($v_indices) - 1
					$v_indices[UBound($v_indices) - 1] = $x_indice
				EndIf
			EndIf
		EndIf
	Next
	If (StringLen($v_indices) > 0 Or IsArray($v_indices)) Then
		Return $v_indices
	Else
		Return $LV_ERR
	EndIf
EndFunc   ;==>_GUICtrlListViewGetSelectedIndices

;===============================================================================
;
; Description:			_GUICtrlListViewGetSubItemsCount
; Parameter(s):		$h_listview - controlID/handle
; Requirement:			None
; Return Value(s):	Number of columns
; User CallTip:		_GUICtrlListViewGetSubItemsCount(ByRef $h_listview) Retrieve the number of columns (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetSubItemsCount($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
;~ 	Local Const $HDM_GETITEMCOUNT = 0x1200
	Return _SendMessage(_GUICtrlListViewGetHeader($h_listview), 0x1200, 0, 0)
EndFunc   ;==>_GUICtrlListViewGetSubItemsCount

;===============================================================================
;
; Description:			_GUICtrlListViewGetTopIndex
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns the index of the item if successful
;							zero if the list-view control is in icon or small icon view.
; User CallTip:		_GUICtrlListViewGetTopIndex($h_listview) Retrieves the index of the topmost visible item when in list or report view (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewGetTopIndex($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETTOPINDEX)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETTOPINDEX, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetTopIndex

;===============================================================================
;
; Description:			_GUICtrlListViewGetUnicodeFormat
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	If this value is nonzero, the control is using Unicode characters.
;							If this value is zero, the control is using ANSI characters.
; User CallTip:		_GUICtrlListViewGetUnicodeFormat($h_listview) Retrieves the UNICODE character format flag for the control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				The Unicode format flag is used by Microsoft Windows NT systems
;							with version 4.71 of Comctl32.dll or later. This message is, thus,
;							supported by Windows 2000 and later, and by Windows NT 4 with Microsoft
;							Internet Explorer 4.0 or later. It is only useful on Windows 95 or Windows 98
;							systems with version 5.80 or later of Comctl32.dll.
;
;							This means that they must have Internet Explorer 5 or later installed.
;							Windows 95 and Windows 98 systems with earlier versions of Internet Explorer
;							ignore the Unicode format flag, and its value has no bearing on whether a control
;							supports Unicode. With these systems, you will instead need to test something that
;							requires Unicode support.
;
;===============================================================================
Func _GUICtrlListViewGetUnicodeFormat($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETUNICODEFORMAT)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETUNICODEFORMAT, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetUnicodeFormat

;===============================================================================
;
; Description:			_GUICtrlListViewGetView
; Parameter(s):		$h_listview - controlID
; Requirement:			None
; Return Value(s):	Returns a DWORD that specifies the current view
; User CallTip:		_GUICtrlListViewGetView($h_listview) Retrieves the current view of a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				Following are the values for views.
;								$LV_VIEW_DETAILS
;								$LV_VIEW_ICON
;								$LV_VIEW_LIST
;								$LV_VIEW_SMALLICON
;								$LV_VIEW_TILE
;
;===============================================================================
Func _GUICtrlListViewGetView($h_listview)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_GETVIEW)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_GETVIEW, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewGetView

;===============================================================================
;
; Description:				_GUICtrlListViewHideColumn
; Parameter(s):			$h_listview - controlID
;								$i_col - column to hide (set width to zero)
; Requirement:				None
; Return Value(s):		Returns TRUE if successful, or FALSE otherwise
; User CallTip:			_GUICtrlListViewHideColumn($h_listview,$i_col) Hides the column "sets column width to zero" (required: <GuiListView.au3>)
; Author(s):				Gary Frost (custompcs at charter dot net)
; Note(s):              Idea from Holger
;
;===============================================================================
Func _GUICtrlListViewHideColumn($h_listview, $i_col)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SETCOLUMNWIDTH, $i_col)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SETCOLUMNWIDTH, $i_col, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewHideColumn

;===============================================================================
;
; Description:				_GUICtrlListViewInsertColumn
; Parameter(s):			$h_listview - controlID
;								$i_col - Zero based index of column position to insert
;								$s_text - Header Text for column
;								$i_justification - Optional: type of justification for column
;								$i_width - Optional: width of the new column
; Requirement:				None
; Return Value(s):		Returns TRUE if successful, or FALSE otherwise
;								if error then $LV_ERR is returned
; User CallTip:			_GUICtrlListViewInsertColumn($h_listview, $i_col, $s_text[, $i_justification=0[, $i_width=25]]) Inserts a column into a list-view control (required: <GuiListView.au3>)
; Author(s):				Gary Frost (custompcs at charter dot net)
; Note(s):              $i_justification
;									0 = Left (default)
;									1 = Right
;									2 = Center
;
;===============================================================================
Func _GUICtrlListViewInsertColumn($h_listview, $i_col, $s_text, $i_justification = 0, $i_width = 25)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	Local $struct_LVCOLUMN, $struct_String, $ret

	$struct_LVCOLUMN = DllStructCreate($LVCOLUMN)
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	$struct_String = DllStructCreate("char[" & StringLen($s_text) + 1 & "]")
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	DllStructSetData($struct_String, 1, $s_text)
	DllStructSetData($struct_LVCOLUMN, $LVC_MASK, BitOR($LVCF_WIDTH, $LVCF_FMT, $LVCF_TEXT))
	If ($i_justification == 1) Then
		DllStructSetData($struct_LVCOLUMN, $LVC_FMT, $LVCFMT_RIGHT)
	ElseIf ($i_justification == 2) Then
		DllStructSetData($struct_LVCOLUMN, $LVC_FMT, $LVCFMT_CENTER)
	Else
		DllStructSetData($struct_LVCOLUMN, $LVC_FMT, $LVCFMT_LEFT)
	EndIf
	DllStructSetData($struct_LVCOLUMN, $LVC_CX, $i_width)

	If IsHWnd($h_listview) Then
		Local $sBuffer_pointer = DllStructGetPtr($struct_String)
		Local $column_struct_pointer = DllStructGetPtr($struct_LVCOLUMN)
		Local $i_Size = DllStructGetSize($struct_LVCOLUMN)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size + StringLen($s_text) + 1, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		Local $string_Memory_pointer = $Memory_pointer + $i_Size
		DllStructSetData($struct_LVCOLUMN, $LVC_PSZTEXT, $string_Memory_pointer)
		_MemWrite ($struct_MemMap, $column_struct_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $sBuffer_pointer, $string_Memory_pointer, StringLen($s_text) + 1)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_INSERTCOLUMNA, $i_col, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		Return $ret
	Else
		DllStructSetData($struct_LVCOLUMN, $LVC_PSZTEXT, DllStructGetPtr($struct_String))
		$ret = GUICtrlSendMsg($h_listview, $LVM_INSERTCOLUMNA, $i_col, DllStructGetPtr($struct_LVCOLUMN))
	EndIf
	Return $ret
EndFunc   ;==>_GUICtrlListViewInsertColumn

;===============================================================================
;
; Description:				_GUICtrlListViewInsertItem
; Parameter(s):			$h_listview - controlID
;								$i_index - Zero based index of position to insert
;											if -1 the item will append to the end
;								$s_text - text for the new item
; Requirement:				None
; Return Value(s):		Returns the index of the new item if successful, or $LV_ERR otherwise
; User CallTip:			_GUICtrlListViewInsertItem($h_listview, $i_index, $s_text) Inserts a new item in a list-view control. (required: <GuiListView.au3>)
; Author(s):				Gary Frost (custompcs at charter dot net)
; Note(s):              $s_text is "|" delimited text
;
;===============================================================================
Func _GUICtrlListViewInsertItem($h_listview, $i_index, $s_text)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $struct_LVITEM, $struct_String, $ret, $a_text

	$struct_LVITEM = DllStructCreate($LVITEM)
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	$struct_String = DllStructCreate("char[" & StringLen($s_text) + 1 & "]")
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	$a_text = StringSplit($s_text, "|")
	DllStructSetData($struct_String, 1, $a_text[1])
	If $i_index = -1 Then $i_index = _GUICtrlListViewGetItemCount($h_listview)
	DllStructSetData($struct_LVITEM, $LVI_MASK, $LVIF_TEXT)
	DllStructSetData($struct_LVITEM, $LVI_IITEM, $i_index)
	DllStructSetData($struct_LVITEM, $LVI_CCHTEXTMAX, StringLen($s_text) + 1)
;~ 	DllStructSetData($struct_LVITEM  , $LVI_IIMAGE    , -1  )
;~ 	DllStructSetData($struct_LVITEM  , $LVI_LPARAM    , 0 )
;~ 	DllStructSetData($struct_LVITEM  , $LVI_IINDENT   , 0 )
	If IsHWnd($h_listview) Then
		Local $sBuffer_pointer = DllStructGetPtr($struct_String)
		Local $LVITEM_pointer = DllStructGetPtr($struct_LVITEM)
		Local $i_Size = DllStructGetSize($struct_LVITEM)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size + StringLen($s_text) + 1, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		Local $string_Memory_pointer = $Memory_pointer + $i_Size
		DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, $string_Memory_pointer)
		_MemWrite ($struct_MemMap, $LVITEM_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $sBuffer_pointer, $string_Memory_pointer, StringLen($s_text) + 1)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_INSERTITEMA, 0, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Else
		DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, DllStructGetPtr($struct_String))
		$ret = GUICtrlSendMsg($h_listview, $LVM_INSERTITEMA, 0, DllStructGetPtr($struct_LVITEM))
	EndIf
	Local $i
	For $i = 2 To $a_text[0]
		_GUICtrlListViewSetItemText($h_listview, $i_index, $i - 1, $a_text[$i])
	Next
	Return $ret
EndFunc   ;==>_GUICtrlListViewInsertItem

;===============================================================================
;
; Description:				_GUICtrlListViewJustifyColumn
; Parameter(s):			$h_listview - controlID
;								$i_col - Zero based index of column Justify
;								$i_justification - Optional: type of justification for column
; Requirement:				None
; Return Value(s):		Returns TRUE if successful, or FALSE otherwise
;								if error then $LV_ERR is returned
; User CallTip:			_GUICtrlListViewJustifyColumn($h_listview, $i_col[, $i_justification=0]) Set Justification of a column for a list-view control (required: <GuiListView.au3>)
; Author(s):				Gary Frost (custompcs at charter dot net)
; Note(s):              $i_justification
;									0 = Left (default)
;									1 = Right
;									2 = Center
;
;===============================================================================
Func _GUICtrlListViewJustifyColumn($h_listview, $i_col, $i_justification = 0)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	Local $struct_LVCOLUMN, $ret

	$struct_LVCOLUMN = DllStructCreate($LVCOLUMN)
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	DllStructSetData($struct_LVCOLUMN, $LVC_MASK, $LVCF_FMT)
	If ($i_justification == 1) Then
		DllStructSetData($struct_LVCOLUMN, $LVC_FMT, $LVCFMT_RIGHT)
	ElseIf ($i_justification == 2) Then
		DllStructSetData($struct_LVCOLUMN, $LVC_FMT, $LVCFMT_CENTER)
	Else
		DllStructSetData($struct_LVCOLUMN, $LVC_FMT, $LVCFMT_LEFT)
	EndIf
	If IsHWnd($h_listview) Then
		Local $column_struct_pointer = DllStructGetPtr($struct_LVCOLUMN)
		Local $i_Size = DllStructGetSize($struct_LVCOLUMN)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $column_struct_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_SETCOLUMNA, $i_col, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Else
		$ret = GUICtrlSendMsg($h_listview, $LVM_SETCOLUMNA, $i_col, DllStructGetPtr($struct_LVCOLUMN))
	EndIf
	Return $ret
EndFunc   ;==>_GUICtrlListViewJustifyColumn

;===============================================================================
;
; Description:			_GUICtrlListViewScroll
; Parameter(s):		$h_listview - controlID
;							$i_dx - Value of type int that specifies the amount of horizontal scrolling in pixels.
;									  If the list-view control is in list-view, this value specifies the number of columns to scroll
;							$i_dy - Value of type int that specifies the amount of vertical scrolling in pixels
; Requirement:			None
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
; User CallTip:		_GUICtrlListViewScroll($h_listview, $i_dx, $i_dy) Scrolls the content of a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				When the list-view control is in report view, the control can
;							only be scrolled vertically in whole line increments.
;
;							Therefore, the $i_dy parameter will be rounded to the nearest number
;							of pixels that form a whole line increment.
;
;							For example, if the height of a line is 16 pixels and 8 is passed for $i_dy,
;							the list will be scrolled by 16 pixels (1 line). If 7 is passed for $i_dy,
;							the list will be scrolled 0 pixels (0 lines).
;
;===============================================================================
Func _GUICtrlListViewScroll($h_listview, $i_dx, $i_dy)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SCROLL, $i_dx, $i_dy)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SCROLL, $i_dx, $i_dy)
	EndIf
EndFunc   ;==>_GUICtrlListViewScroll

;===============================================================================
;
; Description:			_GUICtrlListViewSetCheckState
; Parameter(s):		$h_listview - controlID
;							$i_index - Zero-based index of the item
;							$i_check - Optional: value to set checked state to (1 = checked, 0 = not checked)
; Requirement:			None.
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
;							If error then $LV_ERR is returned
; User CallTip:		_GUICtrlListViewSetCheckState($h_listview, $i_index[, $i_check = 1]) Sets the checked state of a list-view control item (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				$i_index = -1 sets all items
;							$i_check = 1 (default)
;
;===============================================================================
Func _GUICtrlListViewSetCheckState($h_listview, $i_index, $i_check = 1)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	Local $ret
	Local $struct_LVITEM = DllStructCreate($LVITEM)
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	DllStructSetData($struct_LVITEM, $LVI_MASK, $LVIF_STATE)
	DllStructSetData($struct_LVITEM, $LVI_IITEM, $i_index)
	If ($i_check) Then
		DllStructSetData($struct_LVITEM, $LVI_STATE, 0x2000)
	Else
		DllStructSetData($struct_LVITEM, $LVI_STATE, 0x1000)
	EndIf
	DllStructSetData($struct_LVITEM, $LVI_STATEMASK, $LVIS_STATEIMAGEMASK)
	If IsHWnd($h_listview) Then
		Local $LVITEM_pointer = DllStructGetPtr($struct_LVITEM)
		Local $i_Size = DllStructGetSize($struct_LVITEM)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size + 4096, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $LVITEM_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_SETITEMSTATE, $i_index, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Else
		$ret = GUICtrlSendMsg($h_listview, $LVM_SETITEMSTATE, $i_index, DllStructGetPtr($struct_LVITEM))
	EndIf
	Return $ret
EndFunc   ;==>_GUICtrlListViewSetCheckState

;===============================================================================
;
; Description:				_GUICtrlListViewSetColumnHeaderText
; Parameter(s):			$h_listview - controlID
;								$i_col - Zero based index of column Justify
;								$s_text - New text for column header
; Requirement:				None
; Return Value(s):		Returns TRUE if successful, or FALSE otherwise
;								if error then $LV_ERR is returned
; User CallTip:			_GUICtrlListViewSetColumnHeaderText($h_listview, $i_col, $s_text) Change the text of a column header for a list-view control (required: <GuiListView.au3>)
; Author(s):				Gary Frost (custompcs at charter dot net)
; Note(s):
;
;===============================================================================
Func _GUICtrlListViewSetColumnHeaderText($h_listview, $i_col, $s_text)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	Local $struct_LVCOLUMN, $ret, $struct_String

	$struct_String = DllStructCreate("char[" & StringLen($s_text) + 1 & "]")
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	DllStructSetData($struct_String, 1, $s_text)
	$struct_LVCOLUMN = DllStructCreate($LVCOLUMN)
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	DllStructSetData($struct_LVCOLUMN, $LVC_MASK, $LVCF_TEXT)
	If IsHWnd($h_listview) Then
		Local $sBuffer_pointer = DllStructGetPtr($struct_String)
		Local $column_struct_pointer = DllStructGetPtr($struct_LVCOLUMN)
		Local $i_Size = DllStructGetSize($struct_LVCOLUMN)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size + StringLen($s_text) + 1, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		Local $string_Memory_pointer = $Memory_pointer + $i_Size
		DllStructSetData($struct_LVCOLUMN, $LVC_PSZTEXT, $string_Memory_pointer)
		_MemWrite ($struct_MemMap, $column_struct_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $sBuffer_pointer, $string_Memory_pointer, StringLen($s_text) + 1)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_SETCOLUMNA, $i_col, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Else
		DllStructSetData($struct_LVCOLUMN, $LVC_PSZTEXT, DllStructGetPtr($struct_String))
		$ret = GUICtrlSendMsg($h_listview, $LVM_SETCOLUMNA, $i_col, DllStructGetPtr($struct_LVCOLUMN))
	EndIf
	Return $ret
EndFunc   ;==>_GUICtrlListViewSetColumnHeaderText

;===============================================================================
;
; Description:			_GUICtrlListViewSetColumnOrder
; Parameter(s):		$h_listview - controlID
;							$s_order - "|" delimited column order .i.e "2|0|3|1"
; Requirement:			None
; Return Value(s):	Returns nonzero if successful, or zero otherwise.
;							If an error occurs, the return value is $LV_ERR.
; User CallTip:		_GUICtrlListViewSetColumnOrder($h_listview, $s_order) Sets the left-to-right order of columns in a list-view control. (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):           Columns are zero-based
;
;===============================================================================
Func _GUICtrlListViewSetColumnOrder($h_listview, $s_order)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $i, $ret
	Local $struct = ""
	Local $a_order = StringSplit($s_order, "|")
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	For $i = 1 To $a_order[0]
		$struct &= "int;"
	Next
	$struct = StringTrimRight($struct, 1)
	Local $struct_LVCOLUMN = DllStructCreate($struct)
	For $i = 1 To $a_order[0]
		DllStructSetData($struct_LVCOLUMN, $i, $a_order[$i])
	Next
	If IsHWnd($h_listview) Then
		Local $sBuffer_pointer = DllStructGetPtr($struct_LVCOLUMN)
		Local $i_Size = DllStructGetSize($struct_LVCOLUMN)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $sBuffer_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_SETCOLUMNORDERARRAY, $a_order[0], $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Else
		$ret = GUICtrlSendMsg($h_listview, $LVM_SETCOLUMNORDERARRAY, $a_order[0], DllStructGetPtr($struct_LVCOLUMN))
	EndIf
	If (Not $ret) Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Return $ret
EndFunc   ;==>_GUICtrlListViewSetColumnOrder

;===============================================================================
;
; Description:			_GUICtrlListViewSetColumnWidth
; Parameter(s):		$h_listview - controlID
;							$i_col - Zero-based index of a valid column. For list-view mode, this parameter must be set to zero
;							$i_width - New width of the column, in pixels.
; Requirement:			None
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
; User CallTip:		_GUICtrlListViewSetColumnWidth($h_listview, $i_col, $i_width) Changes the width of a column (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				For list-view mode, this parameter must be set to zero
;
;							$i_width
;								New width of the column, in pixels. For report-view mode, the following special values are supported:
;									$LVSCW_AUTOSIZE
;										Automatically sizes the column.
;									$LVSCW_AUTOSIZE_USEHEADER
;										Automatically sizes the column to fit the header text.
;										If you use this value with the last column, its width
;										is set to fill the remaining width of the list-view control
;
;===============================================================================
Func _GUICtrlListViewSetColumnWidth($h_listview, $i_col, $i_width)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SETCOLUMNWIDTH, $i_col, $i_width)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SETCOLUMNWIDTH, $i_col, $i_width)
	EndIf
EndFunc   ;==>_GUICtrlListViewSetColumnWidth

;===============================================================================
;
; Description:			_GUICtrlListViewSetHotItem
; Parameter(s):		$h_listview - controlID
;							$i_index - Zero-based index of the item to be set as the hot item
; Requirement:			None
; Return Value(s):	Returns the index of the item that was previously hot
;							$LV_ERR is returned if no item previously hot
; User CallTip:		_GUICtrlListViewSetHotItem($h_listview, $i_index) Sets the hot item for a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewSetHotItem($h_listview, $i_index)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SETHOTITEM, $i_index)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SETHOTITEM, $i_index, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewSetHotItem

;===============================================================================
;
; Description:			_GUICtrlListViewSetHoverTime
; Parameter(s):		$h_listview - controlID
;							$i_time - The new amount of time, in milliseconds
; Requirement:			None
; Return Value(s):	Returns the previous hover time
; User CallTip:		_GUICtrlListViewSetHoverTime($h_listview, $i_time) Sets the amount of time which the mouse cursor must hover over an item before it is selected (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				$i_time
;								If this value is -1, then the hover time is set to the default hover time
;
;							The hover time only affects list-view controls that have the
;							LVS_EX_TRACKSELECT, LVS_EX_ONECLICKACTIVATE, or
;							LVS_EX_TWOCLICKACTIVATE extended list-view style
;
;===============================================================================
Func _GUICtrlListViewSetHoverTime($h_listview, $i_time)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SETHOVERTIME, 0, $i_time)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SETHOVERTIME, 0, $i_time)
	EndIf
EndFunc   ;==>_GUICtrlListViewSetHoverTime

;===============================================================================
;
; Description:			_GUICtrlListViewSetItemCount
; Parameter(s):		$h_listview - controlID
;							$i_items - Number of items that the list-view control will ultimately contain.
; Requirement:			None
; Return Value(s):	Returns nonzero if successful, or zero otherwise.
; User CallTip:		_GuiCtrlListViewSetItemCount($h_listview, $i_items) Causes the list-view control to allocate memory for the specified number of items. (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				Causes the control to allocate its internal data structures for the specified number of items.
;							This prevents the control from having to allocate the data structures every time an item is added.
;
;===============================================================================
Func _GUICtrlListViewSetItemCount($h_listview, $i_items)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SETITEMCOUNT, $i_items, BitOR($LVSICF_NOINVALIDATEALL, $LVSICF_NOSCROLL))
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SETITEMCOUNT, $i_items, BitOR($LVSICF_NOINVALIDATEALL, $LVSICF_NOSCROLL))
	EndIf
EndFunc   ;==>_GUICtrlListViewSetItemCount

;===============================================================================
;
; Description:			_GUICtrlListViewSetItemSelState
; Parameter(s):		$h_listview - controlID
;							$i_index - Zero based index of the item
;							$i_selected - Optional: set the state of the item (1 = selected, 0 = not selected)
;                    $i_focused - Optional: set the state of the item (1 = focused, 0 = not focused) (default = 0)
; Requirement:			None
; Return Value(s):	1 if successful, 0 otherwise
;							If error then $LV_ERR is returned
; User CallTip:		_GUICtrlListViewSetItemSelState($h_listview, $i_index[, $i_selected = 1[, $i_focused = 0]]) Sets the Item Selected/UnSelected (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				$i_index = -1 sets all items for MultiSelect ListView
;
;===============================================================================
Func _GUICtrlListViewSetItemSelState($h_listview, $i_index, $i_selected = 1, $i_focused = 0)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $ret
	Local $struct_LVITEM = DllStructCreate($LVITEM)
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If ($i_selected == 1) Then
		$i_selected = $LVNI_SELECTED
	Else
		$i_selected = 0
	EndIf
	If ($i_focused == 1) Then
		$i_focused = $LVNI_FOCUSED
	Else
		$i_focused = 0
	EndIf
	DllStructSetData($struct_LVITEM, $LVI_MASK, $LVIF_STATE)
	DllStructSetData($struct_LVITEM, $LVI_IITEM, $i_index)
	DllStructSetData($struct_LVITEM, $LVI_STATE, BitOR($i_selected, $i_focused))
	DllStructSetData($struct_LVITEM, $LVI_STATEMASK, BitOR($LVIS_SELECTED, $i_focused))
	If IsHWnd($h_listview) Then
		Local $sBuffer_pointer = DllStructGetPtr($struct_LVITEM)
		Local $i_Size = DllStructGetSize($struct_LVITEM)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $sBuffer_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_SETITEMSTATE, $i_index, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Else
		$ret = GUICtrlSendMsg($h_listview, $LVM_SETITEMSTATE, $i_index, DllStructGetPtr($struct_LVITEM))
	EndIf
	Return $ret
EndFunc   ;==>_GUICtrlListViewSetItemSelState

;===============================================================================
;
; Description:			_GUICtrlListViewSetItemText
; Parameter(s):		$h_listview - controlID
;							$i_index - Zero based index of the item
;							$i_subitem - Index of the subitem, or it can be zero to set the item label.
;							$s_text - String containing the new text
; Requirement:			None
; Return Value(s):	1 if successful, 0 if not
;							If error then $LV_ERR is returned
; User CallTip:		_GUICtrlListViewSetItemText($h_listview, $i_index, $i_subitem, $s_text) Changes the text of a list-view item or subitem. (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):
;
;===============================================================================
Func _GUICtrlListViewSetItemText($h_listview, $i_index, $i_SubItem, $s_text)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $ret
	Local $struct_LVITEM = DllStructCreate($LVITEM)
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Local $struct_String = DllStructCreate("char[" & StringLen($s_text) + 1 & "]")
	If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	DllStructSetData($struct_String, 1, $s_text)
	DllStructSetData($struct_LVITEM, $LVI_MASK, $LVIF_TEXT)
	DllStructSetData($struct_LVITEM, $LVI_IITEM, $i_index)
	DllStructSetData($struct_LVITEM, $LVI_ISUBITEM, $i_SubItem)
	If IsHWnd($h_listview) Then
		Local $sBuffer_pointer = DllStructGetPtr($struct_String)
		Local $LVITEM_pointer = DllStructGetPtr($struct_LVITEM)
		Local $i_Size = DllStructGetSize($struct_LVITEM)
		Local $struct_MemMap
		Local $Memory_pointer = _MemInit ($h_listview, $i_Size + StringLen($s_text) + 1, $struct_MemMap)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		Local $string_Memory_pointer = $Memory_pointer + $i_Size
		DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, $string_Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $LVITEM_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemWrite ($struct_MemMap, $sBuffer_pointer, $string_Memory_pointer, StringLen($s_text) + 1)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		$ret = _SendMessage($h_listview, $LVM_SETITEMTEXTA, 0, $Memory_pointer)
		If @error Then
			_MemFree ($struct_MemMap)
			Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
		EndIf
		_MemFree ($struct_MemMap)
		If @error Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	Else
		DllStructSetData($struct_LVITEM, $LVI_PSZTEXT, DllStructGetPtr($struct_String))
		$ret = GUICtrlSendMsg($h_listview, $LVM_SETITEMTEXTA, $i_index, DllStructGetPtr($struct_LVITEM))
	EndIf
	Return $ret
EndFunc   ;==>_GUICtrlListViewSetItemText

;===============================================================================
;
; Description:			_GUICtrlListViewSetSelectedColumn
; Parameter(s):		$h_listview - controlID
;							$i_col - Value of type int that specifies the column index
; Requirement:			None
; Return Value(s):	Returns TRUE if successful, or FALSE otherwise
; User CallTip:		_GUICtrlListViewSetSelectedColumn($h_listview, $i_col) Sets the index of the selected column (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				The column indices are stored in an int array
;
;===============================================================================
Func _GUICtrlListViewSetSelectedColumn($h_listview, $i_col)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SETSELECTEDCOLUMN, $i_col)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SETSELECTEDCOLUMN, $i_col, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewSetSelectedColumn

;===============================================================================
;
; Description:			_GUICtrlListViewSort
; Parameter(s):		$h_listview - controlID
;                   	$v_descending	- boolean value, can be a single value or array
;                   	$i_sortcol		- column to sort on
; Requirement:			Array.au3
; Return Value(s):	None
; User CallTip:		_GUICtrlListViewSort(ByRef $h_listview, ByRef $v_descending, $i_sortcol) Sorts a list-view control (required: <GuiListView.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlListViewSort($h_listview, ByRef $v_descending, $i_sortcol)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	Local $X, $Y, $Z, $b_desc, $columns, $items, $v_item, $temp_item
	If _GUICtrlListViewGetItemCount($h_listview) Then
		If (IsArray($v_descending)) Then
			$b_desc = $v_descending[$i_sortcol]
		Else
			$b_desc = $v_descending
		EndIf
		$columns = _GUICtrlListViewGetSubItemsCount($h_listview)
		$items = _GUICtrlListViewGetItemCount($h_listview)
		For $X = 1 To $columns
			$temp_item = $temp_item & " |"
		Next
		$temp_item = StringTrimRight($temp_item, 1)
		Local $a_lv[$items][$columns + 1], $i_selected
		$i_selected = StringSplit(_GUICtrlListViewGetSelectedIndices($h_listview), "|")
		For $X = 0 To UBound($a_lv) - 1 Step 1
			For $Y = 0 To UBound($a_lv, 2) - 2 Step 1
				$v_item = StringStripWS(_GUICtrlListViewGetItemText($h_listview, $X, $Y), 2)
				If (StringIsFloat($v_item) Or StringIsInt($v_item)) Then
					$a_lv[$X][$Y] = Number($v_item)
				Else
					$a_lv[$X][$Y] = $v_item
				EndIf
			Next
			$a_lv[$X][$Y] = $X
		Next
		_ArraySort($a_lv, $b_desc, 0, 0, $columns + 1, $i_sortcol)
		_GUICtrlListViewSetItemSelState($h_listview, -1, 0)
		For $X = 0 To UBound($a_lv) - 1 Step 1
			For $Y = 0 To UBound($a_lv, 2) - 2 Step 1
				_GUICtrlListViewSetItemText($h_listview, $X, $Y, $a_lv[$X][$Y])
			Next
			For $Z = 1 To $i_selected[0]
				If $a_lv[$X][UBound($a_lv, 2) - 1] = $i_selected[$Z]Then
					_GUICtrlListViewSetItemSelState($h_listview, $X, 1, 1)
					ExitLoop
				EndIf
			Next
		Next
		If (IsArray($v_descending)) Then
			$v_descending[$i_sortcol] = Not $b_desc
		Else
			$v_descending = Not $b_desc
		EndIf
	EndIf
EndFunc   ;==>_GUICtrlListViewSort

;===============================================================================
; the following functions are for internal use or possibly new functions as
; of yet not released
;===============================================================================

;===============================================================================
;
; Description:			_ReverseColorOrder
; Parameter(s):		$v_color - Hex Color
; Requirement:			None
; Return Value(s):	Return Hex RGB or BGR Color
; User CallTip:		_ReverseColorOder($v_color) Convert Hex RGB or BGR Color to Hex RGB or BGR Color
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				Used for getting List view colors
;
;===============================================================================
Func _ReverseColorOrder($v_color)
	Local $tc = Hex(String($v_color), 6)
	Return '0x' & StringMid($tc, 5, 2) & StringMid($tc, 3, 2) & StringMid($tc, 1, 2)
EndFunc   ;==>_ReverseColorOrder

;===============================================================================
; ====================================================================================================
; Description ..: Arranges items in icon view
; Parameters ...: $h_listview        - Handle to control
;                 $i_arrange        - Alignment. This can be one of the following values:
;                   $LVA_ALIGNLEFT  - Aligns items along the left edge of the window
;                   $LVA_ALIGNTOP   - Aligns items along the top edge of the window
;                   $LVA_DEFAULT    - Aligns items according to the listview controls current alignment
;                     styles (the default value).
;                   $LVA_SNAPTOGRID - Snaps all icons to the nearest grid position.
; Return values : Success - True
;                 Failure - False
; ====================================================================================================
;===============================================================================
Func _GUICtrlListViewArrange($h_listview, $i_arrange)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If $i_arrange <> $LVA_ALIGNLEFT And $i_arrange <> $LVA_ALIGNTOP And _
			$i_arrange <> $LVA_DEFAULT And $i_arrange <> $LVA_SNAPTOGRID Then Return SetError(-1, -1, 0)
	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_ARRANGE, $i_arrange)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_ARRANGE, $i_arrange, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewArrange

; ====================================================================================================
; Description ..: Sets the spacing between icons in listview controls that have the LVS_ICON style
; Parameters ...: $h_listview        - Handle to control
;                 $i_cx          - Distance, in pixels, to set between icons on the x-axis
;                 $i_cy          - Distance, in pixels, to set between icons on the y-axis
; Return values : Returns a DWORD value that contains the previous cx in the low word and the previous
;                 cy in the high word.
; Notes ........: Values for cx and cy are relative to the upper-left corner of an icon bitmap. To set
;                 spacing between icons that do not overlap, the cx or cy values must include the size
;                 of the icon, plus the amount of empty space desired between icons.   Values that  do
;                 not include the width of the icon will result in overlaps.
; ====================================================================================================
Func _GUICtrlListViewSetIconSpacing($h_listview, $i_cx, $i_cy)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, $LV_ERR)
	If IsHWnd($h_listview) Then
;~ 		Return _SendMessage ($h_listview, $LVM_SETICONSPACING, 0, $i_cx * 65536 + $i_cy)
		Return _SendMessage($h_listview, $LVM_SETICONSPACING, 0, BitOR(BitShift($i_cy, -16), BitAND($i_cx, 0xFFFF)))
	Else
;~ 		Return GUICtrlSendMsg($h_listview, $LVM_SETICONSPACING, 0, $i_cx * 65536 + $i_cy)
		Return GUICtrlSendMsg($h_listview, $LVM_SETICONSPACING, 0, BitOR(BitShift($i_cy, -16), BitAND($i_cx, 0xFFFF)))
	EndIf
EndFunc   ;==>_GUICtrlListViewSetIconSpacing

;===============================================================================
; ====================================================================================================
; Description ..: Moves an item to a specified position in a listview control.  The control must be in
;                 icon or small icon view.
; Parameters ...: $h_listview        - Handle to control
;                 $i_index       - Zero based index of the item
;                 $i_x          - New x-position of the item's upper-left corner, in view coordinates
;                 $i_y          - New y-position of the item's upper-left corner, in view coordinates
; Return values : Success - True
;                 Failure - False
; Notes ........: If the listview control has the $LVS_AUTOARRANGE style, the  items  in  the  listview
;                 control are arranged after the position of the item is set.
; ====================================================================================================
Func _GUICtrlListViewSetItemPosition($h_listview, $i_index, $i_x, $i_y)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, False)
	If IsHWnd($h_listview) Then
;~ 		Return _SendMessage ($h_listview, $LVM_SETITEMPOSITION, $i_index, $i_x * 65536 + $i_y)
		Return _SendMessage($h_listview, $LVM_SETITEMPOSITION, $i_index, BitOR(BitShift($i_y, -16), BitAND($i_x, 0xFFFF)))
	Else
;~ 		Return GUICtrlSendMsg($h_listview, $LVM_SETITEMPOSITION, $i_index, $i_x * 65536 + $i_y)
		Return GUICtrlSendMsg($h_listview, $LVM_SETITEMPOSITION, $i_index, BitOR(BitShift($i_y, -16), BitAND($i_x, 0xFFFF)))
	EndIf
EndFunc   ;==>_GUICtrlListViewSetItemPosition

; ====================================================================================================
; Description ..: Sets the view of a listview control
; Parameters ...: $h_listview        - Handle to control
;                 $i_View        - View state for the control:
;                   $LV_VIEW_DETAILS
;                   $LV_VIEW_ICON
;                   $LV_VIEW_LIST
;                   $LV_VIEW_SMALLICON
;                   $LV_VIEW_TILE
; Return values : Only available for Windows XP
; ====================================================================================================
Func _GUICtrlListViewSetView($h_listview, $i_View)
	If Not _IsClassName ($h_listview, "SysListView32") Then Return SetError($LV_ERR, $LV_ERR, 0)
	If $i_View <> $LV_VIEW_DETAILS And $i_View <> $LV_VIEW_ICON And $i_View <> $LV_VIEW_LIST And _
			$i_View <> $LV_VIEW_SMALLICON And $i_View <> $LV_VIEW_TILE Then Return SetError($LV_ERR, $LV_ERR, 0)

	If IsHWnd($h_listview) Then
		Return _SendMessage($h_listview, $LVM_SETVIEW, $i_View)
	Else
		Return GUICtrlSendMsg($h_listview, $LVM_SETVIEW, $i_View, 0)
	EndIf
EndFunc   ;==>_GUICtrlListViewSetView

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\GUIListView.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\Include\Array.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\Include\Array.au3>
; ----------------------------------------------------------------------------



; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\DiskPartitioner\DiskPartErrors.au3>
; ----------------------------------------------------------------------------

Global $asDiskPartErrors[9]
$asDiskPartErrors[0] = "The arguments you specified for this command are not valid."
$asDiskPartErrors[1] = "The disk management services could not complete the operation."
$asDiskPartErrors[2] = "There is no volume specified." & @LF & "Please select a volume and try again."
$asDiskPartErrors[3] = "The disk you specified is not valid." & @LF & "There is no disk selected."
$asDiskPartErrors[4] = "The specified partition is not valid." & @LF & "Please select a valid partition."
$asDiskPartErrors[5] = "DiskPart was unable to create the specified partition."
$asDiskPartErrors[6] = "The selected partition may be neccessary to the operation of your computer, and may not be deleted."
$asDiskPartErrors[7] = "DiskPart assigned the drive letter, but your computer needs to be rebooted" & @LF & "before the changes take effect."
$asDiskPartErrors[8] = "DiskPart cannot reassign the drive letter on a system, boot or pagefile volume."

Func _CheckForDiskPartErrors($sOutput)
	For $i = 0 to UBound($asDiskPartErrors) - 1
		If StringInStr($sOutput, $asDiskPartErrors[$i]) > 0 Then
			DiskPartitioner_ErrorHandler($asDiskPartErrors[$i], "", "Non-Fatal")
			ExitLoop
		EndIf
	Next
EndFunc

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\DiskPartitioner\DiskPartErrors.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\DiskPartitioner\frmDiskPart.au3>
; ----------------------------------------------------------------------------

Func CreateForm_frmDiskPart(ByRef $afrmNew)

	Dim $afrmNew[23][2]

	$afrmNew[0][0] = "$frmDiskPart"
	$afrmNew[0][1] = GUICreate("Disk Partitioner", 398, 450, (@DesktopWidth - 405)/2, (@DesktopHeight - 457)/2)

	GUICtrlCreateGroup("Selected Drive:", 8, 8, 381, 73)
	$afrmNew[1][0] = "$icoDrive"
	$afrmNew[1][1] = GUICtrlCreateIcon ("shell32.dll", 50, 24, 32, 32, 32)
	$afrmNew[2][0] = "$lblDiskLabel"
	$afrmNew[2][1] = GUICtrlCreateLabel("", 90, 30, 200, 16, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)
	GUICtrlCreateLabel("Disk #: ", 90, 50, 43, 21)
	$afrmNew[3][0] = "$lblDiskNo"
	$afrmNew[3][1] = GUICtrlCreateLabel("", 126, 50, 30, 21, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[4][0] = "$lblDiskType"
	$afrmNew[4][1] = GUICtrlCreateLabel("Type:", 168, 50, 75, 21, $SS_LEFTNOWORDWRAP)
	$afrmNew[5][0] = "$lblDiskSize"
	$afrmNew[5][1] = GUICtrlCreateLabel("Size:", 250, 50, 80, 21, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[6][0] = "$cmdDiskBrowse"
	$afrmNew[6][1] = GUICtrlCreateButton("...", 344, 34, 33, 27)

	GUICtrlCreateLabel("Available Partitions:", 8, 89, 100, 13)
	GUICtrlCreateGroup("", 8, 100, 381, 201)
	$afrmNew[7][0] = "$lvwPartitions"
	$afrmNew[7][1] = GUICtrlCreateListView("Partition|Type|Capacity|Free Space|File System", 16, 115, 361, 144, _
					BitOr($LVS_SHOWSELALWAYS, $LVS_SINGLESEL, $LVS_NOSORTHEADER))
					GUICtrlSendMsg(-1, $LVM_SETEXTENDEDLISTVIEWSTYLE, $LVS_EX_GRIDLINES, $LVS_EX_GRIDLINES)
	;GUICtrlCreateGroup("", 16, 254, 361, 9)
	$afrmNew[8][0] = "$cmdAdd"
	$afrmNew[8][1] = GUICtrlCreateButton("&Add...", 16, 267, 75, 25, $WS_DISABLED)
	$afrmNew[9][0] = "$cmdDelete"
	$afrmNew[9][1] = GUICtrlCreateButton("&Delete", 96, 267, 75, 25, $WS_DISABLED)
	$afrmNew[10][0] = "$cmdEdit"
	$afrmNew[10][1] = GUICtrlCreateButton("&Edit...", 176, 267, 75, 25, $WS_DISABLED)
	$afrmNew[11][0] = "$cmdRefresh"
	$afrmNew[11][1] = GUICtrlCreateButton("&Refresh", 256, 267, 75, 25)

	GUICtrlCreateLabel("Partition Information:", 8, 309, 100, 13)
	GUICtrlCreateGroup("", 8, 320, 381, 101)

	GUICtrlCreateLabel("Volume #:", 16, 334, 60, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[12][0] = "$lblVolNo"
	$afrmNew[12][1] = GUICtrlCreateLabel("", 77, 334, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Offset:", 16, 358, 60, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[13][0] = "$lblOffset"
	$afrmNew[13][1] = GUICtrlCreateLabel("", 77, 358, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Hidden:", 143, 334, 45, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[14][0] = "$lblHidden"
	$afrmNew[14][1] = GUICtrlCreateLabel("", 189, 334, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Active:", 143, 358, 45, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[15][0] = "$lblActive"
	$afrmNew[15][1] = GUICtrlCreateLabel("", 189, 358, 65, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Status:", 256, 334, 40, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[16][0] = "$lblStatus"
	$afrmNew[16][1] = GUICtrlCreateLabel("", 297, 334, 85, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	GUICtrlCreateLabel("Info:", 256, 358, 40, 13);, -1, $WS_EX_STATICEDGE)
	$afrmNew[17][0] = "$lblInfo"
	$afrmNew[17][1] = GUICtrlCreateLabel("", 297, 358, 85, 13, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)

	$afrmNew[18][0] = "$cmdFormat"
	$afrmNew[18][1] = GUICtrlCreateButton("&Format...", 16, 387, 75, 25, $WS_DISABLED)
	$afrmNew[19][0] = "$cmdCheck"
	$afrmNew[19][1] = GUICtrlCreateButton("&Check...", 96, 387, 75, 25, $WS_DISABLED)
	$afrmNew[20][0] = "$cmdDefrag"
	$afrmNew[20][1] = GUICtrlCreateButton("Defra&gment...", 176, 387, 75, 25, $WS_DISABLED)
	$afrmNew[21][0] = "$cmdProperties"
	$afrmNew[21][1] = GUICtrlCreateButton("&Properties...", 256, 387, 75, 25, $WS_DISABLED)
	$afrmNew[22][0] = "$stbStatus"
	$afrmNew[22][1] = GUICtrlCreateLabel("", 0, 432, 398, 18, -1, $WS_EX_STATICEDGE)
EndFunc

Func frmDiskPart_Initialize()

	frmDiskPart_LoadIcons()
	frmDiskPart_ChangeControlState()
EndFunc

Func frmDiskPart_WndProc()

	frmDiskPart_ChangeControlState()

	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		DiskPartitioner_WndProc()	; Send end application message if main window closed
	Case $msg[0] = _GetCtrl("$cmdDiskBrowse", $afrmDiskPart)
		frmSelectDisk_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmSelectDisk[0][1])
	Case $msg[0] = _GetCtrl("$cmdAdd", $afrmDiskPart)
		frmDiskPart_cmdAdd_Click()
	Case $msg[0] = _GetCtrl("$cmdDelete", $afrmDiskPart)
		frmDiskPart_cmdDelete_Click()
	Case $msg[0] = _GetCtrl("$cmdEdit", $afrmDiskPart)
		frmEditPartition_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmEditPartition[0][1])
	Case $msg[0] = _GetCtrl("$cmdRefresh", $afrmDiskPart)
		frmDiskPart_cmdRefresh_Click()
	Case $msg[0] = _GetCtrl("$cmdFormat", $afrmDiskPart)
		frmDiskPart_cmdFormat_Click()
	Case $msg[0] = _GetCtrl("$cmdCheck", $afrmDiskPart)
		frmDiskPart_cmdCheck_Click()
	Case $msg[0] = _GetCtrl("$cmdDefrag", $afrmDiskPart)
		frmDiskPart_cmdDefrag_Click()
	Case $msg[0] = _GetCtrl("$cmdProperties", $afrmDiskPart)
		frmDiskPart_cmdProperties_Click()

	EndSelect
EndFunc

Func frmDiskPart_ChangeControlState()
	Local $lvwPartitions, $iSelPart

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iSelPart = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")

	If  $iSelPart = "" Then
		GUICtrlSetState(_GetCtrl("$cmdDelete", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdEdit", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdFormat", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdCheck", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdDefrag", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdProperties", $afrmDiskPart), $GUI_DISABLE)
	ElseIf ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetText", $iSelPart, 1) = "Extended" Then
		GUICtrlSetState(_GetCtrl("$cmdDelete", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdEdit", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdFormat", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdCheck", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdDefrag", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdProperties", $afrmDiskPart), $GUI_DISABLE)
	Else
		GUICtrlSetState(_GetCtrl("$cmdDelete", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdEdit", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdFormat", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdCheck", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdDefrag", $afrmDiskPart), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cmdProperties", $afrmDiskPart), $GUI_ENABLE)
	EndIf

	If $iSelPart = "" Then
		GUICtrlSetData(_GetCtrl("$lblVolNo", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblOffset", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblHidden", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblActive", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblStatus", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblInfo", $afrmDiskPart), "")
	Else
		GUICtrlSetData(_GetCtrl("$lblVolNo", $afrmDiskPart), StringMid($asPartitions[$iSelPart][4], 8))
		GUICtrlSetData(_GetCtrl("$lblOffset", $afrmDiskPart), $asPartitions[$iSelPart][3])
		GUICtrlSetData(_GetCtrl("$lblHidden", $afrmDiskPart), $asPartitions[$iSelPart][12])
		GUICtrlSetData(_GetCtrl("$lblActive", $afrmDiskPart), $asPartitions[$iSelPart][13])
		GUICtrlSetData(_GetCtrl("$lblStatus", $afrmDiskPart), $asPartitions[$iSelPart][10])
		GUICtrlSetData(_GetCtrl("$lblInfo", $afrmDiskPart), $asPartitions[$iSelPart][11])
	EndIf
EndFunc

Func frmDiskPart_LoadIcons()
	If @compiled = 1 Then
		GUICtrlSetImage(_GetCtrl("$icoDrive", $afrmDiskPart), @ScriptFullPath, 0)
		GUICtrlSetImage(_GetCtrl("$lvwPartitions", $afrmDiskPart), @ScriptFullPath, 1)
	Else
		GUISetIcon("icons\0.ico", 0, $afrmDiskPart[0][1])
		GUICtrlSetImage(_GetCtrl("$icoDrive", $afrmDiskPart), "icons\0.ico", 0)
		GUICtrlSetImage(_GetCtrl("$lvwPartitions", $afrmDiskPart), "icons\1.ico", 0)
	EndIf
EndFunc

Func frmDiskPart_cmdAdd_Click()
	Local $iDiskIndex

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	If _ConvertToMB($asDisks[$iDiskIndex][3]) = 0 Then
		DiskPartitioner_ErrorHandler("All available space on this disk has been allocated.", "", "Non-Fatal")
	Else
		frmCreatePartition_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmCreatePartition[0][1])
	EndIf
EndFunc

Func frmDiskPart_cmdDelete_Click()
	Local $iPartIndex, $bLogicalPresent
	Local $lvwPartitions, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")

	If $asPartitions[$iPartIndex][1] = "Extended" Then
		$bLogicalPresent = False
		For $i = 0 to UBound($asPartitions, 1) - 1
			If $asPartitions[$i][1] = "Logical" Then
				$bLogicalPresent = True
				ExitLoop
			EndIf
		Next

		If $bLogicalPresent Then
			DiskPartitioner_ErrorHandler("Cannot delete extended partition when logical drive(s) are present.", _
										"Delete all logical drives before removing the extended partition.", "Non-Fatal")
		Else
			; Delete extended without prompting when logical drives are not present
			ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
			frmDiskPart_ChangeControlState()

			GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
			GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

			_DeletePartition($sCurrentDisk, $asPartitions[$iPartIndex][0], True, $stbStatus)

			frmSelectDisk_LoadDisks()
			frmDiskPart_LoadPartitions()

			GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
		EndIf
	Else
		frmDeletePartition_Initialize()
		GUISetState(@SW_DISABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_SHOW, $afrmDeletePartition[0][1])
	EndIf
EndFunc

Func frmDiskPart_cmdRefresh_Click()
	Local $lvwPartitions, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
	frmDiskPart_ChangeControlState()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
	GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

	_RefreshDiskPartInfo($sCurrentDisk, $stbStatus)
	frmSelectDisk_LoadDisks()
	frmDiskPart_LoadPartitions()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
EndFunc

Func frmDiskPart_cmdFormat_Click()
	Local $SHFD_CAPACITY_DEFAULT = 0
	Local $SHMT_FORMAT_QUICK = 1  ;Quick format
	Local $SHMT_FORMAT_FULL = 0  ;Full format
	Local $iLetter, $sDriveLetter, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to format the selected partition.", "Non-Fatal")
			SetError(1)
			Return
		Else
			$iLetter = Asc($sDriveLetter) - 65
			DllCall("shell32.dll", "long", "SHFormatDrive", "hwnd", $afrmDiskPart[0][1], "int", $iLetter, _
				"int", $SHFD_CAPACITY_DEFAULT, "int", $SHMT_FORMAT_QUICK)
		EndIf
	EndIf
EndFunc

Func frmDiskPart_cmdCheck_Click()
	Local $sDriveLetter, $sDriveLabel, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to check the selected disk.", "Non-Fatal")
			SetError(1)
			Return
		Else
			$sDriveLabel = $asPartitions[$iPartIndex][6]
			If $sDriveLabel = "" Then $sDriveLabel = "Local Disk"
			DllCall("shell32.dll", "int", "SHObjectProperties", "hwnd", $afrmDiskPart[0][1], "int", 2, "wstr", $sDriveLetter & ":\", "wstr", "Tools")
			If WinWaitActive($sDriveLabel & " (" & $sDriveLetter & ":) Properties", "", 5) = 1 Then
				WinSetState ($sDriveLabel & " (" & $sDriveLetter & ":) Properties", "", @SW_HIDE)
				ControlClick ($sDriveLabel & " (" & $sDriveLetter & ":) Properties", "", "Button2")
			EndIf
			; Putting the $GUI_EVENT_CLOSE for the drive properties window closes it immediately after the check disk window exits.
			WinClose($sDriveLabel & " (" & $sDriveLetter & ":) Properties")
		EndIf
	EndIf
EndFunc

Func frmDiskPart_cmdDefrag_Click()
	Local $sDriveLetter, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to defragment the selected partition.", "Non-Fatal")
			Return
		ElseIf FileExists(@SystemDir & "\MMC.exe") And FileExists(@SystemDir & "\dfrg.msc") Then
			DllCall("shell32.dll", "long", "ShellExecute", "hwnd", $afrmDiskPart[0][1], "str", "", _
					"str", @SystemDir & "\dfrg.msc", "str", $sDriveLetter & ":", "str", @SystemDir, "long", @SW_SHOWNORMAL)
		EndIf
	EndIf
EndFunc

Func frmDiskPart_cmdProperties_Click()
	Local $sDriveLetter, $iPartIndex, $lvwPartitions

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	If $iPartIndex <> "" Then
		$sDriveLetter = $asPartitions[$iPartIndex][5]
		If $sDriveLetter = "" Then
			DiskPartitioner_ErrorHandler("No drive letter assigned.", "A drive letter must be assigned to partition for viewing properties.", "Non-Fatal")
			Return
		Else
			DllCall("shell32.dll", "int", "SHObjectProperties", "hwnd", $afrmDiskPart[0][1], "int", 2, "wstr", $sDriveLetter & ":\", "wstr", "")
		EndIf
	EndIf
EndFunc

Func frmDiskPart_LoadPartitions()
	Local $lvwPartitions, $sPartName, $sDriveFreeSpace

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	GUICtrlSendMsg($lvwPartitions, $LVM_DELETEALLITEMS, 0, 0)	; Delete all Items

	If $asDisks = 0 Then
		GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

		GUICtrlSetData(_GetCtrl("$lblDiskLabel", $afrmDiskPart), "(NO DISKS FOUND)")
		GUICtrlSetData(_GetCtrl("$lblDiskNo", $afrmDiskPart), "")
		GUICtrlSetData(_GetCtrl("$lblDiskType", $afrmDiskPart), "Type: ")
		GUICtrlSetData(_GetCtrl("$lblDiskSize", $afrmDiskPart), "Size: ")
	Else
		GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_ENABLE)

		For $i = 0 to Ubound($asDisks, 1) - 1
			If $asDisks[$i][0] = $sCurrentDisk Then
				GUICtrlSetData(_GetCtrl("$lblDiskLabel", $afrmDiskPart), $asDisks[$i][6])
				GUICtrlSetData(_GetCtrl("$lblDiskNo", $afrmDiskPart), StringMid($asDisks[$i][0], 5))
				GUICtrlSetData(_GetCtrl("$lblDiskType", $afrmDiskPart), "Type: " & $asDisks[$i][8])
				GUICtrlSetData(_GetCtrl("$lblDiskSize", $afrmDiskPart), "Size: " & $asDisks[$i][2])

				ExitLoop
			EndIf
		Next

		; Populate $lvwPartitions
		For $i = 0 to UBound($asPartitions, 1) - 1
			$sPartName = ""
			$sDriveFreeSpace = ""
			If $asPartitions[$i][5] <> "" Then
				$sPartName = $asPartitions[$i][6] & ' (' & $asPartitions[$i][5] & ":)"
				If DriveStatus($asPartitions[$i][5] & ":") <> "UNKNOWN" Then	; check whether drive is formatted
					$sDriveFreeSpace = Int(DriveSpaceFree($asPartitions[$i][5] & ":")) & " MB"
				EndIf
			Else
				$sPartName = $asPartitions[$i][6]
			EndIf

			If $sPartName = "" Then $sPartName = " "	; Shows junk value in first listviewitem if empty

			GUICtrlCreateListViewItem($sPartName & '|' & $asPartitions[$i][1] & '|' & $asPartitions[$i][2] & _
									 '|' & $sDriveFreeSpace & '|' & $asPartitions[$i][7], $lvwPartitions)

			GUICtrlSendMsg($lvwPartitions, $LVM_SETCOLUMNWIDTH, 0, -1)
		Next
	EndIf

	frmDiskPart_ChangeControlState()
EndFunc

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\DiskPartitioner\frmDiskPart.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\DiskPartitioner\frmSelectDisk.au3>
; ----------------------------------------------------------------------------

Func CreateForm_frmSelectDisk(ByRef $afrmNew, $frmParent)

	Dim $afrmNew[5][2], $iExStyle

	$afrmNew[0][0] = "$frmSelectDisk"
	$afrmNew[0][1] = GUICreate("Select Hard Disk", 394, 191, (@DesktopWidth - 100)/2, (@DesktopHeight - 352)/2, _
							BitOr($WS_CAPTION, $WS_SYSMENU, $WS_POPUP), -1, $frmParent)
	GUICtrlCreateLabel("Available Hard Disks:", 8, 8, 110, 13)
	$afrmNew[1][0] = "$lvwHardDisks"
	$afrmNew[1][1] = GUICtrlCreateListView("Disk #   |Model|Disk ID|Type|Size|Free Space|", 8, 28, 377, 118, _
					BitOR($LVS_SHOWSELALWAYS, $LVS_NOSORTHEADER, $LVS_SINGLESEL))
					GUICtrlSendMsg(-1, $LVM_SETEXTENDEDLISTVIEWSTYLE, $LVS_EX_GRIDLINES, $LVS_EX_GRIDLINES)
	$afrmNew[2][0] = "$cmdRefresh"
	$afrmNew[2][1] = GUICtrlCreateButton("&Refresh", 8, 159, 75, 23)
	$afrmNew[3][0] = "$cmdOK"
	$afrmNew[3][1] = GUICtrlCreateButton("&OK", 230, 159, 75, 23, $WS_DISABLED)
	$afrmNew[4][0] = "$cmdCancel"
	$afrmNew[4][1] = GUICtrlCreateButton("Cancel", 311, 159, 75, 23, $BS_DEFPUSHBUTTON)
EndFunc

Func frmSelectDisk_Initialize()
	frmSelectDisk_LoadDisks()

	frmSelectDisk_LoadIcons()
	frmSelectDisk_ChangeControlState()
EndFunc

Func frmSelectDisk_WndProc()

	frmSelectDisk_ChangeControlState()

	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUISetState(@SW_ENABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_HIDE, $afrmSelectDisk[0][1])
	Case $msg[0] = _GetCtrl("$cmdRefresh", $afrmSelectDisk)
		frmSelectDisk_cmdRefresh_Click()
	Case $msg[0] = _GetCtrl("$cmdOK", $afrmSelectDisk)
		$msg[0] = $GUI_EVENT_CLOSE
		frmSelectDisk_WndProc()
		frmSelectDisk_cmdOK_Click()
	Case $msg[0] = _GetCtrl("$cmdCancel", $afrmSelectDisk)
		$msg[0] = $GUI_EVENT_CLOSE
		frmSelectDisk_WndProc()
	EndSelect
EndFunc

Func frmSelectDisk_ChangeControlState()
	If ControlListView($afrmSelectDisk[0][1], "", _GetCtrl("$lvwHardDisks", $afrmSelectDisk), _
						"GetSelectedCount") = 1 Then

		GUICtrlSetState(_GetCtrl("$cmdOK", $afrmSelectDisk), $GUI_ENABLE)
	Else
		GUICtrlSetState(_GetCtrl("$cmdOK", $afrmSelectDisk), $GUI_DISABLE)
	EndIf
EndFunc

Func frmSelectDisk_LoadIcons()
	If @compiled = 1 Then
		GUICtrlSetImage(_GetCtrl("$lvwHardDisks", $afrmSelectDisk), @ScriptFullPath, 0)
	Else
		GUISetIcon("icons\0.ico", 0, $afrmSelectDisk[0][1])
		GUICtrlSetImage(_GetCtrl("$lvwHardDisks", $afrmSelectDisk), "icons\0.ico", 0)
	EndIf
EndFunc

Func frmSelectDisk_cmdRefresh_Click()
	Local $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmSelectDisk), $GUI_DISABLE)
	GUICtrlSetState(_GetCtrl("$cmdOK", $afrmSelectDisk), $GUI_DISABLE)

	_RefreshDiskPartInfo("", $stbStatus)
	frmSelectDisk_LoadDisks()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmSelectDisk), $GUI_ENABLE)
EndFunc

Func frmSelectDisk_LoadDisks()
	Local $lvwHardDisks

	$lvwHardDisks = _GetCtrl("$lvwHardDisks", $afrmSelectDisk)

	; Populate $lvwHardDisks
	GUICtrlSendMsg($lvwHardDisks, $LVM_DELETEALLITEMS, 0, 0)	; Delete all Items

	For $i = 0 to UBound($asDisks, 1) - 1
		GUICtrlCreateListViewItem($asDisks[$i][0] & '|' & $asDisks[$i][6] & '|' & $asDisks[$i][7] & '|' & $asDisks[$i][8] _
									& '|' & $asDisks[$i][2] & '|' & $asDisks[$i][3], $lvwHardDisks)
	Next
EndFunc

Func frmSelectDisk_cmdOK_Click($bLoadFirstDisk = False)
	Local $sDiskNo, $iDiskIndex
	Local $lvwHardDisks, $lvwPartitions, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwHardDisks = _GetCtrl("$lvwHardDisks", $afrmSelectDisk)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	If ControlListView($afrmSelectDisk[0][1], "", $lvwHardDisks, "GetItemCount") > 0 Then
		If $bLoadFirstDisk = True Then
			$sDiskNo = ControlListView($afrmSelectDisk[0][1], "", $lvwHardDisks, "GetText", 0, 0)
		Else
			$iDiskIndex = ControlListView($afrmSelectDisk[0][1], "", $lvwHardDisks, "GetSelected")
			$sDiskNo = ControlListView($afrmSelectDisk[0][1], "", $lvwHardDisks, "GetText", $iDiskIndex, 0)
		EndIf

		ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
		frmDiskPart_ChangeControlState()

		GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

		_RefreshDiskPartInfo($sDiskNo, $stbStatus)

		GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
	EndIf

	frmDiskPart_LoadPartitions()
EndFunc

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\DiskPartitioner\frmSelectDisk.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\DiskPartitioner\frmCreatePartition.au3>
; ----------------------------------------------------------------------------

Func CreateForm_frmCreatePartition(ByRef $afrmNew, $frmParent)

	Dim $afrmNew[14][2]

	$afrmNew[0][0] = "$frmCreatePartition"
	$afrmNew[0][1] = GUICreate("Create Partition", 409, 271, (@DesktopWidth - 200)/2, (@DesktopHeight - 271)/2, _
						BitOr($WS_CAPTION, $WS_POPUP), -1, $frmParent)
	$afrmNew[1][0] = "$grPartPie"
	$afrmNew[1][1] = GuiCtrlCreateGraphic(8, 8, 160, 140)
	$afrmNew[2][0] = "$grLegend"
	$afrmNew[2][1] = GUICtrlCreateGraphic(0, 140, 200, 60)

	GUICtrlCreateLabel("Allocated", 35, 154, 110, 20)
	$afrmNew[3][0] = "$lblAllocated"
	$afrmNew[3][1] = GUICtrlCreateLabel("", 150, 155, 30, 20)
	GUICtrlCreateLabel("Current Partition Size", 35, 184, 110, 20)
	$afrmNew[4][0] = "$lblCurrentSize"
	$afrmNew[4][1] = GUICtrlCreateLabel("", 150, 185, 30, 20)
	GUICtrlCreateLabel("Free Space", 35, 214, 110, 20)
	$afrmNew[5][0] = "$lblFreeSpace"
	$afrmNew[5][1] = GUICtrlCreateLabel("", 150, 215, 30, 20)

	GUICtrlCreateLabel("Partition Size (MB):", 188, 42, 100, 13, $SS_RIGHT)
	$afrmNew[6][0] = "$txtPartSize"
	$afrmNew[6][1] = GUICtrlCreateInput("0", 296, 39, 105, 22, $ES_NUMBER)
	$afrmNew[7][0] = "$udPartSize"
	$afrmNew[7][1] = GUICtrlCreateUpdown(_GetCtrl("$txtPartSize", $afrmNew), $UDS_NOTHOUSANDS)
	$afrmNew[8][0] = "$slPartSize"
	$afrmNew[8][1] = GUICtrlCreateSlider(184, 80, 225, 26, $TBS_NOTICKS)

	GUICtrlCreateLabel("0 MB", 191, 108, 25, 13)
	$afrmNew[9][0] = "$lblMaxPartSize"
	$afrmNew[9][1] = GUICtrlCreateLabel("", 340, 108, 60, 13, $SS_RIGHT);, $WS_EX_STATICEDGE)

	GUICtrlCreateLabel("Partition Type:", 188, 154, 100, 13, $SS_RIGHT)
	$afrmNew[10][0] = "$cboPartType"
	$afrmNew[10][1] = GUICtrlCreateCombo("", 296, 152, 105, 21, $CBS_DROPDOWNLIST)
	GUICtrlCreateLabel("Assign Drive Letter:", 188, 184, 100, 13, $SS_RIGHT)
	$afrmNew[11][0] = "$cboDriveLetter"
	$afrmNew[11][1] = GUICtrlCreateCombo("", 296, 182, 105, 21, BitOr($CBS_DROPDOWNLIST, $CBS_SORT, $WS_VSCROLL))

	$afrmNew[12][0] = "$cmdOK"
	$afrmNew[12][1] = GUICtrlCreateButton("&OK", 244, 238, 75, 25)
	$afrmNew[13][0] = "$cmdCancel"
	$afrmNew[13][1] = GUICtrlCreateButton("Cancel", 324, 238, 75, 25)

EndFunc

Func frmCreatePartition_Initialize()
	Local $cboPartType
	Local $iDiskIndex, $iMaxSize, $iFreeSpace, $iAllocated

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iFreeSpace = 0
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize - $iFreeSpace

	$cboPartType = _GetCtrl("$cboPartType", $afrmCreatePartition)

	; Initialize $cboPartTypes
	frmCreatePartition_LoadPartTypes()
	frmCreatePartition_cboPartType_Click()

	; Initialize $cboDriveLetter
	frmCreatePartition_LoadDriveLetters()

	; Update pie chart
	frmCreatePartition_CreatePieChart($iAllocated, $iMaxSize, $iFreeSpace)

	; Initialize other controls on form
	GUICtrlSetData(_GetCtrl("$lblMaxPartSize", $afrmCreatePartition), $iMaxSize & " MB")
	GUICtrlSetLimit(_GetCtrl("$slPartSize", $afrmCreatePartition), $iMaxSize, 0)
	GUICtrlSetData(_GetCtrl("$slPartSize", $afrmCreatePartition), $iMaxSize)

	GUICtrlSetLimit(_GetCtrl("$udPartSize", $afrmCreatePartition), $iMaxSize, 0)
	GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iMaxSize)

	; Load icons
	frmCreatePartition_LoadIcons()
EndFunc

Func frmCreatePartition_WndProc()

	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUISetState(@SW_ENABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_HIDE, $afrmCreatePartition[0][1])
	Case $msg[0] = _GetCtrl("$slPartSize", $afrmCreatePartition)
		frmCreatePartition_slPartSize_Click()
	Case $msg[0] = _GetCtrl("$txtPartSize", $afrmCreatePartition)
		frmCreatePartition_txtPartSize_Click()
	Case $msg[0] = _GetCtrl("$cboPartType", $afrmCreatePartition)
		frmCreatePartition_cboPartType_Click()
	Case $msg[0] = _GetCtrl("$cmdOK", $afrmCreatePartition)
		frmCreatePartition_cmdOK_Click()
	Case $msg[0] = _GetCtrl("$cmdCancel", $afrmCreatePartition)
		$msg[0] = $GUI_EVENT_CLOSE
		frmCreatePartition_WndProc()

	EndSelect
EndFunc

Func frmCreatePartition_LoadIcons()
	If @compiled = 1 Then
		; Do nothing
	Else
		GUISetIcon("icons\0.ico", 0, $afrmCreatePartition[0][1])
	EndIf
EndFunc

Func frmCreatePartition_slPartSize_Click()
	Local $iDiskIndex
	Local $iCurrentSize, $iMaxSize, $iFreeSpace, $iAllocated

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize

	$iCurrentSize = GUICtrlRead(_GetCtrl("$slPartSize", $afrmCreatePartition))
	$iFreeSpace = $iMaxSize - $iCurrentSize

	GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iCurrentSize)

	; Update pie chart
	frmCreatePartition_CreatePieChart($iAllocated, $iCurrentSize, $iFreeSpace)
EndFunc

Func frmCreatePartition_txtPartSize_Click()
	Local $iDiskIndex, $iCurrentSize, $iMaxSize, $iFreeSpace, $iAllocated, $iError
	Local $msg2

	While $msg2 = 0 And $msg2 <> $GUI_EVENT_MOUSEMOVE
		$msg2 = GUIGetMsg()
	Wend

	If $msg2 = _GetCtrl("$cmdCancel", $afrmCreatePartition) Then
		$msg[0] = _GetCtrl("$cmdCancel", $afrmCreatePartition)
		frmCreatePartition_WndProc()
		Return
	EndIf

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize

	$iCurrentSize = GUICtrlRead(_GetCtrl("$txtPartSize", $afrmCreatePartition))
	If $iCurrentSize > $iMaxSize Then
		DiskPartitioner_ErrorHandler("Partition size value out of range.", _
									"Specify a value less than or equal to " & $iMaxSize & " MB.", "Non-Fatal")
		$iCurrentSize = $iMaxSize
		GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iCurrentSize)
		$iError = 1
	EndIf
	$iFreeSpace = $iMaxSize - $iCurrentSize
	GUICtrlSetData(_GetCtrl("$slPartSize", $afrmCreatePartition), $iCurrentSize)

	; Update pie chart
	frmCreatePartition_CreatePieChart($iAllocated, $iCurrentSize, $iFreeSpace)

	If $msg2 = _GetCtrl("$cmdOK", $afrmCreatePartition) And $iError = 0 Then
		$msg[0] = $msg2
		frmCreatePartition_WndProc()
	EndIf

	SetError($iError)
EndFunc

Func frmCreatePartition_cboPartType_Click()
	Local $sPartType, $iDiskIndex
	Local $iMaxSize, $iFreeSpace, $iAllocated

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iFreeSpace = 0
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize

	$sPartType = GUICtrlRead(_GetCtrl("$cboPartType", $afrmCreatePartition))

	If $sPartType = "Extended" Then
		GUICtrlSetData(_GetCtrl("$slPartSize", $afrmCreatePartition), $iMaxSize)
		GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iMaxSize)
		GUICtrlSetData(_GetCtrl("$cboDriveLetter", $afrmCreatePartition), "(None)")

		GUICtrlSetState(_GetCtrl("$slPartSize", $afrmCreatePartition), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$udPartSize", $afrmCreatePartition), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$txtPartSize", $afrmCreatePartition), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cboDriveLetter", $afrmCreatePartition), $GUI_DISABLE)

		; Update pie chart
		frmCreatePartition_CreatePieChart($iAllocated, $iMaxSize, $iFreeSpace)
	Else
		GUICtrlSetState(_GetCtrl("$slPartSize", $afrmCreatePartition), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$udPartSize", $afrmCreatePartition), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$txtPartSize", $afrmCreatePartition), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cboDriveLetter", $afrmCreatePartition), $GUI_ENABLE)
	EndIf

EndFunc

Func frmCreatePartition_cmdOK_Click()
	Local $sPartType, $sDriveLetter
	Local $iMaxSize, $iPartSize, $iDiskIndex
	Local $stbStatus, $lvwPartitions

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next
	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])

	; Refresh partition size value
	frmCreatePartition_txtPartSize_Click()
	If @error Then
		; Invalid value in partition size
		Return
	Else
		$iPartSize = GUICtrlRead(_GetCtrl("$txtPartSize", $afrmCreatePartition))
		$sPartType = GUICtrlRead(_GetCtrl("$cboPartType", $afrmCreatePartition))
		$sDriveLetter = GUICtrlRead(_GetCtrl("$cboDriveLetter", $afrmCreatePartition))
		If $sDriveLetter = "(None)" Then $sDriveLetter = ""

		$msg[0] = $GUI_EVENT_CLOSE
		frmCreatePartition_WndProc()

		ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
		frmDiskPart_ChangeControlState()

		GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

		If $iPartSize = $iMaxSize Then
			_CreatePartition($sCurrentDisk, $sPartType, -1, $sDriveLetter, $stbStatus)
		Else
			_CreatePartition($sCurrentDisk, $sPartType, $iPartSize, $sDriveLetter, $stbStatus)
		EndIf

		frmSelectDisk_LoadDisks()
		frmDiskPart_LoadPartitions()

		GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
	EndIf
EndFunc

Func frmCreatePartition_LoadPartTypes()
	Local $iDiskIndex, $cboPartType
	Local $bExtendedPresent = 0

	$cboPartType = _GetCtrl("$cboPartType", $afrmCreatePartition)

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	GUICtrlSetData($cboPartType, "")	; Delete all items

	For $i = 0 to UBound($asPartitions, 1) - 1
		If $asPartitions[$i][1] = "Extended" Then
			$bExtendedPresent = True
			ExitLoop
		EndIf
	Next

	If $bExtendedPresent = False Then
		GUICtrlSetData($cboPartType, "Primary|Extended")
	ElseIf $bExtendedPresent = True Then
		GUICtrlSetData($cboPartType, "Logical")
	EndIf

	GUICtrlSendMsg($cboPartType, $CB_SETCURSEL, 0, 0)
EndFunc

Func frmCreatePartition_LoadDriveLetters()
	Local $sDriveLetters, $asDriveLetters, $asDrives
	Local $cboDriveLetter

	$cboDriveLetter = _GetCtrl("$cboDriveLetter", $afrmCreatePartition)
	GUICtrlSetData($cboDriveLetter, "")	; Delete all items

	$sDriveLetters = "(None)|A:|B:|C:|D:|E:|F:|G:|H:|I:|J:|K:|L:|M:|N:|O:|P:|Q:|R:|S:|T:|U:|V:|W:|X:|Y:|Z:"
	$asDriveLetters = StringSplit($sDriveLetters, "|")
	$asDrives = DriveGetDrive("ALL")
	_ArraySort($asDrives, 0, 1)

	For $i = 1 to UBound($asDriveLetters, 1) - 1
		If _ArrayBinarySearch($asDrives, $asDriveLetters[$i], 1) = "" Then
			GUICtrlSetData($cboDriveLetter, $asDriveLetters[$i])
		EndIf
	Next

	GUICtrlSendMsg($cboDriveLetter, $CB_SETCURSEL, 0, 0)
EndFunc

Func frmCreatePartition_CreatePieChart($iAllocated, $iCurrentSize, $iFreeSpace)
	Local $iTotalTests, $iPerAllocated, $iDegAllocated
	Local $iPerCurSize, $iDegCurSize, $iPerFreeSpace, $iDegFreeSpace
	Local $iColorAllocated, $iColorCurSize, $iColorFreeSpace
	Local $hgrCtrlPie, $hgrCtrlLegend

	$hgrCtrlPie = _GetCtrl("$grPartPie", $afrmCreatePartition)
	$hgrCtrlLegend = _GetCtrl("$grLegend", $afrmCreatePartition)

	;$iColorAllocated = 0x787878	; Black
	$iColorAllocated = 0xB0B4FB
	;$iColorCurSize = 0xBEBEBE		; Grey
	$iColorCurSize = 0x8F8FF5
	$iColorFreeSpace = 0xFFFFFF	; White

	;===== The following functions calculate Percentages and Degrees =====
	$iTotalTests = $iAllocated + $iCurrentSize + $iFreeSpace

	$iPerAllocated = $iAllocated / $iTotalTests
	$iDegAllocated =  $iPerAllocated * 360

	$iPerCurSize = $iCurrentSize / $iTotalTests
	$iDegCurSize =  $iPerCurSize * 360

	$iPerFreeSpace = $iFreeSpace / $iTotalTests
	$iDegFreeSpace = $iPerFreeSpace * 360
	;=====================================================================

	;=== This section will create the Pie Chart ==========================
	;Passed Pie section
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_COLOR, 0x000000, $iColorAllocated)
	;Set the Pie chart piece Starts at 90^ and sweeps for $iDegAllocated number of ^
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_PIE, 75, 70, 60, 90, $iDegAllocated)
	;Failed Pie section
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_COLOR, 0x000000, $iColorCurSize)
	;Set the Pie chart Piece Starts at 90^ + total ^ of $iDegAllocated
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_PIE, 75, 70, 60, 90 + $iDegAllocated, $iDegCurSize)
	;Warnings Pie Section
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_COLOR, 0x000000, $iColorFreeSpace)
	;Set the Pie Chart Piece Start at 90^ + Total ^ of $iDegAllocated and $iDegCurSize
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_PIE, 75, 70, 60, 90 + $iDegAllocated + $iDegCurSize, $iDegFreeSpace)

	;=== This section creates the Legend =============================

	;Allocated Legend
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_PENSIZE, 5);Makes the Dot bigger so you can see the color
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_COLOR, $iColorAllocated, $iColorAllocated)
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_DOT, 20, 20)
	;Calculates the total percentage to display
	GUICtrlSetData(_GetCtrl("$lblAllocated", $afrmCreatePartition), Round($iPerAllocated * 100, 0) & "%")

	;Current Partition Size Legend
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_PENSIZE, 5);Makes the Dot bigger so you can see the color
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_COLOR, $iColorCurSize, $iColorCurSize)
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_DOT, 20, 50)
	;Calculates the total percentage to display
	GUICtrlSetData(_GetCtrl("$lblCurrentSize", $afrmCreatePartition), Round($iPerCurSize * 100, 0) & "%")
	;Free Space Legend
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_PENSIZE, 5);Makes the Dot bigger so you can see the color
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_COLOR, $iColorFreeSpace, $iColorFreeSpace)
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_DOT, 20, 80)
	;Calculates the total percentage to display
	GUICtrlSetData(_GetCtrl("$lblFreeSpace", $afrmCreatePartition), Round($iPerFreeSpace * 100, 0) & "%")

	;Refresh Graphics
	GUICtrlSetState($hgrCtrlPie, $GUI_DISABLE)
	GUICtrlSetState($hgrCtrlPie, $GUI_ENABLE)
	GUICtrlSetState($hgrCtrlLegend, $GUI_DISABLE)
	GUICtrlSetState($hgrCtrlLegend, $GUI_ENABLE)
EndFunc

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\DiskPartitioner\frmCreatePartition.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\DiskPartitioner\frmDeletePartition.au3>
; ----------------------------------------------------------------------------

Func CreateForm_frmDeletePartition(ByRef $afrmNew, $frmParent)

	Dim $afrmNew[12][2]

	$afrmNew[0][0] = "$frmDeletePartition"
	$afrmNew[0][1] = GUICreate("Delete Partition", 384, 250, (@DesktopWidth - 100)/2, (@DesktopHeight - 274)/2, _
									BitOr($WS_CAPTION, $WS_SYSMENU, $WS_POPUP), -1, $frmParent)
	$afrmNew[1][0] = "$icoDelete"
	$afrmNew[1][1] = GUICtrlCreateIcon("shell32.dll", 50, 8, 8, 32, 32)
	GUICtrlCreateLabel("Warning: The selected partition may contain user data." & @CRLF & _
					"Continuing will erase any existing data on the partition.", 51, 10, 325, 35);, -1, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)

	GUICtrlCreateGroup("Partition Information:", 8, 49, 368, 105)
	$afrmNew[2][0] = "$lblPartLocation"
	$afrmNew[2][1] = GUICtrlCreateLabel("", 16, 70, 352, 17, $SS_CENTER, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)
	$afrmNew[3][0] = "$lblPartType"
	$afrmNew[3][1] = GUICtrlCreateLabel("Type: ", 16, 95, 105, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[4][0] = "$lblPartSize"
	$afrmNew[4][1] = GUICtrlCreateLabel("Size: ", 16, 120, 105, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[5][0] = "$lblPartLabel"
	$afrmNew[5][1] = GUICtrlCreateLabel("Label: ", 123, 95, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[6][0] = "$lblDriveLetter"
	$afrmNew[6][1] = GUICtrlCreateLabel("Letter: ", 123, 120, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[7][0] = "$lblPartFS"
	$afrmNew[7][1] = GUICtrlCreateLabel("File System: ", 247, 95, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)
	$afrmNew[8][0] = "$lblPartActive"
	$afrmNew[8][1] = GUICtrlCreateLabel("Active: ", 247, 120, 122, 17, $SS_LEFTNOWORDWRAP);, $WS_EX_STATICEDGE)

	GUICtrlCreateLabel("Are you sure you want to delete this partition?", 8, 161, 368, 17, $SS_CENTER);, $WS_EX_STATICEDGE)
					GUICtrlSetFont(-1, 8.5, 600)
	$afrmNew[9][0] = "$chkConfirmDelete"
	$afrmNew[9][1] = GUICtrlCreateCheckbox("&Delete partition and erase any existing data.", 8, 185, 368, 17 )
	$afrmNew[10][0] = "$cmdDelete"
	$afrmNew[10][1] = GUICtrlCreateButton("Delete", 222, 216, 75, 25, $WS_DISABLED)
	$afrmNew[11][0] = "$cmdCancel"
	$afrmNew[11][1] = GUICtrlCreateButton("Cancel", 302, 216, 75, 25, $BS_DEFPUSHBUTTON)
EndFunc

Func frmDeletePartition_Initialize()
	Local $iDiskIndex, $iPartIndex, $lvwPartitions
	Local $chkConfirmDelete, $cmdDelete

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	$chkConfirmDelete = _GetCtrl("$chkConfirmDelete", $afrmDeletePartition)
	$cmdDelete = _GetCtrl("$cmdDelete", $afrmDeletePartition)

	GUICtrlSetData(_GetCtrl("$lblPartLocation", $afrmDeletePartition), $asPartitions[$iPartIndex][0] & " on " & $asDisks[$iDiskIndex][6])
	GUICtrlSetData(_GetCtrl("$lblPartType", $afrmDeletePartition), "Type: " & $asPartitions[$iPartIndex][1])
	GUICtrlSetData(_GetCtrl("$lblPartSize", $afrmDeletePartition), "Size: " & $asPartitions[$iPartIndex][2])
	GUICtrlSetData(_GetCtrl("$lblPartLabel", $afrmDeletePartition), "Label: " & $asPartitions[$iPartIndex][6])
	GUICtrlSetData(_GetCtrl("$lblDriveLetter", $afrmDeletePartition), "Letter: " & $asPartitions[$iPartIndex][5])
	GUICtrlSetData(_GetCtrl("$lblPartFS", $afrmDeletePartition), "File System: " & $asPartitions[$iPartIndex][7])
	GUICtrlSetData(_GetCtrl("$lblPartActive", $afrmDeletePartition), "Active: " & $asPartitions[$iPartIndex][13])

	frmDeletePartition_LoadIcons()
	GUICtrlSetState($chkConfirmDelete, $GUI_UNCHECKED)
	GUICtrlSetState($cmdDelete, $GUI_DISABLE)

EndFunc

Func frmDeletePartition_WndProc()

	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUISetState(@SW_ENABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_HIDE, $afrmDeletePartition[0][1])
	Case $msg[0] = _GetCtrl("$chkConfirmDelete", $afrmDeletePartition)
		frmDeletePartition_chkConfirmDelete_Click()
	Case $msg[0] = _GetCtrl("$cmdDelete", $afrmDeletePartition)
		frmDeletePartition_cmdDelete_Click()
	Case $msg[0] = _GetCtrl("$cmdCancel", $afrmDeletePartition)
		$msg[0] = $GUI_EVENT_CLOSE
		frmDeletePartition_WndProc()
	EndSelect
EndFunc

Func frmDeletePartition_LoadIcons()
	If @compiled = 1 Then
		GUICtrlSetImage(_GetCtrl("$icoDelete", $afrmDeletePartition), @ScriptFullPath, 2)
	Else
		GUISetIcon("icons\0.ico", 0, $afrmDeletePartition[0][1])
		GUICtrlSetImage(_GetCtrl("$icoDelete", $afrmDeletePartition), "icons\2.ico", 0)
	EndIf
EndFunc

Func frmDeletePartition_chkConfirmDelete_Click()
	Local $chkConfirmDelete, $cmdDelete, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$chkConfirmDelete = _GetCtrl("$chkConfirmDelete", $afrmDeletePartition)
	$cmdDelete = _GetCtrl("$cmdDelete", $afrmDeletePartition)

	If GUICtrlRead($chkConfirmDelete) = $GUI_CHECKED Then
		GUICtrlSetState($cmdDelete, $GUI_ENABLE)
	ElseIf GUICtrlRead($chkConfirmDelete) = $GUI_UNCHECKED Then
		GUICtrlSetState($cmdDelete, $GUI_DISABLE)
	EndIf
EndFunc

Func frmDeletePartition_cmdDelete_Click()
	Local $iPartIndex
	Local $lvwPartitions, $stbStatus

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")

	$msg[0] = $GUI_EVENT_CLOSE
	frmDeletePartition_WndProc()

	ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
	frmDiskPart_ChangeControlState()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
	GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

	_DeletePartition($sCurrentDisk, $asPartitions[$iPartIndex][0], False, $stbStatus)

	frmSelectDisk_LoadDisks()
	frmDiskPart_LoadPartitions()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
EndFunc

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\DiskPartitioner\frmDeletePartition.au3>
; ----------------------------------------------------------------------------


; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-START: D:\AutoIt3\DiskPartitioner\frmEditPartition.au3>
; ----------------------------------------------------------------------------

Func CreateForm_frmEditPartition(ByRef $afrmNew, $frmParent)

	Dim $afrmNew[6][2]

	$afrmNew[0][0] = "$frmEditPartition"
	$afrmNew[0][1] = GUICreate("Edit Partition", 258, 144,  (@DesktopWidth - 0)/2, (@DesktopHeight - 274)/2, _
									BitOr($WS_CAPTION, $WS_SYSMENU, $WS_POPUP), -1, $frmParent)

	GUICtrlCreateLabel("Change Label:", 8, 16, 108, 13, $SS_RIGHT);, $WS_EX_STATICEDGE)
	$afrmNew[1][0] = "$txtPartLabel"
	$afrmNew[1][1] = GUICtrlCreateInput("", 124, 14, 125, 21)
	GUICtrlCreateLabel("Assign Drive Letter:", 8, 49, 108, 13, $SS_RIGHT)
	$afrmNew[2][0] = "$cboDriveLetter"
	$afrmNew[2][1] = GUICtrlCreateCombo("", 124, 47, 125, 21, BitOr($CBS_DROPDOWNLIST, $CBS_SORT, $WS_VSCROLL))
	$afrmNew[3][0] = "$chkActive"
	$afrmNew[3][1] = GUICtrlCreateCheckbox("Mark Partition as Active", 106, 80, 165, 17)
	$afrmNew[4][0] = "$cmdOK"
	$afrmNew[4][1] = GUICtrlCreateButton("&OK", 96, 112, 75, 25)
	$afrmNew[5][0] = "$cmdCancel"
	$afrmNew[5][1] = GUICtrlCreateButton("Cancel", 176, 112, 75, 25, $BS_DEFPUSHBUTTON)
EndFunc

Func frmEditPartition_Initialize()
	Local $iPartIndex
	Local $lvwPartitions, $cboDriveLetter, $chkActive, $chkInactive

	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)
	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	$cboDriveLetter = _GetCtrl("$cboDriveLetter", $afrmEditPartition)
	$chkActive = _GetCtrl("$chkActive", $afrmEditPartition)

	frmEditPartition_LoadIcons()

	If $asPartitions[$iPartIndex][1] = "Primary" Then
		If $asPartitions[$iPartIndex][13] = "No" Then
			GUICtrlSetState($chkActive, $GUI_UNCHECKED)
			GUICtrlSetState($chkActive, $GUI_ENABLE)
		Else
			GUICtrlSetState($chkActive, $GUI_CHECKED)
			GUICtrlSetState($chkActive, $GUI_DISABLE)
		EndIf
	Else
		GUICtrlSetState($chkActive, $GUI_DISABLE)
		GUICtrlSetState($chkActive, $GUI_UNCHECKED)
	EndIf

	GUICtrlSetData(_GetCtrl("$txtPartLabel", $afrmEditPartition), $asPartitions[$iPartIndex][6])

	frmEditPartition_LoadDriveLetters()
	If $asPartitions[$iPartIndex][5] <> "" Then
		GUICtrlSetData($cboDriveLetter, $asPartitions[$iPartIndex][5] & ":", $asPartitions[$iPartIndex][5] & ":")
	Else
		GUICtrlSendMsg($cboDriveLetter, $CB_SETCURSEL, 0, 0)
	EndIf

	GUICtrlSetState(_GetCtrl("$txtPartLabel", $afrmEditPartition), $GUI_FOCUS)

	frmEditPartition_LoadIcons()
EndFunc

Func frmEditPartition_WndProc()
	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUISetState(@SW_ENABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_HIDE, $afrmEditPartition[0][1])
	Case $msg[0] = _GetCtrl("$cmdOK", $afrmEditPartition)
		frmEditPartition_cmdOK_Click()
	Case $msg[0] = _GetCtrl("$cmdCancel", $afrmEditPartition)
		$msg[0] = $GUI_EVENT_CLOSE
		frmEditPartition_WndProc()
	EndSelect
EndFunc

Func frmEditPartition_LoadIcons()
	If @compiled = 1 Then
		; Do nothing
	Else
		GUISetIcon("icons\0.ico", 0, $afrmEditPartition[0][1])
	EndIf
EndFunc

Func frmEditPartition_cmdOK_Click()
	Local $iDiskNo, $iPartIndex
	Local $lvwPartitions, $stbStatus
	Local $sNewLabel, $sCurrLetter, $sNewLetter, $bMarkActive = False

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	$iPartIndex = ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "GetSelected")
	$sNewLabel = GUICtrlRead(_GetCtrl("$txtPartLabel", $afrmEditPartition))
	$sNewLetter = GUICtrlRead(_GetCtrl("$cboDriveLetter", $afrmEditPartition))

	; Close $frmEditPartition window
	$msg[0] = $GUI_EVENT_CLOSE
	frmEditPartition_WndProc()

	If $asPartitions[$iPartIndex][5] <> "" Then
		$sCurrLetter = $asPartitions[$iPartIndex][5] & ":"
	EndIf

	If $sNewLetter = "(None)" Then
		$sNewLetter = ""
	EndIf

	If GUICtrlRead(_GetCtrl("$chkActive", $afrmEditPartition)) = $GUI_CHECKED And _
		GUICtrlGetState(_GetCtrl("$chkActive", $afrmEditPartition)) <> 144 Then

		$bMarkActive = True
	EndIf

	ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
	frmDiskPart_ChangeControlState()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
	GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

	_EditPartition($sCurrentDisk, $asPartitions[$iPartIndex][0], $sCurrLetter, $sNewLetter, $sNewLabel, $bMarkActive, $stbStatus)

	frmSelectDisk_LoadDisks()
	frmDiskPart_LoadPartitions()

	GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
EndFunc

Func frmEditPartition_LoadDriveLetters()
	Local $sDriveLetters, $asDriveLetters, $asDrives
	Local $cboDriveLetter

	$cboDriveLetter = _GetCtrl("$cboDriveLetter", $afrmEditPartition)
	GUICtrlSetData($cboDriveLetter, "")	; Delete all items

	$sDriveLetters = "(None)|A:|B:|C:|D:|E:|F:|G:|H:|I:|J:|K:|L:|M:|N:|O:|P:|Q:|R:|S:|T:|U:|V:|W:|X:|Y:|Z:"
	$asDriveLetters = StringSplit($sDriveLetters, "|")
	$asDrives = DriveGetDrive("ALL")
	_ArraySort($asDrives, 0, 1)

	For $i = 1 to UBound($asDriveLetters, 1) - 1
		If _ArrayBinarySearch($asDrives, $asDriveLetters[$i], 1) = "" Then
			GUICtrlSetData($cboDriveLetter, $asDriveLetters[$i])
		EndIf
	Next

	GUICtrlSendMsg($cboDriveLetter, $CB_SETCURSEL, 0, 0)
EndFunc

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\DiskPartitioner\frmEditPartition.au3>
; ----------------------------------------------------------------------------


CreateForm_frmDiskPart($afrmDiskPart)
frmDiskPart_Initialize()

CreateForm_frmSelectDisk($afrmSelectDisk, $afrmDiskPart[0][1])
frmSelectDisk_Initialize()

CreateForm_frmCreatePartition($afrmCreatePartition, $afrmDiskPart[0][1])
CreateForm_frmDeletePartition($afrmDeletePartition, $afrmDiskPart[0][1])
CreateForm_frmEditPartition($afrmEditPartition, $afrmDiskPart[0][1])

GUISetState(@SW_SHOW, $afrmDiskPart[0][1])

frmSelectDisk_cmdRefresh_Click()
frmSelectDisk_cmdOK_Click(True)

While 1
	$msg = GuiGetMsg(1)

	; Prevent unnessary calls to _GetCtrl() by excluding $GUI_EVENT_MOUSEMOVE
	If $msg[0] <> $GUI_EVENT_MOUSEMOVE Then
		Select

		Case $msg[1] = $afrmDiskPart[0][1]
			frmDiskPart_WndProc()
		Case $msg[1] = $afrmSelectDisk[0][1]
			frmSelectDisk_WndProc()
		Case $msg[1] = $afrmCreatePartition[0][1]
			frmCreatePartition_WndProc()
		Case $msg[1] = $afrmDeletePartition[0][1]
			frmDeletePartition_WndProc()
		Case $msg[1] = $afrmEditPartition[0][1]
			frmEditPartition_WndProc()
		EndSelect
	EndIf
Wend

Func DiskPartitioner_WndProc()
	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUIDelete($afrmEditPartition[0][1])
		GUIDelete($afrmDeletePartition[0][1])
		GUIDelete($afrmCreatePartition[0][1])
		GUIDelete($afrmSelectDisk[0][1])
		GUIDelete($afrmDiskPart[0][1])
		Exit

	EndSelect
EndFunc

Func _GetCtrl($sCtrlName, $afrmArray)
	For $i = 0 to UBound($afrmArray, 1) - 1
		If $afrmArray[$i][0] = $sCtrlName Then
			Return $afrmArray[$i][1]
		EndIf
	Next

	; Error Handler
	If $i > UBound($afrmArray, 1) - 1 Then
		DiskPartitioner_ErrorHandler("Control reference invalid ", _
								"Control Name: " & $sCtrlName  & @CRLF & _
								"Form Name: " & $afrmArray[0][0], "Fatal")
		SetError(1)
	EndIf
EndFunc

; Application wide central message handler.
; Displays an error msg and exits the application if the error is fatal.
Func DiskPartitioner_ErrorHandler($sError, $sSolution, $sImpact)
	If $sImpact = "Non-Fatal" Then
		MsgBox(8256, "Disk Partitioner", $sError & @CRLF & @CRLF & $sSolution)
	ElseIf $sImpact = "Fatal" Then
		MsgBox(8240, "Disk Partitioner", $sError & @CRLF & @CRLF & $sSolution)
		$msg[0] = $GUI_EVENT_CLOSE
		DiskPartitioner_WndProc()
	EndIf
EndFunc

Func _ConvertToMB($sSize)
	If StringInStr($sSize, "MB") Then
		Return(Number($sSize))
	ElseIf StringInStr($sSize, "GB") Then
		Return(Number($sSize) * 1000)
	ElseIf StringInStr($sSize, "TB") Then
		Return(Number($sSize) * 1000 * 1000)
	Else
		Return 0
	EndIf
EndFunc

Func _CreateDiskPartProcess()
	Local $sOutput, $hPrDiskPart
	Local $iChoice

	If FileExists(@ScriptDir & "\DiskPart.exe") Or _
		FileExists(@SystemDir & "\DiskPart.exe") Then

		$hPrDiskPart = Run("DiskPart.exe", "", @SW_HIDE, $STDIN_CHILD + $STDOUT_CHILD)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)

			If Not(ProcessExists($hPrDiskPart)) Then
				$iChoice = MsgBox(5 + 64, "Disk Partitioner", "Disk Partitioner could not connect to the Disk Management services." & @CRLF & @CRLF & _
										"Click Retry to try connecting again or choose Cancel to abort.")
				If $iChoice = 4 Then
					$hPrDiskPart = Run("DiskPart.exe", "", @SW_HIDE, $STDIN_CHILD + $STDOUT_CHILD)
				Else
					$hPrDiskPart = 0
					ExitLoop
				EndIf
			EndIf
		Wend

		If $hPrDiskPart <> 0 Then
			; Remove the characters from the process stream
			$sOutput = StdoutRead($hPrDiskPart)
			If $DebugMode = True Then ConsoleWrite($sOutput)
		EndIf

		Return $hPrDiskPart
	Else
		MsgBox(8240, "Disk Partitioner", "One or more required files are missing." & @CRLF & @CRLF & _
					"Command-line DiskPart.exe is required to use this software." & @CRLF & _
					"Download the latest version of DiskPart.exe from Microsoft Download Center.")
		Exit
	EndIf
EndFunc

Func _RefreshDiskPartInfo($sDiskNo = "", $stbStatus = 0, $hPrDiskPart = 0)
	Local $sOutput, $bPrDiskpartExists = True

	GUICtrlSetData($stbStatus, "Refreshing Hard Disk(s) information, Please wait...")

	If $hPrDiskPart = 0 Then
		$bPrDiskpartExists = False
		$hPrDiskPart = _CreateDiskPartProcess()
	EndIf

	_GetDiskInfoBasic($hPrDiskPart)
	_GetDiskInfoExtended($hPrDiskPart)

	If $sDiskNo <> "" Then
		; Update global variable
		$sCurrentDisk = $sDiskNo

		GUICtrlSetData($stbStatus, "Refreshing Partition information for " & $sDiskNo & ", Please wait...")
		_GetPartInfoBasic($hPrDiskPart, $sDiskNo)
		_GetPartInfoExtended($hPrDiskPart, $sDiskNo)
	EndIf

	If $bPrDiskpartExists = False Then
		StdinWrite($hPrDiskPart)	; Close the DiskPart process
	EndIf

	GUICtrlSetData($stbStatus, "")
EndFunc

Func _GetDiskInfoBasic($hPrDiskPart)
	Local $sDiskList, $iPosDataStart, $iPosDataEnd
	Local $asDiskList, $asOffset[6]
	Local $sFormatted, $asDiskBasicInfo

	Dim $asDisks = 0	; Clear Disks array

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; List disk
	StdinWrite($hPrDiskPart, "List Disk" & @CRLF)
	If $DebugMode = True Then ConsoleWrite("List Disk" & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sDiskList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sDiskList)
	_CheckForDiskPartErrors($sDiskList)

	$iPosDataStart = StringInStr($sDiskList, "----")
;	$iPosDataEnd = StringInStr($sDiskList, @LF & @LF & "DISKPART> ")
	$iPosDataEnd = StringInStr($sDiskList, $sNewLine & "DISKPART> ")


	If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
		; Extract relevant data from $sDiskList
		$sDiskList = StringMid($sDiskList, $iPosDataStart, $iPosDataEnd - $iPosDataStart)
		$asDiskList = StringSplit($sDiskList, @LF)
 		For $i = 1 to UBound($asDiskList) - 1
			If StringLeft($asDiskList[$i], 1) = "*" Then
				$asDiskList[$i] = StringMid($asDiskList[$i], 2) ; Remove '*' in the beginning
			EndIf
 			$asDiskList[$i] = StringStripWS($asDiskList[$i], 3)
 		Next

		; Count the offset values
		$asOffset[0] = 1
		For $i = 1 to UBound($asOffset) - 1
			$asOffset[$i] = StringInStr($asDiskList[1], " -", 0, $i) + 1
		Next

		For $i = 2 to UBound($asDiskList) - 1
			$sFormatted = ""
			For $j = 1 to UBound($asOffset) - 1
				$sFormatted = $sFormatted & StringMid($asDiskList[$i], $asOffset[$j - 1], $asOffset[$j] - $asOffset[$j - 1]) & "|"
			Next
			$sFormatted = $sFormatted & StringMid($asDiskList[$i], $asOffset[$j - 1])
			$asDiskList[$i] = $sFormatted
		Next

		_ArrayDelete($asDiskList, 0)
		_ArrayDelete($asDiskList, 0)	; Repeat - $asDiskList[1] is now $asDiskList[0]
		;_ArrayDisplay($asDiskList, "")

		Dim $asDisks[UBound($asDiskList)][12]

		For $i = 0 to UBound($asDiskList) - 1
			$asDiskBasicInfo = StringSplit($asDiskList[$i], "|")
			For $j = 1 to UBound($asDiskBasicInfo) - 1
				$asDisks[$i][$j - 1] = StringStripWS($asDiskBasicInfo[$j], 3)
				;ConsoleWrite("$asDisks[" & $i & "][" & $j - 1 & "] = " & $asDisks[$i][$j - 1])
			Next
		Next
	EndIf

EndFunc

Func _GetDiskInfoExtended($hPrDiskPart)
	Local $sDiskList, $sDiskDetails, $iPosDataStart, $iPosDataEnd
	Local $asDiskInfoExtended

	If $asDisks = 0 Then
		Return
	EndIf

	For $i = 0 to UBound($asDisks, 1) - 1

		; Select disk
		StdinWrite($hPrDiskPart, "Select " & $asDisks[$i][0] & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Select " & $asDisks[$i][0] & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sDiskList = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sDiskList)
		_CheckForDiskPartErrors($sDiskList)

		; Detail disk
		StdinWrite($hPrDiskPart, "Detail Disk" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Detail Disk" & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sDiskList = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sDiskList)
		_CheckForDiskPartErrors($sDiskList)

		$iPosDataStart = 2
		$iPosDataEnd = StringInStr($sDiskList, "Volume #") - 4
		If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
			$sDiskList = StringMid($sDiskList, $iPosDataStart, $iPosDataEnd - $iPosDataStart)

			$asDiskInfoExtended = StringSplit($sDiskList, @LF)
			;_ArrayDisplay($asDiskInfoExtended, "")

			$asDisks[$i][6] = $asDiskInfoExtended[1]	; Model #
			$asDisks[$i][7] = StringMid($asDiskInfoExtended[2], 10)	; ID
			$asDisks[$i][8] = StringMid($asDiskInfoExtended[3], 10)	; Type
			$asDisks[$i][9] = StringMid($asDiskInfoExtended[4], 10)	; Bus
			$asDisks[$i][10] = StringMid($asDiskInfoExtended[5], 10)	; Target
			$asDisks[$i][11] = StringMid($asDiskInfoExtended[6], 10)	; LUN ID
		EndIf
	Next
EndFunc

Func _GetPartInfoBasic($hPrDiskPart, $sDiskNo)
	Local $sPartList, $iPosDataStart, $iPosDataEnd
	Local $asPartList, $asOffset[4]
	Local $sFormatted, $asPartBasicInfo

	Dim $asPartitions = 0 ; Clear Partitions array

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sPartList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sPartList)
	_CheckForDiskPartErrors($sPartList)

	; List partition
	StdinWrite($hPrDiskPart, "List Partition" & @CRLF)
	If $DebugMode = True Then ConsoleWrite("List Partition" & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sPartList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sPartList)
	_CheckForDiskPartErrors($sPartList)

	$iPosDataStart = StringInStr($sPartList, "----")
;	$iPosDataEnd = StringInStr($sPartList, @LF & @LF & "DISKPART> ")
	$iPosDataEnd = StringInStr($sPartList, $sNewLine & "DISKPART> ")


	If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
		; Extract relevant data from $sPartList
		$sPartList = StringMid($sPartList, $iPosDataStart, $iPosDataEnd - $iPosDataStart)
		$asPartList = StringSplit($sPartList, @LF)
 		For $i = 1 to UBound($asPartList) - 1
			If StringLeft($asPartList[$i], 1) = "*" Then
				$asPartList[$i] = StringMid($asPartList[$i], 2) ; Remove '*' in the beginning
			EndIf
 			$asPartList[$i] = StringStripWS($asPartList[$i], 3)
 		Next

		; Count the offset values
		$asOffset[0] = 1
		For $i = 1 to UBound($asOffset) - 1
			$asOffset[$i] = StringInStr($asPartList[1], " -", 0, $i) + 1
		Next

		For $i = 2 to UBound($asPartList) - 1
			$sFormatted = ""
			For $j = 1 to UBound($asOffset) - 1
				$sFormatted = $sFormatted & StringMid($asPartList[$i], $asOffset[$j - 1], $asOffset[$j] - $asOffset[$j - 1]) & "|"
			Next
			$sFormatted = $sFormatted & StringMid($asPartList[$i], $asOffset[$j - 1])
			$asPartList[$i] = $sFormatted
		Next

		_ArrayDelete($asPartList, 0)
		_ArrayDelete($asPartList, 0)	; Repeat - $asPartList[1] is now $asPartList[0]
		;_ArrayDisplay($asPartList, "")

		Dim $asPartitions[UBound($asPartList)][14]

		For $i = 0 to UBound($asPartList) - 1
			$asPartBasicInfo = StringSplit($asPartList[$i], "|")
			For $j = 1 to UBound($asPartBasicInfo) - 1
				$asPartitions[$i][$j - 1] = StringStripWS($asPartBasicInfo[$j], 3)

				;ConsoleWrite("$asPartitions[" & $i & "][" & $j - 1 & "] = " & $asPartitions[$i][$j - 1])
			Next
		Next
	EndIf
EndFunc

Func _GetPartInfoExtended($hPrDiskPart, $sDiskNo)
	Local $sPartList, $sPartDetails, $sPartInfo, $iPosDataStart, $iPosDataEnd
	Local $asPartList, $asOffset[8]
	Local $sFormatted, $asPartExtendedInfo

	If $asPartitions = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sPartList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sPartList)
	_CheckForDiskPartErrors($sPartList)

	For $i = 0 to UBound($asPartitions, 1) - 1

		; Select partition
		StdinWrite($hPrDiskPart, "Select " & $asPartitions[$i][0] & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Select " & $asPartitions[$i][0] & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sPartDetails = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sPartDetails)
		_CheckForDiskPartErrors($sPartDetails)

		; Detail partition
		StdinWrite($hPrDiskPart, "Detail Partition" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Detail Partition" & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sPartDetails = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sPartDetails)
		_CheckForDiskPartErrors($sPartDetails)

		$iPosDataStart = 1
		$iPosDataEnd = StringInStr($sPartDetails, "DISKPART> ")

		If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
			$sPartList = StringMid($sPartDetails, $iPosDataStart, $iPosDataEnd - $iPosDataStart)

			$iPosDataStart = StringInStr($sPartList, "Hidden:") + 7
			$asPartitions[$i][12] = StringStripWS(StringMid($sPartList, $iPosDataStart, 4), 3)
			$iPosDataStart = StringInStr($sPartList, "Active:") + 7
			$asPartitions[$i][13] = StringStripWS(StringMid($sPartList, $iPosDataStart, 4), 3)

			$iPosDataStart = StringInStr($sPartList, "----")
			If $iPosDataStart <> 0 Then
				; Extract relevant data from $sPartList
				$sPartList = StringMid($sPartList, $iPosDataStart)
				$asPartList = StringSplit($sPartList, @LF)
				For $j = 1 to UBound($asPartList) - 1
					If StringLeft($asPartList[$j], 1) = "*" Then
						$asPartList[$j] = StringMid($asPartList[$j], 2)	; Remove '*' in the beginning
					EndIf
					$asPartList[$j] = StringStripWS($asPartList[$j], 3)
				Next

				;_ArrayDisplay($asPartList, "")

				; Count the offset values
				$asOffset[0] = 1
				For $j = 1 to UBound($asOffset) - 1
					$asOffset[$j] = StringInStr($asPartList[1], " -", 0, $j) + 1
				Next

				;_ArrayDisplay($asOffset, "")

				For $j = 2 to UBound($asPartList) - 1
					$sFormatted = ""
					For $k = 1 to UBound($asOffset) - 1
						$sFormatted = $sFormatted & StringMid($asPartList[$j], $asOffset[$k - 1], $asOffset[$k] - $asOffset[$k - 1]) & "|"
					Next
					$sFormatted = $sFormatted & StringMid($asPartList[$j], $asOffset[$k - 1])
					$asPartList[$j] = $sFormatted
				Next

				;_ArrayDisplay($asPartList, "")

				$asPartExtendedInfo = StringSplit($asPartList[2], "|")
				;_ArrayDisplay($asPartExtendedInfo, "")

				For $j = 1 to UBound($asPartExtendedInfo) - 1
					$asPartitions[$i][$j + 3] = StringStripWS($asPartExtendedInfo[$j], 3)

					;ConsoleWrite("$asPartitions[" & $i & "][" & $j + 3 & "] = " & $asPartitions[$i][$j + 3])
				Next
			EndIf
		EndIf

		;ConsoleWrite("$asPartitions[" & $i & "][12] = " & $asPartitions[$i][12])
		;ConsoleWrite("$asPartitions[" & $i & "][13] = " & $asPartitions[$i][13])
	Next

EndFunc

Func _CreatePartition($sDiskNo, $sPartType, $iPartSize = -1, $sLetter = "", $stbStatus = 0)
	Local $sOutput
	Local $hPrDiskPart

	If $iPartSize = -1 Then
		GUICtrlSetData($stbStatus, "Creating " & $sPartType & " Partition of maximum remaining size on " & $sDiskNo & ", Please wait...")
	Else
		GUICtrlSetData($stbStatus, "Creating " & $sPartType & " Partition of " & $iPartSize & " MB on " & $sDiskNo & ", Please wait...")
	EndIf

	$hPrDiskPart = _CreateDiskPartProcess()

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Create partition
	If $iPartSize = -1 Then
		; Create partition of the specified type with max. size
		StdinWrite($hPrDiskPart, "Create Partition " & $sPartType & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Create Partition " & $sPartType & @CRLF)
	Else
		StdinWrite($hPrDiskPart, "Create Partition " & $sPartType & " Size=" & $iPartSize & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Create Partition " & $sPartType & " Size=" & $iPartSize & @CRLF)
	EndIf

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Assign drive letter
	If $sLetter <> "" Then
		StdinWrite($hPrDiskPart, "Assign Letter=" & $sLetter & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Assign Letter=" & $sLetter & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sOutput = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sOutput)
		_CheckForDiskPartErrors($sOutput)
	EndIf

	_RefreshDiskPartInfo($sDiskNo, $stbStatus, $hPrDiskPart)
	StdinWrite($hPrDiskPart)	; Close the DiskPart process

EndFunc

Func _DeletePartition($sDiskNo, $sPartNo, $bIsExtended = False, $stbStatus = 0)
	Local $sOutput
	Local $hPrDiskPart

	GUICtrlSetData($stbStatus, "Deleting " & $sPartNo & " on " & $sDiskNo & ", Please wait...")

	$hPrDiskPart = _CreateDiskPartProcess()

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Select partition
	StdinWrite($hPrDiskPart, "Select " & $sPartNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sPartNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Delete partition
	If $bIsExtended = True Then
		StdinWrite($hPrDiskPart, "Delete Partition Override" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Delete Partition Override" & @CRLF)
	Else
		StdinWrite($hPrDiskPart, "Delete Partition" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Delete Partition" & @CRLF)
	EndIf

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	_RefreshDiskPartInfo($sDiskNo, $stbStatus, $hPrDiskPart)
	StdinWrite($hPrDiskPart)	; Close the DiskPart process
EndFunc

Func _EditPartition($sDiskNo, $sPartNo, $sCurrLetter, $sNewLetter, $sLabel, $bMarkActive = False, $stbStatus = 0)
	Local $sOutput
	Local $hPrDiskPart

	GUICtrlSetData($stbStatus, "Modifying attributes of " & $sPartNo & " on " & $sDiskNo & ", Please wait...")

	; Set drive label
	If $sCurrLetter <> "" And $sNewLetter = "" Then
		DriveSetLabel($sCurrLetter, $sLabel)
	EndIf

	$hPrDiskPart = _CreateDiskPartProcess()

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Select partition
	StdinWrite($hPrDiskPart, "Select " & $sPartNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sPartNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Assign or remove drive letter
	If $sNewLetter <> $sCurrLetter Then
		If $sNewLetter = "" Then
			StdinWrite($hPrDiskPart, "Remove" & @CRLF)
			If $DebugMode = True Then ConsoleWrite("Remove" & @CRLF)
		Else
			StdinWrite($hPrDiskPart, "Assign Letter=" & $sNewLetter & @CRLF)
			If $DebugMode = True Then ConsoleWrite("Assign Letter=" & $sNewLetter & @CRLF)
		EndIf

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sOutput = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sOutput)
		_CheckForDiskPartErrors($sOutput)
	EndIf

	; Mark partition active
	If $bMarkActive = True Then
		StdinWrite($hPrDiskPart, "Active" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Active" & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sOutput = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sOutput)
		_CheckForDiskPartErrors($sOutput)
	EndIf

	; Set drive label
	If $sNewLetter <> "" Then
		DriveSetLabel($sNewLetter, $sLabel)
	EndIf

	_RefreshDiskPartInfo($sDiskNo, $stbStatus, $hPrDiskPart)
	StdinWrite($hPrDiskPart)	; Close the DiskPart process
EndFunc

; ----------------------------------------------------------------------------
; <AUT2EXE INCLUDE-END: D:\AutoIt3\DiskPartitioner\DiskPartitioner.au3>
; ----------------------------------------------------------------------------

