#include-once

Func CreateForm_frmCreatePartition(ByRef $afrmNew, $frmParent)

	Dim $afrmNew[14][2]

	$afrmNew[0][0] = "$frmCreatePartition"
	$afrmNew[0][1] = GUICreate("Create Partition", 409, 271, (@DesktopWidth - 200)/2, (@DesktopHeight - 271)/2, _
						BitOr($WS_CAPTION, $WS_POPUP), -1, $frmParent)
	$afrmNew[1][0] = "$grPartPie"
	$afrmNew[1][1] = GuiCtrlCreateGraphic(8, 8, 160, 140)
	$afrmNew[2][0] = "$grLegend"
	$afrmNew[2][1] = GUICtrlCreateGraphic(0, 140, 200, 60)

	GUICtrlCreateLabel("Allocated", 35, 154, 110, 20)
	$afrmNew[3][0] = "$lblAllocated"
	$afrmNew[3][1] = GUICtrlCreateLabel("", 150, 155, 30, 20)
	GUICtrlCreateLabel("Current Partition Size", 35, 184, 110, 20)
	$afrmNew[4][0] = "$lblCurrentSize"
	$afrmNew[4][1] = GUICtrlCreateLabel("", 150, 185, 30, 20)
	GUICtrlCreateLabel("Free Space", 35, 214, 110, 20)
	$afrmNew[5][0] = "$lblFreeSpace"
	$afrmNew[5][1] = GUICtrlCreateLabel("", 150, 215, 30, 20)

	GUICtrlCreateLabel("Partition Size (MB):", 188, 42, 100, 13, $SS_RIGHT)
	$afrmNew[6][0] = "$txtPartSize"
	$afrmNew[6][1] = GUICtrlCreateInput("0", 296, 39, 105, 22, $ES_NUMBER)
	$afrmNew[7][0] = "$udPartSize"
	$afrmNew[7][1] = GUICtrlCreateUpdown(_GetCtrl("$txtPartSize", $afrmNew), $UDS_NOTHOUSANDS)
	$afrmNew[8][0] = "$slPartSize"
	$afrmNew[8][1] = GUICtrlCreateSlider(184, 80, 225, 26, $TBS_NOTICKS)

	GUICtrlCreateLabel("0 MB", 191, 108, 25, 13)
	$afrmNew[9][0] = "$lblMaxPartSize"
	$afrmNew[9][1] = GUICtrlCreateLabel("", 340, 108, 60, 13, $SS_RIGHT);, $WS_EX_STATICEDGE)

	GUICtrlCreateLabel("Partition Type:", 188, 154, 100, 13, $SS_RIGHT)
	$afrmNew[10][0] = "$cboPartType"
	$afrmNew[10][1] = GUICtrlCreateCombo("", 296, 152, 105, 21, $CBS_DROPDOWNLIST)
	GUICtrlCreateLabel("Assign Drive Letter:", 188, 184, 100, 13, $SS_RIGHT)
	$afrmNew[11][0] = "$cboDriveLetter"
	$afrmNew[11][1] = GUICtrlCreateCombo("", 296, 182, 105, 21, BitOr($CBS_DROPDOWNLIST, $CBS_SORT, $WS_VSCROLL))

	$afrmNew[12][0] = "$cmdOK"
	$afrmNew[12][1] = GUICtrlCreateButton("&OK", 244, 238, 75, 25)
	$afrmNew[13][0] = "$cmdCancel"
	$afrmNew[13][1] = GUICtrlCreateButton("Cancel", 324, 238, 75, 25)

EndFunc

Func frmCreatePartition_Initialize()
	Local $cboPartType
	Local $iDiskIndex, $iMaxSize, $iFreeSpace, $iAllocated

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iFreeSpace = 0
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize - $iFreeSpace

	$cboPartType = _GetCtrl("$cboPartType", $afrmCreatePartition)

	; Initialize $cboPartTypes
	frmCreatePartition_LoadPartTypes()
	frmCreatePartition_cboPartType_Click()

	; Initialize $cboDriveLetter
	frmCreatePartition_LoadDriveLetters()

	; Update pie chart
	frmCreatePartition_CreatePieChart($iAllocated, $iMaxSize, $iFreeSpace)

	; Initialize other controls on form
	GUICtrlSetData(_GetCtrl("$lblMaxPartSize", $afrmCreatePartition), $iMaxSize & " MB")
	GUICtrlSetLimit(_GetCtrl("$slPartSize", $afrmCreatePartition), $iMaxSize, 0)
	GUICtrlSetData(_GetCtrl("$slPartSize", $afrmCreatePartition), $iMaxSize)

	GUICtrlSetLimit(_GetCtrl("$udPartSize", $afrmCreatePartition), $iMaxSize, 0)
	GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iMaxSize)

	; Load icons
	frmCreatePartition_LoadIcons()
EndFunc

Func frmCreatePartition_WndProc()

	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUISetState(@SW_ENABLE, $afrmDiskPart[0][1])
		GUISetState(@SW_HIDE, $afrmCreatePartition[0][1])
	Case $msg[0] = _GetCtrl("$slPartSize", $afrmCreatePartition)
		frmCreatePartition_slPartSize_Click()
	Case $msg[0] = _GetCtrl("$txtPartSize", $afrmCreatePartition)
		frmCreatePartition_txtPartSize_Click()
	Case $msg[0] = _GetCtrl("$cboPartType", $afrmCreatePartition)
		frmCreatePartition_cboPartType_Click()
	Case $msg[0] = _GetCtrl("$cmdOK", $afrmCreatePartition)
		frmCreatePartition_cmdOK_Click()
	Case $msg[0] = _GetCtrl("$cmdCancel", $afrmCreatePartition)
		$msg[0] = $GUI_EVENT_CLOSE
		frmCreatePartition_WndProc()

	EndSelect
EndFunc

Func frmCreatePartition_LoadIcons()
	If @compiled = 1 Then
		; Do nothing
	Else
		GUISetIcon("icons\0.ico", 0, $afrmCreatePartition[0][1])
	EndIf
EndFunc

Func frmCreatePartition_slPartSize_Click()
	Local $iDiskIndex
	Local $iCurrentSize, $iMaxSize, $iFreeSpace, $iAllocated

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize

	$iCurrentSize = GUICtrlRead(_GetCtrl("$slPartSize", $afrmCreatePartition))
	$iFreeSpace = $iMaxSize - $iCurrentSize

	GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iCurrentSize)

	; Update pie chart
	frmCreatePartition_CreatePieChart($iAllocated, $iCurrentSize, $iFreeSpace)
EndFunc

Func frmCreatePartition_txtPartSize_Click()
	Local $iDiskIndex, $iCurrentSize, $iMaxSize, $iFreeSpace, $iAllocated, $iError
	Local $msg2

	While $msg2 = 0 And $msg2 <> $GUI_EVENT_MOUSEMOVE
		$msg2 = GUIGetMsg()
	Wend

	If $msg2 = _GetCtrl("$cmdCancel", $afrmCreatePartition) Then
		$msg[0] = _GetCtrl("$cmdCancel", $afrmCreatePartition)
		frmCreatePartition_WndProc()
		Return
	EndIf

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize

	$iCurrentSize = GUICtrlRead(_GetCtrl("$txtPartSize", $afrmCreatePartition))
	If $iCurrentSize > $iMaxSize Then
		DiskPartitioner_ErrorHandler("Partition size value out of range.", _
									"Specify a value less than or equal to " & $iMaxSize & " MB.", "Non-Fatal")
		$iCurrentSize = $iMaxSize
		GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iCurrentSize)
		$iError = 1
	EndIf
	$iFreeSpace = $iMaxSize - $iCurrentSize
	GUICtrlSetData(_GetCtrl("$slPartSize", $afrmCreatePartition), $iCurrentSize)

	; Update pie chart
	frmCreatePartition_CreatePieChart($iAllocated, $iCurrentSize, $iFreeSpace)

	If $msg2 = _GetCtrl("$cmdOK", $afrmCreatePartition) And $iError = 0 Then
		$msg[0] = $msg2
		frmCreatePartition_WndProc()
	EndIf

	SetError($iError)
EndFunc

Func frmCreatePartition_cboPartType_Click()
	Local $sPartType, $iDiskIndex
	Local $iMaxSize, $iFreeSpace, $iAllocated

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])
	$iFreeSpace = 0
	$iAllocated = _ConvertToMB($asDisks[$iDiskIndex][2]) - $iMaxSize

	$sPartType = GUICtrlRead(_GetCtrl("$cboPartType", $afrmCreatePartition))

	If $sPartType = "Extended" Then
		GUICtrlSetData(_GetCtrl("$slPartSize", $afrmCreatePartition), $iMaxSize)
		GUICtrlSetData(_GetCtrl("$txtPartSize", $afrmCreatePartition), $iMaxSize)
		GUICtrlSetData(_GetCtrl("$cboDriveLetter", $afrmCreatePartition), "(None)")

		GUICtrlSetState(_GetCtrl("$slPartSize", $afrmCreatePartition), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$udPartSize", $afrmCreatePartition), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$txtPartSize", $afrmCreatePartition), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cboDriveLetter", $afrmCreatePartition), $GUI_DISABLE)

		; Update pie chart
		frmCreatePartition_CreatePieChart($iAllocated, $iMaxSize, $iFreeSpace)
	Else
		GUICtrlSetState(_GetCtrl("$slPartSize", $afrmCreatePartition), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$udPartSize", $afrmCreatePartition), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$txtPartSize", $afrmCreatePartition), $GUI_ENABLE)
		GUICtrlSetState(_GetCtrl("$cboDriveLetter", $afrmCreatePartition), $GUI_ENABLE)
	EndIf

EndFunc

Func frmCreatePartition_cmdOK_Click()
	Local $sPartType, $sDriveLetter
	Local $iMaxSize, $iPartSize, $iDiskIndex
	Local $stbStatus, $lvwPartitions

	$stbStatus = _GetCtrl("$stbStatus", $afrmDiskPart)
	$lvwPartitions = _GetCtrl("$lvwPartitions", $afrmDiskPart)

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next
	$iMaxSize = _ConvertToMB($asDisks[$iDiskIndex][3])

	; Refresh partition size value
	frmCreatePartition_txtPartSize_Click()
	If @error Then
		; Invalid value in partition size
		Return
	Else
		$iPartSize = GUICtrlRead(_GetCtrl("$txtPartSize", $afrmCreatePartition))
		$sPartType = GUICtrlRead(_GetCtrl("$cboPartType", $afrmCreatePartition))
		$sDriveLetter = GUICtrlRead(_GetCtrl("$cboDriveLetter", $afrmCreatePartition))
		If $sDriveLetter = "(None)" Then $sDriveLetter = ""

		$msg[0] = $GUI_EVENT_CLOSE
		frmCreatePartition_WndProc()

		ControlListView($afrmDiskPart[0][1], "", $lvwPartitions, "SelectClear")
		frmDiskPart_ChangeControlState()

		GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_DISABLE)
		GUICtrlSetState(_GetCtrl("$cmdAdd", $afrmDiskPart), $GUI_DISABLE)

		If $iPartSize = $iMaxSize Then
			_CreatePartition($sCurrentDisk, $sPartType, -1, $sDriveLetter, $stbStatus)
		Else
			_CreatePartition($sCurrentDisk, $sPartType, $iPartSize, $sDriveLetter, $stbStatus)
		EndIf

		frmSelectDisk_LoadDisks()
		frmDiskPart_LoadPartitions()

		GUICtrlSetState(_GetCtrl("$cmdRefresh", $afrmDiskPart), $GUI_ENABLE)
	EndIf
EndFunc

Func frmCreatePartition_LoadPartTypes()
	Local $iDiskIndex, $cboPartType
	Local $bExtendedPresent = 0

	$cboPartType = _GetCtrl("$cboPartType", $afrmCreatePartition)

	For $i = 0 to Ubound($asDisks, 1) - 1
		If $asDisks[$i][0] = $sCurrentDisk Then
			$iDiskIndex = $i
			ExitLoop
		EndIf
	Next

	GUICtrlSetData($cboPartType, "")	; Delete all items

	For $i = 0 to UBound($asPartitions, 1) - 1
		If $asPartitions[$i][1] = "Extended" Then
			$bExtendedPresent = True
			ExitLoop
		EndIf
	Next

	If $bExtendedPresent = False Then
		GUICtrlSetData($cboPartType, "Primary|Extended")
	ElseIf $bExtendedPresent = True Then
		GUICtrlSetData($cboPartType, "Logical")
	EndIf

	GUICtrlSendMsg($cboPartType, $CB_SETCURSEL, 0, 0)
EndFunc

Func frmCreatePartition_LoadDriveLetters()
	Local $sDriveLetters, $asDriveLetters, $asDrives
	Local $cboDriveLetter

	$cboDriveLetter = _GetCtrl("$cboDriveLetter", $afrmCreatePartition)
	GUICtrlSetData($cboDriveLetter, "")	; Delete all items

	$sDriveLetters = "(None)|A:|B:|C:|D:|E:|F:|G:|H:|I:|J:|K:|L:|M:|N:|O:|P:|Q:|R:|S:|T:|U:|V:|W:|X:|Y:|Z:"
	$asDriveLetters = StringSplit($sDriveLetters, "|")
	$asDrives = DriveGetDrive("ALL")
	_ArraySort($asDrives, 0, 1)

	For $i = 1 to UBound($asDriveLetters, 1) - 1
		If _ArrayBinarySearch($asDrives, $asDriveLetters[$i], 1) = "" Then
			GUICtrlSetData($cboDriveLetter, $asDriveLetters[$i])
		EndIf
	Next

	GUICtrlSendMsg($cboDriveLetter, $CB_SETCURSEL, 0, 0)
EndFunc

Func frmCreatePartition_CreatePieChart($iAllocated, $iCurrentSize, $iFreeSpace)
	Local $iTotalTests, $iPerAllocated, $iDegAllocated
	Local $iPerCurSize, $iDegCurSize, $iPerFreeSpace, $iDegFreeSpace
	Local $iColorAllocated, $iColorCurSize, $iColorFreeSpace
	Local $hgrCtrlPie, $hgrCtrlLegend

	$hgrCtrlPie = _GetCtrl("$grPartPie", $afrmCreatePartition)
	$hgrCtrlLegend = _GetCtrl("$grLegend", $afrmCreatePartition)

	;$iColorAllocated = 0x787878	; Black
	$iColorAllocated = 0xB0B4FB
	;$iColorCurSize = 0xBEBEBE		; Grey
	$iColorCurSize = 0x8F8FF5
	$iColorFreeSpace = 0xFFFFFF	; White

	;===== The following functions calculate Percentages and Degrees =====
	$iTotalTests = $iAllocated + $iCurrentSize + $iFreeSpace

	$iPerAllocated = $iAllocated / $iTotalTests
	$iDegAllocated =  $iPerAllocated * 360

	$iPerCurSize = $iCurrentSize / $iTotalTests
	$iDegCurSize =  $iPerCurSize * 360

	$iPerFreeSpace = $iFreeSpace / $iTotalTests
	$iDegFreeSpace = $iPerFreeSpace * 360
	;=====================================================================

	;=== This section will create the Pie Chart ==========================
	;Passed Pie section
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_COLOR, 0x000000, $iColorAllocated)
	;Set the Pie chart piece Starts at 90^ and sweeps for $iDegAllocated number of ^
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_PIE, 75, 70, 60, 90, $iDegAllocated)
	;Failed Pie section
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_COLOR, 0x000000, $iColorCurSize)
	;Set the Pie chart Piece Starts at 90^ + total ^ of $iDegAllocated
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_PIE, 75, 70, 60, 90 + $iDegAllocated, $iDegCurSize)
	;Warnings Pie Section
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_COLOR, 0x000000, $iColorFreeSpace)
	;Set the Pie Chart Piece Start at 90^ + Total ^ of $iDegAllocated and $iDegCurSize
	GUICtrlSetGraphic($hgrCtrlPie, $GUI_GR_PIE, 75, 70, 60, 90 + $iDegAllocated + $iDegCurSize, $iDegFreeSpace)

	;=== This section creates the Legend =============================

	;Allocated Legend
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_PENSIZE, 5);Makes the Dot bigger so you can see the color
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_COLOR, $iColorAllocated, $iColorAllocated)
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_DOT, 20, 20)
	;Calculates the total percentage to display
	GUICtrlSetData(_GetCtrl("$lblAllocated", $afrmCreatePartition), Round($iPerAllocated * 100, 0) & "%")

	;Current Partition Size Legend
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_PENSIZE, 5);Makes the Dot bigger so you can see the color
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_COLOR, $iColorCurSize, $iColorCurSize)
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_DOT, 20, 50)
	;Calculates the total percentage to display
	GUICtrlSetData(_GetCtrl("$lblCurrentSize", $afrmCreatePartition), Round($iPerCurSize * 100, 0) & "%")
	;Free Space Legend
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_PENSIZE, 5);Makes the Dot bigger so you can see the color
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_COLOR, $iColorFreeSpace, $iColorFreeSpace)
	GUICtrlSetGraphic($hgrCtrlLegend, $GUI_GR_DOT, 20, 80)
	;Calculates the total percentage to display
	GUICtrlSetData(_GetCtrl("$lblFreeSpace", $afrmCreatePartition), Round($iPerFreeSpace * 100, 0) & "%")

	;Refresh Graphics
	GUICtrlSetState($hgrCtrlPie, $GUI_DISABLE)
	GUICtrlSetState($hgrCtrlPie, $GUI_ENABLE)
	GUICtrlSetState($hgrCtrlLegend, $GUI_DISABLE)
	GUICtrlSetState($hgrCtrlLegend, $GUI_ENABLE)
EndFunc

