#include-once

#Region - Compiler Directives

#Compiler_Prompt = n
#Compiler_AUT2EXE = Icons\Aut2Exe.exe
#Compiler_Icon = Icons\0.ico
#Compiler_Compression = 0
#Compiler_Allow_Decompile = n
#Compiler_PassPhrase =
#Compiler_Res_Fileversion = 1.5.0.0
#Compiler_Res_Description = Disk Partitioner
#Compiler_Res_LegalCopyright = tonedeaf
#Compiler_Res_Comment = Front-end for DISKPART.EXE
#Compiler_Res_Field1Name = Platform
#Compiler_Res_Field1Value = NT
#Compiler_Res_Field2Name = Autoit version
#Compiler_res_Field2Value = 3.1.1.106(beta)
#Compiler_Run_AU3Check = y
#Compiler_Run_Before =
#Compiler_Run_After =

#EndRegion

Opt("MustDeclareVars", 1)	; Variables must be pre-declared
Opt("GUICloseOnEsc", 0)
Opt("TrayIconHide", 1)	; Hide the AutoIt tray icon
Opt("WinWaitDelay", 10)

; Flags declarations
;If Not IsDeclared("CB_SETCURSEL") Then Global Const $CB_SETCURSEL = 0x14E

; Global variable declarations
Global $msg	; application wide message variable
Global $DebugMode = False	; Set to TRUE to echo all communication with Diskpart.exe

Global $afrmDiskPart
Global $afrmSelectDisk
Global $afrmCreatePartition
Global $afrmDeletePartition
Global $afrmEditPartition

; Global variables
Global $asDisks
Global $asPartitions

Global $sCurrentDisk

; Deal with difference in output from Diskpart in XP and Vista
Global $sNewLine
If (@OSBuild >= 6000) Then
	$sNewLine = @CRLF & @CRLF
Else
	$sNewLine = @LF & @LF
EndIf


#include <Constants.au3>


#include <GUIConstants.au3>


#include <GUIListView.au3>


#include <Array.au3>



#include <AutoIt3\DiskPartitioner\DiskPartErrors.au3>


#include <AutoIt3\DiskPartitioner\frmDiskPart.au3>


#include <AutoIt3\DiskPartitioner\frmSelectDisk.au3>


#include <AutoIt3\DiskPartitioner\frmCreatePartition.au3>


#include <AutoIt3\DiskPartitioner\frmDeletePartition.au3>


#include <AutoIt3\DiskPartitioner\frmEditPartition.au3>


CreateForm_frmDiskPart($afrmDiskPart)
frmDiskPart_Initialize()

CreateForm_frmSelectDisk($afrmSelectDisk, $afrmDiskPart[0][1])
frmSelectDisk_Initialize()

CreateForm_frmCreatePartition($afrmCreatePartition, $afrmDiskPart[0][1])
CreateForm_frmDeletePartition($afrmDeletePartition, $afrmDiskPart[0][1])
CreateForm_frmEditPartition($afrmEditPartition, $afrmDiskPart[0][1])

GUISetState(@SW_SHOW, $afrmDiskPart[0][1])

frmSelectDisk_cmdRefresh_Click()
frmSelectDisk_cmdOK_Click(True)

While 1
	$msg = GuiGetMsg(1)

	; Prevent unnessary calls to _GetCtrl() by excluding $GUI_EVENT_MOUSEMOVE
	If $msg[0] <> $GUI_EVENT_MOUSEMOVE Then
		Select

		Case $msg[1] = $afrmDiskPart[0][1]
			frmDiskPart_WndProc()
		Case $msg[1] = $afrmSelectDisk[0][1]
			frmSelectDisk_WndProc()
		Case $msg[1] = $afrmCreatePartition[0][1]
			frmCreatePartition_WndProc()
		Case $msg[1] = $afrmDeletePartition[0][1]
			frmDeletePartition_WndProc()
		Case $msg[1] = $afrmEditPartition[0][1]
			frmEditPartition_WndProc()
		EndSelect
	EndIf
Wend

Func DiskPartitioner_WndProc()
	Select

	Case $msg[0] = $GUI_EVENT_CLOSE
		GUIDelete($afrmEditPartition[0][1])
		GUIDelete($afrmDeletePartition[0][1])
		GUIDelete($afrmCreatePartition[0][1])
		GUIDelete($afrmSelectDisk[0][1])
		GUIDelete($afrmDiskPart[0][1])
		Exit

	EndSelect
EndFunc

Func _GetCtrl($sCtrlName, $afrmArray)
	For $i = 0 to UBound($afrmArray, 1) - 1
		If $afrmArray[$i][0] = $sCtrlName Then
			Return $afrmArray[$i][1]
		EndIf
	Next

	; Error Handler
	If $i > UBound($afrmArray, 1) - 1 Then
		DiskPartitioner_ErrorHandler("Control reference invalid ", _
								"Control Name: " & $sCtrlName  & @CRLF & _
								"Form Name: " & $afrmArray[0][0], "Fatal")
		SetError(1)
	EndIf
EndFunc

; Application wide central message handler.
; Displays an error msg and exits the application if the error is fatal.
Func DiskPartitioner_ErrorHandler($sError, $sSolution, $sImpact)
	If $sImpact = "Non-Fatal" Then
		MsgBox(8256, "Disk Partitioner", $sError & @CRLF & @CRLF & $sSolution)
	ElseIf $sImpact = "Fatal" Then
		MsgBox(8240, "Disk Partitioner", $sError & @CRLF & @CRLF & $sSolution)
		$msg[0] = $GUI_EVENT_CLOSE
		DiskPartitioner_WndProc()
	EndIf
EndFunc

Func _ConvertToMB($sSize)
	If StringInStr($sSize, "MB") Then
		Return(Number($sSize))
	ElseIf StringInStr($sSize, "GB") Then
		Return(Number($sSize) * 1000)
	ElseIf StringInStr($sSize, "TB") Then
		Return(Number($sSize) * 1000 * 1000)
	Else
		Return 0
	EndIf
EndFunc

Func _CreateDiskPartProcess()
	Local $sOutput, $hPrDiskPart
	Local $iChoice

	If FileExists(@ScriptDir & "\DiskPart.exe") Or _
		FileExists(@SystemDir & "\DiskPart.exe") Then

		$hPrDiskPart = Run("DiskPart.exe", "", @SW_HIDE, $STDIN_CHILD + $STDOUT_CHILD)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)

			If Not(ProcessExists($hPrDiskPart)) Then
				$iChoice = MsgBox(5 + 64, "Disk Partitioner", "Disk Partitioner could not connect to the Disk Management services." & @CRLF & @CRLF & _
										"Click Retry to try connecting again or choose Cancel to abort.")
				If $iChoice = 4 Then
					$hPrDiskPart = Run("DiskPart.exe", "", @SW_HIDE, $STDIN_CHILD + $STDOUT_CHILD)
				Else
					$hPrDiskPart = 0
					ExitLoop
				EndIf
			EndIf
		Wend

		If $hPrDiskPart <> 0 Then
			; Remove the characters from the process stream
			$sOutput = StdoutRead($hPrDiskPart)
			If $DebugMode = True Then ConsoleWrite($sOutput)
		EndIf

		Return $hPrDiskPart
	Else
		MsgBox(8240, "Disk Partitioner", "One or more required files are missing." & @CRLF & @CRLF & _
					"Command-line DiskPart.exe is required to use this software." & @CRLF & _
					"Download the latest version of DiskPart.exe from Microsoft Download Center.")
		Exit
	EndIf
EndFunc

Func _RefreshDiskPartInfo($sDiskNo = "", $stbStatus = 0, $hPrDiskPart = 0)
	Local $sOutput, $bPrDiskpartExists = True

	GUICtrlSetData($stbStatus, "Refreshing Hard Disk(s) information, Please wait...")

	If $hPrDiskPart = 0 Then
		$bPrDiskpartExists = False
		$hPrDiskPart = _CreateDiskPartProcess()
	EndIf

	_GetDiskInfoBasic($hPrDiskPart)
	_GetDiskInfoExtended($hPrDiskPart)

	If $sDiskNo <> "" Then
		; Update global variable
		$sCurrentDisk = $sDiskNo

		GUICtrlSetData($stbStatus, "Refreshing Partition information for " & $sDiskNo & ", Please wait...")
		_GetPartInfoBasic($hPrDiskPart, $sDiskNo)
		_GetPartInfoExtended($hPrDiskPart, $sDiskNo)
	EndIf

	If $bPrDiskpartExists = False Then
		StdinWrite($hPrDiskPart)	; Close the DiskPart process
	EndIf

	GUICtrlSetData($stbStatus, "")
EndFunc

Func _GetDiskInfoBasic($hPrDiskPart)
	Local $sDiskList, $iPosDataStart, $iPosDataEnd
	Local $asDiskList, $asOffset[6]
	Local $sFormatted, $asDiskBasicInfo

	Dim $asDisks = 0	; Clear Disks array

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; List disk
	StdinWrite($hPrDiskPart, "List Disk" & @CRLF)
	If $DebugMode = True Then ConsoleWrite("List Disk" & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sDiskList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sDiskList)
	_CheckForDiskPartErrors($sDiskList)

	$iPosDataStart = StringInStr($sDiskList, "----")
;	$iPosDataEnd = StringInStr($sDiskList, @LF & @LF & "DISKPART> ")
	$iPosDataEnd = StringInStr($sDiskList, $sNewLine & "DISKPART> ")


	If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
		; Extract relevant data from $sDiskList
		$sDiskList = StringMid($sDiskList, $iPosDataStart, $iPosDataEnd - $iPosDataStart)
		$asDiskList = StringSplit($sDiskList, @LF)
 		For $i = 1 to UBound($asDiskList) - 1
			If StringLeft($asDiskList[$i], 1) = "*" Then
				$asDiskList[$i] = StringMid($asDiskList[$i], 2) ; Remove '*' in the beginning
			EndIf
 			$asDiskList[$i] = StringStripWS($asDiskList[$i], 3)
 		Next

		; Count the offset values
		$asOffset[0] = 1
		For $i = 1 to UBound($asOffset) - 1
			$asOffset[$i] = StringInStr($asDiskList[1], " -", 0, $i) + 1
		Next

		For $i = 2 to UBound($asDiskList) - 1
			$sFormatted = ""
			For $j = 1 to UBound($asOffset) - 1
				$sFormatted = $sFormatted & StringMid($asDiskList[$i], $asOffset[$j - 1], $asOffset[$j] - $asOffset[$j - 1]) & "|"
			Next
			$sFormatted = $sFormatted & StringMid($asDiskList[$i], $asOffset[$j - 1])
			$asDiskList[$i] = $sFormatted
		Next

		_ArrayDelete($asDiskList, 0)
		_ArrayDelete($asDiskList, 0)	; Repeat - $asDiskList[1] is now $asDiskList[0]
		;_ArrayDisplay($asDiskList, "")

		Dim $asDisks[UBound($asDiskList)][12]

		For $i = 0 to UBound($asDiskList) - 1
			$asDiskBasicInfo = StringSplit($asDiskList[$i], "|")
			For $j = 1 to UBound($asDiskBasicInfo) - 1
				$asDisks[$i][$j - 1] = StringStripWS($asDiskBasicInfo[$j], 3)
				;ConsoleWrite("$asDisks[" & $i & "][" & $j - 1 & "] = " & $asDisks[$i][$j - 1])
			Next
		Next
	EndIf

EndFunc

Func _GetDiskInfoExtended($hPrDiskPart)
	Local $sDiskList, $sDiskDetails, $iPosDataStart, $iPosDataEnd
	Local $asDiskInfoExtended

	If $asDisks = 0 Then
		Return
	EndIf

	For $i = 0 to UBound($asDisks, 1) - 1

		; Select disk
		StdinWrite($hPrDiskPart, "Select " & $asDisks[$i][0] & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Select " & $asDisks[$i][0] & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sDiskList = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sDiskList)
		_CheckForDiskPartErrors($sDiskList)

		; Detail disk
		StdinWrite($hPrDiskPart, "Detail Disk" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Detail Disk" & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sDiskList = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sDiskList)
		_CheckForDiskPartErrors($sDiskList)

		$iPosDataStart = 2
		$iPosDataEnd = StringInStr($sDiskList, "Volume #") - 4
		If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
			$sDiskList = StringMid($sDiskList, $iPosDataStart, $iPosDataEnd - $iPosDataStart)

			$asDiskInfoExtended = StringSplit($sDiskList, @LF)
			;_ArrayDisplay($asDiskInfoExtended, "")

			$asDisks[$i][6] = $asDiskInfoExtended[1]	; Model #
			$asDisks[$i][7] = StringMid($asDiskInfoExtended[2], 10)	; ID
			$asDisks[$i][8] = StringMid($asDiskInfoExtended[3], 10)	; Type
			$asDisks[$i][9] = StringMid($asDiskInfoExtended[4], 10)	; Bus
			$asDisks[$i][10] = StringMid($asDiskInfoExtended[5], 10)	; Target
			$asDisks[$i][11] = StringMid($asDiskInfoExtended[6], 10)	; LUN ID
		EndIf
	Next
EndFunc

Func _GetPartInfoBasic($hPrDiskPart, $sDiskNo)
	Local $sPartList, $iPosDataStart, $iPosDataEnd
	Local $asPartList, $asOffset[4]
	Local $sFormatted, $asPartBasicInfo

	Dim $asPartitions = 0 ; Clear Partitions array

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sPartList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sPartList)
	_CheckForDiskPartErrors($sPartList)

	; List partition
	StdinWrite($hPrDiskPart, "List Partition" & @CRLF)
	If $DebugMode = True Then ConsoleWrite("List Partition" & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sPartList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sPartList)
	_CheckForDiskPartErrors($sPartList)

	$iPosDataStart = StringInStr($sPartList, "----")
;	$iPosDataEnd = StringInStr($sPartList, @LF & @LF & "DISKPART> ")
	$iPosDataEnd = StringInStr($sPartList, $sNewLine & "DISKPART> ")


	If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
		; Extract relevant data from $sPartList
		$sPartList = StringMid($sPartList, $iPosDataStart, $iPosDataEnd - $iPosDataStart)
		$asPartList = StringSplit($sPartList, @LF)
 		For $i = 1 to UBound($asPartList) - 1
			If StringLeft($asPartList[$i], 1) = "*" Then
				$asPartList[$i] = StringMid($asPartList[$i], 2) ; Remove '*' in the beginning
			EndIf
 			$asPartList[$i] = StringStripWS($asPartList[$i], 3)
 		Next

		; Count the offset values
		$asOffset[0] = 1
		For $i = 1 to UBound($asOffset) - 1
			$asOffset[$i] = StringInStr($asPartList[1], " -", 0, $i) + 1
		Next

		For $i = 2 to UBound($asPartList) - 1
			$sFormatted = ""
			For $j = 1 to UBound($asOffset) - 1
				$sFormatted = $sFormatted & StringMid($asPartList[$i], $asOffset[$j - 1], $asOffset[$j] - $asOffset[$j - 1]) & "|"
			Next
			$sFormatted = $sFormatted & StringMid($asPartList[$i], $asOffset[$j - 1])
			$asPartList[$i] = $sFormatted
		Next

		_ArrayDelete($asPartList, 0)
		_ArrayDelete($asPartList, 0)	; Repeat - $asPartList[1] is now $asPartList[0]
		;_ArrayDisplay($asPartList, "")

		Dim $asPartitions[UBound($asPartList)][14]

		For $i = 0 to UBound($asPartList) - 1
			$asPartBasicInfo = StringSplit($asPartList[$i], "|")
			For $j = 1 to UBound($asPartBasicInfo) - 1
				$asPartitions[$i][$j - 1] = StringStripWS($asPartBasicInfo[$j], 3)

				;ConsoleWrite("$asPartitions[" & $i & "][" & $j - 1 & "] = " & $asPartitions[$i][$j - 1])
			Next
		Next
	EndIf
EndFunc

Func _GetPartInfoExtended($hPrDiskPart, $sDiskNo)
	Local $sPartList, $sPartDetails, $sPartInfo, $iPosDataStart, $iPosDataEnd
	Local $asPartList, $asOffset[8]
	Local $sFormatted, $asPartExtendedInfo

	If $asPartitions = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sPartList = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sPartList)
	_CheckForDiskPartErrors($sPartList)

	For $i = 0 to UBound($asPartitions, 1) - 1

		; Select partition
		StdinWrite($hPrDiskPart, "Select " & $asPartitions[$i][0] & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Select " & $asPartitions[$i][0] & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sPartDetails = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sPartDetails)
		_CheckForDiskPartErrors($sPartDetails)

		; Detail partition
		StdinWrite($hPrDiskPart, "Detail Partition" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Detail Partition" & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sPartDetails = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sPartDetails)
		_CheckForDiskPartErrors($sPartDetails)

		$iPosDataStart = 1
		$iPosDataEnd = StringInStr($sPartDetails, "DISKPART> ")

		If $iPosDataStart <> 0 And $iPosDataEnd <> 0 Then
			$sPartList = StringMid($sPartDetails, $iPosDataStart, $iPosDataEnd - $iPosDataStart)

			$iPosDataStart = StringInStr($sPartList, "Hidden:") + 7
			$asPartitions[$i][12] = StringStripWS(StringMid($sPartList, $iPosDataStart, 4), 3)
			$iPosDataStart = StringInStr($sPartList, "Active:") + 7
			$asPartitions[$i][13] = StringStripWS(StringMid($sPartList, $iPosDataStart, 4), 3)

			$iPosDataStart = StringInStr($sPartList, "----")
			If $iPosDataStart <> 0 Then
				; Extract relevant data from $sPartList
				$sPartList = StringMid($sPartList, $iPosDataStart)
				$asPartList = StringSplit($sPartList, @LF)
				For $j = 1 to UBound($asPartList) - 1
					If StringLeft($asPartList[$j], 1) = "*" Then
						$asPartList[$j] = StringMid($asPartList[$j], 2)	; Remove '*' in the beginning
					EndIf
					$asPartList[$j] = StringStripWS($asPartList[$j], 3)
				Next

				;_ArrayDisplay($asPartList, "")

				; Count the offset values
				$asOffset[0] = 1
				For $j = 1 to UBound($asOffset) - 1
					$asOffset[$j] = StringInStr($asPartList[1], " -", 0, $j) + 1
				Next

				;_ArrayDisplay($asOffset, "")

				For $j = 2 to UBound($asPartList) - 1
					$sFormatted = ""
					For $k = 1 to UBound($asOffset) - 1
						$sFormatted = $sFormatted & StringMid($asPartList[$j], $asOffset[$k - 1], $asOffset[$k] - $asOffset[$k - 1]) & "|"
					Next
					$sFormatted = $sFormatted & StringMid($asPartList[$j], $asOffset[$k - 1])
					$asPartList[$j] = $sFormatted
				Next

				;_ArrayDisplay($asPartList, "")

				$asPartExtendedInfo = StringSplit($asPartList[2], "|")
				;_ArrayDisplay($asPartExtendedInfo, "")

				For $j = 1 to UBound($asPartExtendedInfo) - 1
					$asPartitions[$i][$j + 3] = StringStripWS($asPartExtendedInfo[$j], 3)

					;ConsoleWrite("$asPartitions[" & $i & "][" & $j + 3 & "] = " & $asPartitions[$i][$j + 3])
				Next
			EndIf
		EndIf

		;ConsoleWrite("$asPartitions[" & $i & "][12] = " & $asPartitions[$i][12])
		;ConsoleWrite("$asPartitions[" & $i & "][13] = " & $asPartitions[$i][13])
	Next

EndFunc

Func _CreatePartition($sDiskNo, $sPartType, $iPartSize = -1, $sLetter = "", $stbStatus = 0)
	Local $sOutput
	Local $hPrDiskPart

	If $iPartSize = -1 Then
		GUICtrlSetData($stbStatus, "Creating " & $sPartType & " Partition of maximum remaining size on " & $sDiskNo & ", Please wait...")
	Else
		GUICtrlSetData($stbStatus, "Creating " & $sPartType & " Partition of " & $iPartSize & " MB on " & $sDiskNo & ", Please wait...")
	EndIf

	$hPrDiskPart = _CreateDiskPartProcess()

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Create partition
	If $iPartSize = -1 Then
		; Create partition of the specified type with max. size
		StdinWrite($hPrDiskPart, "Create Partition " & $sPartType & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Create Partition " & $sPartType & @CRLF)
	Else
		StdinWrite($hPrDiskPart, "Create Partition " & $sPartType & " Size=" & $iPartSize & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Create Partition " & $sPartType & " Size=" & $iPartSize & @CRLF)
	EndIf

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Assign drive letter
	If $sLetter <> "" Then
		StdinWrite($hPrDiskPart, "Assign Letter=" & $sLetter & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Assign Letter=" & $sLetter & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sOutput = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sOutput)
		_CheckForDiskPartErrors($sOutput)
	EndIf

	_RefreshDiskPartInfo($sDiskNo, $stbStatus, $hPrDiskPart)
	StdinWrite($hPrDiskPart)	; Close the DiskPart process

EndFunc

Func _DeletePartition($sDiskNo, $sPartNo, $bIsExtended = False, $stbStatus = 0)
	Local $sOutput
	Local $hPrDiskPart

	GUICtrlSetData($stbStatus, "Deleting " & $sPartNo & " on " & $sDiskNo & ", Please wait...")

	$hPrDiskPart = _CreateDiskPartProcess()

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Select partition
	StdinWrite($hPrDiskPart, "Select " & $sPartNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sPartNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Delete partition
	If $bIsExtended = True Then
		StdinWrite($hPrDiskPart, "Delete Partition Override" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Delete Partition Override" & @CRLF)
	Else
		StdinWrite($hPrDiskPart, "Delete Partition" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Delete Partition" & @CRLF)
	EndIf

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	_RefreshDiskPartInfo($sDiskNo, $stbStatus, $hPrDiskPart)
	StdinWrite($hPrDiskPart)	; Close the DiskPart process
EndFunc

Func _EditPartition($sDiskNo, $sPartNo, $sCurrLetter, $sNewLetter, $sLabel, $bMarkActive = False, $stbStatus = 0)
	Local $sOutput
	Local $hPrDiskPart

	GUICtrlSetData($stbStatus, "Modifying attributes of " & $sPartNo & " on " & $sDiskNo & ", Please wait...")

	; Set drive label
	If $sCurrLetter <> "" And $sNewLetter = "" Then
		DriveSetLabel($sCurrLetter, $sLabel)
	EndIf

	$hPrDiskPart = _CreateDiskPartProcess()

	If $hPrDiskPart = 0 Then
		Return
	EndIf

	; Select disk
	StdinWrite($hPrDiskPart, "Select " & $sDiskNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sDiskNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Select partition
	StdinWrite($hPrDiskPart, "Select " & $sPartNo & @CRLF)
	If $DebugMode = True Then ConsoleWrite("Select " & $sPartNo & @CRLF)

	While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
		Sleep(100)
	Wend
	$sOutput = StdoutRead($hPrDiskPart)
	If $DebugMode = True Then ConsoleWrite($sOutput)
	_CheckForDiskPartErrors($sOutput)

	; Assign or remove drive letter
	If $sNewLetter <> $sCurrLetter Then
		If $sNewLetter = "" Then
			StdinWrite($hPrDiskPart, "Remove" & @CRLF)
			If $DebugMode = True Then ConsoleWrite("Remove" & @CRLF)
		Else
			StdinWrite($hPrDiskPart, "Assign Letter=" & $sNewLetter & @CRLF)
			If $DebugMode = True Then ConsoleWrite("Assign Letter=" & $sNewLetter & @CRLF)
		EndIf

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sOutput = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sOutput)
		_CheckForDiskPartErrors($sOutput)
	EndIf

	; Mark partition active
	If $bMarkActive = True Then
		StdinWrite($hPrDiskPart, "Active" & @CRLF)
		If $DebugMode = True Then ConsoleWrite("Active" & @CRLF)

		While StringRight(StdoutRead($hPrDiskPart, -1, True), 10) <> "DISKPART> "
			Sleep(100)
		Wend
		$sOutput = StdoutRead($hPrDiskPart)
		If $DebugMode = True Then ConsoleWrite($sOutput)
		_CheckForDiskPartErrors($sOutput)
	EndIf

	; Set drive label
	If $sNewLetter <> "" Then
		DriveSetLabel($sNewLetter, $sLabel)
	EndIf

	_RefreshDiskPartInfo($sDiskNo, $stbStatus, $hPrDiskPart)
	StdinWrite($hPrDiskPart)	; Close the DiskPart process
EndFunc

